/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.MSSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.Sieves.MSSieves.MSSieve;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeterministicSpeakerSieve
extends MSSieve {
    public DeterministicSpeakerSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet);
    }

    @Override
    public void doMentionToSpeaker(Annotation doc) {
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        for (CoreMap quote : quotes) {
            Person speaker;
            String mention = (String)quote.get(QuoteAttributionAnnotator.MentionAnnotation.class);
            if (mention == null) continue;
            int mentionBegin = (Integer)quote.get(QuoteAttributionAnnotator.MentionBeginAnnotation.class);
            int mentionEnd = (Integer)quote.get(QuoteAttributionAnnotator.MentionEndAnnotation.class);
            ArrayList mentionTokens = new ArrayList();
            for (int i = mentionBegin; i <= mentionEnd; ++i) {
                mentionTokens.add(((List)doc.get(CoreAnnotations.TokensAnnotation.class)).get(i));
            }
            String mentionType = (String)quote.get(QuoteAttributionAnnotator.MentionTypeAnnotation.class);
            if (mentionType.equals("name")) {
                quote.set(QuoteAttributionAnnotator.SpeakerAnnotation.class, ((Person)((List)this.characterMap.get((Object)mention)).get((int)0)).name);
                quote.set(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class, "automatic name");
                continue;
            }
            if (!mentionType.equals("pronoun") || (speaker = this.doCoreference((Integer)((CoreLabel)mentionTokens.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), quote)) == null) continue;
            quote.set(QuoteAttributionAnnotator.SpeakerAnnotation.class, speaker.name);
            quote.set(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class, "coref");
        }
    }
}

