/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.MSSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.Sieves.MSSieves.MSSieve;
import edu.stanford.nlp.quoteattribution.Sieves.Sieve;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaselineTopSpeakerSieve
extends MSSieve {
    private static final Redwood.RedwoodChannels log = Redwood.channels(BaselineTopSpeakerSieve.class);
    private final Map<String, Person.Gender> genderList;
    private final Set<String> familyRelations;
    public static final int BACKWARD_WINDOW = 2000;
    public static final int BACKWARD_WINDOW_BIG = 4000;
    public static final int FORWARD_WINDOW = 500;
    public static final int FORWARD_WINDOW_BIG = 2500;
    public static final double FORWARD_WEIGHT = 0.34;
    public static final double BACKWARD_WEIGHT = 1.0;

    public BaselineTopSpeakerSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet, Map<String, Person.Gender> genderList, Set<String> familyRelations) {
        super(doc, characterMap, pronounCorefMap, animacySet);
        this.genderList = genderList;
        this.familyRelations = familyRelations;
    }

    @Override
    public void doMentionToSpeaker(Annotation doc) {
        this.topSpeakerInRange(doc);
    }

    public Sieve.MentionData makeMentionData(CoreMap q) {
        if (q.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null) {
            return new Sieve.MentionData((Integer)q.get(QuoteAttributionAnnotator.MentionBeginAnnotation.class), (Integer)q.get(QuoteAttributionAnnotator.MentionEndAnnotation.class), (String)q.get(QuoteAttributionAnnotator.MentionAnnotation.class), (String)q.get(QuoteAttributionAnnotator.MentionTypeAnnotation.class));
        }
        return new Sieve.MentionData(-1, -1, null, null);
    }

    public void topSpeakerInRange(Annotation doc) {
        List toks = (List)doc.get(CoreAnnotations.TokensAnnotation.class);
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        int qsize = quotes.size();
        for (int quote_idx = 0; quote_idx < qsize; ++quote_idx) {
            Pair<String, String> famPrediction;
            Pair<String, String> prevPrediction;
            CoreMap quote = (CoreMap)quotes.get(quote_idx);
            if (quote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class) != null) continue;
            Pair quoteRun = new Pair(quote.get(CoreAnnotations.TokenBeginAnnotation.class), quote.get(CoreAnnotations.TokenEndAnnotation.class));
            int backSpanStart = Math.max(0, (Integer)quoteRun.first - 2000);
            List<Sieve.MentionData> closestMentionsBackward = this.findClosestMentionsInSpanBackward(new Pair<Integer, Integer>(backSpanStart, (Integer)quoteRun.first - 1));
            int forwardSpanEnd = Math.min((Integer)quoteRun.second + 500, toks.size() - 1);
            List<Sieve.MentionData> closestMentions = this.findClosestMentionsInSpanForward(new Pair<Integer, Integer>((Integer)quoteRun.second + 1, forwardSpanEnd));
            closestMentions.addAll(closestMentionsBackward);
            Person.Gender gender = this.getGender(this.makeMentionData(quote));
            List<String> topSpeakers = Counters.toSortedList(this.getTopSpeakers(closestMentions, closestMentionsBackward, gender, quote, false));
            if (topSpeakers.isEmpty()) {
                if (backSpanStart > 0) {
                    backSpanStart = Math.max(0, (Integer)quoteRun.first - 4000);
                    closestMentionsBackward = this.findClosestMentionsInSpanBackward(new Pair<Integer, Integer>(backSpanStart, (Integer)quoteRun.first - 1));
                }
                if (forwardSpanEnd < toks.size() - 1) {
                    forwardSpanEnd = Math.min((Integer)quoteRun.second + 2500, toks.size() - 1);
                    closestMentions = this.findClosestMentionsInSpanForward(new Pair<Integer, Integer>((Integer)quoteRun.second + 1, forwardSpanEnd));
                }
                topSpeakers = Counters.toSortedList(this.getTopSpeakers(closestMentions, closestMentionsBackward, gender, quote, true));
            }
            if (topSpeakers.isEmpty()) {
                log.warn("  Empty top speakers list for: " + quote.toShorterString(new String[0]) + " [no candidate top speakers found \u2013 just ignore!");
                continue;
            }
            topSpeakers = this.removeQuoteNames(topSpeakers, quote);
            String topSpeaker = topSpeakers.get(0);
            Pair<String, String> nextPrediction = this.getConversationalNextPrediction(quotes, quote_idx, gender);
            boolean set = this.updatePredictions(quote, nextPrediction);
            if (set || (set = this.updatePredictions(quote, prevPrediction = this.getConversationalPreviousPrediction(quotes, quote_idx, gender))) || (set = this.updatePredictions(quote, famPrediction = this.getFamilyAnimateVocative(quotes, quote_idx, gender, topSpeakers)))) continue;
            this.updatePredictions(quote, new Pair<String, String>(topSpeaker, ""));
        }
    }

    public List<String> removeQuoteNames(List<String> topSpeakers, CoreMap quote) {
        String topSpeaker = topSpeakers.get(0);
        Set<Person> namesInParagraphQuotes = this.getNamesInParagraph(quote);
        if (namesInParagraphQuotes.contains(((List)this.characterMap.get(topSpeaker)).get(0)) && topSpeakers.size() > 1) {
            topSpeakers.remove(0);
        }
        return topSpeakers;
    }

    public Person.Gender getGender(Sieve.MentionData mention) {
        Person.Gender gender = Person.Gender.UNK;
        if (mention.type != null && mention.type.equals("pronoun")) {
            if (mention.text.equalsIgnoreCase("he")) {
                gender = Person.Gender.MALE;
            } else if (mention.text.equalsIgnoreCase("she")) {
                gender = Person.Gender.FEMALE;
            }
        } else if (mention.type != null && mention.type.equals("animate noun")) {
            String mentionText = mention.text.toLowerCase();
            if (this.genderList.get(mentionText) != null) {
                gender = this.genderList.get(mentionText);
            }
        } else if (mention.type != null && mention.type.equals("name")) {
            gender = ((Person)((List)this.characterMap.get((Object)mention.text)).get((int)0)).gender;
        }
        return gender;
    }

    public Counter<String> getTopSpeakers(List<Sieve.MentionData> closestMentionsForward, List<Sieve.MentionData> closestMentionsBackward, Person.Gender gender, CoreMap quote, boolean overrideGender) {
        ArrayList<Sieve.MentionData> closestMentions = new ArrayList<Sieve.MentionData>(closestMentionsForward.size() + closestMentionsBackward.size());
        closestMentions.addAll(closestMentionsForward);
        closestMentions.addAll(closestMentionsBackward);
        ClassicCounter<String> topSpeakerInRange = new ClassicCounter<String>();
        ClassicCounter<String> topSpeakerInRangeIgnoreGender = new ClassicCounter<String>();
        HashSet<Sieve.MentionData> backwardsMentions = new HashSet<Sieve.MentionData>(closestMentionsBackward);
        for (Sieve.MentionData mention : closestMentions) {
            int charBeginKey;
            Person p;
            double weight;
            double d = weight = backwardsMentions.contains(mention) ? 1.0 : 0.34;
            if (mention.type.equals("name")) {
                if (!this.characterMap.containsKey(mention.text)) continue;
                Person p2 = (Person)((List)this.characterMap.get(mention.text)).get(0);
                if (gender == Person.Gender.MALE && p2.gender == Person.Gender.MALE || gender == Person.Gender.FEMALE && p2.gender == Person.Gender.FEMALE || gender == Person.Gender.UNK) {
                    topSpeakerInRange.incrementCount(p2.name, weight);
                }
                topSpeakerInRangeIgnoreGender.incrementCount(p2.name, weight);
                continue;
            }
            if (!mention.type.equals("pronoun") || (p = this.doCoreference(charBeginKey = ((CoreLabel)((List)this.doc.get(CoreAnnotations.TokensAnnotation.class)).get(mention.begin)).beginPosition(), quote)) == null) continue;
            if (gender == Person.Gender.MALE && p.gender == Person.Gender.MALE || gender == Person.Gender.FEMALE && p.gender == Person.Gender.FEMALE || gender == Person.Gender.UNK) {
                topSpeakerInRange.incrementCount(p.name, weight);
            }
            topSpeakerInRangeIgnoreGender.incrementCount(p.name, weight);
        }
        if (topSpeakerInRange.size() > 0) {
            return topSpeakerInRange;
        }
        if (gender != Person.Gender.UNK && !overrideGender) {
            return topSpeakerInRange;
        }
        return topSpeakerInRangeIgnoreGender;
    }

    public boolean updatePredictions(CoreMap quote, Pair<String, String> speakerAndMethod) {
        if (speakerAndMethod.first != null && speakerAndMethod.second != null) {
            quote.set(QuoteAttributionAnnotator.SpeakerAnnotation.class, ((Person)((List)this.characterMap.get(speakerAndMethod.first)).get((int)0)).name);
            quote.set(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class, "Baseline Top" + (String)speakerAndMethod.second);
            return true;
        }
        return false;
    }

    public Pair<String, String> getFamilyAnimateVocative(List<CoreMap> quotes, int quote_index, Person.Gender gender, List<String> topSpeakers) {
        String relatedName;
        int quoteContainingMention;
        Sieve.MentionData mention = this.makeMentionData(quotes.get(quote_index));
        if (mention.text != null && mention.type.equals("animate noun") && this.familyRelations.contains(mention.text.toLowerCase()) && gender != Person.Gender.UNK && (quoteContainingMention = BaselineTopSpeakerSieve.getQuoteContainingRange(quotes, new Pair<Integer, Integer>(mention.begin, mention.end))) >= 0 && (relatedName = (String)quotes.get(quoteContainingMention).get(QuoteAttributionAnnotator.SpeakerAnnotation.class)) != null) {
            for (String speaker : topSpeakers) {
                String[] speakerNames = speaker.split("_");
                if (!relatedName.endsWith(speakerNames[speakerNames.length - 1])) continue;
                return new Pair<String, String>(speaker, "family animate");
            }
        }
        return new Pair<Object, Object>(null, null);
    }

    public Pair<String, String> getConversationalPreviousPrediction(List<CoreMap> quotes, int quoteIndex, Person.Gender gender) {
        String topSpeaker = null;
        String modifier = null;
        ArrayList<Integer> quotesInPrevPrev = new ArrayList<Integer>();
        CoreMap quote = quotes.get(quoteIndex);
        int quoteParagraph = this.getQuoteParagraph(quote);
        for (int j = quoteIndex - 1; j >= 0; --j) {
            if (this.getQuoteParagraph(quotes.get(j)) != quoteParagraph - 2) continue;
            quotesInPrevPrev.add(j);
        }
        Iterator iterator = quotesInPrevPrev.iterator();
        while (iterator.hasNext()) {
            int prevPrev = (Integer)iterator.next();
            CoreMap prevprevQuote = quotes.get(prevPrev);
            String speakerName = (String)prevprevQuote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class);
            if ((speakerName == null || gender != Person.Gender.UNK) && this.getGender(this.makeMentionData(prevprevQuote)) != gender) continue;
            topSpeaker = speakerName;
            modifier = " conversation - prev";
        }
        return new Pair<Object, Object>(topSpeaker, modifier);
    }

    public Pair<String, String> getConversationalNextPrediction(List<CoreMap> quotes, int quoteIndex, Person.Gender gender) {
        String topSpeaker = null;
        String modifier = null;
        ArrayList<Integer> quotesInNextNext = new ArrayList<Integer>();
        CoreMap quote = quotes.get(quoteIndex);
        int quoteParagraph = this.getQuoteParagraph(quote);
        for (int j = quoteIndex + 1; j < quotes.size(); ++j) {
            if (this.getQuoteParagraph(quotes.get(j)) != quoteParagraph + 2) continue;
            quotesInNextNext.add(j);
        }
        Iterator iterator = quotesInNextNext.iterator();
        while (iterator.hasNext()) {
            int nextNext = (Integer)iterator.next();
            CoreMap nextNextQuote = quotes.get(nextNext);
            String speakerName = (String)nextNextQuote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class);
            Sieve.MentionData md = this.makeMentionData(quotes.get(nextNext));
            if ((speakerName == null || gender != Person.Gender.UNK) && this.getGender(md) != gender) continue;
            topSpeaker = speakerName;
            modifier = " conversation - next";
        }
        return new Pair<Object, Object>(topSpeaker, modifier);
    }

    public static int getQuoteContainingRange(List<CoreMap> quotes, Pair<Integer, Integer> range) {
        int qSize = quotes.size();
        for (int i = 0; i < qSize; ++i) {
            if ((Integer)quotes.get(i).get(CoreAnnotations.TokenBeginAnnotation.class) > (Integer)range.first || (Integer)quotes.get(i).get(CoreAnnotations.TokenEndAnnotation.class) < (Integer)range.second) continue;
            return i;
        }
        return -1;
    }
}

