/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.OpenIE;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.QuoteAnnotator;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TextOutputter
extends AnnotationOutputter {
    @Override
    public void print(Annotation annotation, OutputStream stream, AnnotationOutputter.Options options) throws IOException {
        PrintWriter os = new PrintWriter(IOUtils.encodedOutputStreamWriter(stream, options.encoding));
        TextOutputter.print(annotation, os, options);
    }

    private static void print(Annotation annotation, PrintWriter pw, AnnotationOutputter.Options options) {
        Map corefChains;
        String docSourceType;
        String docType;
        String docDate;
        String docTitle;
        double beam = options.relationsBeam;
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        String docId = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docId != null) {
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            int nSentences = sentences != null ? sentences.size() : 0;
            int nTokens = tokens != null ? tokens.size() : 0;
            pw.printf("Document: ID=%s (%d sentences, %d tokens)%n", docId, nSentences, nTokens);
        }
        if ((docTitle = (String)annotation.get(CoreAnnotations.DocTitleAnnotation.class)) != null) {
            pw.printf("Document Title: %s%n", docTitle);
        }
        if ((docDate = (String)annotation.get(CoreAnnotations.DocDateAnnotation.class)) != null) {
            pw.printf("Document Date: %s%n", docDate);
        }
        if ((docType = (String)annotation.get(CoreAnnotations.DocTypeAnnotation.class)) != null) {
            pw.printf("Document Type: %s%n", docType);
        }
        if ((docSourceType = (String)annotation.get(CoreAnnotations.DocSourceTypeAnnotation.class)) != null) {
            pw.printf("Document Source Type: %s%n", docSourceType);
        }
        if (sentences != null) {
            int sz = sentences.size();
            for (int i = 0; i < sz; ++i) {
                Collection kbpTriples;
                Collection openieTriples;
                List relations;
                List entities;
                List entityMentions;
                Tree binaryTree;
                pw.println();
                CoreMap sentence = (CoreMap)sentences.get(i);
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                String sentiment = (String)sentence.get(SentimentCoreAnnotations.SentimentClass.class);
                String piece = sentiment == null ? "" : ", sentiment: " + sentiment;
                pw.printf("Sentence #%d (%d tokens%s):%n", i + 1, tokens.size(), piece);
                String text = (String)sentence.get(CoreAnnotations.TextAnnotation.class);
                pw.println(text);
                String[] tokenAnnotations = new String[]{"Text", "PartOfSpeech", "Lemma", "Answer", "NamedEntityTag", "CharacterOffsetBegin", "CharacterOffsetEnd", "NormalizedNamedEntityTag", "CodepointOffsetBegin", "CodepointOffsetEnd", "Timex", "TrueCase", "TrueCaseText", "SentimentClass", "WikipediaEntity"};
                pw.println();
                pw.println("Tokens:");
                for (CoreLabel token : tokens) {
                    pw.print(token.toShorterString(tokenAnnotations));
                    pw.println();
                }
                Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                if (tree != null) {
                    pw.println();
                    pw.println("Constituency parse: ");
                    options.constituencyTreePrinter.printTree(tree, pw);
                }
                if ((binaryTree = (Tree)sentence.get(TreeCoreAnnotations.BinarizedTreeAnnotation.class)) != null) {
                    pw.println();
                    pw.println("Binary Constituency parse: ");
                    options.constituencyTreePrinter.printTree(binaryTree, pw);
                }
                if (!StringUtils.isNullOrEmpty(sentiment)) {
                    pw.println();
                    pw.println("Sentiment-annotated binary tree:");
                    Tree sTree = (Tree)sentence.get(SentimentCoreAnnotations.SentimentAnnotatedTree.class);
                    if (sTree != null) {
                        sTree.pennPrint(pw, label -> label.value() == null ? "" : (RNNCoreAnnotations.getPredictedClass(label) != -1 ? label.value() + "|sentiment=" + RNNCoreAnnotations.getPredictedClass(label) + "|prob=" + String.format("%.3f", RNNCoreAnnotations.getPredictedClassProb(label)) : label.value()));
                        pw.println();
                    }
                }
                if (sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class) != null) {
                    pw.println();
                    pw.println("Dependency Parse (enhanced plus plus dependencies):");
                    pw.print(((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class)).toList());
                }
                if ((entityMentions = (List)sentence.get(CoreAnnotations.MentionsAnnotation.class)) != null) {
                    pw.println();
                    pw.println("Extracted the following NER entity mentions:");
                    for (Object entityMention : entityMentions) {
                        Map nerConfidences = (Map)entityMention.get(CoreAnnotations.NamedEntityTagProbsAnnotation.class);
                        String nerConfidenceKey = nerConfidences.keySet().size() > 0 ? (String)nerConfidences.keySet().toArray()[0] : "";
                        String nerConfidenceEntry = !nerConfidenceKey.equals("") && !nerConfidenceKey.equals("O") ? nerConfidenceKey + ":" + nerConfidences.get(nerConfidenceKey) : "-";
                        if (entityMention.get(CoreAnnotations.EntityTypeAnnotation.class) == null) continue;
                        pw.println((String)entityMention.get(CoreAnnotations.TextAnnotation.class) + '\t' + (String)entityMention.get(CoreAnnotations.EntityTypeAnnotation.class) + '\t' + nerConfidenceEntry);
                    }
                }
                if ((entities = (List)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class)) != null) {
                    Object entityMention;
                    pw.println();
                    pw.println("Extracted the following MachineReading entity mentions:");
                    entityMention = entities.iterator();
                    while (entityMention.hasNext()) {
                        EntityMention e = (EntityMention)entityMention.next();
                        pw.print('\t');
                        pw.println(e);
                    }
                }
                if ((relations = (List)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class)) != null) {
                    pw.println();
                    pw.println("Extracted the following MachineReading relation mentions:");
                    for (Object r : relations) {
                        if (!((RelationMention)r).printableObject(beam)) continue;
                        pw.println(r);
                    }
                }
                if ((openieTriples = (Collection)sentence.get(NaturalLogicAnnotations.RelationTriplesAnnotation.class)) != null && !openieTriples.isEmpty()) {
                    Object r;
                    pw.println();
                    pw.println("Extracted the following Open IE triples:");
                    r = openieTriples.iterator();
                    while (r.hasNext()) {
                        RelationTriple triple = (RelationTriple)r.next();
                        pw.println(OpenIE.tripleToString(triple, docId, sentence));
                    }
                }
                if ((kbpTriples = (Collection)sentence.get(CoreAnnotations.KBPTriplesAnnotation.class)) == null || kbpTriples.isEmpty()) continue;
                pw.println();
                pw.println("Extracted the following KBP triples:");
                for (RelationTriple triple : kbpTriples) {
                    pw.println(triple);
                }
            }
        } else {
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            pw.println("Tokens:");
            pw.println((String)annotation.get(CoreAnnotations.TextAnnotation.class));
            for (CoreLabel token : tokens) {
                int tokenCharBegin = (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int tokenCharEnd = (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                String extra = "";
                Integer codepoint = (Integer)token.get(CoreAnnotations.CodepointOffsetBeginAnnotation.class);
                if (codepoint != null) {
                    extra = extra + " CodepointOffsetBegin=" + codepoint;
                }
                if ((codepoint = (Integer)token.get(CoreAnnotations.CodepointOffsetEndAnnotation.class)) != null) {
                    extra = extra + " CodepointOffsetEnd=" + codepoint;
                }
                pw.println("[Text=" + token.word() + " CharacterOffsetBegin=" + tokenCharBegin + " CharacterOffsetEnd=" + tokenCharEnd + extra + ']');
            }
        }
        if ((corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class)) != null && sentences != null) {
            for (CorefChain chain : corefChains.values()) {
                CorefChain.CorefMention representative = chain.getRepresentativeMention();
                boolean outputHeading = false;
                for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
                    if (mention == representative && (!options.printSingletons || chain.getMentionsInTextualOrder().size() > 1)) continue;
                    if (!outputHeading) {
                        outputHeading = true;
                        pw.println();
                        pw.println("Coreference set:");
                    }
                    pw.printf("\t(%d,%d,[%d,%d]) -> (%d,%d,[%d,%d]), that is: \"%s\" -> \"%s\"%n", mention.sentNum, mention.headIndex, mention.startIndex, mention.endIndex, representative.sentNum, representative.headIndex, representative.startIndex, representative.endIndex, mention.mentionSpan, representative.mentionSpan);
                }
            }
        }
        if (annotation.get(CoreAnnotations.QuotationsAnnotation.class) != null) {
            pw.println();
            pw.println("Extracted quotes:");
            List<CoreMap> allQuotes = QuoteAnnotator.gatherQuotes(annotation);
            for (CoreMap quote : allQuotes) {
                String speakerString = quote.get(QuoteAttributionAnnotator.CanonicalMentionAnnotation.class) != null ? (String)quote.get(QuoteAttributionAnnotator.CanonicalMentionAnnotation.class) : (quote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class) != null ? (String)quote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class) : "Unknown");
                pw.printf("%s:\t%s\t[index=%d, charOffsetBegin=%d]%n", speakerString, quote.get(CoreAnnotations.TextAnnotation.class), quote.get(CoreAnnotations.QuotationIndexAnnotation.class), quote.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class));
            }
        }
        pw.flush();
    }

    public static void prettyPrint(Annotation annotation, OutputStream stream, StanfordCoreNLP pipeline) {
        TextOutputter.prettyPrint(annotation, new PrintWriter(stream), pipeline);
    }

    public static void prettyPrint(Annotation annotation, PrintWriter pw, StanfordCoreNLP pipeline) {
        TextOutputter.print(annotation, pw, TextOutputter.getOptions(pipeline.getProperties()));
    }
}

