/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.CoreMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CoNLLUReader {
    public static final int CoNLLU_IndexField = 0;
    public static final int CoNLLU_WordField = 1;
    public static final int CoNLLU_LemmaField = 2;
    public static final int CoNLLU_UPOSField = 3;
    public static final int CoNLLU_XPOSField = 4;
    public static final int CoNLLU_GovField = 6;
    public static final int CoNLLU_RelnField = 7;
    public static final int CoNLLU_MiscField = 9;
    public int columnCount = 10;
    public static Pattern COMMENT_LINE = Pattern.compile("^#.*");
    public static Pattern DOCUMENT_LINE = Pattern.compile("^# newdoc");
    public static Pattern MWT_LINE = Pattern.compile("^[0-9]+-[0-9]+.*");
    public static Pattern TOKEN_LINE = Pattern.compile("^[0-9]+\t.*");
    public static HashMap<String, String> classShorthandToFull = new HashMap();
    private HashMap<Integer, Class> extraColumns = new HashMap();

    public CoNLLUReader() throws ClassNotFoundException {
        this(new Properties());
    }

    public CoNLLUReader(Properties props) throws ClassNotFoundException {
        if (props.getProperty("conllu.extraColumns", "").equals("")) {
            this.extraColumns.put(10, CoreAnnotations.NamedEntityTagAnnotation.class);
        } else {
            int extraColumnIndex = 10;
            for (String className : props.getProperty("conllu.extraColumns").split(",")) {
                if (classShorthandToFull.containsKey(className)) {
                    className = classShorthandToFull.get(className) + className;
                }
                Class<?> clazz = Class.forName(className);
                this.extraColumns.put(extraColumnIndex, clazz);
            }
        }
        this.columnCount += this.extraColumns.size();
    }

    public List<Annotation> readCoNLLUFile(String filePath) throws IOException {
        List<CoNLLUDocument> docs = this.readCoNLLUFileCreateCoNLLUDocuments(filePath);
        return docs.stream().map(doc -> this.convertCoNLLUDocumentToAnnotation((CoNLLUDocument)doc)).collect(Collectors.toList());
    }

    public List<String> readCoNLLUFileCreateCoNLLXLines(String filePath) throws IOException {
        List<CoNLLUDocument> docs = this.readCoNLLUFileCreateCoNLLUDocuments(filePath);
        ArrayList<String> conllXLines = new ArrayList<String>();
        for (CoNLLUDocument doc : docs) {
            for (CoNLLUSentence sentence : doc.sentences) {
                conllXLines.addAll(sentence.tokenLines);
                conllXLines.add("");
            }
        }
        return conllXLines;
    }

    public List<CoNLLUDocument> readCoNLLUFileCreateCoNLLUDocuments(String filePath) throws IOException {
        BufferedReader reader = IOUtils.readerFromString(filePath);
        Iterable<String> lines = IOUtils.getLineIterable(reader, false);
        ArrayList<CoNLLUDocument> docs = new ArrayList<CoNLLUDocument>();
        docs.add(new CoNLLUDocument());
        for (String line : lines) {
            boolean endSentence;
            if (DOCUMENT_LINE.matcher(line).matches()) {
                docs.add(new CoNLLUDocument());
                ((CoNLLUDocument)docs.get((int)(docs.size() - 1))).sentences.add(new CoNLLUSentence());
            }
            if (!(endSentence = ((CoNLLUDocument)docs.get(docs.size() - 1)).lastSentence().processLine(line))) continue;
            ((CoNLLUDocument)docs.get((int)(docs.size() - 1))).sentences.add(new CoNLLUSentence());
        }
        ((CoNLLUDocument)docs.get((int)(docs.size() - 1))).sentences.remove(((CoNLLUDocument)docs.get((int)(docs.size() - 1))).sentences.size() - 1);
        return docs;
    }

    public Annotation convertCoNLLUDocumentToAnnotation(CoNLLUDocument doc) {
        Annotation finalAnnotation = new Annotation("");
        ArrayList<CoreMap> sentences = new ArrayList<CoreMap>();
        for (CoNLLUSentence sent : doc.sentences) {
            sentences.add(this.convertCoNLLUSentenceToCoreMap(doc, sent));
        }
        finalAnnotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>();
        finalAnnotation.set(CoreAnnotations.TokensAnnotation.class, tokens);
        int documentIdx = 0;
        int sentenceIdx = 0;
        for (CoreMap sentence : (List)finalAnnotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            sentence.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIdx);
            if (sentenceIdx > 0) {
                ((CoreLabel)((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).get(0)).setBefore("\n");
            }
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                token.set(CoreAnnotations.TokenBeginAnnotation.class, documentIdx);
                token.set(CoreAnnotations.TokenEndAnnotation.class, documentIdx + 1);
                token.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIdx);
                tokens.add(token);
                ++documentIdx;
            }
            ++sentenceIdx;
        }
        finalAnnotation.set(CoreAnnotations.TextAnnotation.class, doc.docText);
        return finalAnnotation;
    }

    public CoreMap convertCoNLLUSentenceToCoreMap(CoNLLUDocument doc, CoNLLUSentence sentence) {
        List<String> lines = sentence.tokenLines;
        ArrayList<CoreLabel> coreLabels = new ArrayList<CoreLabel>();
        int sentenceTokenIndex = 1;
        for (String line : lines) {
            List<String> fields = Arrays.asList(line.split("\t"));
            CoreLabel cl = new CoreLabel();
            cl.setWord(fields.get(1));
            cl.setValue(fields.get(1));
            cl.setOriginalText(fields.get(1));
            cl.setIsNewline(false);
            if (!fields.get(2).equals("_")) {
                cl.setLemma(fields.get(2));
            }
            if (!fields.get(3).equals("_")) {
                cl.setTag(fields.get(3));
            }
            for (int extraColumnIdx = 10; extraColumnIdx < this.columnCount && extraColumnIdx < fields.size(); ++extraColumnIdx) {
                cl.set(this.extraColumns.get(extraColumnIdx), fields.get(extraColumnIdx));
            }
            cl.setIndex(sentenceTokenIndex);
            if (!fields.get(9).equals("_")) {
                HashMap miscKeyValues = new HashMap();
                Arrays.stream(fields.get(9).split("\\|")).forEach(kv -> miscKeyValues.put(kv.split("=")[0], kv.split("=")[1]));
                if (!miscKeyValues.getOrDefault("SpaceAfter", "Yes").equals("No")) {
                    cl.setAfter(" ");
                } else {
                    cl.setAfter("");
                }
            } else {
                cl.setAfter(" ");
            }
            if (sentence.mwtData.containsKey(sentenceTokenIndex - 1)) {
                cl.set(CoreAnnotations.MWTTokenTextAnnotation.class, sentence.mwtTokens.get(sentence.mwtData.get(sentenceTokenIndex - 1)));
                cl.setIsMWT(true);
                if (sentence.mwtData.containsKey(sentenceTokenIndex - 2) && sentence.mwtData.get(sentenceTokenIndex - 2).equals(sentence.mwtData.get(sentenceTokenIndex - 1))) {
                    cl.setIsMWTFirst(false);
                } else {
                    cl.setIsMWTFirst(true);
                }
                String miscInfo = sentence.mwtMiscs.get(sentence.mwtData.get(sentenceTokenIndex - 1));
                for (String miscKV : miscInfo.split("\\|")) {
                    if (!miscKV.startsWith("SpaceAfter")) continue;
                    cl.setAfter(miscKV.split("=")[1].equals("No") ? "" : " ");
                }
            } else {
                cl.setIsMWT(false);
                cl.setIsMWTFirst(false);
            }
            ++sentenceTokenIndex;
            coreLabels.add(cl);
        }
        ((CoreLabel)coreLabels.get(coreLabels.size() - 1)).setAfter("\n");
        ((CoreLabel)coreLabels.get(0)).setBefore("");
        for (int i = 1; i < coreLabels.size(); ++i) {
            if (((CoreLabel)coreLabels.get(i)).isMWT().booleanValue() && !((CoreLabel)coreLabels.get(i)).isMWTFirst().booleanValue()) {
                ((CoreLabel)coreLabels.get(i)).setBefore(((CoreLabel)coreLabels.get(i - 1)).before());
                continue;
            }
            ((CoreLabel)coreLabels.get(i)).setBefore(((CoreLabel)coreLabels.get(i - 1)).after());
        }
        int sentenceCharBegin = doc.docText.length();
        int processedMWTTokens = 0;
        int lastMWTCharBegin = -1;
        int lastMWTCharEnd = -1;
        for (CoreLabel cl : coreLabels) {
            if (sentence.mwtData.containsKey(cl.index() - 1)) {
                if (sentence.mwtData.get(cl.index() - 1) == processedMWTTokens) {
                    cl.setBeginPosition(doc.docText.length());
                    doc.docText = doc.docText + sentence.mwtTokens.get(processedMWTTokens);
                    cl.setEndPosition(doc.docText.length());
                    lastMWTCharBegin = cl.beginPosition();
                    lastMWTCharEnd = cl.endPosition();
                    doc.docText = doc.docText + ((CoreLabel)coreLabels.get(sentence.mwtLastCoreLabels.get(processedMWTTokens))).after();
                    ++processedMWTTokens;
                } else {
                    cl.setBeginPosition(lastMWTCharBegin);
                    cl.setEndPosition(lastMWTCharEnd);
                }
                cl.setIsMWT(true);
                continue;
            }
            cl.setBeginPosition(doc.docText.length());
            doc.docText = doc.docText + cl.word();
            cl.setEndPosition(doc.docText.length());
            doc.docText = doc.docText + cl.after();
        }
        ArrayList<SemanticGraphEdge> graphEdges = new ArrayList<SemanticGraphEdge>();
        for (int i = 0; i < lines.size(); ++i) {
            List<String> fields = Arrays.asList(lines.get(i).split("\t"));
            if (fields.get(6).equals("0")) continue;
            IndexedWord dependent = new IndexedWord((CoreLabel)coreLabels.get(i));
            IndexedWord gov = new IndexedWord((CoreLabel)coreLabels.get(Integer.parseInt(fields.get(6)) - 1));
            GrammaticalRelation reln = GrammaticalRelation.valueOf(fields.get(7));
            graphEdges.add(new SemanticGraphEdge(gov, dependent, reln, 1.0, false));
        }
        SemanticGraph depParse = SemanticGraphFactory.makeFromEdges(graphEdges);
        Annotation sentenceCoreMap = new Annotation(doc.docText.substring(sentenceCharBegin).trim());
        sentenceCoreMap.set(CoreAnnotations.TokensAnnotation.class, coreLabels);
        sentenceCoreMap.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, depParse);
        return sentenceCoreMap;
    }

    static {
        classShorthandToFull.put("CoreAnnotations", "edu.stanford.nlp.ling.");
        classShorthandToFull.put("SemanticGraphCoreAnnotations", "edu.stanford.nlp.semgraph.");
        classShorthandToFull.put("SentimentCoreAnnotations", "edu.stanford.nlp.sentiment.");
    }

    public class CoNLLUSentence {
        public List<String> tokenLines = new ArrayList<String>();
        public HashMap<String, String> sentenceData = new HashMap();
        HashMap<Integer, Integer> mwtData = new HashMap();
        List<String> mwtTokens = new ArrayList<String>();
        List<String> mwtMiscs = new ArrayList<String>();
        List<Integer> mwtLastCoreLabels = new ArrayList<Integer>();

        public boolean processLine(String line) {
            if (COMMENT_LINE.matcher(line).matches()) {
                this.addSentenceData(line);
            } else if (MWT_LINE.matcher(line).matches()) {
                this.addMWTData(line);
            } else if (TOKEN_LINE.matcher(line).matches()) {
                this.tokenLines.add(line);
            } else {
                return true;
            }
            return false;
        }

        public void addSentenceData(String sentenceDataLine) {
            if (COMMENT_LINE.matcher(sentenceDataLine).matches() && sentenceDataLine.contains("=")) {
                String[] keyAndValue = sentenceDataLine.substring(1).split("=");
                String key = sentenceDataLine.substring(1, sentenceDataLine.indexOf(61));
                String value = sentenceDataLine.substring(sentenceDataLine.indexOf(61));
                this.sentenceData.put(key, value);
            }
        }

        void addMWTData(String mwtDataLine) {
            String[] mwtFields = mwtDataLine.split("\t");
            String[] mwtRange = mwtFields[0].split("-");
            String mwtText = mwtFields[1];
            int mwtStart = Integer.parseInt(mwtRange[0]);
            int mwtEnd = Integer.parseInt(mwtRange[1]);
            for (int i = mwtStart - 1; i < mwtEnd; ++i) {
                this.mwtData.put(i, this.mwtTokens.size());
            }
            this.mwtTokens.add(mwtText);
            this.mwtMiscs.add(mwtFields[9]);
            this.mwtLastCoreLabels.add(mwtEnd - 1);
        }
    }

    public class CoNLLUDocument {
        public List<CoNLLUSentence> sentences = new ArrayList<CoNLLUSentence>();
        public HashMap<String, String> docData = new HashMap();
        public String docText = "";

        public CoNLLUDocument() {
            this.sentences.add(new CoNLLUSentence());
        }

        public CoNLLUSentence lastSentence() {
            return this.sentences.get(this.sentences.size() - 1);
        }
    }
}

