/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.PatternsAnnotations;
import edu.stanford.nlp.patterns.SentenceIndex;
import edu.stanford.nlp.patterns.surface.Token;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;

public class InvertedIndexByTokens<E extends Pattern>
extends SentenceIndex<E>
implements Serializable {
    private static Redwood.RedwoodChannels log = Redwood.channels(InvertedIndexByTokens.class);
    private static final long serialVersionUID = 1L;
    Map<String, Set<String>> index;

    public InvertedIndexByTokens(Properties props, Set<String> stopWords, Function<CoreLabel, Map<String, String>> transformSentenceToString) {
        super(stopWords, transformSentenceToString);
        ArgumentParser.fillOptions((Object)this, props);
        this.index = new HashMap<String, Set<String>>();
    }

    public InvertedIndexByTokens(Properties props, Set<String> stopWords, Function<CoreLabel, Map<String, String>> transformSentenceToString, Map<String, Set<String>> index) {
        super(stopWords, transformSentenceToString);
        ArgumentParser.fillOptions((Object)this, props);
        this.index = index;
    }

    @Override
    public void add(Map<String, DataInstance> sents, boolean addProcessedText) {
        for (Map.Entry<String, DataInstance> sEn : sents.entrySet()) {
            this.add(sEn.getValue().getTokens(), sEn.getKey(), addProcessedText);
        }
    }

    @Override
    protected void add(List<CoreLabel> sent, String sentId, boolean addProcessedText) {
        ++this.numAllSentences;
        for (CoreLabel l : sent) {
            String val;
            Map addThis = (Map)this.transformCoreLabeltoString.apply(l);
            for (Map.Entry en : addThis.entrySet()) {
                String val2 = this.combineKeyValue((String)en.getKey(), (String)en.getValue());
                this.add(val2, sentId);
            }
            if (!addProcessedText || this.stopWords.contains((val = Token.getKeyForClass(PatternsAnnotations.ProcessedTextAnnotation.class) + ":" + (String)l.get(PatternsAnnotations.ProcessedTextAnnotation.class)).toLowerCase())) continue;
            this.add(val, sentId);
        }
    }

    @Override
    public void finishUpdating() {
    }

    @Override
    public void update(List<CoreLabel> tokens, String sentid) {
        this.add(tokens, sentid, false);
    }

    void add(String w, String sentid) {
        Set<String> sentids = this.index.get(w);
        if (sentids == null) {
            sentids = new HashSet<String>();
        }
        sentids.add(sentid);
        this.index.put(w, sentids);
    }

    String combineKeyValue(String key, String value) {
        return key + ":" + value;
    }

    public Set<String> getFileSentIds(CollectionValuedMap<String, String> relevantWords) {
        Set<String> sentids = null;
        for (Map.Entry<String, Collection<String>> en : relevantWords.entrySet()) {
            for (String en2 : en.getValue()) {
                if (this.stopWords.contains(en2.toLowerCase())) continue;
                String w = this.combineKeyValue(en.getKey(), en2);
                Set<String> st = this.index.get(w);
                if (st == null) {
                    return Collections.emptySet();
                }
                if (sentids == null) {
                    sentids = st;
                    continue;
                }
                sentids = CollectionUtils.intersection(sentids, st);
            }
        }
        return sentids;
    }

    public Map<E, Set<String>> getFileSentIdsFromPats(Collection<E> pats) {
        HashMap<Pattern, Set<String>> sents = new HashMap<Pattern, Set<String>>();
        for (Pattern pat : pats) {
            Set<String> ids = this.getFileSentIds(pat.getRelevantWords());
            Redwood.log(ConstantsAndVariables.extremedebug, "For pattern with index " + pat + " extracted the following sentences from the index " + ids);
            sents.put(pat, ids);
        }
        return sents;
    }

    public static InvertedIndexByTokens createIndex(Map<String, List<CoreLabel>> sentences, Properties props, Set<String> stopWords, String dir, Function<CoreLabel, Map<String, String>> transformCoreLabeltoString) {
        InvertedIndexByTokens inv = new InvertedIndexByTokens(props, stopWords, transformCoreLabeltoString);
        if (sentences != null && sentences.size() > 0) {
            inv.add(sentences, true);
        }
        System.out.println("Created index with size " + inv.size() + ". Don't worry if it's zero and you are using batch process sents.");
        return inv;
    }

    @Override
    public Map<E, Set<String>> queryIndex(Collection<E> patterns) {
        Map<E, Set<String>> sentSentids = this.getFileSentIdsFromPats(patterns);
        return sentSentids;
    }

    @Override
    public void saveIndex(String dir) {
        try {
            IOUtils.ensureDir(new File(dir));
            IOUtils.writeObjectToFile(this.index, dir + "/map.ser");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InvertedIndexByTokens loadIndex(Properties props, Set<String> stopwords, String dir, Function<CoreLabel, Map<String, String>> transformSentenceToString) {
        try {
            Map index = (Map)IOUtils.readObjectFromFile(dir + "/map.ser");
            System.out.println("Loading inverted index from " + dir);
            return new InvertedIndexByTokens(props, stopwords, transformSentenceToString, index);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load the inverted index. " + e);
        }
    }
}

