/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.parser.metrics.EvalbByCat;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredConstituentFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Set;

public class Evalb
extends AbstractEval {
    private static Redwood.RedwoodChannels log = Redwood.channels(Evalb.class);
    private final ConstituentFactory cf = new LabeledScoredConstituentFactory();
    private static final int minArgs = 2;

    public Evalb(String str, boolean runningAverages) {
        super(str, runningAverages);
    }

    protected Set<Constituent> makeObjects(Tree tree) {
        Set<Constituent> set = Generics.newHashSet();
        if (tree != null) {
            set.addAll(tree.constituents(this.cf));
        }
        return set;
    }

    @Override
    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        if (gold == null || guess == null) {
            System.err.printf("%s: Cannot compare against a null gold or guess tree!\n", this.getClass().getName());
            return;
        }
        if (guess.yield().size() != gold.yield().size()) {
            log.info("Warning: yield differs:");
            log.info("Guess: " + SentenceUtils.listToString(guess.yield()));
            log.info("Gold:  " + SentenceUtils.listToString(gold.yield()));
        }
        super.evaluate(guess, gold, pw);
    }

    private static String usage() {
        StringBuilder sb = new StringBuilder();
        String nl = System.getProperty("line.separator");
        sb.append(String.format("Usage: java %s [OPTS] gold guess%n%n", Evalb.class.getName()));
        sb.append("Options:").append(nl);
        sb.append("  -v         : Verbose mode.").append(nl);
        sb.append("  -l lang    : Select language settings from ").append(Language.langList).append(nl);
        sb.append("  -y num     : Skip gold trees with yields longer than num.").append(nl);
        sb.append("  -s num     : Sort the trees by F1 and output the num lowest F1 trees.").append(nl);
        sb.append("  -c         : Compute LP/LR/F1 by category.").append(nl);
        sb.append("  -f regex   : Compute category level evaluation for categories that match this regex.").append(nl);
        sb.append("  -e         : Input encoding.").append(nl);
        return sb.toString();
    }

    private static Map<String, Integer> optionArgDefs() {
        Map<String, Integer> optionArgDefs = Generics.newHashMap();
        optionArgDefs.put("v", 0);
        optionArgDefs.put("l", 1);
        optionArgDefs.put("y", 1);
        optionArgDefs.put("s", 1);
        optionArgDefs.put("c", 0);
        optionArgDefs.put("e", 0);
        optionArgDefs.put("f", 1);
        return optionArgDefs;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            log.info(Evalb.usage());
            System.exit(-1);
        }
        Properties options = StringUtils.argsToProperties(args, Evalb.optionArgDefs());
        Language language = PropertiesUtils.get(options, "l", Language.English, Language.class);
        TreebankLangParserParams tlpp = language.params;
        int maxGoldYield = PropertiesUtils.getInt(options, "y", Integer.MAX_VALUE);
        boolean VERBOSE = PropertiesUtils.getBool(options, "v", false);
        boolean sortByF1 = PropertiesUtils.hasProperty(options, "s");
        int worstKTreesToEmit = PropertiesUtils.getInt(options, "s", 0);
        PriorityQueue<Triple<Double, Tree, Tree>> queue = sortByF1 ? new PriorityQueue<Triple<Double, Tree, Tree>>(2000, new F1Comparator()) : null;
        boolean doCatLevel = PropertiesUtils.getBool(options, "c", false);
        String labelRegex = options.getProperty("f", null);
        String encoding = options.getProperty("e", "UTF-8");
        String[] parsedArgs = options.getProperty("", "").split("\\s+");
        if (parsedArgs.length != 2) {
            log.info(Evalb.usage());
            System.exit(-1);
        }
        String goldFile = parsedArgs[0];
        String guessFile = parsedArgs[1];
        tlpp.setInputEncoding(encoding);
        PrintWriter pwOut = tlpp.pw();
        DiskTreebank guessTreebank = tlpp.diskTreebank();
        guessTreebank.loadPath(guessFile);
        pwOut.println("GUESS TREEBANK:");
        pwOut.println(guessTreebank.textualSummary());
        DiskTreebank goldTreebank = tlpp.diskTreebank();
        goldTreebank.loadPath(goldFile);
        pwOut.println("GOLD TREEBANK:");
        pwOut.println(goldTreebank.textualSummary());
        Evalb metric = new Evalb("Evalb LP/LR", true);
        EvalbByCat evalbCat = doCatLevel ? new EvalbByCat("EvalbByCat LP/LR", true, labelRegex) : null;
        TreeTransformer tc = tlpp.collinizer();
        Iterator goldItr = ((AbstractCollection)goldTreebank).iterator();
        Iterator guessItr = ((AbstractCollection)guessTreebank).iterator();
        int goldLineId = 0;
        int guessLineId = 0;
        int skippedGuessTrees = 0;
        while (guessItr.hasNext() && goldItr.hasNext()) {
            Tree guessTree = (Tree)guessItr.next();
            ArrayList<Label> guessYield = guessTree.yield();
            ++guessLineId;
            Tree goldTree = (Tree)goldItr.next();
            ArrayList<Label> goldYield = goldTree.yield();
            ++goldLineId;
            if (goldYield.size() > maxGoldYield) {
                ++skippedGuessTrees;
                continue;
            }
            if (goldYield.size() != guessYield.size()) {
                pwOut.printf("Yield mismatch gold: %d tokens vs. guess: %d tokens (lines: gold %d guess %d)%n", goldYield.size(), guessYield.size(), goldLineId, guessLineId);
                ++skippedGuessTrees;
                continue;
            }
            Tree evalGuess = tc.transformTree(guessTree);
            Tree evalGold = tc.transformTree(goldTree);
            metric.evaluate(evalGuess, evalGold, VERBOSE ? pwOut : null);
            if (doCatLevel) {
                evalbCat.evaluate(evalGuess, evalGold, VERBOSE ? pwOut : null);
            }
            if (!sortByF1) continue;
            Evalb.storeTrees(queue, guessTree, goldTree, metric.getLastF1());
        }
        if (guessItr.hasNext() || goldItr.hasNext()) {
            System.err.printf("Guess/gold files do not have equal lengths (guess: %d gold: %d)%n.", guessLineId, goldLineId);
        }
        pwOut.println("================================================================================");
        if (skippedGuessTrees != 0) {
            pwOut.printf("%s %d guess trees\n", "Unable to evaluate", skippedGuessTrees);
        }
        metric.display(true, pwOut);
        pwOut.println();
        if (doCatLevel) {
            evalbCat.display(true, pwOut);
            pwOut.println();
        }
        if (sortByF1) {
            Evalb.emitSortedTrees(queue, worstKTreesToEmit, guessFile);
        }
        pwOut.close();
    }

    private static void emitSortedTrees(PriorityQueue<Triple<Double, Tree, Tree>> queue, int worstKTreesToEmit, String filePrefix) {
        if (queue == null) {
            log.info("Queue was not initialized properly");
        }
        try {
            PrintWriter guessPw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePrefix + ".kworst.guess"), "UTF-8")));
            PrintWriter goldPw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePrefix + ".kworst.gold"), "UTF-8")));
            LabeledScoredConstituentFactory cFact = new LabeledScoredConstituentFactory();
            PrintWriter guessDepPw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePrefix + ".kworst.guess.deps"), "UTF-8")));
            PrintWriter goldDepPw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePrefix + ".kworst.gold.deps"), "UTF-8")));
            System.out.printf("F1s of %d worst trees:\n", worstKTreesToEmit);
            for (int i = 0; queue.peek() != null && i < worstKTreesToEmit; ++i) {
                Triple<Double, Tree, Tree> trees = queue.poll();
                System.out.println(trees.first());
                goldPw.println(trees.second().toString());
                guessPw.println(trees.third().toString());
                Set<Constituent> goldDeps = Generics.newHashSet();
                goldDeps.addAll(trees.second().constituents(cFact));
                goldDeps.removeAll(trees.third().constituents(cFact));
                for (Constituent c : goldDeps) {
                    goldDepPw.print(c.toString() + "  ");
                }
                goldDepPw.println();
                Set<Constituent> guessDeps = Generics.newHashSet();
                guessDeps.addAll(trees.third().constituents(cFact));
                guessDeps.removeAll(trees.second().constituents(cFact));
                for (Constituent c : guessDeps) {
                    guessDepPw.print(c.toString() + "  ");
                }
                guessDepPw.println();
            }
            guessPw.close();
            goldPw.close();
            goldDepPw.close();
            guessDepPw.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void storeTrees(PriorityQueue<Triple<Double, Tree, Tree>> queue, Tree guess, Tree gold, double curF1) {
        if (queue == null) {
            return;
        }
        queue.add(new Triple<Double, Tree, Tree>(curF1, gold, guess));
    }

    private static class F1Comparator
    implements Comparator<Triple<Double, Tree, Tree>> {
        private F1Comparator() {
        }

        @Override
        public int compare(Triple<Double, Tree, Tree> o1, Triple<Double, Tree, Tree> o2) {
            double secondF1;
            double firstF1 = o1.first();
            if (firstF1 < (secondF1 = o2.first().doubleValue())) {
                return -1;
            }
            if (firstF1 == secondF1) {
                return 0;
            }
            return 1;
        }
    }

    public static class CBEval
    extends Evalb {
        private double cb = 0.0;
        private double num = 0.0;
        private double zeroCB = 0.0;

        protected void checkCrossing(Set<Constituent> s1, Set<Constituent> s2) {
            double c = 0.0;
            for (Constituent constit : s1) {
                if (!constit.crosses(s2)) continue;
                c += 1.0;
            }
            if (c == 0.0) {
                this.zeroCB += 1.0;
            }
            this.cb += c;
            this.num += 1.0;
        }

        @Override
        public void evaluate(Tree t1, Tree t2, PrintWriter pw) {
            Set<Constituent> b1 = this.makeObjects(t1);
            Set<Constituent> b2 = this.makeObjects(t2);
            this.checkCrossing(b1, b2);
            if (pw != null && this.runningAverages) {
                pw.println("AvgCB: " + (double)((int)(10000.0 * this.cb / this.num)) / 100.0 + " ZeroCB: " + (double)((int)(10000.0 * this.zeroCB / this.num)) / 100.0 + " N: " + this.getNum());
            }
        }

        @Override
        public void display(boolean verbose, PrintWriter pw) {
            pw.println(this.str + " AvgCB: " + (double)((int)(10000.0 * this.cb / this.num)) / 100.0 + " ZeroCB: " + (double)((int)(10000.0 * this.zeroCB / this.num)) / 100.0);
        }

        public CBEval(String str, boolean runningAverages) {
            super(str, runningAverages);
        }
    }
}

