/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.KBPRelationExtractor;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionExtractor;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KBPTokensregexExtractor
implements KBPRelationExtractor {
    protected static final Redwood.RedwoodChannels logger = Redwood.channels(KBPTokensregexExtractor.class);
    @ArgumentParser.Option(name="dir", gloss="The tokensregex directory")
    public static String DIR = "edu/stanford/nlp/models/kbp/english/tokensregex";
    @ArgumentParser.Option(name="test", gloss="The dataset to test on")
    public static File TEST_FILE = new File("test.conll");
    @ArgumentParser.Option(name="predictions", gloss="Dump model predictions to this file")
    public static Optional<String> PREDICTIONS = Optional.empty();
    private final Map<KBPRelationExtractor.RelationType, CoreMapExpressionExtractor> rules = new HashMap<KBPRelationExtractor.RelationType, CoreMapExpressionExtractor>();

    public KBPTokensregexExtractor(String tokensregexDir) {
        this(tokensregexDir, false);
    }

    public KBPTokensregexExtractor(String tokensregexDir, boolean verbose) {
        if (verbose) {
            logger.log("Creating TokensRegexExtractor");
        }
        for (KBPRelationExtractor.RelationType rel : KBPRelationExtractor.RelationType.values()) {
            String relFileNameComponent = rel.canonicalName.replaceAll(":", "_");
            String path = tokensregexDir + File.separator + relFileNameComponent.replaceAll("/", "SLASH") + ".rules";
            if (!IOUtils.existsInClasspathOrFileSystem(path)) continue;
            ArrayList<String> listFiles = new ArrayList<String>();
            listFiles.add(tokensregexDir + File.separator + "defs.rules");
            listFiles.add(path);
            if (verbose) {
                logger.log("Rule files for relation " + (java.lang.Object)((java.lang.Object)rel) + " is " + path);
            }
            Env env = TokenSequencePattern.getNewEnv();
            env.bind("collapseExtractionRules", true);
            env.bind("verbose", verbose);
            CoreMapExpressionExtractor extr = CoreMapExpressionExtractor.createExtractorFromFiles(env, listFiles).keepTemporaryTags();
            this.rules.put(rel, extr);
        }
    }

    @Override
    public Pair<String, Double> classify(KBPRelationExtractor.KBPInput input) {
        int i;
        CoreMap sentenceAsMap = input.sentence.asCoreMap(Sentence::nerTags);
        List tokens = (List)sentenceAsMap.get(CoreAnnotations.TokensAnnotation.class);
        java.lang.Object object = input.subjectSpan.iterator();
        while (object.hasNext()) {
            i = object.next();
            ((CoreLabel)tokens.get(i)).set(Subject.class, "true");
            if (!"O".equals(((CoreLabel)tokens.get(i)).ner())) continue;
            ((CoreLabel)tokens.get(i)).setNER(input.subjectType.name);
        }
        object = input.objectSpan.iterator();
        while (object.hasNext()) {
            i = object.next();
            ((CoreLabel)tokens.get(i)).set(Object.class, "true");
            if (!"O".equals(((CoreLabel)tokens.get(i)).ner())) continue;
            ((CoreLabel)tokens.get(i)).setNER(input.objectType.name);
        }
        for (KBPRelationExtractor.RelationType rel : KBPRelationExtractor.RelationType.values()) {
            CoreMapExpressionExtractor extractor;
            List extractions;
            if (!this.rules.containsKey((java.lang.Object)rel) || rel.entityType != input.subjectType || !rel.validNamedEntityLabels.contains((java.lang.Object)input.objectType) || (extractions = (extractor = this.rules.get((java.lang.Object)rel)).extractExpressions(sentenceAsMap)) == null || extractions.size() <= 0) continue;
            java.lang.Object best = MatchedExpression.getBestMatched(extractions, MatchedExpression.EXPR_WEIGHT_SCORER);
            for (CoreLabel token : tokens) {
                token.remove(Subject.class);
                token.remove(Object.class);
            }
            return Pair.makePair(rel.canonicalName, ((MatchedExpression)best).getWeight());
        }
        for (CoreLabel token : tokens) {
            token.remove(Subject.class);
            token.remove(Object.class);
        }
        return Pair.makePair("no_relation", 1.0);
    }

    public static void main(String[] args) throws IOException {
        RedwoodConfiguration.standard().apply();
        ArgumentParser.fillOptions(KBPTokensregexExtractor.class, args);
        KBPTokensregexExtractor extractor = new KBPTokensregexExtractor(DIR);
        List<Pair<KBPRelationExtractor.KBPInput, String>> testExamples = KBPRelationExtractor.readDataset(TEST_FILE);
        extractor.computeAccuracy(testExamples.stream(), PREDICTIONS.map(x -> {
            try {
                return "stdout".equalsIgnoreCase((String)x) ? System.out : new PrintStream(new FileOutputStream((String)x));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }));
    }

    public static class Object
    implements CoreAnnotation<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }
    }

    public static class Subject
    implements CoreAnnotation<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }
    }
}

