/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.neural;

import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.CorefRules;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.statistical.FeatureExtractor;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.neural.NeuralUtils;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.ejml.simple.SimpleMatrix;

public class CategoricalFeatureExtractor {
    private final Dictionaries dictionaries;
    private final Map<String, Integer> genres;
    private final boolean conll;

    public CategoricalFeatureExtractor(Properties props, Dictionaries dictionaries) {
        this.dictionaries = dictionaries;
        this.conll = CorefProperties.conll(props);
        if (this.conll) {
            boolean english;
            this.genres = new HashMap<String, Integer>();
            this.genres.put("bc", 0);
            this.genres.put("bn", 1);
            this.genres.put("mz", 2);
            this.genres.put("nw", 3);
            boolean bl = english = CorefProperties.getLanguage(props) == Locale.ENGLISH;
            if (english) {
                this.genres.put("pt", 4);
            }
            this.genres.put("tc", english ? 5 : 4);
            this.genres.put("wb", english ? 6 : 5);
        } else {
            this.genres = null;
        }
    }

    public SimpleMatrix getPairFeatures(Pair<Integer, Integer> pair, Document document, Map<Integer, List<Mention>> mentionsByHeadIndex) {
        Mention m1 = document.predictedMentionsByID.get(pair.first);
        Mention m2 = document.predictedMentionsByID.get(pair.second);
        List<Integer> featureVals = CategoricalFeatureExtractor.pairwiseFeatures(document, m1, m2, this.dictionaries);
        SimpleMatrix features = new SimpleMatrix(featureVals.size(), 1);
        for (int i = 0; i < featureVals.size(); ++i) {
            features.set(i, (double)featureVals.get(i).intValue());
        }
        features = NeuralUtils.concatenate(features, CategoricalFeatureExtractor.encodeDistance(m2.sentNum - m1.sentNum), CategoricalFeatureExtractor.encodeDistance(m2.mentionNum - m1.mentionNum - 1), new SimpleMatrix((double[][])new double[][]{{m1.sentNum == m2.sentNum && m1.endIndex > m2.startIndex ? 1.0 : 0.0}}), this.getMentionFeatures(m1, document, mentionsByHeadIndex), this.getMentionFeatures(m2, document, mentionsByHeadIndex), this.encodeGenre(document));
        return features;
    }

    public static List<Integer> pairwiseFeatures(Document document, Mention m1, Mention m2, Dictionaries dictionaries) {
        String speaker1 = (String)m1.headWord.get(CoreAnnotations.SpeakerAnnotation.class);
        String speaker2 = (String)m2.headWord.get(CoreAnnotations.SpeakerAnnotation.class);
        boolean hasSpeakers = speaker1 != null && speaker2 != null;
        ArrayList<Integer> features = new ArrayList<Integer>();
        features.add(hasSpeakers ? (speaker1.equals(speaker2) ? 1 : 0) : 0);
        features.add(hasSpeakers ? (CorefRules.antecedentIsMentionSpeaker(document, m2, m1, dictionaries) ? 1 : 0) : 0);
        features.add(hasSpeakers ? (CorefRules.antecedentIsMentionSpeaker(document, m1, m2, dictionaries) ? 1 : 0) : 0);
        features.add(m1.headsAgree(m2) ? 1 : 0);
        features.add(m1.toString().trim().toLowerCase().equals(m2.toString().trim().toLowerCase()) ? 1 : 0);
        features.add(FeatureExtractor.relaxedStringMatch(m1, m2) ? 1 : 0);
        return features;
    }

    public SimpleMatrix getAnaphoricityFeatures(Mention m, Document document, Map<Integer, List<Mention>> mentionsByHeadIndex) {
        return NeuralUtils.concatenate(this.getMentionFeatures(m, document, mentionsByHeadIndex), this.encodeGenre(document));
    }

    private SimpleMatrix getMentionFeatures(Mention m, Document document, Map<Integer, List<Mention>> mentionsByHeadIndex) {
        return NeuralUtils.concatenate(NeuralUtils.oneHot(m.mentionType.ordinal(), 4), CategoricalFeatureExtractor.encodeDistance(m.endIndex - m.startIndex - 1), new SimpleMatrix((double[][])new double[][]{{(double)m.mentionNum / (double)document.predictedMentionsByID.size()}, {mentionsByHeadIndex.get(m.headIndex).stream().anyMatch(m2 -> m != m2 && m.insideIn((Mention)m2)) ? 1.0 : 0.0}}));
    }

    public static SimpleMatrix encodeDistance(int d) {
        SimpleMatrix m = new SimpleMatrix(11, 1);
        if (d < 5) {
            m.set(d, 1.0);
        } else if (d < 8) {
            m.set(5, 1.0);
        } else if (d < 16) {
            m.set(6, 1.0);
        } else if (d < 32) {
            m.set(7, 1.0);
        } else if (d < 64) {
            m.set(8, 1.0);
        } else {
            m.set(9, 1.0);
        }
        m.set(10, (double)Math.min(d, 64) / 64.0);
        return m;
    }

    private SimpleMatrix encodeGenre(Document document) {
        return this.conll ? NeuralUtils.oneHot(this.genres.get(document.docInfo.get("DOC_ID").split("/")[0]), this.genres.size()) : new SimpleMatrix(1, 1);
    }
}

