/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.layout.element.Link;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TextRenderer;

public class LinkRenderer
extends TextRenderer {
    public LinkRenderer(Link link) {
        this(link, link.getText());
    }

    public LinkRenderer(Link linkElement, String text) {
        super(linkElement, text);
    }

    @Override
    public void draw(DrawContext drawContext) {
        super.draw(drawContext);
        boolean isRelativePosition = this.isRelativePosition();
        if (isRelativePosition) {
            this.applyAbsolutePositioningTranslation(false);
        }
        PdfLinkAnnotation linkAnnotation = ((Link)this.modelElement).getLinkAnnotation();
        Rectangle pdfBBox = this.calculateAbsolutePdfBBox();
        linkAnnotation.setRectangle(new PdfArray(pdfBBox));
        if (isRelativePosition) {
            this.applyAbsolutePositioningTranslation(true);
        }
        PdfPage page = drawContext.getDocument().getPage(this.occupiedArea.getPageNumber());
        page.addAnnotation((PdfAnnotation)linkAnnotation);
    }

    @Override
    public IRenderer getNextRenderer() {
        return new LinkRenderer((Link)this.modelElement, null);
    }
}

