/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dkm.pikes.depparseannotation;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dkm.pikes.depparseannotation.DepParseInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class StanfordToConllDepsAnnotator
implements Annotator {
    public StanfordToConllDepsAnnotator(String annotatorName, Properties props) {
    }

    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            int sentOffset = 0;
            boolean useOffset = false;
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                SemanticGraph dependencies = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
                if (dependencies != null) {
                    DepParseInfo info = new DepParseInfo(dependencies);
                    Set<Integer> ints = info.getDepLabels().keySet();
                    if (!useOffset && Collections.min(ints) != 1) {
                        useOffset = true;
                    }
                    for (int i = 0; i < tokens.size(); ++i) {
                        CoreLabel token = (CoreLabel)tokens.get(i);
                        int j = i;
                        if (useOffset) {
                            j += sentOffset;
                        }
                        String label = info.getDepLabels().get(j + 1);
                        int head = info.getDepParents().get(j + 1) - 1;
                        if (useOffset) {
                            head -= sentOffset;
                        }
                        if (head < -1) {
                            head = -1;
                        }
                        token.set(CoreAnnotations.CoNLLDepTypeAnnotation.class, (Object)label);
                        token.set(CoreAnnotations.CoNLLDepParentIndexAnnotation.class, (Object)head);
                    }
                }
                sentOffset += tokens.size();
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.CoNLLDepTypeAnnotation.class, CoreAnnotations.CoNLLDepParentIndexAnnotation.class)));
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.TokensAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)));
    }
}

