/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability.utils;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import eu.fbk.dh.tint.readability.Readability;
import eu.fbk.dh.tint.readability.ReadabilityAnnotations;
import eu.fbk.utils.core.CommandLine;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class CalculateParameters {
    public static Set<String> values = new HashSet<String>();

    public static void main(String[] args) {
        try {
            CommandLine cmd = CommandLine.parser().withName("./calculate-values").withHeader("Calculate values for online demo").withOption("e", "input-easy", "Input folder", "FILE", CommandLine.Type.DIRECTORY_EXISTING, true, false, true).withOption("d", "input-difficult", "Input folder", "FILE", CommandLine.Type.DIRECTORY_EXISTING, true, false, true).withLogger(LoggerFactory.getLogger((String)"eu.fbk")).parse(args);
            File inputEasyFolder = (File)cmd.getOptionValue("input-easy", File.class);
            File inputDiffFolder = (File)cmd.getOptionValue("input-difficult", File.class);
            Properties properties = new Properties();
            properties.setProperty("annotators", "tokenize, ssplit, pos, lemma, parse, depparse, readability");
            properties.setProperty("annotators", "tokenize, ssplit, pos, lemma, readability");
            properties.setProperty("customAnnotatorClass.readability", "eu.fbk.dh.tint.readability.ReadabilityAnnotator");
            properties.setProperty("readability.language", "en");
            properties.setProperty("readability.ttrLimit", "100");
            StanfordCoreNLP coreNLP = new StanfordCoreNLP(properties);
            HashMap<String, Double> sums = new HashMap<String, Double>();
            for (String value : values) {
                sums.putIfAbsent(value, 0.0);
            }
            sums.putIfAbsent("main", 0.0);
            HashMap<String, File> list = new HashMap<String, File>();
            list.put("easy", inputEasyFolder);
            list.put("difficult", inputDiffFolder);
            int limit = 0;
            for (Map.Entry entry : list.entrySet()) {
                int fileCount = 0;
                for (File file : ((File)entry.getValue()).listFiles()) {
                    if (file.isDirectory() || limit > 0 && ++fileCount > limit) continue;
                    System.out.println(file.getAbsolutePath());
                    Annotation annotation = new Annotation(Files.toString((File)file, (Charset)Charsets.UTF_8));
                    coreNLP.annotate(annotation);
                    Readability readability = (Readability)annotation.get(ReadabilityAnnotations.ReadabilityAnnotation.class);
                    boolean tokenCount = true;
                    Double v = (Double)sums.get("ttrValue");
                    v = v + readability.getTtrValue() * (double)tokenCount;
                    sums.put("ttrValue", v);
                    v = (Double)sums.get("density");
                    v = v + readability.getDensity() * (double)tokenCount;
                    sums.put("density", v);
                }
            }
        }
        catch (Exception e) {
            CommandLine.fail((Throwable)e);
        }
    }

    static {
        values.add("ttrValue");
        values.add("deepAvg");
        values.add("deepMax");
        values.add("density");
    }
}

