/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.readability.Readability;
import eu.fbk.dh.tint.readability.ReadabilityAnnotations;
import eu.fbk.dh.tint.readability.en.EnglishStandardReadability;
import eu.fbk.dh.tint.readability.es.SpanishStandardReadability;
import eu.fbk.dh.tint.readability.gl.GalicianStandardReadability;
import eu.fbk.dh.tint.readability.it.ItalianStandardReadability;
import eu.fbk.utils.core.PropertiesUtils;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadabilityAnnotator
implements Annotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadabilityAnnotator.class);
    public static Integer DEFAULT_MAX_SENTENCE_LENGTH = 25;
    private String language;
    private String className;
    private int maxSentenceLength;
    private Properties globalProperties;
    private Properties localProperties;

    public ReadabilityAnnotator(String annotatorName, Properties props) {
        this.globalProperties = props;
        this.localProperties = PropertiesUtils.dotConvertedProperties((Properties)props, (String)annotatorName);
        this.language = this.globalProperties.getProperty(annotatorName + ".language");
        this.className = this.globalProperties.getProperty(annotatorName + ".className");
        this.maxSentenceLength = PropertiesUtils.getInteger((String)this.localProperties.getProperty("maxSentenceLength"), (int)DEFAULT_MAX_SENTENCE_LENGTH);
    }

    public void annotate(Annotation annotation) {
        Readability readability = null;
        if (this.className != null) {
            try {
                Class<?> obj = Class.forName(this.className);
                Constructor<?> constructor = obj.getConstructor(Properties.class, Properties.class, Annotation.class);
                readability = (Readability)constructor.newInstance(this.globalProperties, this.localProperties, annotation);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (readability == null) {
            if (this.language == null) {
                LOGGER.warn("Language variable is not defined, readability will be empty");
                return;
            }
            switch (this.language) {
                case "it": {
                    readability = new ItalianStandardReadability(this.globalProperties, this.localProperties, annotation);
                    break;
                }
                case "es": {
                    readability = new SpanishStandardReadability(this.globalProperties, this.localProperties, annotation);
                    break;
                }
                case "en": {
                    readability = new EnglishStandardReadability(this.globalProperties, this.localProperties, annotation);
                    break;
                }
                case "gl": {
                    readability = new GalicianStandardReadability(this.globalProperties, this.localProperties, annotation);
                }
            }
        }
        if (readability == null) {
            return;
        }
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        int tokenCount = 0;
        int goodSentencesCount = 0;
        for (CoreMap sentence : sentences) {
            int sentenceID = (Integer)sentence.get(CoreAnnotations.SentenceIndexAnnotation.class);
            int wordsNow = readability.getWordCount();
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            if (tokens.size() <= 1 && ((String)sentence.get(CoreAnnotations.TextAnnotation.class)).length() > 25) continue;
            ++goodSentencesCount;
            for (CoreLabel token : tokens) {
                readability.addWord(token);
                ++tokenCount;
            }
            int words = readability.getWordCount() - wordsNow;
            if (words <= this.maxSentenceLength) continue;
            readability.addTooLongSentence(sentenceID);
        }
        readability.setTokenCount(tokenCount);
        readability.setSentenceCount(sentences.size());
        readability.setGoodSentenceCount(goodSentencesCount);
        readability.finalizeReadability();
        annotation.set(ReadabilityAnnotations.ReadabilityAnnotation.class, (Object)readability);
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(ReadabilityAnnotations.ReadabilityAnnotation.class);
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }
}

