/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability;

import com.itextpdf.layout.hyphenation.Hyphenation;
import com.itextpdf.layout.hyphenation.Hyphenator;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.readability.DescriptionForm;
import eu.fbk.dh.tint.readability.ReadabilityAnnotations;
import eu.fbk.dh.tint.readability.SemanticGraphUtils;
import eu.fbk.dh.tint.readability.es.SpanishReadabilityModel;
import eu.fbk.dh.tint.verb.VerbAnnotations;
import eu.fbk.dh.tint.verb.VerbMultiToken;
import eu.fbk.utils.core.FrequencyHashSet;
import eu.fbk.utils.core.PropertiesUtils;
import eu.fbk.utils.gson.JSONExclude;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;

public abstract class Readability {
    public static Integer DEFAULT_TTR_LIMIT = 100;
    @JSONExclude
    private int ttrLimit;
    private String language = null;
    private int contentWordSize = 0;
    private int contentEasyWordSize = 0;
    private int wordCount = 0;
    private int docLenWithSpaces = 0;
    private int docLenWithoutSpaces = 0;
    private int docLenLettersOnly = 0;
    private int goodSentenceCount = 0;
    private int sentenceCount = 0;
    private int tokenCount = 0;
    private int hyphenCount = 0;
    private int hyphenWordCount = 0;
    private Double ttrValue;
    private Double density;
    private Double deepAvg;
    private Double deepMax;
    private Double propositionsAvg;
    private Double wordsAvg;
    private Double subordinateRatio;
    Map<Integer, Integer> deeps = new HashMap<Integer, Integer>();
    protected TreeMap<Integer, DescriptionForm> forms = new TreeMap();
    protected Map<String, Double> measures = new HashMap<String, Double>();
    protected Map<String, String> labels = new HashMap<String, String>();
    protected Map<String, Double> minYellowValues = new HashMap<String, Double>();
    protected Map<String, Double> maxYellowValues = new HashMap<String, Double>();
    protected Map<String, Double> minValues = new HashMap<String, Double>();
    protected Map<String, Double> maxValues = new HashMap<String, Double>();
    @JSONExclude
    protected HashSet<String> contentPosList = new HashSet();
    @JSONExclude
    protected HashSet<String> simplePosList = new HashSet();
    @JSONExclude
    protected HashSet<String> nonWordPosList = new HashSet();
    protected HashMap<String, String> genericPosDescription = new HashMap();
    protected HashMap<String, String> posDescription = new HashMap();
    @JSONExclude
    boolean useGenericForContent = true;
    @JSONExclude
    boolean useGenericForSimple = true;
    @JSONExclude
    boolean useGenericForWord = true;
    Set<Integer> tooLongSentences = new HashSet<Integer>();
    FrequencyHashSet<String> posStats = new FrequencyHashSet();
    FrequencyHashSet<String> genericPosStats = new FrequencyHashSet();
    @JSONExclude
    protected Hyphenator hyphenator;
    @JSONExclude
    protected Annotation annotation;

    public int getHyphenWordCount() {
        return this.hyphenWordCount;
    }

    public Readability(String language, Annotation annotation, Properties localProperties) {
        this.language = language;
        this.annotation = annotation;
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        this.docLenWithSpaces = text.length();
        this.docLenWithoutSpaces = text.replaceAll("\\s+", "").length();
        this.ttrLimit = PropertiesUtils.getInteger((String)localProperties.getProperty("ttrLimit"), (int)DEFAULT_TTR_LIMIT);
    }

    public void finalizeReadability() {
        int total;
        Number sentSubordinateRatio;
        Object pos;
        int sentIndex;
        HashSet<String> ttr = new HashSet<String>();
        int i = 0;
        for (CoreLabel token : (List)this.annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            Boolean isWord = (Boolean)token.get(ReadabilityAnnotations.LiteralWord.class);
            if (isWord == null || !isWord.booleanValue()) continue;
            if (this.ttrLimit > 0 && i >= this.ttrLimit) break;
            String tokenText = token.originalText().toLowerCase();
            ttr.add(tokenText);
            ++i;
        }
        ArrayList<Integer> propositions = new ArrayList<Integer>();
        Integer coordinates = 0;
        Integer subordinates = 0;
        List sentences = (List)this.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        if (this.language.equals("en")) {
            for (sentIndex = 0; sentIndex < sentences.size(); ++sentIndex) {
                int sentSubordinates = 0;
                int sentCoordinates = 0;
                int auxAnnotations = 0;
                int verbAnnotations = 0;
                CoreMap sentence = (CoreMap)sentences.get(sentIndex);
                SemanticGraph semanticGraph2 = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
                try {
                    for (SemanticGraphEdge edge : semanticGraph2.edgeListSorted()) {
                        switch (edge.getRelation().getShortName()) {
                            case "aux": 
                            case "auxpass": {
                                ++auxAnnotations;
                                break;
                            }
                            case "mark": 
                            case "acl:relcl": {
                                ++sentSubordinates;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                    pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    if (!((String)pos).startsWith("V") && !((String)pos).startsWith("M")) continue;
                    ++verbAnnotations;
                }
                propositions.add(verbAnnotations -= auxAnnotations);
                sentCoordinates = Math.max(0, verbAnnotations - sentSubordinates);
                Integer sentTotal = sentCoordinates + sentSubordinates;
                coordinates = coordinates + sentCoordinates;
                subordinates = subordinates + sentSubordinates;
                sentSubordinateRatio = 0.0;
                if (sentTotal > 0) {
                    sentSubordinateRatio = 1.0 * (double)sentSubordinates / (double)sentTotal.intValue();
                }
                sentence.set(ReadabilityAnnotations.SubordinateRatioAnnotation.class, (Object)sentSubordinateRatio);
            }
        }
        for (sentIndex = 0; sentIndex < sentences.size(); ++sentIndex) {
            CoreMap sentence = (CoreMap)sentences.get(sentIndex);
            SemanticGraph semanticGraph = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            int depth = 0;
            if (semanticGraph == null) continue;
            for (IndexedWord indexedWord : semanticGraph.getLeafVertices()) {
                try {
                    depth = Math.max(depth, semanticGraph.getPathToRoot(indexedWord).size());
                }
                catch (NullPointerException semanticGraph2) {}
            }
            this.deeps.put(sentIndex, depth);
            sentence.set(ReadabilityAnnotations.SentenceDepthAnnotation.class, (Object)depth);
            Integer contentWords = 0;
            Integer literalWords = 0;
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                if (token.get(ReadabilityAnnotations.ContentWord.class) != null && ((Boolean)token.get(ReadabilityAnnotations.ContentWord.class)).booleanValue()) {
                    sentSubordinateRatio = contentWords;
                    contentWords = contentWords + 1;
                    pos = contentWords;
                }
                if (token.get(ReadabilityAnnotations.LiteralWord.class) == null || !((Boolean)token.get(ReadabilityAnnotations.LiteralWord.class)).booleanValue()) continue;
                sentSubordinateRatio = literalWords;
                literalWords = literalWords + 1;
                pos = literalWords;
            }
            Double sentDensity = 1.0 * (double)contentWords.intValue() / (double)literalWords.intValue();
            sentence.set(ReadabilityAnnotations.DensityAnnotation.class, (Object)sentDensity);
            sentence.set(ReadabilityAnnotations.ContentWordsAnnotation.class, (Object)contentWords);
            sentence.set(ReadabilityAnnotations.LiteralWordsAnnotation.class, (Object)literalWords);
            if (!sentence.containsKey(VerbAnnotations.VerbsAnnotation.class) || !this.language.equals("it")) continue;
            Integer sentCoordinates = 0;
            Integer sentSubordinates = 0;
            List verbs = (List)sentence.get(VerbAnnotations.VerbsAnnotation.class);
            propositions.add(verbs.size());
            HashSet<Integer> heads = new HashSet<Integer>();
            for (VerbMultiToken verb : verbs) {
                Integer n;
                Integer n2;
                Map<Integer, String> parentIDs = SemanticGraphUtils.getParent(verb, semanticGraph);
                Integer head = SemanticGraphUtils.getHead(verb, semanticGraph);
                heads.add(head);
                if (parentIDs.size() == 0) continue;
                if (parentIDs.values().contains("conj")) {
                    n2 = sentCoordinates;
                    n = sentCoordinates = Integer.valueOf(sentCoordinates + 1);
                    continue;
                }
                n2 = sentSubordinates;
                n = sentSubordinates = Integer.valueOf(sentSubordinates + 1);
            }
            Integer sentTotal = sentCoordinates + sentSubordinates;
            coordinates = coordinates + sentCoordinates;
            subordinates = subordinates + sentSubordinates;
            Double sentSubordinateRatio2 = 0.0;
            if (sentTotal > 0) {
                sentSubordinateRatio2 = 1.0 * (double)sentSubordinates.intValue() / (double)sentTotal.intValue();
            }
            sentence.set(ReadabilityAnnotations.SubordinateRatioAnnotation.class, (Object)sentSubordinateRatio2);
        }
        this.ttrValue = 1.0 * (double)ttr.size() / (1.0 * (double)i);
        if (this.deeps.size() > 0) {
            this.deepAvg = this.deeps.values().stream().mapToInt(val -> val).average().getAsDouble();
            this.deepMax = (double)this.deeps.values().stream().mapToInt(val -> val).max().getAsInt() * 1.0;
        }
        if (propositions.size() > 0) {
            this.propositionsAvg = propositions.stream().mapToInt(val -> val).average().getAsDouble();
            this.wordsAvg = 1.0 * (double)this.getWordCount() / (double)propositions.stream().mapToInt(val -> val).sum();
            if (this.wordsAvg == Double.POSITIVE_INFINITY) {
                this.wordsAvg = 0.0;
            }
        }
        this.subordinateRatio = (total = coordinates + subordinates) == 0 ? Double.valueOf(0.0) : Double.valueOf(1.0 * (double)subordinates.intValue() / (double)(coordinates + subordinates));
        this.density = 1.0 * (double)this.getContentWordSize() / (double)this.getWordCount();
    }

    public Map<String, Double> getMeasures() {
        return this.measures;
    }

    public void addingContentWord(CoreLabel token) {
        token.set(ReadabilityAnnotations.ContentWord.class, (Object)true);
    }

    public abstract void addingEasyWord(CoreLabel var1);

    public void addingWord(CoreLabel token) {
        token.set(ReadabilityAnnotations.LiteralWord.class, (Object)true);
    }

    public abstract void addingToken(CoreLabel var1);

    public abstract void addingSentence(CoreMap var1);

    public void addTooLongSentence(Integer sentenceID) {
        this.tooLongSentences.add(sentenceID);
    }

    public Set<Integer> getTooLongSentences() {
        return this.tooLongSentences;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getContentWordSize() {
        return this.contentWordSize;
    }

    public void setContentWordSize(int contentWordSize) {
        this.contentWordSize = contentWordSize;
    }

    public int getContentEasyWordSize() {
        return this.contentEasyWordSize;
    }

    public void setContentEasyWordSize(int contentEasyWordSize) {
        this.contentEasyWordSize = contentEasyWordSize;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    public void setWordCount(int wordCount) {
        this.wordCount = wordCount;
    }

    public int getDocLenWithSpaces() {
        return this.docLenWithSpaces;
    }

    public void setDocLenWithSpaces(int docLenWithSpaces) {
        this.docLenWithSpaces = docLenWithSpaces;
    }

    public int getDocLenWithoutSpaces() {
        return this.docLenWithoutSpaces;
    }

    public void setDocLenWithoutSpaces(int docLenWithoutSpaces) {
        this.docLenWithoutSpaces = docLenWithoutSpaces;
    }

    public int getDocLenLettersOnly() {
        return this.docLenLettersOnly;
    }

    public void setDocLenLettersOnly(int docLenLettersOnly) {
        this.docLenLettersOnly = docLenLettersOnly;
    }

    public int getGoodSentenceCount() {
        return this.goodSentenceCount;
    }

    public void setGoodSentenceCount(int goodSentenceCount) {
        this.goodSentenceCount = goodSentenceCount;
    }

    public int getSentenceCount() {
        return this.sentenceCount;
    }

    public void setSentenceCount(int sentenceCount) {
        this.sentenceCount = sentenceCount;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public void setTokenCount(int tokenCount) {
        this.tokenCount = tokenCount;
    }

    public FrequencyHashSet<String> getPosStats() {
        return this.posStats;
    }

    public FrequencyHashSet<String> getGenericPosStats() {
        return this.genericPosStats;
    }

    public String getTransformedPos(String pos) {
        return pos;
    }

    public int getHyphenCount() {
        return this.hyphenCount;
    }

    public void setHyphenCount(int hyphenCount) {
        this.hyphenCount = hyphenCount;
    }

    public void incrementHyphenCount(int increment) {
        this.hyphenCount += increment;
    }

    public static String flattenToAscii(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        for (char c : string.toCharArray()) {
            if (c > '\u007f') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public void addWord(CoreLabel token) {
        token.set(ReadabilityAnnotations.ContentWord.class, (Object)false);
        token.set(ReadabilityAnnotations.LiteralWord.class, (Object)false);
        String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
        String word = token.word();
        this.addingToken(token);
        if (this.isWordPos(pos)) {
            this.addingWord(token);
            ++this.wordCount;
            this.docLenLettersOnly += token.endPosition() - token.beginPosition();
            word = Readability.flattenToAscii(word);
            Hyphenation hyphenation = this.hyphenator.hyphenate(word);
            boolean done = false;
            if (hyphenation != null) {
                try {
                    String h = hyphenation.toString();
                    this.incrementHyphenCount(hyphenation.length() + 1);
                    token.set(ReadabilityAnnotations.HyphenationAnnotation.class, (Object)h);
                    done = true;
                    ++this.hyphenWordCount;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!done && word.length() < 5) {
                this.incrementHyphenCount(1);
                ++this.hyphenWordCount;
            }
            if (this.isContentPos(pos)) {
                ++this.contentWordSize;
                this.addingContentWord(token);
            }
            if (this.isEasyPos(pos)) {
                ++this.contentEasyWordSize;
                this.addingEasyWord(token);
            }
        }
        if (token.get(ReadabilityAnnotations.HyphenationAnnotation.class) == null) {
            token.set(ReadabilityAnnotations.HyphenationAnnotation.class, (Object)token.originalText());
        }
        String genericPos = this.getGenericPos(pos);
        this.posStats.add((Object)pos);
        this.genericPosStats.add((Object)genericPos);
    }

    protected String getGenericPos(String pos) {
        return pos.substring(0, 1);
    }

    protected boolean getGenericPosInfo(boolean constraint, Set<String> setToCheck, String pos, boolean reverse) {
        if (constraint) {
            pos = this.getGenericPos(pos);
        }
        boolean ret = setToCheck.contains(pos);
        if (reverse) {
            return !ret;
        }
        return ret;
    }

    public static InputStream getStream(String fileName, @Nullable String defaultFileName) throws FileNotFoundException {
        File streamFile;
        if (fileName != null && (streamFile = new File(fileName)).exists()) {
            return new FileInputStream(streamFile);
        }
        InputStream input = SpanishReadabilityModel.class.getResourceAsStream(defaultFileName);
        if (input != null) {
            return input;
        }
        if (defaultFileName != null) {
            return Readability.getStream(defaultFileName, null);
        }
        return null;
    }

    protected boolean isWordPos(String pos) {
        return this.getGenericPosInfo(this.useGenericForWord, this.nonWordPosList, pos, true);
    }

    protected boolean isContentPos(String pos) {
        return this.getGenericPosInfo(this.useGenericForContent, this.contentPosList, pos, false);
    }

    protected boolean isEasyPos(String pos) {
        return this.getGenericPosInfo(this.useGenericForSimple, this.simplePosList, pos, false);
    }

    public Double getTtrValue() {
        return this.ttrValue;
    }

    public Double getDeepAvg() {
        return this.deepAvg;
    }

    public Double getDeepMax() {
        return this.deepMax;
    }

    public Double getPropositionsAvg() {
        return this.propositionsAvg;
    }

    public Double getWordsAvg() {
        return this.wordsAvg;
    }

    public Double getSubordinateRatio() {
        return this.subordinateRatio;
    }

    public Double getDensity() {
        return this.density;
    }

    public String toString() {
        return "Readability{language='" + this.language + '\'' + ", contentWordSize=" + this.contentWordSize + ", contentEasyWordSize=" + this.contentEasyWordSize + ", wordCount=" + this.wordCount + ", docLenWithSpaces=" + this.docLenWithSpaces + ", docLenWithoutSpaces=" + this.docLenWithoutSpaces + ", docLenLettersOnly=" + this.docLenLettersOnly + ", sentenceCount=" + this.sentenceCount + ", tokenCount=" + this.tokenCount + ", hyphenCount=" + this.hyphenCount + ", hyphenWordCount=" + this.hyphenWordCount + ", ttrValue=" + this.ttrValue + ", deepAvg=" + this.deepAvg + ", deepMax=" + this.deepMax + ", propositionsAvg=" + this.propositionsAvg + ", wordsAvg=" + this.wordsAvg + ", subordinateRatio=" + this.subordinateRatio + ", measures=" + this.measures + ", contentPosList=" + this.contentPosList + ", simplePosList=" + this.simplePosList + ", nonWordPosList=" + this.nonWordPosList + ", tooLongSentences=" + this.tooLongSentences + ", posStats=" + this.posStats + ", genericPosStats=" + this.genericPosStats + '}';
    }
}

