/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.readability;

import com.google.common.collect.HashMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import eu.fbk.utils.core.CommandLine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseDeMauro {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseDeMauro.class);

    public static void main(String[] args) {
        try {
            String line;
            CommandLine cmd = CommandLine.parser().withName("./parse-demauro").withHeader("Parse HTML file extracted from De Mauro").withOption("i", "input", "Input file", "FILE", CommandLine.Type.FILE_EXISTING, true, false, true).withOption("o", "output", "Output file", "FILE", CommandLine.Type.FILE, true, false, true).withLogger(LoggerFactory.getLogger((String)"eu.fbk")).parse(args);
            File inputFile = (File)cmd.getOptionValue("input", File.class);
            File outputFile = (File)cmd.getOptionValue("output", File.class);
            HashMultimap level1 = HashMultimap.create();
            HashMultimap level2 = HashMultimap.create();
            HashMultimap level3 = HashMultimap.create();
            BufferedReader reader = new BufferedReader(new FileReader(inputFile));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).contains("Grassetto")) {
                    ParseDeMauro.addWordToLevel((HashMultimap<String, String>)level1, line.replaceAll("</?span[^>]*>", ""));
                    continue;
                }
                if (line.contains("Corsivo")) {
                    ParseDeMauro.addWordToLevel((HashMultimap<String, String>)level3, line.replaceAll("</?span[^>]*>", ""));
                    continue;
                }
                ParseDeMauro.addWordToLevel((HashMultimap<String, String>)level2, line.replaceAll("</?span[^>]*>", ""));
            }
            reader.close();
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.setPrettyPrinting();
            gsonBuilder.registerTypeAdapter(HashMultimap.class, (Object)new HashMultimapSerializer());
            Gson gson = gsonBuilder.create();
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("level-1", gson.toJsonTree((Object)level1));
            jsonObject.add("level-2", gson.toJsonTree((Object)level2));
            jsonObject.add("level-3", gson.toJsonTree((Object)level3));
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
            writer.write(gson.toJson((JsonElement)jsonObject));
            writer.close();
        }
        catch (Exception e) {
            CommandLine.fail((Throwable)e);
        }
    }

    private static void addWordToLevel(HashMultimap<String, String> level, String s) {
        String firstPart = s.replaceAll("\\s.*", "");
        String secondPart = s.replaceAll("^[^\\s]*\\s", "");
        if (firstPart.length() < 3) {
            return;
        }
        if (secondPart.contains(" s.") || secondPart.startsWith("s.")) {
            level.put((Object)"n", (Object)firstPart);
        }
        if (secondPart.contains(" avv.") || secondPart.startsWith("avv.")) {
            level.put((Object)"r", (Object)firstPart);
        }
        if (secondPart.contains(" agg.") || secondPart.startsWith("agg.")) {
            level.put((Object)"a", (Object)firstPart);
        }
        if (secondPart.contains(" v.") || secondPart.startsWith("v.")) {
            level.put((Object)"v", (Object)firstPart);
        }
    }

    static class HashMultimapSerializer
    implements JsonSerializer<HashMultimap> {
        HashMultimapSerializer() {
        }

        public JsonElement serialize(HashMultimap hashMultimap, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject object = new JsonObject();
            for (Object key : hashMultimap.keySet()) {
                object.add(key.toString(), jsonSerializationContext.serialize((Object)hashMultimap.get(key)));
            }
            return object;
        }
    }
}

