/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.kd.annotator;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.kd.annotator.DigiKDAnnotations;
import eu.fbk.dh.kd.annotator.DigiKDModel;
import eu.fbk.dh.kd.annotator.DigiKDResult;
import eu.fbk.dh.kd.lib.KD_configuration;
import eu.fbk.dh.kd.lib.KD_core;
import eu.fbk.dh.kd.lib.KD_keyconcept;
import eu.fbk.dh.kd.lib.KD_loader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DigiKDAnnotator
implements Annotator {
    private KD_configuration configuration = new KD_configuration();
    private KD_core.Language lang = KD_core.Language.ENGLISH;
    private KD_core kd;

    public DigiKDAnnotator(String annotatorName, Properties prop) {
        KD_core.Threads t;
        this.lang = KD_core.Language.valueOf((String)prop.getProperty(annotatorName + ".language", "ENGLISH").toUpperCase());
        if (prop.getProperty(annotatorName + ".language", "ENGLISH").toUpperCase().equals("CUSTOM")) {
            this.lang = KD_core.Language.CUSTOM;
            this.lang.set_Custom_Language(prop.getProperty(annotatorName + ".languageName", "ENGLISH").toUpperCase());
        }
        this.configuration.languagePackPath = prop.getProperty(annotatorName + ".languageFolder", KD_configuration.getDefault_laguage_pack_localtion());
        this.configuration.only_multiword = Boolean.parseBoolean(prop.getProperty(annotatorName + ".only_multiword", "false"));
        this.configuration.numberOfConcepts = Integer.parseInt(prop.getProperty(annotatorName + ".numberOfConcepts", "20"));
        this.configuration.local_frequency_threshold = Integer.parseInt(prop.getProperty(annotatorName + ".local_frequency_threshold", "2"));
        this.configuration.max_keyword_length = Integer.parseInt(prop.getProperty(annotatorName + ".max_keyword_length", "4"));
        this.configuration.prefer_specific_concept = KD_configuration.Prefer_Specific_Concept.valueOf((String)prop.getProperty(annotatorName + ".prefer_specific_concept", "MEDIUM").toUpperCase());
        this.configuration.tagset = KD_configuration.Tagset.STANFORD;
        this.configuration.column_configuration = KD_configuration.ColumExtraction.TOKEN_LEMMA_POS;
        this.configuration.group_by = KD_configuration.Group.valueOf((String)prop.getProperty(annotatorName + ".group_by", "NONE").toUpperCase());
        this.configuration.no_syn = Boolean.parseBoolean(prop.getProperty(annotatorName + ".no_syn", "false"));
        this.configuration.no_idf = Boolean.parseBoolean(prop.getProperty(annotatorName + ".no_idf", "false"));
        this.configuration.use_pattern_weight = Boolean.parseBoolean(prop.getProperty(annotatorName + ".use_pattern_weight", "false"));
        this.configuration.capitalize_pos = Boolean.parseBoolean(prop.getProperty(annotatorName + ".capitalize_pos", "false"));
        this.configuration.boost_acronyms = Boolean.parseBoolean(prop.getProperty(annotatorName + ".boost_acronyms", "false"));
        this.configuration.skipFrequencyAbsorption = Boolean.parseBoolean(prop.getProperty(annotatorName + ".skipFrequencyAbsorption", "false"));
        this.configuration.skip_keyword_with_proper_noun = Boolean.parseBoolean(prop.getProperty(annotatorName + ".skip_keyword_with_proper_noun", "true"));
        this.configuration.skip_proper_noun = Boolean.parseBoolean(prop.getProperty(annotatorName + ".skip_proper_noun", "true"));
        this.configuration.use_pattern_weight = Boolean.parseBoolean(prop.getProperty(annotatorName + ".use_pattern_weight", "false"));
        this.configuration.no_abstract = Boolean.parseBoolean(prop.getProperty(annotatorName + ".no_abstract", "true"));
        this.configuration.rerank_by_position = Boolean.parseBoolean(prop.getProperty(annotatorName + ".rerank_by_position", "false"));
        this.configuration.skip_keyword_with_not_allowed_words = Boolean.parseBoolean(prop.getProperty(annotatorName + ".skip_keyword_with_not_allowed_words", "false"));
        this.configuration.verbose = false;
        if (Boolean.parseBoolean(prop.getProperty(annotatorName + ".update", "false"))) {
            KD_loader.run_the_updater((KD_core.Language)this.lang, (String)this.configuration.languagePackPath);
        }
        int cores = Runtime.getRuntime().availableProcessors();
        switch (cores) {
            case 1: {
                t = KD_core.Threads.ONE;
                break;
            }
            case 2: {
                t = KD_core.Threads.TWO;
                break;
            }
            case 4: {
                t = KD_core.Threads.FOUR;
                break;
            }
            case 6: {
                t = KD_core.Threads.SIX;
                break;
            }
            case 8: {
                t = KD_core.Threads.EIGHT;
                break;
            }
            case 10: {
                t = KD_core.Threads.TEN;
                break;
            }
            case 12: {
                t = KD_core.Threads.TWELVE;
                break;
            }
            default: {
                t = KD_core.Threads.TWO;
            }
        }
        if (cores > 12) {
            t = KD_core.Threads.TWELVE;
        }
        this.kd = DigiKDModel.getInstance(t);
    }

    public void annotate(Annotation annotation) {
        StringBuffer doc = new StringBuffer();
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (CoreLabel c : tokens) {
                    doc.append(c.word() + "\t" + (String)c.get(CoreAnnotations.LemmaAnnotation.class) + "\t" + (String)c.get(CoreAnnotations.PartOfSpeechAnnotation.class) + "\n");
                }
                doc.append("\n");
            }
        }
        ArrayList<DigiKDResult> listOfKeys = new ArrayList<DigiKDResult>();
        try {
            for (KD_keyconcept k : this.kd.extractExpressions(this.lang, this.configuration, null, doc)) {
                listOfKeys.add(new DigiKDResult(k.getString(), k.frequency, k.score, k.getLemmaArray(), k.getTokenArray(), k.getPosList(), k.getStemArray(), k.getSysnonymsArray(), k.getIdf(), k.getScoreBoost(), k.getPatternBoost(), k.getTokenChainLength()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        annotation.set(DigiKDAnnotations.KeyphrasesAnnotation.class, listOfKeys);
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(DigiKDAnnotations.KeyphrasesAnnotation.class);
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.LemmaAnnotation.class)));
    }
}

