/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.ejml.EjmlParameters;
import org.ejml.LinearSolverSafe;
import org.ejml.MatrixDimensionException;
import org.ejml.UtilEjml;
import org.ejml.data.BMatrixRMaj;
import org.ejml.data.FMatrix;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.data.ReshapeMatrix;
import org.ejml.dense.row.MatrixFeatures_FDRM;
import org.ejml.dense.row.SpecializedOps_FDRM;
import org.ejml.dense.row.decomposition.TriangularSolver_FDRM;
import org.ejml.dense.row.decomposition.lu.LUDecompositionAlt_FDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_FDRM;
import org.ejml.dense.row.linsol.chol.LinearSolverChol_FDRM;
import org.ejml.dense.row.linsol.lu.LinearSolverLu_FDRM;
import org.ejml.dense.row.misc.ImplCommonOps_FDMA;
import org.ejml.dense.row.misc.ImplCommonOps_FDRM;
import org.ejml.dense.row.misc.RrefGaussJordanRowPivot_FDRM;
import org.ejml.dense.row.misc.TransposeAlgs_FDRM;
import org.ejml.dense.row.misc.UnrolledCholesky_FDRM;
import org.ejml.dense.row.misc.UnrolledDeterminantFromMinor_FDRM;
import org.ejml.dense.row.misc.UnrolledInverseFromMinor_FDRM;
import org.ejml.dense.row.mult.MatrixMatrixMult_FDRM;
import org.ejml.dense.row.mult.MatrixMultProduct_FDRM;
import org.ejml.dense.row.mult.MatrixVectorMult_FDRM;
import org.ejml.dense.row.mult.VectorVectorMult_FDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class CommonOps_FDRM {
    public static void mult(FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        UtilEjml.checkSameInstance((Object)a, (Object)c);
        UtilEjml.checkSameInstance((Object)b, (Object)c);
        if (b.numCols == 1) {
            MatrixVectorMult_FDRM.mult(a, (FMatrixD1)b, (FMatrixD1)c);
        } else if (b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.mult_reorder(a, b, c);
        } else {
            MatrixMatrixMult_FDRM.mult_small(a, b, c);
        }
    }

    public static void mult(float alpha, FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        UtilEjml.checkSameInstance((Object)a, (Object)c);
        UtilEjml.checkSameInstance((Object)b, (Object)c);
        if (b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.mult_reorder(alpha, a, b, c);
        } else {
            MatrixMatrixMult_FDRM.mult_small(alpha, a, b, c);
        }
    }

    public static void multTransA(FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        UtilEjml.checkSameInstance((Object)a, (Object)c);
        UtilEjml.checkSameInstance((Object)b, (Object)c);
        if (b.numCols == 1) {
            if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_FDRM.multTransA_reorder(a, (FMatrixD1)b, (FMatrixD1)c);
            } else {
                MatrixVectorMult_FDRM.multTransA_small(a, (FMatrixD1)b, (FMatrixD1)c);
            }
        } else if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.multTransA_reorder(a, b, c);
        } else {
            MatrixMatrixMult_FDRM.multTransA_small(a, b, c);
        }
    }

    public static void multTransA(float alpha, FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        UtilEjml.checkSameInstance((Object)a, (Object)c);
        UtilEjml.checkSameInstance((Object)b, (Object)c);
        if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.multTransA_reorder(alpha, a, b, c);
        } else {
            MatrixMatrixMult_FDRM.multTransA_small(alpha, a, b, c);
        }
    }

    public static void multTransB(FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        UtilEjml.checkSameInstance((Object)a, (Object)c);
        UtilEjml.checkSameInstance((Object)b, (Object)c);
        if (b.numRows == 1) {
            MatrixVectorMult_FDRM.mult(a, (FMatrixD1)b, (FMatrixD1)c);
        } else {
            MatrixMatrixMult_FDRM.multTransB(a, b, c);
        }
    }

    public static void multTransB(float alpha, FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        UtilEjml.checkSameInstance((Object)a, (Object)c);
        UtilEjml.checkSameInstance((Object)b, (Object)c);
        MatrixMatrixMult_FDRM.multTransB(alpha, a, b, c);
    }

    public static void multTransAB(FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        UtilEjml.checkSameInstance((Object)a, (Object)c);
        UtilEjml.checkSameInstance((Object)b, (Object)c);
        if (b.numRows == 1) {
            if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_FDRM.multTransA_reorder(a, (FMatrixD1)b, (FMatrixD1)c);
            } else {
                MatrixVectorMult_FDRM.multTransA_small(a, (FMatrixD1)b, (FMatrixD1)c);
            }
        } else if (a.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.multTransAB_aux(a, b, c, null);
        } else {
            MatrixMatrixMult_FDRM.multTransAB(a, b, c);
        }
    }

    public static void multTransAB(float alpha, FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        UtilEjml.checkSameInstance((Object)a, (Object)c);
        UtilEjml.checkSameInstance((Object)b, (Object)c);
        if (a.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.multTransAB_aux(alpha, a, b, c, null);
        } else {
            MatrixMatrixMult_FDRM.multTransAB(alpha, a, b, c);
        }
    }

    public static float dot(FMatrixD1 a, FMatrixD1 b) {
        if (!MatrixFeatures_FDRM.isVector((Matrix)a) || !MatrixFeatures_FDRM.isVector((Matrix)b)) {
            throw new RuntimeException("Both inputs must be vectors");
        }
        return VectorVectorMult_FDRM.innerProd(a, b);
    }

    public static void multInner(FMatrix1Row a, FMatrix1Row c) {
        c.reshape(a.numCols, a.numCols);
        if (a.numCols >= EjmlParameters.MULT_INNER_SWITCH) {
            MatrixMultProduct_FDRM.inner_small(a, c);
        } else {
            MatrixMultProduct_FDRM.inner_reorder(a, c);
        }
    }

    public static void multOuter(FMatrix1Row a, FMatrix1Row c) {
        c.reshape(a.numRows, a.numRows);
        MatrixMultProduct_FDRM.outer(a, c);
    }

    public static void multAdd(FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        if (b.numCols == 1) {
            MatrixVectorMult_FDRM.multAdd(a, (FMatrixD1)b, (FMatrixD1)c);
        } else if (b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.multAdd_reorder(a, b, c);
        } else {
            MatrixMatrixMult_FDRM.multAdd_small(a, b, c);
        }
    }

    public static void multAdd(float alpha, FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        if (b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.multAdd_reorder(alpha, a, b, c);
        } else {
            MatrixMatrixMult_FDRM.multAdd_small(alpha, a, b, c);
        }
    }

    public static void multAddTransA(FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        if (b.numCols == 1) {
            if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_FDRM.multAddTransA_reorder(a, (FMatrixD1)b, (FMatrixD1)c);
            } else {
                MatrixVectorMult_FDRM.multAddTransA_small(a, (FMatrixD1)b, (FMatrixD1)c);
            }
        } else if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.multAddTransA_reorder(a, b, c);
        } else {
            MatrixMatrixMult_FDRM.multAddTransA_small(a, b, c);
        }
    }

    public static void multAddTransA(float alpha, FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.multAddTransA_reorder(alpha, a, b, c);
        } else {
            MatrixMatrixMult_FDRM.multAddTransA_small(alpha, a, b, c);
        }
    }

    public static void multAddTransB(FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        MatrixMatrixMult_FDRM.multAddTransB(a, b, c);
    }

    public static void multAddTransB(float alpha, FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        MatrixMatrixMult_FDRM.multAddTransB(alpha, a, b, c);
    }

    public static void multAddTransAB(FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        if (b.numRows == 1) {
            if (a.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_FDRM.multAddTransA_reorder(a, (FMatrixD1)b, (FMatrixD1)c);
            } else {
                MatrixVectorMult_FDRM.multAddTransA_small(a, (FMatrixD1)b, (FMatrixD1)c);
            }
        } else if (a.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.multAddTransAB_aux(a, b, c, null);
        } else {
            MatrixMatrixMult_FDRM.multAddTransAB(a, b, c);
        }
    }

    public static void multAddTransAB(float alpha, FMatrix1Row a, FMatrix1Row b, FMatrix1Row c) {
        if (a.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_FDRM.multAddTransAB_aux(alpha, a, b, c, null);
        } else {
            MatrixMatrixMult_FDRM.multAddTransAB(alpha, a, b, c);
        }
    }

    public static boolean solve(FMatrixRMaj a, FMatrixRMaj b, FMatrixRMaj x) {
        x.reshape(a.numCols, b.numCols);
        LinearSolverSafe solver = LinearSolverFactory_FDRM.general(a.numRows, a.numCols);
        solver = new LinearSolverSafe(solver);
        if (!solver.setA((Matrix)a)) {
            return false;
        }
        solver.solve((Matrix)b, (Matrix)x);
        return true;
    }

    public static boolean solveSPD(FMatrixRMaj A, FMatrixRMaj b, FMatrixRMaj x) {
        if (A.numRows != A.numCols) {
            throw new IllegalArgumentException("Must be a square matrix");
        }
        x.reshape(A.numCols, b.numCols);
        if (A.numRows <= 7) {
            FMatrixRMaj L = A.createLike();
            if (!UnrolledCholesky_FDRM.lower((FMatrix1Row)A, (FMatrix1Row)L)) {
                return false;
            }
            if (x.numCols == 1) {
                x.set((FMatrixD1)b);
                TriangularSolver_FDRM.solveL(L.data, x.data, L.numCols);
                TriangularSolver_FDRM.solveTranL(L.data, x.data, L.numCols);
            } else {
                float[] vv = new float[A.numCols];
                LinearSolverChol_FDRM.solveLower(L, b, x, vv);
            }
        } else {
            LinearSolverSafe solver = LinearSolverFactory_FDRM.chol(A.numCols);
            if (!(solver = new LinearSolverSafe(solver)).setA((Matrix)A)) {
                return false;
            }
            solver.solve((Matrix)b, (Matrix)x);
            return true;
        }
        return true;
    }

    public static void transpose(FMatrixRMaj mat) {
        if (mat.numCols == mat.numRows) {
            TransposeAlgs_FDRM.square((FMatrix1Row)mat);
        } else {
            FMatrixRMaj b = new FMatrixRMaj(mat.numCols, mat.numRows);
            CommonOps_FDRM.transpose(mat, b);
            mat.set((FMatrixD1)b);
        }
    }

    public static FMatrixRMaj transpose(FMatrixRMaj A, FMatrixRMaj A_tran) {
        if (A_tran == null) {
            A_tran = new FMatrixRMaj(A.numCols, A.numRows);
        } else if (A.numRows != A_tran.numCols || A.numCols != A_tran.numRows) {
            throw new MatrixDimensionException("Incompatible matrix dimensions");
        }
        if (A.numRows > EjmlParameters.TRANSPOSE_SWITCH && A.numCols > EjmlParameters.TRANSPOSE_SWITCH) {
            TransposeAlgs_FDRM.block((FMatrix1Row)A, (FMatrix1Row)A_tran, EjmlParameters.BLOCK_WIDTH);
        } else {
            TransposeAlgs_FDRM.standard((FMatrix1Row)A, (FMatrix1Row)A_tran);
        }
        return A_tran;
    }

    public static float trace(FMatrix1Row a) {
        int N = Math.min(a.numRows, a.numCols);
        float sum = 0.0f;
        int index = 0;
        for (int i = 0; i < N; ++i) {
            sum += a.get(index);
            index += 1 + a.numCols;
        }
        return sum;
    }

    public static float det(FMatrixRMaj mat) {
        int numRow;
        int numCol = mat.getNumCols();
        if (numCol != (numRow = mat.getNumRows())) {
            throw new MatrixDimensionException("Must be a square matrix.");
        }
        if (numCol <= 6) {
            if (numCol >= 2) {
                return UnrolledDeterminantFromMinor_FDRM.det((FMatrix1Row)mat);
            }
            return mat.get(0);
        }
        LUDecompositionAlt_FDRM alg = new LUDecompositionAlt_FDRM();
        if (alg.inputModified()) {
            mat = mat.copy();
        }
        if (!alg.decompose(mat)) {
            return 0.0f;
        }
        return alg.computeDeterminant().real;
    }

    public static boolean invert(FMatrixRMaj mat) {
        if (mat.numCols <= 5) {
            if (mat.numCols != mat.numRows) {
                throw new MatrixDimensionException("Must be a square matrix.");
            }
            if (mat.numCols >= 2) {
                UnrolledInverseFromMinor_FDRM.inv(mat, mat);
            } else {
                mat.set(0, 1.0f / mat.get(0));
            }
        } else {
            LUDecompositionAlt_FDRM alg = new LUDecompositionAlt_FDRM();
            LinearSolverLu_FDRM solver = new LinearSolverLu_FDRM(alg);
            if (solver.setA(mat)) {
                solver.invert(mat);
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean invert(FMatrixRMaj mat, FMatrixRMaj result) {
        result.reshape(mat.numRows, mat.numCols);
        if (mat.numCols <= 5) {
            if (mat.numCols != mat.numRows) {
                throw new MatrixDimensionException("Must be a square matrix.");
            }
            if (result.numCols >= 2) {
                UnrolledInverseFromMinor_FDRM.inv(mat, result);
            } else {
                result.set(0, 1.0f / mat.get(0));
            }
        } else {
            LUDecompositionAlt_FDRM alg = new LUDecompositionAlt_FDRM();
            LinearSolverLu_FDRM solver = new LinearSolverLu_FDRM(alg);
            if (solver.modifiesA()) {
                mat = mat.copy();
            }
            if (!solver.setA(mat)) {
                return false;
            }
            solver.invert(result);
        }
        return true;
    }

    public static boolean invertSPD(FMatrixRMaj mat, FMatrixRMaj result) {
        if (mat.numRows != mat.numCols) {
            throw new IllegalArgumentException("Must be a square matrix");
        }
        result.reshape(mat.numRows, mat.numRows);
        if (mat.numRows <= 7) {
            if (!UnrolledCholesky_FDRM.lower((FMatrix1Row)mat, (FMatrix1Row)result)) {
                return false;
            }
            TriangularSolver_FDRM.invertLower(result.data, result.numCols);
            SpecializedOps_FDRM.multLowerTranA(result);
        } else {
            LinearSolverDense<FMatrixRMaj> solver = LinearSolverFactory_FDRM.chol(mat.numCols);
            if (solver.modifiesA()) {
                mat = mat.copy();
            }
            if (!solver.setA((Matrix)mat)) {
                return false;
            }
            solver.invert((Matrix)result);
        }
        return true;
    }

    public static void pinv(FMatrixRMaj A, FMatrixRMaj invA) {
        LinearSolverDense<FMatrixRMaj> solver = LinearSolverFactory_FDRM.pseudoInverse(true);
        if (solver.modifiesA()) {
            A = A.copy();
        }
        if (!solver.setA((Matrix)A)) {
            throw new IllegalArgumentException("Invert failed, maybe a bug?");
        }
        solver.invert((Matrix)invA);
    }

    public static FMatrixRMaj[] columnsToVector(FMatrixRMaj A, FMatrixRMaj[] v) {
        FMatrixRMaj[] ret = v == null || v.length < A.numCols ? new FMatrixRMaj[A.numCols] : v;
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] == null) {
                ret[i] = new FMatrixRMaj(A.numRows, 1);
            } else {
                ret[i].reshape(A.numRows, 1, false);
            }
            FMatrixRMaj u = ret[i];
            for (int j = 0; j < A.numRows; ++j) {
                u.set(j, 0, A.get(j, i));
            }
        }
        return ret;
    }

    public static FMatrixRMaj[] rowsToVector(FMatrixRMaj A, FMatrixRMaj[] v) {
        FMatrixRMaj[] ret = v == null || v.length < A.numRows ? new FMatrixRMaj[A.numRows] : v;
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] == null) {
                ret[i] = new FMatrixRMaj(A.numCols, 1);
            } else {
                ret[i].reshape(A.numCols, 1, false);
            }
            FMatrixRMaj u = ret[i];
            for (int j = 0; j < A.numCols; ++j) {
                u.set(j, 0, A.get(i, j));
            }
        }
        return ret;
    }

    public static void setIdentity(FMatrix1Row mat) {
        int width = mat.numRows < mat.numCols ? mat.numRows : mat.numCols;
        Arrays.fill(mat.data, 0, mat.getNumElements(), 0.0f);
        int index = 0;
        int i = 0;
        while (i < width) {
            mat.data[index] = 1.0f;
            ++i;
            index += mat.numCols + 1;
        }
    }

    public static FMatrixRMaj identity(int width) {
        FMatrixRMaj ret = new FMatrixRMaj(width, width);
        for (int i = 0; i < width; ++i) {
            ret.set(i, i, 1.0f);
        }
        return ret;
    }

    public static FMatrixRMaj identity(int numRows, int numCols) {
        FMatrixRMaj ret = new FMatrixRMaj(numRows, numCols);
        int small = numRows < numCols ? numRows : numCols;
        for (int i = 0; i < small; ++i) {
            ret.set(i, i, 1.0f);
        }
        return ret;
    }

    public static FMatrixRMaj diag(float ... diagEl) {
        return CommonOps_FDRM.diag(null, diagEl.length, diagEl);
    }

    public static FMatrixRMaj diag(FMatrixRMaj ret, int width, float ... diagEl) {
        if (ret == null) {
            ret = new FMatrixRMaj(width, width);
        } else {
            if (ret.numRows != width || ret.numCols != width) {
                throw new IllegalArgumentException("Unexpected matrix size");
            }
            CommonOps_FDRM.fill((FMatrixD1)ret, 0.0f);
        }
        for (int i = 0; i < width; ++i) {
            ret.unsafe_set(i, i, diagEl[i]);
        }
        return ret;
    }

    public static FMatrixRMaj diagR(int numRows, int numCols, float ... diagEl) {
        FMatrixRMaj ret = new FMatrixRMaj(numRows, numCols);
        int o = Math.min(numRows, numCols);
        for (int i = 0; i < o; ++i) {
            ret.set(i, i, diagEl[i]);
        }
        return ret;
    }

    public static void kron(FMatrixRMaj A, FMatrixRMaj B, FMatrixRMaj C) {
        int numColsC = A.numCols * B.numCols;
        int numRowsC = A.numRows * B.numRows;
        if (C.numCols != numColsC || C.numRows != numRowsC) {
            throw new MatrixDimensionException("C does not have the expected dimensions");
        }
        for (int i = 0; i < A.numRows; ++i) {
            for (int j = 0; j < A.numCols; ++j) {
                float a = A.get(i, j);
                for (int rowB = 0; rowB < B.numRows; ++rowB) {
                    for (int colB = 0; colB < B.numCols; ++colB) {
                        float val = a * B.get(rowB, colB);
                        C.set(i * B.numRows + rowB, j * B.numCols + colB, val);
                    }
                }
            }
        }
    }

    public static void extract(FMatrix src, int srcY0, int srcY1, int srcX0, int srcX1, FMatrix dst, int dstY0, int dstX0) {
        if (srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.getNumRows()) {
            throw new MatrixDimensionException("srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.numRows. " + UtilEjml.stringShapes((Matrix)src, (Matrix)dst));
        }
        if (srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.getNumCols()) {
            throw new MatrixDimensionException("srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.numCols. " + UtilEjml.stringShapes((Matrix)src, (Matrix)dst));
        }
        int w = srcX1 - srcX0;
        int h = srcY1 - srcY0;
        if (dstY0 + h > dst.getNumRows()) {
            throw new MatrixDimensionException("dst is too small in rows. " + dst.getNumRows() + " < " + (dstY0 + h));
        }
        if (dstX0 + w > dst.getNumCols()) {
            throw new MatrixDimensionException("dst is too small in columns. " + dst.getNumCols() + " < " + (dstX0 + w));
        }
        if (src instanceof FMatrixRMaj && dst instanceof FMatrixRMaj) {
            ImplCommonOps_FDRM.extract((FMatrixRMaj)src, srcY0, srcX0, (FMatrixRMaj)dst, dstY0, dstX0, h, w);
        } else {
            ImplCommonOps_FDMA.extract(src, srcY0, srcX0, dst, dstY0, dstX0, h, w);
        }
    }

    public static void extract(FMatrix src, int srcY0, int srcY1, int srcX0, int srcX1, FMatrix dst) {
        ((ReshapeMatrix)dst).reshape(srcY1 - srcY0, srcX1 - srcX0);
        CommonOps_FDRM.extract(src, srcY0, srcY1, srcX0, srcX1, dst, 0, 0);
    }

    public static void extract(FMatrix src, int srcY0, int srcX0, FMatrix dst) {
        CommonOps_FDRM.extract(src, srcY0, srcY0 + dst.getNumRows(), srcX0, srcX0 + dst.getNumCols(), dst, 0, 0);
    }

    public static FMatrixRMaj extract(FMatrixRMaj src, int srcY0, int srcY1, int srcX0, int srcX1) {
        if (srcY1 <= srcY0 || srcY0 < 0 || srcY1 > src.numRows) {
            throw new MatrixDimensionException("srcY1 <= srcY0 || srcY0 < 0 || srcY1 > src.numRows");
        }
        if (srcX1 <= srcX0 || srcX0 < 0 || srcX1 > src.numCols) {
            throw new MatrixDimensionException("srcX1 <= srcX0 || srcX0 < 0 || srcX1 > src.numCols");
        }
        int w = srcX1 - srcX0;
        int h = srcY1 - srcY0;
        FMatrixRMaj dst = new FMatrixRMaj(h, w);
        ImplCommonOps_FDRM.extract(src, srcY0, srcX0, dst, 0, 0, h, w);
        return dst;
    }

    public static void extract(FMatrixRMaj src, int[] rows, int rowsSize, int[] cols, int colsSize, FMatrixRMaj dst) {
        if (rowsSize != dst.numRows || colsSize != dst.numCols) {
            throw new MatrixDimensionException("Unexpected number of rows and/or columns in dst matrix");
        }
        int indexDst = 0;
        for (int i = 0; i < rowsSize; ++i) {
            int indexSrcRow = src.numCols * rows[i];
            for (int j = 0; j < colsSize; ++j) {
                dst.data[indexDst++] = src.data[indexSrcRow + cols[j]];
            }
        }
    }

    public static void extract(FMatrixRMaj src, int[] indexes, int length, FMatrixRMaj dst) {
        if (!MatrixFeatures_FDRM.isVector((Matrix)dst)) {
            throw new MatrixDimensionException("Dst must be a vector");
        }
        if (length != dst.getNumElements()) {
            throw new MatrixDimensionException("Unexpected number of elements in dst vector");
        }
        for (int i = 0; i < length; ++i) {
            dst.data[i] = src.data[indexes[i]];
        }
    }

    public static void insert(FMatrixRMaj src, FMatrixRMaj dst, int[] rows, int rowsSize, int[] cols, int colsSize) {
        if (rowsSize != src.numRows || colsSize != src.numCols) {
            throw new MatrixDimensionException("Unexpected number of rows and/or columns in dst matrix");
        }
        int indexSrc = 0;
        for (int i = 0; i < rowsSize; ++i) {
            int indexDstRow = dst.numCols * rows[i];
            for (int j = 0; j < colsSize; ++j) {
                dst.data[indexDstRow + cols[j]] = src.data[indexSrc++];
            }
        }
    }

    public static void extractDiag(FMatrixRMaj src, FMatrixRMaj dst) {
        int N = Math.min(src.numRows, src.numCols);
        if (!MatrixFeatures_FDRM.isVector((Matrix)dst) || dst.numCols * dst.numCols != N) {
            dst.reshape(N, 1);
        }
        for (int i = 0; i < N; ++i) {
            dst.set(i, src.unsafe_get(i, i));
        }
    }

    public static FMatrixRMaj extractRow(FMatrixRMaj a, int row, FMatrixRMaj out) {
        if (out == null) {
            out = new FMatrixRMaj(1, a.numCols);
        } else if (!MatrixFeatures_FDRM.isVector((Matrix)out) || out.getNumElements() != a.numCols) {
            throw new MatrixDimensionException("Output must be a vector of length " + a.numCols);
        }
        System.arraycopy(a.data, a.getIndex(row, 0), out.data, 0, a.numCols);
        return out;
    }

    public static FMatrixRMaj extractColumn(FMatrixRMaj a, int column, FMatrixRMaj out) {
        if (out == null) {
            out = new FMatrixRMaj(a.numRows, 1);
        } else if (!MatrixFeatures_FDRM.isVector((Matrix)out) || out.getNumElements() != a.numRows) {
            throw new MatrixDimensionException("Output must be a vector of length " + a.numRows);
        }
        int index = column;
        int i = 0;
        while (i < a.numRows) {
            out.data[i] = a.data[index];
            ++i;
            index += a.numCols;
        }
        return out;
    }

    public static void removeColumns(FMatrixRMaj A, int col0, int col1) {
        if (col1 < col0) {
            throw new IllegalArgumentException("col1 must be >= col0");
        }
        if (col0 >= A.numCols || col1 >= A.numCols) {
            throw new IllegalArgumentException("Columns which are to be removed must be in bounds");
        }
        int step = col1 - col0 + 1;
        int offset = 0;
        int idx = 0;
        for (int row = 0; row < A.numRows; ++row) {
            int i = 0;
            while (i < col0) {
                A.data[idx] = A.data[idx + offset];
                ++i;
                ++idx;
            }
            offset += step;
            i = col1 + 1;
            while (i < A.numCols) {
                A.data[idx] = A.data[idx + offset];
                ++i;
                ++idx;
            }
        }
        A.numCols -= step;
    }

    public static void insert(FMatrix src, FMatrix dest, int destY0, int destX0) {
        CommonOps_FDRM.extract(src, 0, src.getNumRows(), 0, src.getNumCols(), dest, destY0, destX0);
    }

    public static float elementMax(FMatrixD1 a) {
        int size = a.getNumElements();
        float max = a.get(0);
        for (int i = 1; i < size; ++i) {
            float val = a.get(i);
            if (!(val >= max)) continue;
            max = val;
        }
        return max;
    }

    public static float elementMaxAbs(FMatrixD1 a) {
        int size = a.getNumElements();
        float max = 0.0f;
        for (int i = 0; i < size; ++i) {
            float val = Math.abs(a.get(i));
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static float elementMin(FMatrixD1 a) {
        int size = a.getNumElements();
        float min = a.get(0);
        for (int i = 1; i < size; ++i) {
            float val = a.get(i);
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static float elementMinAbs(FMatrixD1 a) {
        int size = a.getNumElements();
        float min = Float.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            float val = Math.abs(a.get(i));
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static void elementMult(FMatrixD1 a, FMatrixD1 b) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.times(i, b.get(i));
        }
    }

    public static void elementMult(FMatrixD1 a, FMatrixD1 b, FMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows || a.numRows != c.numRows || a.numCols != c.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, a.get(i) * b.get(i));
        }
    }

    public static void elementDiv(FMatrixD1 a, FMatrixD1 b) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.div(i, b.get(i));
        }
    }

    public static void elementDiv(FMatrixD1 a, FMatrixD1 b, FMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows || a.numRows != c.numRows || a.numCols != c.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, a.get(i) / b.get(i));
        }
    }

    public static float elementSum(FMatrixD1 mat) {
        float total = 0.0f;
        int size = mat.getNumElements();
        for (int i = 0; i < size; ++i) {
            total += mat.get(i);
        }
        return total;
    }

    public static float elementSumAbs(FMatrixD1 mat) {
        float total = 0.0f;
        int size = mat.getNumElements();
        for (int i = 0; i < size; ++i) {
            total += Math.abs(mat.get(i));
        }
        return total;
    }

    public static void elementPower(FMatrixD1 A, FMatrixD1 B, FMatrixD1 C) {
        if (A.numRows != B.numRows || A.numRows != C.numRows || A.numCols != B.numCols || A.numCols != C.numCols) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            C.data[i] = (float)Math.pow(A.data[i], B.data[i]);
        }
    }

    public static void elementPower(float a, FMatrixD1 B, FMatrixD1 C) {
        if (B.numRows != C.numRows || B.numCols != C.numCols) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = B.getNumElements();
        for (int i = 0; i < size; ++i) {
            C.data[i] = (float)Math.pow(a, B.data[i]);
        }
    }

    public static void elementPower(FMatrixD1 A, float b, FMatrixD1 C) {
        if (A.numRows != C.numRows || A.numCols != C.numCols) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            C.data[i] = (float)Math.pow(A.data[i], b);
        }
    }

    public static void elementLog(FMatrixD1 A, FMatrixD1 C) {
        if (A.numCols != C.numCols || A.numRows != C.numRows) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            C.data[i] = (float)Math.log(A.data[i]);
        }
    }

    public static void elementExp(FMatrixD1 A, FMatrixD1 C) {
        if (A.numCols != C.numCols || A.numRows != C.numRows) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A.getNumElements();
        for (int i = 0; i < size; ++i) {
            C.data[i] = (float)Math.exp(A.data[i]);
        }
    }

    public static void multRows(float[] values, FMatrixRMaj A) {
        if (values.length < A.numRows) {
            throw new IllegalArgumentException("Not enough elements in values.");
        }
        int index = 0;
        for (int row = 0; row < A.numRows; ++row) {
            float v = values[row];
            for (int col = 0; col < A.numCols; ++col) {
                int n = index++;
                A.data[n] = A.data[n] * v;
            }
        }
    }

    public static void divideRows(float[] values, FMatrixRMaj A) {
        if (values.length < A.numRows) {
            throw new IllegalArgumentException("Not enough elements in values.");
        }
        int index = 0;
        for (int row = 0; row < A.numRows; ++row) {
            float v = values[row];
            for (int col = 0; col < A.numCols; ++col) {
                int n = index++;
                A.data[n] = A.data[n] / v;
            }
        }
    }

    public static void multCols(FMatrixRMaj A, float[] values) {
        if (values.length < A.numCols) {
            throw new IllegalArgumentException("Not enough elements in values.");
        }
        int index = 0;
        for (int row = 0; row < A.numRows; ++row) {
            for (int col = 0; col < A.numCols; ++col) {
                int n = index++;
                A.data[n] = A.data[n] * values[col];
            }
        }
    }

    public static void divideCols(FMatrixRMaj A, float[] values) {
        if (values.length < A.numCols) {
            throw new IllegalArgumentException("Not enough elements in values.");
        }
        int index = 0;
        for (int row = 0; row < A.numRows; ++row) {
            for (int col = 0; col < A.numCols; ++col) {
                int n = index++;
                A.data[n] = A.data[n] / values[col];
            }
        }
    }

    public static void divideRowsCols(float[] diagA, int offsetA, FMatrixRMaj B, float[] diagC, int offsetC) {
        if (diagA.length - offsetA < B.numRows) {
            throw new IllegalArgumentException("Not enough elements in diagA.");
        }
        if (diagC.length - offsetC < B.numCols) {
            throw new IllegalArgumentException("Not enough elements in diagC.");
        }
        int rows = B.numRows;
        int cols = B.numCols;
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            float va = diagA[offsetA + row];
            for (int col = 0; col < cols; ++col) {
                int n = index++;
                B.data[n] = B.data[n] / (va * diagC[offsetC + col]);
            }
        }
    }

    public static FMatrixRMaj sumRows(FMatrixRMaj input, FMatrixRMaj output) {
        if (output == null) {
            output = new FMatrixRMaj(input.numRows, 1);
        } else {
            output.reshape(input.numRows, 1);
        }
        for (int row = 0; row < input.numRows; ++row) {
            float total = 0.0f;
            int end = (row + 1) * input.numCols;
            for (int index = row * input.numCols; index < end; ++index) {
                total += input.data[index];
            }
            output.set(row, total);
        }
        return output;
    }

    public static FMatrixRMaj minRows(FMatrixRMaj input, FMatrixRMaj output) {
        if (output == null) {
            output = new FMatrixRMaj(input.numRows, 1);
        } else {
            output.reshape(input.numRows, 1);
        }
        for (int row = 0; row < input.numRows; ++row) {
            float min = Float.MAX_VALUE;
            int end = (row + 1) * input.numCols;
            for (int index = row * input.numCols; index < end; ++index) {
                float v = input.data[index];
                if (!(v < min)) continue;
                min = v;
            }
            output.set(row, min);
        }
        return output;
    }

    public static FMatrixRMaj maxRows(FMatrixRMaj input, FMatrixRMaj output) {
        if (output == null) {
            output = new FMatrixRMaj(input.numRows, 1);
        } else {
            output.reshape(input.numRows, 1);
        }
        for (int row = 0; row < input.numRows; ++row) {
            float max = -3.4028235E38f;
            int end = (row + 1) * input.numCols;
            for (int index = row * input.numCols; index < end; ++index) {
                float v = input.data[index];
                if (!(v > max)) continue;
                max = v;
            }
            output.set(row, max);
        }
        return output;
    }

    public static FMatrixRMaj sumCols(FMatrixRMaj input, FMatrixRMaj output) {
        if (output == null) {
            output = new FMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int cols = 0; cols < input.numCols; ++cols) {
            int index;
            float total = 0.0f;
            int end = index + input.numCols * input.numRows;
            for (index = cols; index < end; index += input.numCols) {
                total += input.data[index];
            }
            output.set(cols, total);
        }
        return output;
    }

    public static FMatrixRMaj minCols(FMatrixRMaj input, FMatrixRMaj output) {
        if (output == null) {
            output = new FMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int cols = 0; cols < input.numCols; ++cols) {
            int index;
            float minimum = Float.MAX_VALUE;
            int end = index + input.numCols * input.numRows;
            for (index = cols; index < end; index += input.numCols) {
                float v = input.data[index];
                if (!(v < minimum)) continue;
                minimum = v;
            }
            output.set(cols, minimum);
        }
        return output;
    }

    public static FMatrixRMaj maxCols(FMatrixRMaj input, FMatrixRMaj output) {
        if (output == null) {
            output = new FMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int cols = 0; cols < input.numCols; ++cols) {
            int index;
            float maximum = -3.4028235E38f;
            int end = index + input.numCols * input.numRows;
            for (index = cols; index < end; index += input.numCols) {
                float v = input.data[index];
                if (!(v > maximum)) continue;
                maximum = v;
            }
            output.set(cols, maximum);
        }
        return output;
    }

    public static void addEquals(FMatrixD1 a, FMatrixD1 b) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.plus(i, b.get(i));
        }
    }

    public static void addEquals(FMatrixD1 a, float beta, FMatrixD1 b) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.plus(i, beta * b.get(i));
        }
    }

    public static void add(FMatrixD1 a, FMatrixD1 b, FMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void add(FMatrixD1 a, float beta, FMatrixD1 b, FMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, a.get(i) + beta * b.get(i));
        }
    }

    public static void add(float alpha, FMatrixD1 a, float beta, FMatrixD1 b, FMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, alpha * a.get(i) + beta * b.get(i));
        }
    }

    public static void add(float alpha, FMatrixD1 a, FMatrixD1 b, FMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.set(i, alpha * a.get(i) + b.get(i));
        }
    }

    public static void add(FMatrixD1 a, float val) {
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.plus(i, val);
        }
    }

    public static void add(FMatrixD1 a, float val, FMatrixD1 c) {
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.data[i] = a.data[i] + val;
        }
    }

    public static void subtract(FMatrixD1 a, float val, FMatrixD1 c) {
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.data[i] = a.data[i] - val;
        }
    }

    public static void subtract(float val, FMatrixD1 a, FMatrixD1 c) {
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.data[i] = val - a.data[i];
        }
    }

    public static void subtractEquals(FMatrixD1 a, FMatrixD1 b) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            int n = i;
            a.data[n] = a.data[n] - b.data[i];
        }
    }

    public static void subtract(FMatrixD1 a, FMatrixD1 b, FMatrixD1 c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.data[i] = a.data[i] - b.data[i];
        }
    }

    public static void scale(float alpha, FMatrixD1 a) {
        int size = a.getNumElements();
        int i = 0;
        while (i < size) {
            int n = i++;
            a.data[n] = a.data[n] * alpha;
        }
    }

    public static void scale(float alpha, FMatrixD1 a, FMatrixD1 b) {
        b.reshape(a.numRows, a.numCols);
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            b.data[i] = a.data[i] * alpha;
        }
    }

    public static void scaleRow(float alpha, FMatrixRMaj A, int row) {
        int idx = row * A.numCols;
        for (int col = 0; col < A.numCols; ++col) {
            int n = idx++;
            A.data[n] = A.data[n] * alpha;
        }
    }

    public static void scaleCol(float alpha, FMatrixRMaj A, int col) {
        int idx = col;
        int row = 0;
        while (row < A.numRows) {
            int n = idx;
            A.data[n] = A.data[n] * alpha;
            ++row;
            idx += A.numCols;
        }
    }

    public static void divide(float alpha, FMatrixD1 a) {
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            a.data[i] = alpha / a.data[i];
        }
    }

    public static void divide(FMatrixD1 a, float alpha) {
        int size = a.getNumElements();
        int i = 0;
        while (i < size) {
            int n = i++;
            a.data[n] = a.data[n] / alpha;
        }
    }

    public static void divide(float alpha, FMatrixD1 a, FMatrixD1 b) {
        b.reshape(a.numRows, a.numCols);
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            b.data[i] = alpha / a.data[i];
        }
    }

    public static void divide(FMatrixD1 a, float alpha, FMatrixD1 b) {
        b.reshape(a.numRows, a.numCols);
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            b.data[i] = a.data[i] / alpha;
        }
    }

    public static void changeSign(FMatrixD1 a) {
        int size = a.getNumElements();
        for (int i = 0; i < size; ++i) {
            a.data[i] = -a.data[i];
        }
    }

    public static <T extends FMatrixD1> T changeSign(T input, @Nullable T output) {
        if (output == null) {
            output = (FMatrixD1)input.createLike();
        } else {
            output.reshape(input.numRows, input.numCols);
        }
        int size = input.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = -input.data[i];
        }
        return output;
    }

    public static void fill(FMatrixD1 a, float value) {
        Arrays.fill(a.data, 0, a.getNumElements(), value);
    }

    public static FMatrixRMaj rref(FMatrixRMaj A, int numUnknowns, FMatrixRMaj reduced) {
        if (reduced == null) {
            reduced = new FMatrixRMaj(A.numRows, A.numCols);
        }
        reduced.reshape(A.numRows, A.numCols);
        if (numUnknowns <= 0) {
            numUnknowns = Math.min(A.numCols, A.numRows);
        }
        RrefGaussJordanRowPivot_FDRM alg = new RrefGaussJordanRowPivot_FDRM();
        alg.setTolerance(CommonOps_FDRM.elementMaxAbs((FMatrixD1)A) * UtilEjml.F_EPS * (float)Math.max(A.numRows, A.numCols));
        reduced.set((FMatrixD1)A);
        alg.reduce((Matrix)reduced, numUnknowns);
        return reduced;
    }

    public static BMatrixRMaj elementLessThan(FMatrixRMaj A, float value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] < value;
        }
        return output;
    }

    public static BMatrixRMaj elementLessThanOrEqual(FMatrixRMaj A, float value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] <= value;
        }
        return output;
    }

    public static BMatrixRMaj elementMoreThan(FMatrixRMaj A, float value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] > value;
        }
        return output;
    }

    public static BMatrixRMaj elementMoreThanOrEqual(FMatrixRMaj A, float value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] >= value;
        }
        return output;
    }

    public static BMatrixRMaj elementLessThan(FMatrixRMaj A, FMatrixRMaj B, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] < B.data[i];
        }
        return output;
    }

    public static BMatrixRMaj elementLessThanOrEqual(FMatrixRMaj A, FMatrixRMaj B, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A.numRows, A.numCols);
        }
        output.reshape(A.numRows, A.numCols);
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A.data[i] <= B.data[i];
        }
        return output;
    }

    public static FMatrixRMaj elements(FMatrixRMaj A, BMatrixRMaj marked, FMatrixRMaj output) {
        if (A.numRows != marked.numRows || A.numCols != marked.numCols) {
            throw new MatrixDimensionException("Input matrices must have the same shape");
        }
        if (output == null) {
            output = new FMatrixRMaj(1, 1);
        }
        output.reshape(CommonOps_FDRM.countTrue(marked), 1);
        int N = A.getNumElements();
        int index = 0;
        for (int i = 0; i < N; ++i) {
            if (!marked.data[i]) continue;
            output.data[index++] = A.data[i];
        }
        return output;
    }

    public static int countTrue(BMatrixRMaj A) {
        int total = 0;
        int N = A.getNumElements();
        for (int i = 0; i < N; ++i) {
            if (!A.data[i]) continue;
            ++total;
        }
        return total;
    }

    public static void concatColumns(FMatrixRMaj a, FMatrixRMaj b, FMatrixRMaj output) {
        int rows = Math.max(a.numRows, b.numRows);
        int cols = a.numCols + b.numCols;
        output.reshape(rows, cols);
        output.zero();
        CommonOps_FDRM.insert((FMatrix)a, (FMatrix)output, 0, 0);
        CommonOps_FDRM.insert((FMatrix)b, (FMatrix)output, 0, a.numCols);
    }

    public static FMatrixRMaj concatColumnsMulti(FMatrixRMaj ... m) {
        int rows = 0;
        int cols = 0;
        for (int i = 0; i < m.length; ++i) {
            rows = Math.max(rows, m[i].numRows);
            cols += m[i].numCols;
        }
        FMatrixRMaj R = new FMatrixRMaj(rows, cols);
        int col = 0;
        for (int i = 0; i < m.length; ++i) {
            CommonOps_FDRM.insert((FMatrix)m[i], (FMatrix)R, 0, col);
            col += m[i].numCols;
        }
        return R;
    }

    public static void concatRows(FMatrixRMaj a, FMatrixRMaj b, FMatrixRMaj output) {
        int rows = a.numRows + b.numRows;
        int cols = Math.max(a.numCols, b.numCols);
        output.reshape(rows, cols);
        output.zero();
        CommonOps_FDRM.insert((FMatrix)a, (FMatrix)output, 0, 0);
        CommonOps_FDRM.insert((FMatrix)b, (FMatrix)output, a.numRows, 0);
    }

    public static FMatrixRMaj concatRowsMulti(FMatrixRMaj ... m) {
        int rows = 0;
        int cols = 0;
        for (int i = 0; i < m.length; ++i) {
            rows += m[i].numRows;
            cols = Math.max(cols, m[i].numCols);
        }
        FMatrixRMaj R = new FMatrixRMaj(rows, cols);
        int row = 0;
        for (int i = 0; i < m.length; ++i) {
            CommonOps_FDRM.insert((FMatrix)m[i], (FMatrix)R, row, 0);
            row += m[i].numRows;
        }
        return R;
    }

    public static FMatrixRMaj permuteRowInv(int[] pinv, FMatrixRMaj input, FMatrixRMaj output) {
        if (input.numRows > pinv.length) {
            throw new MatrixDimensionException("permutation vector must have at least as many elements as input has rows");
        }
        if (output == null) {
            output = new FMatrixRMaj(1, 1);
        }
        output.reshape(input.numRows, input.numCols);
        int m = input.numCols;
        for (int row = 0; row < input.numRows; ++row) {
            System.arraycopy(input.data, row * m, output.data, pinv[row] * m, m);
        }
        return output;
    }

    public static void abs(FMatrixD1 a, FMatrixD1 c) {
        c.reshape(a.numRows, a.numCols);
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            c.data[i] = Math.abs(a.data[i]);
        }
    }

    public static void abs(FMatrixD1 a) {
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            a.data[i] = Math.abs(a.data[i]);
        }
    }

    public static void symmLowerToFull(FMatrixRMaj A) {
        if (A.numRows != A.numCols) {
            throw new MatrixDimensionException("Must be a square matrix");
        }
        int cols = A.numCols;
        for (int row = 0; row < A.numRows; ++row) {
            for (int col = row + 1; col < cols; ++col) {
                A.data[row * cols + col] = A.data[col * cols + row];
            }
        }
    }

    public static void symmUpperToFull(FMatrixRMaj A) {
        if (A.numRows != A.numCols) {
            throw new MatrixDimensionException("Must be a square matrix");
        }
        int cols = A.numCols;
        for (int row = 0; row < A.numRows; ++row) {
            for (int col = 0; col <= row; ++col) {
                A.data[row * cols + col] = A.data[col * cols + row];
            }
        }
    }
}

