/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.Map;

public class Network {
    private static Integer DEFAULT_TIMEOUT = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postRequest(String host, int port, Map<String, String> pars) throws IOException {
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson(pars);
        String fromServer = null;
        String urlAddress = "http://" + host + ":" + Integer.toString(port) + "/";
        URL serverAddress = new URL(urlAddress);
        StringBuilder sb = new StringBuilder();
        HttpURLConnection connection = (HttpURLConnection)serverAddress.openConnection();
        try {
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(Integer.parseInt(DEFAULT_TIMEOUT.toString()));
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            connection.getOutputStream().write(json.getBytes("UTF-8"));
            connection.connect();
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                while ((fromServer = rd.readLine()) != null) {
                    sb.append(fromServer + '\n');
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            connection.disconnect();
        }
        return sb.toString();
    }

    public static String request(String host, int port, Map<String, String> pars) throws IOException {
        String responseLine;
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson(pars);
        Socket echoSocket = new Socket(host, port);
        PrintWriter out = new PrintWriter(echoSocket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));
        out.println(json);
        StringBuffer response = new StringBuffer();
        while ((responseLine = in.readLine()) != null) {
            response.append(responseLine);
        }
        in.close();
        out.close();
        echoSocket.close();
        return response.toString();
    }
}

