/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;

public interface JsonObjectProcessor {
    default public <T> T get(JsonElement json, Class<T> clazz, String ... path) {
        JsonElement result = json;
        for (String element : path) {
            result = result instanceof JsonObject ? ((JsonObject)result).get(element) : null;
        }
        if (result == null || result instanceof JsonNull) {
            return null;
        }
        if (clazz.isInstance(result)) {
            return clazz.cast(result);
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(result.getAsLong());
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(result.getAsFloat());
        }
        if (clazz == String.class) {
            return (T)result.getAsString();
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(result.getAsInt());
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.valueOf(result.getAsBoolean());
        }
        throw new UnsupportedOperationException(clazz.getName());
    }
}

