/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.digimorph.annotator;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.digimorph.annotator.DigiMorphAnnotations;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DigiLemmaAnnotator
implements Annotator {
    private Map<String, String> pos_morpho_mapping = new HashMap<String, String>();
    private final String auxiliary = "VA";
    private final Set<String> betweenAuxAndVerb = new HashSet<String>(Arrays.asList("B", "BN"));

    public DigiLemmaAnnotator(String annotatorName, Properties prop) {
        this.pos_morpho_mapping.put("A", "+adj");
        this.pos_morpho_mapping.put("AP", "+adj");
        this.pos_morpho_mapping.put("B", "+adv");
        this.pos_morpho_mapping.put("BN", "+adv");
        this.pos_morpho_mapping.put("C", "+conj");
        this.pos_morpho_mapping.put("CC", "+conj");
        this.pos_morpho_mapping.put("CS", "+conj");
        this.pos_morpho_mapping.put("DD", "+adj");
        this.pos_morpho_mapping.put("DE", "+adj");
        this.pos_morpho_mapping.put("DI", "+adj");
        this.pos_morpho_mapping.put("DQ", "+adj");
        this.pos_morpho_mapping.put("DR", "+adj");
        this.pos_morpho_mapping.put("DT", "+adj");
        this.pos_morpho_mapping.put("E", "+prep");
        this.pos_morpho_mapping.put("E+RD", "+prep");
        this.pos_morpho_mapping.put("I", "+inter");
        this.pos_morpho_mapping.put("N", "+adj");
        this.pos_morpho_mapping.put("NO", "+adj");
        this.pos_morpho_mapping.put("PC", "+pron");
        this.pos_morpho_mapping.put("PD", "+pron");
        this.pos_morpho_mapping.put("PE", "+pron");
        this.pos_morpho_mapping.put("PI", "+pron");
        this.pos_morpho_mapping.put("PP", "+pron");
        this.pos_morpho_mapping.put("PQ", "+pron");
        this.pos_morpho_mapping.put("PR", "+pron");
        this.pos_morpho_mapping.put("RD", "+art");
        this.pos_morpho_mapping.put("RI", "+art");
        this.pos_morpho_mapping.put("S", "+n+");
        this.pos_morpho_mapping.put("SP", "+n+");
        this.pos_morpho_mapping.put("T", "+adj");
        this.pos_morpho_mapping.put("V", "+v+");
        this.pos_morpho_mapping.put("VA", "+v+");
        this.pos_morpho_mapping.put("VA", "+v+");
        this.pos_morpho_mapping.put("VM", "+v+");
        this.pos_morpho_mapping.put("VM", "+v+");
        this.pos_morpho_mapping.put("V+PC", "+v+");
    }

    public void annotate(Annotation annotation) {
        if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                String last_valuable_genre = "";
                Boolean valid_aux = false;
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (CoreLabel c : tokens) {
                    String[] morph_fatures = ((String)c.get(DigiMorphAnnotations.MorphoAnnotation.class)).split(" ");
                    String pos = (String)c.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    c.set(CoreAnnotations.LemmaAnnotation.class, (Object)morph_fatures[0]);
                    if (!pos.equals("V")) {
                        valid_aux = pos.equals("VA") || valid_aux != false && this.betweenAuxAndVerb.contains(pos) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (pos.equals("SP") || morph_fatures.length <= 1) continue;
                    if (morph_fatures.length == 2) {
                        last_valuable_genre = morph_fatures[1].contains("+art") && morph_fatures[1].contains("+m+") ? "m" : "f";
                        c.set(CoreAnnotations.LemmaAnnotation.class, (Object)morph_fatures[1].split("\\+")[0].split("~")[0]);
                        continue;
                    }
                    HashSet<String> lemmas = new HashSet<String>();
                    for (int i = 1; i < morph_fatures.length; ++i) {
                        lemmas.add(morph_fatures[i].split("\\+")[0].split("~")[0]);
                    }
                    if (lemmas.size() > 1) {
                        String featMapped = this.pos_morpho_mapping.get(pos);
                        String possible_candidate = "";
                        String firstCandidate = "";
                        if (featMapped == null) continue;
                        for (String feature : morph_fatures) {
                            if (!feature.contains(featMapped)) continue;
                            if (firstCandidate.length() == 0) {
                                firstCandidate = feature.split("\\+")[0].split("~")[0];
                            }
                            if (featMapped.equals("+art") && feature.contains("+m+")) {
                                last_valuable_genre = "m";
                            } else if (featMapped.equals("+art") && feature.contains("+f+")) {
                                last_valuable_genre = "f";
                            }
                            if (last_valuable_genre.equals("m") && feature.contains("+m+")) {
                                possible_candidate = feature.split("\\+")[0].split("~")[0];
                            } else if (last_valuable_genre.equals("m") && feature.contains("+f+")) {
                                possible_candidate = feature.split("\\+")[0].split("~")[0];
                            }
                            if (!valid_aux.booleanValue() || !feature.contains("+part+")) continue;
                            possible_candidate = feature.split("\\+")[0].split("~")[0];
                            valid_aux = false;
                        }
                        if (firstCandidate.length() == 0) {
                            firstCandidate = c.word();
                        }
                        c.set(CoreAnnotations.LemmaAnnotation.class, (Object)(possible_candidate.length() > 0 ? possible_candidate : firstCandidate));
                        continue;
                    }
                    c.set(CoreAnnotations.LemmaAnnotation.class, (Object)morph_fatures[1].split("\\+")[0].split("~")[0]);
                }
            }
        }
    }

    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(LEMMA_REQUIREMENT);
    }

    public Set<Annotator.Requirement> requires() {
        return Collections.unmodifiableSet(new ArraySet((Object[])new Annotator.Requirement[]{DigiMorphAnnotations.DH_MORPHOLOGY_REQUIREMENT, POS_REQUIREMENT}));
    }
}

