/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dkm.pikes.depparseannotation;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dkm.pikes.depparseannotation.DepParseInfo;
import eu.fbk.dkm.pikes.depparseannotation.DepparseAnnotations;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class StanfordToConllDepsAnnotator
implements Annotator {
    public StanfordToConllDepsAnnotator(String annotatorName, Properties props) {
    }

    public void annotate(Annotation annotation) {
        if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            int sentOffset = 0;
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                SemanticGraph dependencies = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
                DepParseInfo info = new DepParseInfo(dependencies);
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                if (dependencies != null) {
                    for (int i = 0; i < tokens.size(); ++i) {
                        CoreLabel token = (CoreLabel)tokens.get(i);
                        int j = i + sentOffset;
                        String label = info.getDepLabels().get(j + 1);
                        int head = info.getDepParents().get(j + 1) - 1 - sentOffset;
                        if (head < -1) {
                            head = -1;
                        }
                        token.set(CoreAnnotations.CoNLLDepTypeAnnotation.class, (Object)label);
                        token.set(CoreAnnotations.CoNLLDepParentIndexAnnotation.class, (Object)head);
                    }
                }
                sentOffset += tokens.size();
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
    }

    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(DepparseAnnotations.CONLLPARSE_REQUIREMENT);
    }

    public Set<Annotator.Requirement> requires() {
        return TOKENIZE_SSPLIT_POS_DEPPARSE;
    }
}

