/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dkm.pikes.depparseannotation;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.Generics;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class DepParseInfo {
    private HashMap<Integer, Integer> depParents = new HashMap();
    private HashMap<Integer, String> depLabels = new HashMap();

    private static String space(int width) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    private static void recToString(IndexedWord curr, StringBuilder sb, int offset, Set<IndexedWord> used, SemanticGraph dependencies, HashMap<Integer, String> depLabels, HashMap<Integer, Integer> depParents) {
        used.add(curr);
        List edges = dependencies.outgoingEdgeList(curr);
        Collections.sort(edges);
        for (SemanticGraphEdge edge : edges) {
            IndexedWord target = edge.getTarget();
            depParents.put(target.index(), edge.getSource().index());
            depLabels.put(target.index(), edge.getRelation().toString());
            sb.append(DepParseInfo.space(2 * offset)).append("-> ").append(target).append(" (").append(edge.getRelation()).append(")\n");
            if (used.contains(target)) continue;
            DepParseInfo.recToString(target, sb, offset + 1, used, dependencies, depLabels, depParents);
        }
    }

    public DepParseInfo(HashMap<Integer, Integer> depParents, HashMap<Integer, String> depLabels) {
        this.depParents = depParents;
        this.depLabels = depLabels;
    }

    public DepParseInfo(SemanticGraph dependencies) {
        Collection rootNodes = dependencies.getRoots();
        if (rootNodes.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Set used = Generics.newHashSet();
        for (IndexedWord root : rootNodes) {
            this.depParents.put(root.index(), 0);
            this.depLabels.put(root.index(), "root");
            sb.append("-> ").append(root).append(" (root)\n");
            DepParseInfo.recToString(root, sb, 1, used, dependencies, this.depLabels, this.depParents);
        }
        Set nodes = Generics.newHashSet((Collection)dependencies.vertexSet());
        nodes.removeAll(used);
        while (!nodes.isEmpty()) {
            IndexedWord node = (IndexedWord)nodes.iterator().next();
            sb.append(node).append("\n");
            DepParseInfo.recToString(node, sb, 1, used, dependencies, this.depLabels, this.depParents);
            nodes.removeAll(used);
        }
    }

    public HashMap<Integer, Integer> getDepParents() {
        return this.depParents;
    }

    public HashMap<Integer, String> getDepLabels() {
        return this.depLabels;
    }

    public String toString() {
        return "DepParseInfo{depParents=" + this.depParents + ", depLabels=" + this.depLabels + '}';
    }
}

