/*
 * Decompiled with CFR 0.152.
 */
package jvntextpro.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;

public class StringUtils {
    public static int findFirstOf(String container, String chars, int begin) {
        int minIdx = -1;
        for (int i = 0; i < chars.length() && i >= 0; ++i) {
            int idx = container.indexOf(chars.charAt(i), begin);
            if ((idx >= minIdx || idx == -1) && minIdx != -1) continue;
            minIdx = idx;
        }
        return minIdx;
    }

    public static int findLastOf(String container, String charSeq, int begin) {
        for (int i = begin; i < container.length() && i >= 0; --i) {
            if (!charSeq.contains("" + container.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstNotOf(String container, String chars, int begin) {
        for (int i = begin; i < container.length() && i >= 0; ++i) {
            if (chars.contains("" + container.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int findLastNotOf(String container, String charSeq, int end) {
        for (int i = end; i < container.length() && i >= 0; --i) {
            if (charSeq.contains("" + container.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean containNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containLetter(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLetter(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containLetterAndDigit(String str) {
        return StringUtils.containLetter(str) && StringUtils.containNumber(str);
    }

    public static boolean isAllNumber(String str) {
        boolean hasNumber = false;
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i)) && str.charAt(i) != '.' && str.charAt(i) != ',' && str.charAt(i) != '%' && str.charAt(i) != '$' && str.charAt(i) != '_') {
                return false;
            }
            if (!Character.isDigit(str.charAt(i))) continue;
            hasNumber = true;
        }
        return hasNumber;
    }

    public static boolean isFirstCap(String str) {
        if (StringUtils.isAllCap(str)) {
            return false;
        }
        return str.length() > 0 && Character.isLetter(str.charAt(0)) && Character.isUpperCase(str.charAt(0));
    }

    public static boolean isAllCap(String str) {
        if (str.length() <= 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isLetter(str.charAt(i)) && Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotFirstCap(String str) {
        return !StringUtils.isFirstCap(str);
    }

    public static boolean endsWithPunc(String str) {
        return str.endsWith(".") || str.endsWith("?") || str.endsWith("!") || str.endsWith(",") || str.endsWith(":") || str.endsWith("\"") || str.endsWith("'") || str.endsWith("''") || str.endsWith(";");
    }

    public static boolean endsWithStop(String str) {
        return str.endsWith(".") || str.endsWith("?") || str.endsWith("!");
    }

    public static int countStops(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '.' && str.charAt(i) != '?' && str.charAt(i) != '!') continue;
            ++count;
        }
        return count;
    }

    public static int countPuncs(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '.' && str.charAt(i) != '?' && str.charAt(i) != '!' && str.charAt(i) != ',' && str.charAt(i) != ':' && str.charAt(i) != ';') continue;
            ++count;
        }
        return count;
    }

    public static boolean isStop(String str) {
        if (str.compareTo(".") == 0) {
            return true;
        }
        if (str.compareTo("?") == 0) {
            return true;
        }
        return str.compareTo("!") == 0;
    }

    public static boolean isPunc(String str) {
        if (str == null) {
            return false;
        }
        str = str.trim();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isDigit(c) && !Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public static String join(Object[] objects, char sep) {
        if (objects.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(objects[0].toString());
        for (int i = 1; i < objects.length; ++i) {
            buffer.append(sep);
            buffer.append(objects[i].toString());
        }
        return buffer.toString();
    }

    public static String join(Collection col, char sep) {
        if (col.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Object o : col) {
            if (first) {
                first = false;
            } else {
                buffer.append(sep);
            }
            buffer.append(o.toString());
        }
        return buffer.toString();
    }

    public static String capitalizeWord(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String quote(String s) {
        return '\'' + s + '\'';
    }

    public static String doubleQuote(String s) {
        return '\"' + s + '\"';
    }

    public static String pad(String s, int length) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        StringBuffer buffer = new StringBuffer(s);
        int spaces = length - s.length();
        while (spaces-- > 0) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static String sort(String s) {
        char[] chars = s.toCharArray();
        Arrays.sort(chars);
        return new String(chars);
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        int sLen = s.length();
        for (int i = 0; i < sLen; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String s) {
        if (s == null) {
            return false;
        }
        int sLen = s.length();
        for (int i = 0; i < sLen; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int countOccurrences(String s, char c) {
        int count = 0;
        int index = 0;
        while ((index = s.indexOf(c, index)) != -1) {
            ++count;
        }
        return count;
    }

    public static boolean isContained(String[] array, String s) {
        for (String string : array) {
            if (!string.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(String[] array, String s) {
        for (int index = 0; index < array.length; ++index) {
            if (!s.equals(array[index])) continue;
            return index;
        }
        return -1;
    }

    public static ArrayList<String> toList(String[] array) {
        if (array == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> list = new ArrayList<String>(array.length);
        for (String s : array) {
            list.add(s);
        }
        return list;
    }

    public static Vector<String> toVector(String[] array) {
        if (array == null) {
            return new Vector<String>(0);
        }
        Vector<String> v = new Vector<String>(array.length);
        v.copyInto(array);
        return v;
    }

    public static ArrayList<String> toList(Set<String> set) {
        int n = set.size();
        ArrayList<String> list = new ArrayList<String>(n);
        for (String string : set) {
            list.add(string);
        }
        return list;
    }
}

