/*
 * Decompiled with CFR 0.152.
 */
package jvntextpro.service;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import jvntextpro.JVnTextPro;
import jvntextpro.service.ServiceOption;
import jvntextpro.service.Session;
import org.kohsuke.args4j.CmdLineParser;

public class TaggingService
extends Thread {
    private int port = 2929;
    private ServerSocket socket;
    public static final int maxNSession = 5;
    public static Vector<Session> pool;
    private JVnTextPro vnTextPro = null;
    private ServiceOption option;

    public TaggingService(int p, ServiceOption option) {
        this.port = p;
        this.option = option;
    }

    public TaggingService(ServiceOption option) {
        this.option = option;
    }

    private void init() {
        try {
            this.vnTextPro = new JVnTextPro();
            if (this.option.doSenToken) {
                this.vnTextPro.initSenTokenization();
            }
            if (this.option.doSenSeg) {
                this.vnTextPro.initSenSegmenter(this.option.modelDir + File.separator + "jvnsensegmenter");
            }
            if (this.option.doWordSeg) {
                this.vnTextPro.initSegmenter(this.option.modelDir + File.separator + "jvnsegmenter");
            }
            if (this.option.doPosTagging) {
                this.vnTextPro.initPosTagger(this.option.modelDir + File.separator + "jvnpostag" + File.separator + "maxent");
            }
            pool = new Vector();
            for (int i = 0; i < 5; ++i) {
                Session w = new Session(this.vnTextPro);
                w.start();
                pool.add(w);
            }
        }
        catch (Exception e) {
            System.out.println("Error while initilizing service:" + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println("Starting tagging service!");
        try {
            this.socket = new ServerSocket(this.port);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            System.exit(1);
        }
        this.init();
        System.out.println("Tagging service is started successfully");
        while (true) {
            Socket incoming = null;
            try {
                incoming = this.socket.accept();
                Session w = null;
                Vector<Session> vector = pool;
                synchronized (vector) {
                    if (pool.isEmpty()) {
                        w = new Session(this.vnTextPro);
                        w.setSocket(incoming);
                        w.start();
                    } else {
                        w = pool.elementAt(0);
                        pool.removeElementAt(0);
                        w.setSocket(incoming);
                    }
                    continue;
                }
            }
            catch (IOException e) {
                System.out.println(e);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        ServiceOption option = new ServiceOption();
        CmdLineParser parser = new CmdLineParser((Object)option);
        if (args.length == 0) {
            System.out.println("TaggingService [options...] [arguments..]");
            parser.printUsage((OutputStream)System.out);
            return;
        }
        new TaggingService(option).run();
    }
}

