/*
 * Decompiled with CFR 0.152.
 */
package jvnsegmenter;

import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jvnsegmenter.BasicContextGenerator;
import jvntextpro.data.Sentence;
import org.w3c.dom.Element;

public class RegexContextGenerator
extends BasicContextGenerator {
    private static String strNumberPattern = "[+-]?\\d+([,.]\\d+)*";
    private static String strShortDatePattern = "\\d+[/-:]\\d+";
    private static String strLongDatePattern = "\\d+[/-:]\\d+[/-:]\\d+";
    private static String strPercentagePattern = strNumberPattern + "%";
    private static String strCurrencyPattern = "\\p{Sc}" + strNumberPattern;
    private static String strViCurrencyPattern = strNumberPattern + "[ \t]*\\p{Sc}";
    private static Pattern ptnNumber;
    private static Pattern ptnShortDate;
    private static Pattern ptnLongDate;
    private static Pattern ptnPercentage;
    private static Pattern ptnCurrency;
    private static Pattern ptnViCurrency;

    public RegexContextGenerator(Element node) {
        this.readFeatureParameters(node);
    }

    @Override
    public String[] getContext(Sentence sent, int pos) {
        ArrayList<String> cps = new ArrayList<String>();
        for (int it = 0; it < this.cpnames.size(); ++it) {
            String cp = (String)this.cpnames.get(it);
            Vector paras = (Vector)this.paras.get(it);
            String cpvalue = "";
            String suffix = "";
            String regex = "";
            String word = "";
            boolean outOfArrayIndex = false;
            for (int i = 0; i < paras.size(); ++i) {
                if (pos + (Integer)paras.get(i) < 0 || pos + (Integer)paras.get(i) >= sent.size()) {
                    cpvalue = "";
                    outOfArrayIndex = true;
                    break;
                }
                suffix = suffix + paras.get(i) + ":";
                word = word + sent.getWordAt(pos + (Integer)paras.get(i)) + " ";
            }
            if (outOfArrayIndex) continue;
            word = word.trim().toLowerCase();
            suffix = suffix.substring(0, suffix.length() - 1);
            suffix = ":" + suffix;
            regex = RegexContextGenerator.patternMatching(cp, word);
            if (!regex.equals("")) {
                cpvalue = "re" + suffix + regex;
            }
            if (cpvalue.equals("")) continue;
            cps.add(cpvalue);
        }
        String[] ret = new String[cps.size()];
        return cps.toArray(ret);
    }

    private static void patternCompile() {
        try {
            ptnNumber = Pattern.compile(strNumberPattern);
            ptnShortDate = Pattern.compile(strShortDatePattern);
            ptnLongDate = Pattern.compile(strLongDatePattern);
            ptnPercentage = Pattern.compile(strPercentagePattern);
            ptnCurrency = Pattern.compile(strCurrencyPattern);
            ptnViCurrency = Pattern.compile(strViCurrencyPattern);
        }
        catch (PatternSyntaxException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private static String patternMatching(String ptnName, String input) {
        String suffix = "";
        if (ptnNumber == null) {
            RegexContextGenerator.patternCompile();
        }
        if (ptnName.equals("number")) {
            Matcher matcher = ptnNumber.matcher(input);
            if (matcher.matches()) {
                suffix = ":number";
            }
        } else if (ptnName.equals("short_date")) {
            Matcher matcher = ptnShortDate.matcher(input);
            if (matcher.matches()) {
                suffix = ":short-date";
            }
        } else if (ptnName.equals("long_date")) {
            Matcher matcher = ptnLongDate.matcher(input);
            if (matcher.matches()) {
                suffix = ":long-date";
            }
        } else if (ptnName.equals("percentage")) {
            Matcher matcher = ptnPercentage.matcher(input);
            if (matcher.matches()) {
                suffix = ":percentage";
            }
        } else if (ptnName.equals("currency")) {
            Matcher matcher = ptnCurrency.matcher(input);
            if (matcher.matches()) {
                suffix = ":currency";
            } else {
                matcher = ptnViCurrency.matcher(input);
                if (matcher.matches()) {
                    suffix = ":currency";
                }
            }
        }
        return suffix;
    }
}

