/*
 * Decompiled with CFR 0.152.
 */
package jvnsegmenter;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import jvnsegmenter.BasicContextGenerator;
import jvntextpro.data.Sentence;
import org.w3c.dom.Element;

public class LexiconContextGenerator
extends BasicContextGenerator {
    private static HashSet hsVietnameseDict;
    private static HashSet hsViFamilyNames;
    private static HashSet hsViMiddleNames;
    private static HashSet hsViLastNames;
    private static HashSet hsViLocations;

    public LexiconContextGenerator(Element node) {
        this.readFeatureParameters(node);
    }

    @Override
    public String[] getContext(Sentence sent, int pos) {
        ArrayList<String> cps = new ArrayList<String>();
        for (int it = 0; it < this.cpnames.size(); ++it) {
            String cp = (String)this.cpnames.get(it);
            Vector paras = (Vector)this.paras.get(it);
            String cpvalue = "";
            String suffix = "";
            String word = "";
            boolean outOfArrayIndex = false;
            for (int i = 0; i < paras.size(); ++i) {
                if (pos + (Integer)paras.get(i) < 0 || pos + (Integer)paras.get(i) >= sent.size()) {
                    cpvalue = "";
                    outOfArrayIndex = true;
                    break;
                }
                suffix = suffix + paras.get(i) + ":";
                word = word + sent.getWordAt(pos + (Integer)paras.get(i)) + " ";
            }
            word = word.trim();
            if (suffix.endsWith(":")) {
                suffix = suffix.substring(0, suffix.length() - 1);
            }
            if (outOfArrayIndex) continue;
            if (cp.equals("vietnamese_dict")) {
                if (LexiconContextGenerator.inVietnameseDict(word = word.toLowerCase())) {
                    cpvalue = "d:" + suffix;
                }
            } else if (cp.equals("family_name")) {
                if (LexiconContextGenerator.inViFamilyNameList(word)) {
                    cpvalue = "fam:" + suffix;
                }
            } else if (cp.equals("middle_name")) {
                if (LexiconContextGenerator.inViMiddleNameList(word)) {
                    cpvalue = "mdl:" + suffix;
                }
            } else if (cp.equals("last_name")) {
                if (LexiconContextGenerator.inViLastNameList(word)) {
                    cpvalue = "lst:" + suffix;
                }
            } else if (cp.equals("location") && LexiconContextGenerator.inViLocations(word)) {
                cpvalue = "loc:" + suffix;
            }
            if (cpvalue.equals("")) continue;
            cps.add(cpvalue);
        }
        String[] ret = new String[cps.size()];
        return cps.toArray(ret);
    }

    public static boolean inVietnameseDict(String word) {
        return hsVietnameseDict.contains(word);
    }

    public static boolean inViFamilyNameList(String word) {
        return hsViFamilyNames.contains(word);
    }

    public static boolean inViMiddleNameList(String word) {
        return hsViMiddleNames.contains(word);
    }

    public static boolean inViLastNameList(String word) {
        return hsViLastNames.contains(word);
    }

    public static boolean inViLocations(String word) {
        return hsViLocations.contains(word);
    }

    public static void loadVietnameseDict(String filename) {
        try {
            FileInputStream in = new FileInputStream(filename);
            if (hsVietnameseDict == null) {
                String line;
                hsVietnameseDict = new HashSet();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if (!line.substring(0, 2).equals("##")) continue;
                    String word = line.substring(2);
                    word = word.toLowerCase();
                    hsVietnameseDict.add(word);
                }
            }
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
            e.printStackTrace();
        }
    }

    public static void loadViPersonalNames(String filename) {
        try {
            FileInputStream in = new FileInputStream(filename);
            if (hsViFamilyNames == null) {
                String line;
                hsViFamilyNames = new HashSet();
                hsViLastNames = new HashSet();
                hsViMiddleNames = new HashSet();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).equals("")) continue;
                    int idxSpace = line.indexOf(32);
                    int lastIdxSpace = line.lastIndexOf(32);
                    if (idxSpace != -1) {
                        String strFamilyName = line.substring(0, idxSpace);
                        hsViFamilyNames.add(strFamilyName);
                    }
                    if (idxSpace != -1 && lastIdxSpace > idxSpace + 1) {
                        String strMiddleName = line.substring(idxSpace + 1, lastIdxSpace - 1);
                        hsViMiddleNames.add(strMiddleName);
                    }
                    if (lastIdxSpace == -1) continue;
                    String strLastName = line.substring(lastIdxSpace + 1, line.length());
                    hsViLastNames.add(strLastName);
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.print(e.getMessage());
        }
    }

    public static void loadViLocationList(String filename) {
        try {
            FileInputStream in = new FileInputStream(filename);
            if (hsViLocations == null) {
                String line;
                hsViLocations = new HashSet();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    String word = line.trim();
                    hsViLocations.add(word);
                }
            }
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
    }
}

