/*
 * Decompiled with CFR 0.152.
 */
package jmaxent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import jmaxent.CountFIdx;
import jmaxent.Data;
import jmaxent.Element;
import jmaxent.Observation;
import jmaxent.Option;

public class Dictionary {
    public Map dict = null;
    public Option option = null;
    public Data data = null;

    public Dictionary() {
        this.dict = new HashMap();
    }

    public Dictionary(Option option, Data data) {
        this.option = option;
        this.data = data;
        this.dict = new HashMap();
    }

    public void readDict(BufferedReader fin) throws IOException {
        this.dict.clear();
        String line = fin.readLine();
        if (line == null) {
            System.out.println("No dictionary size information");
            return;
        }
        int dictSize = Integer.parseInt(line);
        if (dictSize <= 0) {
            System.out.println("Invalid dictionary size");
        }
        System.out.println("Reading dictionary ...");
        for (int i = 0; i < dictSize; ++i) {
            line = fin.readLine();
            if (line == null) {
                System.out.println("Invalid dictionary line");
                return;
            }
            StringTokenizer strTok = new StringTokenizer(line, " \t\r\n");
            int len = strTok.countTokens();
            if (len < 2) continue;
            StringTokenizer cpTok = new StringTokenizer(strTok.nextToken(), ":");
            int cp = Integer.parseInt(cpTok.nextToken());
            int cpCount = Integer.parseInt(cpTok.nextToken());
            Element elem = new Element();
            elem.count = cpCount;
            elem.chosen = 1;
            while (strTok.hasMoreTokens()) {
                StringTokenizer lbTok = new StringTokenizer(strTok.nextToken(), ":");
                int label = Integer.parseInt(lbTok.nextToken());
                int count = Integer.parseInt(lbTok.nextToken());
                int fidx = Integer.parseInt(lbTok.nextToken());
                CountFIdx cntFIdx = new CountFIdx(count, fidx);
                elem.lbCntFidxes.put(new Integer(label), cntFIdx);
            }
            this.dict.put(new Integer(cp), elem);
        }
        System.out.println("Reading dictionary (" + Integer.toString(this.dict.size()) + " entries) completed!");
        line = fin.readLine();
    }

    public void writeDict(PrintWriter fout) throws IOException {
        Element elem;
        Iterator it = null;
        int count = 0;
        for (Integer cpInt : this.dict.keySet()) {
            elem = (Element)this.dict.get(cpInt);
            if (elem.chosen != 1) continue;
            ++count;
        }
        fout.println(Integer.toString(count));
        for (Integer cpInt : this.dict.keySet()) {
            elem = (Element)this.dict.get(cpInt);
            if (elem.chosen == 0) continue;
            fout.print(cpInt.toString() + ":" + Integer.toString(elem.count));
            for (Integer labelInt : elem.lbCntFidxes.keySet()) {
                CountFIdx cntFIdx = (CountFIdx)elem.lbCntFidxes.get(labelInt);
                if (cntFIdx.fidx < 0) continue;
                fout.print(" " + labelInt.toString() + ":" + Integer.toString(cntFIdx.count) + ":" + Integer.toString(cntFIdx.fidx));
            }
            fout.println();
        }
        fout.println(Option.modelSeparator);
    }

    public void addDict(int cp, int label, int count) {
        Element elem = (Element)this.dict.get(new Integer(cp));
        if (elem == null) {
            elem = new Element();
            elem.count = count;
            CountFIdx cntFIdx = new CountFIdx(count, -1);
            elem.lbCntFidxes.put(new Integer(label), cntFIdx);
            this.dict.put(new Integer(cp), elem);
        } else {
            elem.count += count;
            CountFIdx cntFIdx = (CountFIdx)elem.lbCntFidxes.get(new Integer(label));
            if (cntFIdx == null) {
                cntFIdx = new CountFIdx(count, -1);
                elem.lbCntFidxes.put(new Integer(label), cntFIdx);
            } else {
                cntFIdx.count += count;
            }
        }
    }

    public void generateDict() {
        if (this.data.trnData == null) {
            System.out.println("No data available for generating dictionary");
            return;
        }
        for (int i = 0; i < this.data.trnData.size(); ++i) {
            Observation obsr = (Observation)this.data.trnData.get(i);
            for (int j = 0; j < obsr.cps.length; ++j) {
                this.addDict(obsr.cps[j], obsr.humanLabel, 1);
            }
        }
    }

    public int size() {
        if (this.dict == null) {
            return 0;
        }
        return this.dict.size();
    }
}

