/*
 * Decompiled with CFR 0.152.
 */
package jflexcrf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import jflexcrf.Dictionary;
import jflexcrf.Feature;
import jflexcrf.FeatureGen;
import jflexcrf.Maps;
import jflexcrf.Option;
import jflexcrf.Viterbi;

public class Model {
    public Option taggerOpt = null;
    public Maps taggerMaps = null;
    public Dictionary taggerDict = null;
    public FeatureGen taggerFGen = null;
    public Viterbi taggerVtb = null;
    double[] lambda = null;

    public Model() {
    }

    public Model(Option taggerOpt, Maps taggerMaps, Dictionary taggerDict, FeatureGen taggerFGen, Viterbi taggerVtb) {
        this.taggerOpt = taggerOpt;
        this.taggerMaps = taggerMaps;
        this.taggerDict = taggerDict;
        this.taggerFGen = taggerFGen;
        this.taggerVtb = taggerVtb;
    }

    public boolean init() {
        BufferedReader fin = null;
        String modelFile = this.taggerOpt.modelDir + File.separator + this.taggerOpt.modelFile;
        try {
            fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(modelFile), "UTF-8"));
            this.taggerMaps.readCpMaps(fin);
            System.gc();
            this.taggerMaps.readLbMaps(fin);
            System.gc();
            this.taggerDict.readDict(fin);
            System.gc();
            this.taggerFGen.readFeatures(fin);
            System.gc();
            fin.close();
        }
        catch (IOException e) {
            System.out.println("Couldn't open model file: " + modelFile);
            System.out.println(e.toString());
            return false;
        }
        if (this.lambda == null) {
            int numFeatures = this.taggerFGen.numFeatures();
            this.lambda = new double[numFeatures];
            for (int i = 0; i < numFeatures; ++i) {
                Feature f = (Feature)this.taggerFGen.features.get(i);
                this.lambda[f.idx] = f.wgt;
            }
        }
        if (this.taggerVtb != null) {
            this.taggerVtb.init(this);
        }
        return true;
    }

    public void inference(List seq) {
        this.taggerVtb.viterbiInference(seq);
    }

    public void inferenceAll(List data) {
        System.out.println("Starting inference ...");
        long start = System.currentTimeMillis();
        for (int i = 0; i < data.size(); ++i) {
            System.out.println("sequence " + Integer.toString(i + 1));
            List seq = (List)data.get(i);
            this.inference(seq);
        }
        long stop = System.currentTimeMillis();
        long elapsed = stop - start;
        System.out.println("Inference " + Integer.toString(data.size()) + " sequences completed!");
        System.out.println("Inference time: " + Double.toString((double)elapsed / 1000.0) + " seconds");
    }
}

