/*
 * Decompiled with CFR 0.152.
 */
package jflexcrf;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Maps {
    public Map cpStr2Int = null;
    public Map cpInt2Str = null;
    public Map lbStr2Int = null;
    public Map lbInt2Str = null;

    public void readCpMaps(BufferedReader fin) throws IOException {
        if (this.cpStr2Int != null) {
            this.cpStr2Int.clear();
        } else {
            this.cpStr2Int = new HashMap();
        }
        if (this.cpInt2Str != null) {
            this.cpInt2Str.clear();
        } else {
            this.cpInt2Str = new HashMap();
        }
        String line = fin.readLine();
        if (line == null) {
            System.out.println("No context predicate map size information");
            return;
        }
        int numCps = Integer.parseInt(line);
        if (numCps <= 0) {
            System.out.println("Invalid mapping size");
            return;
        }
        System.out.println("Reading the context predicate maps ...");
        for (int i = 0; i < numCps; ++i) {
            line = fin.readLine();
            if (line == null) {
                System.out.println("Invalid context predicate mapping line");
                return;
            }
            StringTokenizer strTok = new StringTokenizer(line, " \t\r\n");
            if (strTok.countTokens() != 2) continue;
            String cpStr = strTok.nextToken();
            String cpInt = strTok.nextToken();
            this.cpStr2Int.put(cpStr, new Integer(cpInt));
            this.cpInt2Str.put(new Integer(cpInt), cpStr);
        }
        System.out.println("Reading context predicate maps (" + Integer.toString(this.cpStr2Int.size()) + " entries) completed!");
        line = fin.readLine();
    }

    public void readLbMaps(BufferedReader fin) throws IOException {
        if (this.lbStr2Int != null) {
            this.lbStr2Int.clear();
        } else {
            this.lbStr2Int = new HashMap();
        }
        if (this.lbInt2Str != null) {
            this.lbInt2Str.clear();
        } else {
            this.lbInt2Str = new HashMap();
        }
        String line = fin.readLine();
        if (line == null) {
            System.out.println("No label map size information");
            return;
        }
        int numLabels = Integer.parseInt(line);
        if (numLabels <= 0) {
            System.out.println("Invalid label map size");
            return;
        }
        System.out.println("Reading label maps ...");
        for (int i = 0; i < numLabels; ++i) {
            line = fin.readLine();
            if (line == null) {
                System.out.println("Invalid label map line");
                return;
            }
            StringTokenizer strTok = new StringTokenizer(line, " \t\r\n");
            if (strTok.countTokens() != 2) continue;
            String lbStr = strTok.nextToken();
            String lbInt = strTok.nextToken();
            this.lbStr2Int.put(lbStr, new Integer(lbInt));
            this.lbInt2Str.put(new Integer(lbInt), lbStr);
        }
        System.out.println("Reading label maps (" + Integer.toString(this.lbStr2Int.size()) + " entries) completed!");
        line = fin.readLine();
    }

    public int numCps() {
        if (this.cpStr2Int == null) {
            return 0;
        }
        return this.cpStr2Int.size();
    }

    public int numLabels() {
        if (this.lbStr2Int == null) {
            return 0;
        }
        return this.lbStr2Int.size();
    }
}

