/*
 * Decompiled with CFR 0.152.
 */
package jflexcrf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jflexcrf.Dictionary;
import jflexcrf.FeatureGen;
import jflexcrf.Maps;
import jflexcrf.Model;
import jflexcrf.Observation;
import jflexcrf.Option;
import jflexcrf.Viterbi;
import jvntextpro.data.DataReader;
import jvntextpro.data.DataWriter;
import jvntextpro.data.Sentence;
import jvntextpro.data.TaggingData;

public class Labeling {
    private String modelDir = "";
    public Maps taggerMaps = null;
    public Dictionary taggerDict = null;
    private FeatureGen taggerFGen = null;
    private Viterbi taggerVtb = null;
    private Model taggerModel = null;
    private TaggingData dataTagger = null;
    private DataReader dataReader = null;
    private DataWriter dataWriter = null;

    public Labeling(String modelDir, TaggingData dataTagger, DataReader dataReader, DataWriter dataWriter) {
        this.init(modelDir);
        this.dataTagger = dataTagger;
        this.dataWriter = dataWriter;
        this.dataReader = dataReader;
    }

    public boolean init(String modelDir) {
        this.modelDir = modelDir;
        Option taggerOpt = new Option(this.modelDir);
        if (!taggerOpt.readOptions()) {
            return false;
        }
        this.taggerMaps = new Maps();
        this.taggerDict = new Dictionary();
        this.taggerFGen = new FeatureGen(this.taggerMaps, this.taggerDict);
        this.taggerVtb = new Viterbi();
        this.taggerModel = new Model(taggerOpt, this.taggerMaps, this.taggerDict, this.taggerFGen, this.taggerVtb);
        if (!this.taggerModel.init()) {
            System.out.println("Couldn't load the model");
            System.out.println("Check the <model directory> and the <model file> again");
            return false;
        }
        return true;
    }

    public void setDataReader(DataReader reader) {
        this.dataReader = reader;
    }

    public void setDataTagger(TaggingData tagger) {
        this.dataTagger = tagger;
    }

    public void setDataWriter(DataWriter writer) {
        this.dataWriter = writer;
    }

    public List seqLabeling(String data) {
        List<Sentence> obsvSeqs = this.dataReader.readString(data);
        return this.labeling(obsvSeqs);
    }

    public List seqLabeling(File file) {
        List<Sentence> obsvSeqs = this.dataReader.readFile(file.getPath());
        return this.labeling(obsvSeqs);
    }

    public String strLabeling(String data) {
        List lblSeqs = this.seqLabeling(data);
        String ret = this.dataWriter.writeString(lblSeqs);
        return ret;
    }

    public String strLabeling(File file) {
        List<Sentence> obsvSeqs = this.dataReader.readFile(file.getPath());
        List lblSeqs = this.labeling(obsvSeqs);
        String ret = this.dataWriter.writeString(lblSeqs);
        return ret;
    }

    private List labeling(List<Sentence> obsvSeqs) {
        int j;
        int i;
        ArrayList labelSeqs = new ArrayList();
        for (i = 0; i < obsvSeqs.size(); ++i) {
            ArrayList<Observation> sequence = new ArrayList<Observation>();
            Sentence sentence = obsvSeqs.get(i);
            for (j = 0; j < sentence.size(); ++j) {
                int k;
                Observation obsv = new Observation();
                obsv.originalData = sentence.getWordAt(j);
                String[] strCps = this.dataTagger.getContext(sentence, j);
                ArrayList<Integer> tempCpsInt = new ArrayList<Integer>();
                for (k = 0; k < strCps.length; ++k) {
                    Integer cpInt = (Integer)this.taggerMaps.cpStr2Int.get(strCps[k]);
                    if (cpInt == null) continue;
                    tempCpsInt.add(cpInt);
                }
                obsv.cps = new int[tempCpsInt.size()];
                for (k = 0; k < tempCpsInt.size(); ++k) {
                    obsv.cps[k] = (Integer)tempCpsInt.get(k);
                }
                sequence.add(obsv);
            }
            labelSeqs.add(sequence);
        }
        this.taggerModel.inferenceAll(labelSeqs);
        for (i = 0; i < obsvSeqs.size(); ++i) {
            Sentence sent = obsvSeqs.get(i);
            List seq = (List)labelSeqs.get(i);
            for (j = 0; j < sent.size(); ++j) {
                Observation obsrv = (Observation)seq.get(j);
                String label = (String)this.taggerMaps.lbInt2Str.get(obsrv.modelLabel);
                sent.getTWordAt(j).setTag(label);
            }
        }
        return obsvSeqs;
    }
}

