/*
 * Decompiled with CFR 0.152.
 */
package jflexcrf;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jflexcrf.CountFeatureIdx;
import jflexcrf.Dictionary;
import jflexcrf.Element;
import jflexcrf.Feature;
import jflexcrf.Maps;
import jflexcrf.Observation;

public class FeatureGen {
    List features = null;
    Map fmap = null;
    Maps maps = null;
    Dictionary dict = null;
    List sFeatures = null;
    int sFeatureIdx = 0;
    List eFeatures = null;
    int eFeatureIdx = 0;

    public FeatureGen(Maps maps, Dictionary dict) {
        this.maps = maps;
        this.dict = dict;
    }

    public void addFeature(Feature f) {
        f.strId2IdxAdd(this.fmap);
        this.features.add(f);
    }

    public int numFeatures() {
        if (this.features == null) {
            return 0;
        }
        return this.features.size();
    }

    public void readFeatures(BufferedReader fin) throws IOException {
        if (this.features != null) {
            this.features.clear();
        } else {
            this.features = new ArrayList();
        }
        if (this.fmap != null) {
            this.fmap.clear();
        } else {
            this.fmap = new HashMap();
        }
        if (this.eFeatures != null) {
            this.eFeatures.clear();
        } else {
            this.eFeatures = new ArrayList();
        }
        if (this.sFeatures != null) {
            this.sFeatures.clear();
        } else {
            this.sFeatures = new ArrayList();
        }
        String line = fin.readLine();
        if (line == null) {
            System.out.println("Unknown number of features");
            return;
        }
        int numFeatures = Integer.parseInt(line);
        System.out.println("Number of features: " + numFeatures);
        if (numFeatures <= 0) {
            System.out.println("Invalid number of features");
            return;
        }
        System.out.println("Reading features ...");
        for (int i = 0; i < numFeatures; ++i) {
            StringTokenizer strTok;
            line = fin.readLine();
            if (line == null || (strTok = new StringTokenizer(line, " ")).countTokens() != 3) continue;
            Feature f = new Feature(line, this.maps.cpStr2Int, this.maps.lbStr2Int);
            Integer fidx = (Integer)this.fmap.get(f.strId);
            if (fidx == null) {
                this.fmap.put(f.strId, new Integer(f.idx));
                this.features.add(f);
                if (f.ftype != 1) continue;
                this.eFeatures.add(f);
                continue;
            }
            this.features.add(f);
        }
        System.out.println("Reading " + Integer.toString(this.features.size()) + " features completed!");
        line = fin.readLine();
    }

    public void startScanFeaturesAt(List seq, int pos) {
        this.startScanSFeaturesAt(seq, pos);
        this.startScanEFeatures();
    }

    public boolean hasNextFeature() {
        return this.hasNextSFeature() || this.hasNextEFeature();
    }

    public Feature nextFeature() {
        Feature f = null;
        if (this.hasNextSFeature()) {
            f = this.nextSFeature();
        } else if (this.hasNextEFeature()) {
            f = this.nextEFeature();
        }
        return f;
    }

    void startScanSFeaturesAt(List seq, int pos) {
        this.sFeatures.clear();
        this.sFeatureIdx = 0;
        Observation obsr = (Observation)seq.get(pos);
        for (int i = 0; i < obsr.cps.length; ++i) {
            Element elem = (Element)this.dict.dict.get(new Integer(obsr.cps[i]));
            if (elem == null) continue;
            if (!elem.isScanned) {
                for (Integer label : elem.lbCntFidxes.keySet()) {
                    CountFeatureIdx cntFidx = (CountFeatureIdx)elem.lbCntFidxes.get(label);
                    if (cntFidx.fidx < 0) continue;
                    Feature sF = new Feature();
                    sF.sFeature1Init(label, obsr.cps[i]);
                    sF.idx = cntFidx.fidx;
                    elem.cpFeatures.add(sF);
                }
                elem.isScanned = true;
            }
            for (int j = 0; j < elem.cpFeatures.size(); ++j) {
                this.sFeatures.add(elem.cpFeatures.get(j));
            }
        }
    }

    boolean hasNextSFeature() {
        return this.sFeatureIdx < this.sFeatures.size();
    }

    Feature nextSFeature() {
        Feature sF = (Feature)this.sFeatures.get(this.sFeatureIdx);
        ++this.sFeatureIdx;
        return sF;
    }

    void startScanEFeatures() {
        this.eFeatureIdx = 0;
    }

    boolean hasNextEFeature() {
        return this.eFeatureIdx < this.eFeatures.size();
    }

    Feature nextEFeature() {
        Feature eF = (Feature)this.eFeatures.get(this.eFeatureIdx);
        ++this.eFeatureIdx;
        return eF;
    }
}

