/*
 * Decompiled with CFR 0.152.
 */
package jflexcrf;

public class DoubleVector {
    public double[] vect = null;
    public int len = 0;

    public DoubleVector() {
        this.len = 0;
        this.vect = null;
    }

    public DoubleVector(int len) {
        this.len = len;
        this.vect = new double[len];
    }

    public DoubleVector(int len, double[] vect) {
        this.len = len;
        this.vect = new double[len];
        for (int i = 0; i < len; ++i) {
            this.vect[i] = vect[i];
        }
    }

    public DoubleVector(DoubleVector dv) {
        this.len = dv.len;
        this.vect = new double[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.vect[i] = dv.vect[i];
        }
    }

    public int size() {
        return this.len;
    }

    public void assign(double val) {
        for (int i = 0; i < this.len; ++i) {
            this.vect[i] = val;
        }
    }

    public void assign(DoubleVector dv) {
        for (int i = 0; i < this.len; ++i) {
            this.vect[i] = dv.vect[i];
        }
    }

    public double sum() {
        double res = 0.0;
        for (int i = 0; i < this.len; ++i) {
            res += this.vect[i];
        }
        return res;
    }

    public void compMult(double val) {
        int i = 0;
        while (i < this.len) {
            int n = i++;
            this.vect[n] = this.vect[n] * val;
        }
    }

    public void compMult(DoubleVector dv) {
        for (int i = 0; i < this.len; ++i) {
            int n = i;
            this.vect[n] = this.vect[n] * dv.vect[i];
        }
    }
}

