/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.consumer.tempeval3writer;

import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import de.unihd.dbs.uima.types.heideltime.Dct;
import de.unihd.dbs.uima.types.heideltime.Timex3;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TempEval3Writer
extends CasConsumer_ImplBase {
    private Class<?> component = ((Object)((Object)this)).getClass();
    private static final String PARAM_OUTPUTDIR = "OutputDir";
    private static volatile Integer outCount = 0;
    private File mOutputDir;

    public void initialize() throws ResourceInitializationException {
        this.mOutputDir = new File((String)this.getConfigParameterValue(PARAM_OUTPUTDIR));
        if (!this.mOutputDir.exists() && !this.mOutputDir.mkdirs()) {
            Logger.printError(this.component, "Couldn't create non-existant folder " + this.mOutputDir.getAbsolutePath());
            throw new ResourceInitializationException();
        }
        if (!this.mOutputDir.canWrite()) {
            Logger.printError(this.component, "Folder " + this.mOutputDir.getAbsolutePath() + " is not writable.");
            throw new ResourceInitializationException();
        }
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        Dct dct = null;
        String filename = null;
        try {
            dct = (Dct)((Object)jcas.getAnnotationIndex(Dct.type).iterator().next());
            filename = new File(dct.getFilename()).getName();
        }
        catch (Exception e) {
            filename = "doc_" + TempEval3Writer.getOutCount() + ".tml";
        }
        Document xmlDoc = this.buildTimeMLDocument(jcas, dct, filename);
        this.writeTimeMLDocument(xmlDoc, filename);
    }

    private Document buildTimeMLDocument(JCas jcas, Dct dct, String filename) {
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        Document doc = null;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            Logger.printError(this.component, "XML Builder could not be instantiated");
        }
        Element rootEl = doc.createElement("TimeML");
        rootEl.setAttributeNS("xmlns", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootEl.setAttributeNS("xsi", "noNamespaceSchemaLocation", "http://timeml.org/timeMLdocs/TimeML_1.2.1.xsd");
        doc.appendChild(rootEl);
        Element docidEl = doc.createElement("DOCID");
        docidEl.appendChild(doc.createTextNode(filename));
        rootEl.appendChild(docidEl);
        if (dct != null) {
            Element dctEl = doc.createElement("DCT");
            Element timexForDCT = doc.createElement("TIMEX3");
            timexForDCT.setAttribute("tid", "t0");
            timexForDCT.setAttribute("type", "DATE");
            timexForDCT.setAttribute("value", dct.getValue());
            timexForDCT.setAttribute("temporalFunction", "false");
            timexForDCT.setAttribute("functionInDocument", "CREATION_TIME");
            timexForDCT.appendChild(doc.createTextNode(dct.getValue()));
            dctEl.appendChild(timexForDCT);
            rootEl.appendChild(dctEl);
        }
        Integer offset = 0;
        Element textEl = doc.createElement("TEXT");
        rootEl.appendChild(textEl);
        FSIterator it = jcas.getAnnotationIndex(Timex3.type).iterator();
        String docText = jcas.getDocumentText();
        if (!it.hasNext()) {
            textEl.appendChild(doc.createTextNode(docText));
        } else {
            HashSet<Timex3> timexesToSkip = new HashSet<Timex3>();
            Timex3 prevT = null;
            Timex3 thisT = null;
            while (it.hasNext()) {
                thisT = (Timex3)((Object)it.next());
                if (((Object)((Object)thisT)).getClass() != Timex3.class) continue;
                if (prevT != null && prevT.getEnd() > thisT.getBegin()) {
                    Timex3 removedT = null;
                    if (prevT.getTimexValue().length() > thisT.getTimexValue().length()) {
                        timexesToSkip.add(thisT);
                        removedT = thisT;
                    } else {
                        timexesToSkip.add(prevT);
                        removedT = prevT;
                        prevT = thisT;
                    }
                    Logger.printError(this.component, "Two overlapping Timexes have been discovered:" + System.getProperty("line.separator") + "Timex A: " + prevT.getCoveredText() + " [\"" + prevT.getTimexValue() + "\" / " + prevT.getBegin() + ":" + prevT.getEnd() + "]" + System.getProperty("line.separator") + "Timex B: " + removedT.getCoveredText() + " [\"" + removedT.getTimexValue() + "\" / " + removedT.getBegin() + ":" + removedT.getEnd() + "] [removed]" + System.getProperty("line.separator") + "The writer chose, for granularity: " + prevT.getCoveredText() + System.getProperty("line.separator") + "This usually happens with an incomplete ruleset. Please consider adding a new rule that covers the entire expression.");
                    continue;
                }
                prevT = thisT;
            }
            it.moveToFirst();
            while (it.hasNext()) {
                Timex3 t = (Timex3)((Object)it.next());
                if (((Object)((Object)t)).getClass() != Timex3.class || timexesToSkip.contains((Object)t)) continue;
                if (t.getBegin() > offset) {
                    textEl.appendChild(doc.createTextNode(docText.substring(offset, t.getBegin())));
                }
                Element newTimex = doc.createElement("TIMEX3");
                newTimex.setAttribute("tid", t.getTimexId());
                newTimex.setAttribute("type", t.getTimexType());
                newTimex.setAttribute("value", t.getTimexValue());
                if (!t.getTimexMod().equals("")) {
                    newTimex.setAttribute("mod", t.getTimexMod());
                }
                if (!t.getTimexQuant().equals("")) {
                    newTimex.setAttribute("quant", t.getTimexQuant());
                }
                if (!t.getTimexFreq().equals("")) {
                    newTimex.setAttribute("freq", t.getTimexFreq());
                }
                newTimex.appendChild(doc.createTextNode(t.getCoveredText()));
                textEl.appendChild(newTimex);
                offset = t.getEnd();
            }
            if (offset < docText.length()) {
                textEl.appendChild(doc.createTextNode(docText.substring(offset)));
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTimeMLDocument(Document xmlDoc, String filename) {
        File outFile = new File(this.mOutputDir, filename + ".tml");
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(outFile));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "no");
            DOMSource source = new DOMSource(xmlDoc);
            StreamResult result = new StreamResult(bw);
            transformer.transform(source, result);
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.printError(this.component, "File " + outFile.getAbsolutePath() + " could not be written.");
        }
        catch (TransformerException e) {
            e.printStackTrace();
            Logger.printError(this.component, "XML transformer could not be properly initialized.");
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Logger.printError(this.component, "File " + outFile.getAbsolutePath() + " could not be closed.");
            }
        }
    }

    public static synchronized Integer getOutCount() {
        Integer n = outCount;
        Integer n2 = outCount = Integer.valueOf(outCount + 1);
        return n;
    }
}

