/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.consumer.tempeval2writer;

import de.unihd.dbs.uima.types.heideltime.Timex3;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class Tempeval2Writer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDir";
    private File mOutputDir;

    public void initialize() throws ResourceInitializationException {
        this.mOutputDir = new File((String)this.getConfigParameterValue(PARAM_OUTPUTDIR));
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        this.printTimexAnnotations(jcas);
    }

    public void printTimexAnnotations(JCas jcas) {
        File outExtents = new File(this.mOutputDir, "timex-extents.tab");
        File outAttributes = new File(this.mOutputDir, "timex-attributes.tab");
        AnnotationIndex indexTimex = jcas.getAnnotationIndex(Timex3.type);
        for (Timex3 t : indexTimex) {
            if (t.getType().toString().equals("de.unihd.dbs.uima.heidopp.types.tempeval2.GoldTimex3")) continue;
            String toPrintExtents = "";
            String[] allTokList = t.getAllTokIds().split("<-->");
            for (int i = 1; i < allTokList.length; ++i) {
                toPrintExtents = toPrintExtents + t.getFilename() + "\t" + t.getSentId() + "\t" + allTokList[i] + "\ttimex3\t" + t.getTimexId() + "\t1\n";
            }
            try {
                BufferedWriter bf = new BufferedWriter(new FileWriter(outExtents, true));
                bf.write(toPrintExtents);
                bf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String toPrintAttributes = t.getFilename() + "\t" + t.getSentId() + "\t" + t.getFirstTokId() + "\ttimex3\t" + t.getTimexId() + "\t1\ttype\t" + t.getTimexType() + "\n";
            toPrintAttributes = toPrintAttributes + t.getFilename() + "\t" + t.getSentId() + "\t" + t.getFirstTokId() + "\ttimex3\t" + t.getTimexId() + "\t1\tvalue\t" + t.getTimexValue() + "\n";
            try {
                BufferedWriter bf = new BufferedWriter(new FileWriter(outAttributes, true));
                bf.write(toPrintAttributes);
                bf.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

