/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.consumer.eventi2014writer;

import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import de.unihd.dbs.uima.types.heideltime.Dct;
import de.unihd.dbs.uima.types.heideltime.Timex3;
import de.unihd.dbs.uima.types.heideltime.Timex3Interval;
import de.unihd.dbs.uima.types.heideltime.Token;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class Eventi2014Writer
extends CasConsumer_ImplBase {
    private Class<?> component = ((Object)((Object)this)).getClass();
    private static final String PARAM_OUTPUTDIR = "OutputDir";
    private static volatile Integer outCount = 0;
    private File mOutputDir;

    public void initialize() throws ResourceInitializationException {
        this.mOutputDir = new File((String)this.getConfigParameterValue(PARAM_OUTPUTDIR));
        if (!this.mOutputDir.exists() && !this.mOutputDir.mkdirs()) {
            Logger.printError(this.component, "Couldn't create non-existant folder " + this.mOutputDir.getAbsolutePath());
            throw new ResourceInitializationException();
        }
        if (!this.mOutputDir.canWrite()) {
            Logger.printError(this.component, "Folder " + this.mOutputDir.getAbsolutePath() + " is not writable.");
            throw new ResourceInitializationException();
        }
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        String fullDocument = "";
        Dct dct = null;
        String filename = null;
        String dctTag = "";
        try {
            dct = (Dct)((Object)jcas.getAnnotationIndex(Dct.type).iterator().next());
            String[] parts = dct.getFilename().split("---");
            filename = parts[0];
            dctTag = parts[1];
        }
        catch (Exception e) {
            e.printStackTrace();
            filename = "doc_" + Eventi2014Writer.getOutCount();
        }
        String firstLine = "<Document doc_name=\"FILENAME\">\n";
        fullDocument = firstLine.replaceAll("FILENAME", filename);
        FSIterator itToken = jcas.getAnnotationIndex(Token.type).iterator();
        int oldTokNum = 0;
        int oldTokID = 0;
        while (itToken.hasNext()) {
            String tokenLine;
            Token t = (Token)((Object)itToken.next());
            String[] parts = t.getFilename().split("---");
            String sentNum = parts[1];
            String tokNum = parts[2];
            while (oldTokID < t.getTokenId() - 1) {
                tokenLine = "<token t_id=\"TOKENID\" sentence=\"SENTENCEID\" number=\"TOKENNUMBER\">TOKENSTRING</token>\n";
                tokenLine = tokenLine.replace("TOKENID", ++oldTokID + "");
                tokenLine = tokenLine.replace("SENTENCEID", sentNum);
                tokenLine = tokenLine.replace("TOKENNUMBER", ++oldTokNum + "");
                tokenLine = tokenLine.replace("TOKENSTRING", "");
                fullDocument = fullDocument + tokenLine;
            }
            tokenLine = "<token t_id=\"TOKENID\" sentence=\"SENTENCEID\" number=\"TOKENNUMBER\">TOKENSTRING</token>\n";
            tokenLine = tokenLine.replace("TOKENID", t.getTokenId() + "");
            tokenLine = tokenLine.replace("SENTENCEID", sentNum);
            tokenLine = tokenLine.replace("TOKENNUMBER", tokNum);
            tokenLine = tokenLine.replace("TOKENSTRING", t.getCoveredText());
            oldTokNum = Integer.parseInt(tokNum);
            oldTokID = t.getTokenId();
            fullDocument = fullDocument + tokenLine;
        }
        fullDocument = fullDocument + "\n\n<Markables>\n";
        HashMap<Timex3, Integer> emptyValueTimexes = new HashMap<Timex3, Integer>();
        HashMap<String, String> idTranslation = new HashMap<String, String>();
        int markableCounter = 1;
        for (Timex3 t : jcas.getAnnotationIndex(Timex3.type)) {
            if (t instanceof Timex3Interval) continue;
            if (t.getEmptyValue() != null && !t.getEmptyValue().equals("")) {
                emptyValueTimexes.put(t, markableCounter);
            }
            String open = "<TIMEX3 m_id=\"MARKABLEID\" mod=\"MODSTRING\" quant=\"QUANTSTRING\" freq=\"FREQSTRING\" value=\"VALUESTRING\" type=\"TYPESTRING\"  >\n";
            String tokenInfoSingle = "<token_anchor t_id=\"TOKENID\"/>\n";
            String string = "</TIMEX3>\n";
            open = open.replace("MARKABLEID", markableCounter + "");
            open = open.replace("MODSTRING", t.getTimexMod());
            open = open.replace("QUANTSTRING", t.getTimexQuant());
            open = open.replace("FREQSTRING", t.getTimexFreq());
            open = open.replace("VALUESTRING", t.getTimexValue());
            open = open.replace("TYPESTRING", t.getTimexType());
            fullDocument = fullDocument + open;
            for (Token tok : jcas.getAnnotationIndex(Token.type)) {
                if (tok.getBegin() < t.getBegin() || tok.getEnd() > t.getEnd()) continue;
                int tokID = tok.getTokenId();
                String line = tokenInfoSingle;
                line = line.replace("TOKENID", tokID + "");
                fullDocument = fullDocument + (String)line;
            }
            fullDocument = fullDocument + string;
            idTranslation.put(t.getTimexId(), markableCounter + "");
            ++markableCounter;
        }
        Pattern p = Pattern.compile("m_id=\"([^\"]*)\"");
        Matcher m = p.matcher(dctTag);
        if (m.find()) {
            dctTag = dctTag.substring(0, m.start(1)) + markableCounter++ + dctTag.substring(m.end(1), dctTag.length());
        }
        fullDocument = fullDocument + dctTag + "\n";
        for (Map.Entry entry : emptyValueTimexes.entrySet()) {
            String open = "<TIMEX3 m_id=\"" + markableCounter++ + "\" TAG_DESCRIPTOR=\"Empty_Mark\" anchorTimeID=\"" + entry.getValue() + "\" value=\"" + ((Timex3)((Object)entry.getKey())).getEmptyValue() + "\" type=\"DATE\" />\n";
            fullDocument = fullDocument + open;
        }
        for (Timex3Interval timex3Interval : jcas.getAnnotationIndex(Timex3Interval.type)) {
            if (timex3Interval.getEmptyValue() == null || timex3Interval.getEmptyValue().equals("")) continue;
            String beginMarkable = (String)idTranslation.get(timex3Interval.getBeginTimex());
            String endMarkable = (String)idTranslation.get(timex3Interval.getEndTimex());
            fullDocument = fullDocument + "<TIMEX3 m_id=\"" + markableCounter++ + "\" TAG_DESCRIPTOR=\"Empty_Mark\" beginPoint=\"" + beginMarkable + "\" endPoint=\"" + endMarkable + "\" anchorTimeID=\"" + beginMarkable + "\" value=\"" + timex3Interval.getEmptyValue() + "\" type=\"DURATION\" />\n";
        }
        fullDocument = fullDocument + "</Markables>\n<Relations>\n</Relations>\n</Document>";
        this.writeDocument(fullDocument, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(String fullDocument, String filename) {
        File outFile = new File(this.mOutputDir, filename + ".xml");
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(outFile));
            bw.append(fullDocument);
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.printError(this.component, "File " + outFile.getAbsolutePath() + " could not be written.");
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Logger.printError(this.component, "File " + outFile.getAbsolutePath() + " could not be closed.");
            }
        }
    }

    public static synchronized Integer getOutCount() {
        Integer n = outCount;
        Integer n2 = outCount = Integer.valueOf(outCount + 1);
        return n;
    }
}

