/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.consumer.aceternwriter;

import de.unihd.dbs.uima.types.heideltime.SourceDocInfo;
import de.unihd.dbs.uima.types.heideltime.Timex3;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class ACETernWriter
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDir";
    public static final String PARAM_CONVERTTIMEX3TO2 = "ConvertTimex3To2";
    private File mOutputDir;
    private int mDocNum;
    private Boolean convertTimex3To2 = true;
    private boolean printDetails = false;

    public void initialize() throws ResourceInitializationException {
        this.mDocNum = 0;
        this.convertTimex3To2 = (Boolean)this.getConfigParameterValue(PARAM_CONVERTTIMEX3TO2);
        this.mOutputDir = new File((String)this.getConfigParameterValue(PARAM_OUTPUTDIR));
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        this.printTimexAnnotationsInline(jcas);
    }

    public void printTimexAnnotationsInline(JCas jcas) {
        FSIterator it = jcas.getAnnotationIndex(SourceDocInfo.type).iterator();
        File outFile = null;
        File inFile = null;
        if (it.hasNext()) {
            SourceDocInfo fileLoc = (SourceDocInfo)((Object)it.next());
            try {
                inFile = new File(new URL(fileLoc.getUri()).getPath());
                String outFileName = inFile.getName();
                if (fileLoc.getOffsetInSource() > 0) {
                    outFileName = outFileName + "_" + fileLoc.getOffsetInSource();
                }
                outFileName = outFileName + ".xmi";
                outFile = new File(this.mOutputDir, outFileName);
            }
            catch (MalformedURLException outFileName) {
                // empty catch block
            }
        }
        if (outFile == null) {
            outFile = new File(this.mOutputDir, "doc" + this.mDocNum++);
        }
        String toprint = "";
        String doctext = jcas.getDocumentText();
        int startposition = 0;
        int endposition = doctext.length();
        boolean anyTimex = false;
        AnnotationIndex indexTimex = jcas.getAnnotationIndex(Timex3.type);
        FSIterator iterTimex = indexTimex.iterator();
        while (iterTimex.hasNext()) {
            anyTimex = true;
            Timex3 t = (Timex3)((Object)iterTimex.next());
            endposition = t.getBegin();
            if (endposition < startposition) {
                if (!this.printDetails) continue;
                System.err.println("[Tern2004Writer] Overlapping expressions... ignoring: " + t.getCoveredText());
                continue;
            }
            String timexvalue = t.getTimexValue();
            if (this.convertTimex3To2.booleanValue()) {
                timexvalue = this.translatetimex3timex2(timexvalue);
                if (t.getTimexType().equals("SET")) {
                    timexvalue = this.translatetimex3timex2set(timexvalue);
                }
            }
            toprint = toprint + doctext.substring(startposition, endposition);
            toprint = toprint + "<TIMEX2 val=\"" + timexvalue + "\">";
            toprint = toprint + t.getCoveredText();
            toprint = toprint + "</TIMEX2>";
            startposition = t.getEnd();
        }
        if (anyTimex) {
            toprint = toprint + doctext.substring(startposition);
        }
        if (!anyTimex) {
            toprint = toprint + doctext;
        }
        try {
            BufferedWriter bf = new BufferedWriter(new FileWriter(outFile));
            bf.append(toprint);
            bf.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public String translatetimex3timex2(String timexvalue) {
        String century;
        String decade = "(.*\\d\\d\\d)X";
        if (timexvalue.matches(decade)) {
            for (MatchResult m : ACETernWriter.findMatches(Pattern.compile(decade), timexvalue)) {
                timexvalue = m.group(1);
            }
        }
        if (timexvalue.matches(century = "(.*\\d\\d)XX")) {
            for (MatchResult m : ACETernWriter.findMatches(Pattern.compile(century), timexvalue)) {
                timexvalue = m.group(1);
            }
        }
        return timexvalue;
    }

    public String translatetimex3timex2set(String timexvalue) {
        String minute;
        String hour;
        String day;
        String month;
        String year = "(P(\\d)+Y)";
        if (timexvalue.matches(year)) {
            timexvalue = "XXXX";
        }
        if (timexvalue.matches(month = "(P(\\d)+M)")) {
            timexvalue = "XXXX-XX";
        }
        if (timexvalue.matches(day = "(P(\\d)+D)")) {
            timexvalue = "XXXX-XX-XX";
        }
        if (timexvalue.matches(hour = "(PT(\\d)+H)")) {
            timexvalue = "XXXX-XX-XXTXX";
        }
        if (timexvalue.matches(minute = "(PT(\\d)+M)")) {
            timexvalue = "XXXX-XX-XXTXX:XX";
        }
        return timexvalue;
    }

    public static Iterable<MatchResult> findMatches(Pattern pattern, CharSequence s) {
        ArrayList<MatchResult> results = new ArrayList<MatchResult>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            results.add(m.toMatchResult());
        }
        return results;
    }
}

