/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.intervaltagger;

import de.unihd.dbs.uima.annotator.heideltime.resources.Language;
import de.unihd.dbs.uima.annotator.heideltime.resources.RePatternManager;
import de.unihd.dbs.uima.annotator.heideltime.resources.ResourceMap;
import de.unihd.dbs.uima.annotator.heideltime.resources.ResourceScanner;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Toolbox;
import de.unihd.dbs.uima.types.heideltime.IntervalCandidateSentence;
import de.unihd.dbs.uima.types.heideltime.Sentence;
import de.unihd.dbs.uima.types.heideltime.Timex3;
import de.unihd.dbs.uima.types.heideltime.Timex3Interval;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class IntervalTagger
extends JCasAnnotator_ImplBase {
    private Class<?> component = ((Object)((Object)this)).getClass();
    public static String PARAM_LANGUAGE = "language";
    public static String PARAM_INTERVALS = "annotate_intervals";
    public static String PARAM_INTERVAL_CANDIDATES = "annotate_interval_candidates";
    private Language language = null;
    private Boolean find_intervals = true;
    private Boolean find_interval_candidates = true;
    private HashMap<Pattern, String> hmIntervalPattern = new HashMap();
    private HashMap<String, String> hmIntervalNormalization = new HashMap();

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.language = Language.getLanguageFromString((String)aContext.getConfigParameterValue(PARAM_LANGUAGE));
        this.find_intervals = (Boolean)aContext.getConfigParameterValue(PARAM_INTERVALS);
        this.find_interval_candidates = (Boolean)aContext.getConfigParameterValue(PARAM_INTERVAL_CANDIDATES);
        ResourceScanner rs = ResourceScanner.getInstance();
        this.readResources(rs.getRules(this.language.getName()));
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (this.find_intervals.booleanValue()) {
            this.findIntervals(jcas);
            this.findSentenceIntervals(jcas);
        }
    }

    private void readResources(ResourceMap hmResourcesRules) throws ResourceInitializationException {
        Pattern paReadRules = Pattern.compile("RULENAME=\"(.*?)\",EXTRACTION=\"(.*?)\",NORM_VALUE=\"(.*?)\"(.*)");
        Pattern paVariable = Pattern.compile("%(re[a-zA-Z0-9]*)");
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            for (String resource : hmResourcesRules.keySet()) {
                String line;
                is = hmResourcesRules.getInputStream(resource);
                isr = new InputStreamReader(is, "UTF-8");
                br = new BufferedReader(isr);
                Logger.printDetail(this.component, "Adding rule resource: " + resource);
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("//") || line.equals("")) continue;
                    Logger.printDetail("DEBUGGING: reading rules..." + line);
                    for (MatchResult r : Toolbox.findMatches(paReadRules, line)) {
                        String rule_name = r.group(1);
                        String rule_extraction = r.group(2);
                        String rule_normalization = r.group(3);
                        RePatternManager rpm = RePatternManager.getInstance(this.language, false);
                        for (MatchResult mr : Toolbox.findMatches(paVariable, rule_extraction)) {
                            Logger.printDetail("DEBUGGING: replacing patterns..." + mr.group());
                            if (!rpm.containsKey(mr.group(1)).booleanValue()) {
                                Logger.printError("Error creating rule:" + rule_name);
                                Logger.printError("The following pattern used in this rule does not exist, does it? %" + mr.group(1));
                                System.exit(-1);
                            }
                            rule_extraction = rule_extraction.replaceAll("%" + mr.group(1), rpm.get(mr.group(1)));
                        }
                        rule_extraction = rule_extraction.replaceAll(" ", "[\\\\s]+");
                        Pattern pattern = null;
                        try {
                            pattern = Pattern.compile(rule_extraction);
                        }
                        catch (PatternSyntaxException e) {
                            Logger.printError("Compiling rules resulted in errors.");
                            Logger.printError("Problematic rule is " + rule_name);
                            Logger.printError("Cannot compile pattern: " + rule_extraction);
                            e.printStackTrace();
                            System.exit(-1);
                        }
                        if (!resource.equals("intervalrules")) continue;
                        this.hmIntervalPattern.put(pattern, rule_name);
                        this.hmIntervalNormalization.put(rule_name, rule_normalization);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ResourceInitializationException();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void findSentenceIntervals(JCas jcas) {
        HashSet<Timex3Interval> timexesToRemove = new HashSet<Timex3Interval>();
        for (Sentence s : jcas.getAnnotationIndex(Sentence.type)) {
            String sString = s.getCoveredText();
            FSIterator iterInter = jcas.getAnnotationIndex(Timex3Interval.type).subiterator((AnnotationFS)s);
            int count = 0;
            ArrayList<Timex3Interval> txes = new ArrayList<Timex3Interval>();
            ArrayList<Timex3Interval> sentenceTxes = new ArrayList<Timex3Interval>();
            while (iterInter.hasNext()) {
                Timex3Interval t = (Timex3Interval)((Object)iterInter.next());
                sString = sString.replace(t.getCoveredText(), "<TX3_" + count + ">");
                ++count;
                txes.add(t);
            }
            if (count <= 0) continue;
            if (this.find_interval_candidates.booleanValue()) {
                IntervalCandidateSentence sI = new IntervalCandidateSentence(jcas);
                sI.setBegin(s.getBegin());
                sI.setEnd(s.getEnd());
                sI.addToIndexes();
            }
            for (Pattern p : this.hmIntervalPattern.keySet()) {
                String name = this.hmIntervalPattern.get(p);
                List results = (List)Toolbox.findMatches(p, sString);
                if (results.size() <= 0) continue;
                for (MatchResult r : results) {
                    String norm;
                    Pattern pNorm = Pattern.compile("group\\(([1-9]+)\\)-group\\(([1-9]+)\\)");
                    Matcher mNorm = pNorm.matcher(norm = this.hmIntervalNormalization.get(name));
                    if (!mNorm.matches()) {
                        System.err.println("Problem with the Norm in rule " + name);
                    }
                    Timex3Interval startTx = null;
                    Timex3Interval endTx = null;
                    try {
                        int startId = Integer.parseInt(mNorm.group(1));
                        int endId = Integer.parseInt(mNorm.group(2));
                        startTx = (Timex3Interval)((Object)txes.get(Integer.parseInt(r.group(startId))));
                        endTx = (Timex3Interval)((Object)txes.get(Integer.parseInt(r.group(endId))));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    Timex3Interval annotation = new Timex3Interval(jcas);
                    annotation.setBegin(startTx.getBegin() > endTx.getBegin() ? endTx.getBegin() : startTx.getBegin());
                    annotation.setEnd(startTx.getEnd() > endTx.getEnd() ? startTx.getEnd() : endTx.getEnd());
                    boolean duplicate = false;
                    for (Timex3Interval tx : sentenceTxes) {
                        if (tx.getBegin() != annotation.getBegin() || tx.getEnd() != annotation.getEnd()) continue;
                        duplicate = true;
                        break;
                    }
                    if (duplicate) continue;
                    annotation.setTimexValueEB(startTx.getTimexValueEB());
                    annotation.setTimexValueLB(startTx.getTimexValueLE());
                    annotation.setTimexValueEE(endTx.getTimexValueEB());
                    annotation.setTimexValueLE(endTx.getTimexValueLE());
                    annotation.setTimexType(startTx.getTimexType());
                    annotation.setFoundByRule(name);
                    String emptyValue = this.createEmptyValue(startTx, endTx, jcas);
                    annotation.setEmptyValue(emptyValue);
                    annotation.setBeginTimex(startTx.getBeginTimex());
                    annotation.setEndTimex(endTx.getEndTimex());
                    try {
                        sentenceTxes.add(annotation);
                    }
                    catch (NumberFormatException e) {
                        Logger.printError(this.component, "Couldn't do emptyValue calculation on accont of a faulty normalization in " + annotation.getTimexValueEB() + " or " + annotation.getTimexValueEE());
                    }
                    timexesToRemove.add(startTx);
                    timexesToRemove.add(endTx);
                    annotation.addToIndexes();
                }
            }
        }
        for (Timex3Interval txi : timexesToRemove) {
            txi.removeFromIndexes();
        }
    }

    private String createEmptyValue(Timex3Interval startTx, Timex3Interval endTx, JCas jcas) throws NumberFormatException {
        String dateStr = "";
        String timeStr = "";
        Pattern p = Pattern.compile("(\\d{1,4})?-?(\\d{2})?-?(\\d{2})?(T)?(\\d{2})?:?(\\d{2})?:?(\\d{2})?");
        Matcher mStart = p.matcher(startTx.getTimexValue());
        Matcher mEnd = p.matcher(endTx.getTimexValue());
        Integer granularityStart = -1;
        Integer granularityEnd = -2;
        Integer granularity = -1;
        if (mStart.find() && mEnd.find()) {
            Integer i = 1;
            while (i <= mStart.groupCount()) {
                if (mStart.group(i) != null) {
                    granularityStart = i;
                }
                if (mEnd.group(i) != null) {
                    granularityEnd = i;
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        if (granularityEnd != granularityStart) {
            return "";
        }
        granularity = granularityStart;
        Integer myYears = 0;
        Integer myMonths = 0;
        Integer myDays = 0;
        Integer myHours = 0;
        Integer myMinutes = 0;
        Integer mySeconds = 0;
        if (granularity >= 7 && mStart.group(7) != null && mEnd.group(7) != null && (mySeconds = Integer.valueOf(Integer.parseInt(mEnd.group(7)) - Integer.parseInt(mStart.group(7)))) < 0) {
            mySeconds = mySeconds + 60;
            myMinutes = myMinutes - 1;
        }
        if (granularity >= 6 && mStart.group(6) != null && mEnd.group(6) != null && (myMinutes = Integer.valueOf(myMinutes + (Integer.parseInt(mEnd.group(6)) - Integer.parseInt(mStart.group(6))))) < 0) {
            myMinutes = myMinutes + 60;
            myHours = myHours - 1;
        }
        if (granularity >= 5 && mStart.group(5) != null && mEnd.group(5) != null && (myHours = Integer.valueOf(myHours + (Integer.parseInt(mEnd.group(5)) - Integer.parseInt(mStart.group(5))))) < 0) {
            myMinutes = myMinutes + 24;
            myDays = myDays - 1;
        }
        if (granularity >= 3 && mStart.group(3) != null && mEnd.group(3) != null && (myDays = Integer.valueOf(myDays + (Integer.parseInt(mEnd.group(3)) - Integer.parseInt(mStart.group(3))))) < 0) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, Integer.parseInt(mStart.group(1)));
            cal.set(2, Integer.parseInt(mStart.group(2)));
            myMonths = myMonths - 1;
            myDays = myDays + cal.getActualMaximum(5);
        }
        if (granularity >= 2 && mStart.group(2) != null && mEnd.group(2) != null && (myMonths = Integer.valueOf(myMonths + (Integer.parseInt(mEnd.group(2)) - Integer.parseInt(mStart.group(2))))) < 0) {
            myMonths = myMonths + Integer.parseInt(mStart.group(2));
            myYears = myYears - 1;
        }
        String myYearUnit = "";
        if (granularity >= 1 && mStart.group(1) != null && mEnd.group(1) != null) {
            String year1str = mStart.group(1);
            String year2str = mEnd.group(1);
            while (year2str.length() > year1str.length()) {
                year2str = year2str.substring(0, year2str.length() - 1);
            }
            while (year1str.length() > year2str.length()) {
                year1str = year1str.substring(0, year1str.length() - 1);
            }
            switch (year1str.length()) {
                case 2: {
                    myYearUnit = "CE";
                    myYears = Integer.parseInt(year2str) - Integer.parseInt(year1str);
                    break;
                }
                case 3: {
                    myYearUnit = "DE";
                    myYears = Integer.parseInt(year2str) - Integer.parseInt(year1str);
                    break;
                }
                case 4: {
                    myYearUnit = "Y";
                    myYears = myYears + (Integer.parseInt(year2str) - Integer.parseInt(year1str));
                    break;
                }
            }
        }
        dateStr = dateStr + (myYears > 0 ? myYears + myYearUnit : "");
        dateStr = dateStr + (myMonths > 0 ? myMonths + "M" : "");
        dateStr = dateStr + (myDays > 0 ? myDays + "D" : "");
        timeStr = timeStr + (myHours > 0 ? myHours + "H" : "");
        timeStr = timeStr + (myMinutes > 0 ? myMinutes + "M" : "");
        timeStr = timeStr + (mySeconds > 0 ? mySeconds + "S" : "");
        return "P" + dateStr + (timeStr.length() > 0 ? "T" + timeStr : "");
    }

    private void findIntervals(JCas jcas) {
        ArrayList<Timex3Interval> newAnnotations = new ArrayList<Timex3Interval>();
        FSIterator iterTimex3 = jcas.getAnnotationIndex(Timex3.type).iterator();
        while (iterTimex3.hasNext()) {
            Calendar c;
            Calendar c2;
            Timex3Interval annotation = new Timex3Interval(jcas);
            Timex3 timex3 = (Timex3)((Object)iterTimex3.next());
            Pattern pDate = Pattern.compile("(?:BC)?(\\d\\d\\d\\d)(-(\\d+))?(-(\\d+))?(T(\\d+))?(:(\\d+))?(:(\\d+))?");
            Pattern pCentury = Pattern.compile("(\\d\\d)");
            Pattern pDecate = Pattern.compile("(\\d\\d\\d)");
            Pattern pQuarter = Pattern.compile("(\\d+)-Q([1-4])");
            Pattern pHalf = Pattern.compile("(\\d+)-H([1-2])");
            Pattern pSeason = Pattern.compile("(\\d+)-(SP|SU|FA|WI)");
            Pattern pWeek = Pattern.compile("(\\d+)-W(\\d+)");
            Pattern pWeekend = Pattern.compile("(\\d+)-W(\\d+)-WE");
            Pattern pTimeOfDay = Pattern.compile("(\\d+)-(\\d+)-(\\d+)T(AF|DT|MI|MO|EV|NI)");
            Matcher mDate = pDate.matcher(timex3.getTimexValue());
            Matcher mCentury = pCentury.matcher(timex3.getTimexValue());
            Matcher mDecade = pDecate.matcher(timex3.getTimexValue());
            Matcher mQuarter = pQuarter.matcher(timex3.getTimexValue());
            Matcher mHalf = pHalf.matcher(timex3.getTimexValue());
            Matcher mSeason = pSeason.matcher(timex3.getTimexValue());
            Matcher mWeek = pWeek.matcher(timex3.getTimexValue());
            Matcher mWeekend = pWeekend.matcher(timex3.getTimexValue());
            Matcher mTimeOfDay = pTimeOfDay.matcher(timex3.getTimexValue());
            boolean matchesDate = mDate.matches();
            boolean matchesCentury = mCentury.matches();
            boolean matchesDecade = mDecade.matches();
            boolean matchesQuarter = mQuarter.matches();
            boolean matchesHalf = mHalf.matches();
            boolean matchesSeason = mSeason.matches();
            boolean matchesWeek = mWeek.matches();
            boolean matchesWeekend = mWeekend.matches();
            boolean matchesTimeOfDay = mTimeOfDay.matches();
            String endYear = "UNDEF";
            String beginYear = "UNDEF";
            String beginMonth = "01";
            String endMonth = "12";
            String beginDay = "01";
            String endDay = "31";
            String beginHour = "00";
            String endHour = "23";
            String beginMinute = "00";
            String endMinute = "59";
            String beginSecond = "00";
            String endSecond = "59";
            if (matchesDate) {
                beginYear = endYear = mDate.group(1);
                if (mDate.group(3) != null) {
                    beginMonth = endMonth = mDate.group(3);
                    if (mDate.group(5) == null) {
                        c2 = Calendar.getInstance();
                        c2.set(Integer.parseInt(beginYear), Integer.parseInt(beginMonth) - 1, 1);
                        endDay = "" + c2.getActualMaximum(5);
                        beginDay = "01";
                    } else {
                        beginDay = endDay = mDate.group(5);
                        if (mDate.group(7) != null) {
                            beginHour = endHour = mDate.group(7);
                            if (mDate.group(9) != null) {
                                beginMinute = endMinute = mDate.group(9);
                                if (mDate.group(11) != null) {
                                    beginSecond = endSecond = mDate.group(11);
                                }
                            }
                        }
                    }
                }
            } else if (matchesCentury) {
                beginYear = mCentury.group(1) + "00";
                endYear = mCentury.group(1) + "99";
            } else if (matchesDecade) {
                beginYear = mDecade.group(1) + "0";
                endYear = mDecade.group(1) + "9";
            } else if (matchesQuarter) {
                beginYear = endYear = mQuarter.group(1);
                int beginMonthI = 3 * (Integer.parseInt(mQuarter.group(2)) - 1) + 1;
                beginMonth = "" + beginMonthI;
                endMonth = "" + (beginMonthI + 2);
                c = Calendar.getInstance();
                c.set(Integer.parseInt(beginYear), Integer.parseInt(endMonth) - 1, 1);
                endDay = "" + c.getActualMaximum(5);
            } else if (matchesHalf) {
                beginYear = endYear = mHalf.group(1);
                int beginMonthI = 6 * (Integer.parseInt(mHalf.group(2)) - 1) + 1;
                beginMonth = "" + beginMonthI;
                endMonth = "" + (beginMonthI + 5);
                c = Calendar.getInstance();
                c.set(Integer.parseInt(beginYear), Integer.parseInt(endMonth) - 1, 1);
                endDay = "" + c.getActualMaximum(5);
            } else if (matchesSeason) {
                endYear = beginYear = mSeason.group(1);
                if (mSeason.group(2).equals("SP")) {
                    beginMonth = "03";
                    beginDay = "21";
                    endMonth = "06";
                    endDay = "20";
                } else if (mSeason.group(2).equals("SU")) {
                    beginMonth = "06";
                    beginDay = "21";
                    endMonth = "09";
                    endDay = "22";
                } else if (mSeason.group(2).equals("FA")) {
                    beginMonth = "09";
                    beginDay = "23";
                    endMonth = "12";
                    endDay = "21";
                } else if (mSeason.group(2).equals("WI")) {
                    endYear = "" + (Integer.parseInt(beginYear) + 1);
                    beginMonth = "12";
                    beginDay = "22";
                    endMonth = "03";
                    endDay = "20";
                }
            } else if (matchesWeek) {
                beginYear = endYear = mWeek.group(1);
                c2 = Calendar.getInstance();
                c2.setFirstDayOfWeek(2);
                c2.set(1, Integer.parseInt(beginYear));
                c2.set(3, Integer.parseInt(mWeek.group(2)));
                c2.set(7, 2);
                beginDay = "" + c2.get(5);
                beginMonth = "" + (c2.get(2) + 1);
                c2.set(7, 1);
                endDay = "" + c2.get(5);
                endMonth = "" + (c2.get(2) + 1);
            } else if (matchesWeekend) {
                beginYear = endYear = mWeekend.group(1);
                c2 = Calendar.getInstance();
                c2.setFirstDayOfWeek(2);
                c2.set(1, Integer.parseInt(beginYear));
                c2.set(3, Integer.parseInt(mWeekend.group(2)));
                c2.set(7, 7);
                beginDay = "" + c2.get(5);
                beginMonth = "" + (c2.get(2) + 1);
                c2.set(7, 1);
                endDay = "" + c2.get(5);
                endMonth = "" + (c2.get(2) + 1);
            } else if (matchesTimeOfDay) {
                beginYear = endYear = mTimeOfDay.group(1);
                beginMonth = endMonth = mTimeOfDay.group(2);
                beginDay = endDay = mTimeOfDay.group(3);
            }
            if (Integer.parseInt(beginDay) < 10) {
                beginDay = "0" + Integer.parseInt(beginDay);
            }
            if (Integer.parseInt(beginMonth) < 10) {
                beginMonth = "0" + Integer.parseInt(beginMonth);
            }
            if (Integer.parseInt(endDay) < 10) {
                endDay = "0" + Integer.parseInt(endDay);
            }
            if (Integer.parseInt(endMonth) < 10) {
                endMonth = "0" + Integer.parseInt(endMonth);
            }
            if (beginYear.equals("UNDEF") || endYear.equals("UNDEF")) continue;
            annotation.setTimexValueEB(beginYear + "-" + beginMonth + "-" + beginDay + "T" + beginHour + ":" + beginMinute + ":" + beginSecond);
            annotation.setTimexValueLE(endYear + "-" + endMonth + "-" + endDay + "T" + endHour + ":" + endMinute + ":" + endSecond);
            annotation.setTimexValueLB(endYear + "-" + endMonth + "-" + endDay + "T" + endHour + ":" + endMinute + ":" + endSecond);
            annotation.setTimexValueEE(beginYear + "-" + beginMonth + "-" + beginDay + "T" + beginHour + ":" + beginMinute + ":" + beginSecond);
            annotation.setTimexFreq(timex3.getTimexFreq());
            annotation.setTimexId(timex3.getTimexId());
            annotation.setTimexInstance(timex3.getTimexInstance());
            annotation.setTimexMod(timex3.getTimexMod());
            annotation.setTimexQuant(timex3.getTimexMod());
            annotation.setTimexType(timex3.getTimexType());
            annotation.setTimexValue(timex3.getTimexValue());
            annotation.setSentId(timex3.getSentId());
            annotation.setBegin(timex3.getBegin());
            annotation.setFoundByRule(timex3.getFoundByRule());
            annotation.setEnd(timex3.getEnd());
            annotation.setAllTokIds(timex3.getAllTokIds());
            annotation.setFilename(timex3.getFilename());
            annotation.setBeginTimex(timex3.getTimexId());
            annotation.setEndTimex(timex3.getTimexId());
            newAnnotations.add(annotation);
        }
        for (Timex3Interval t3i : newAnnotations) {
            t3i.addToIndexes();
        }
    }
}

