/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime;

import de.unihd.dbs.uima.annotator.heideltime.ProcessorManager;
import de.unihd.dbs.uima.annotator.heideltime.processors.TemponymPostprocessing;
import de.unihd.dbs.uima.annotator.heideltime.resources.Language;
import de.unihd.dbs.uima.annotator.heideltime.resources.NormalizationManager;
import de.unihd.dbs.uima.annotator.heideltime.resources.RePatternManager;
import de.unihd.dbs.uima.annotator.heideltime.resources.RegexHashMap;
import de.unihd.dbs.uima.annotator.heideltime.resources.RuleManager;
import de.unihd.dbs.uima.annotator.heideltime.utilities.ContextAnalyzer;
import de.unihd.dbs.uima.annotator.heideltime.utilities.DateCalculator;
import de.unihd.dbs.uima.annotator.heideltime.utilities.LocaleException;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Toolbox;
import de.unihd.dbs.uima.types.heideltime.Dct;
import de.unihd.dbs.uima.types.heideltime.Sentence;
import de.unihd.dbs.uima.types.heideltime.Timex3;
import de.unihd.dbs.uima.types.heideltime.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class HeidelTime
extends JCasAnnotator_ImplBase {
    private Class<?> component = ((Object)((Object)this)).getClass();
    private ProcessorManager procMan = new ProcessorManager();
    public int timex_counter = 0;
    public int timex_counter_global = 0;
    public Boolean flagHistoricDates = false;
    private int timexID = 0;
    private String PARAM_LANGUAGE = "Language";
    private String PARAM_TYPE_TO_PROCESS = "Type";
    private String PARAM_LOCALE = "locale";
    private Language language = Language.ENGLISH;
    private String typeToProcess = "news";
    private String PARAM_DATE = "Date";
    private String PARAM_TIME = "Time";
    private String PARAM_DURATION = "Duration";
    private String PARAM_SET = "Set";
    private String PARAM_TEMPONYMS = "Temponym";
    private String PARAM_DEBUG = "Debugging";
    private String PARAM_GROUP = "ConvertDurations";
    private Boolean find_dates = true;
    private Boolean find_times = true;
    private Boolean find_durations = true;
    private Boolean find_sets = true;
    private Boolean find_temponyms = false;
    private Boolean group_gran = true;
    private Boolean deleteOverlapped = true;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.deleteOverlapped = true;
        Boolean doDebug = (Boolean)aContext.getConfigParameterValue(this.PARAM_DEBUG);
        Logger.setPrintDetails(doDebug == null ? false : doDebug);
        String requestedLocale = (String)aContext.getConfigParameterValue(this.PARAM_LOCALE);
        if (requestedLocale == null || requestedLocale.length() == 0) {
            Locale.setDefault(Locale.UK);
        } else {
            try {
                Locale locale = DateCalculator.getLocaleFromString(requestedLocale);
                Locale.setDefault(locale);
            }
            catch (LocaleException e) {
                Logger.printError("Supplied locale parameter couldn't be resolved to a working locale. Try one of these:");
                String localesString = new String();
                for (Locale l : Locale.getAvailableLocales()) {
                    localesString = localesString + l.toString() + " ";
                }
                Logger.printError(localesString);
                System.exit(-1);
            }
        }
        this.language = Language.getLanguageFromString((String)aContext.getConfigParameterValue(this.PARAM_LANGUAGE));
        this.typeToProcess = (String)aContext.getConfigParameterValue(this.PARAM_TYPE_TO_PROCESS);
        this.find_dates = (Boolean)aContext.getConfigParameterValue(this.PARAM_DATE);
        this.find_times = (Boolean)aContext.getConfigParameterValue(this.PARAM_TIME);
        this.find_durations = (Boolean)aContext.getConfigParameterValue(this.PARAM_DURATION);
        this.find_sets = (Boolean)aContext.getConfigParameterValue(this.PARAM_SET);
        this.find_temponyms = (Boolean)aContext.getConfigParameterValue(this.PARAM_TEMPONYMS);
        this.group_gran = (Boolean)aContext.getConfigParameterValue(this.PARAM_GROUP);
        NormalizationManager.getInstance(this.language, this.find_temponyms);
        RePatternManager.getInstance(this.language, this.find_temponyms);
        RuleManager.getInstance(this.language, this.find_temponyms);
        this.procMan.registerProcessor("de.unihd.dbs.uima.annotator.heideltime.processors.HolidayProcessor");
        this.procMan.registerProcessor("de.unihd.dbs.uima.annotator.heideltime.processors.DecadeProcessor");
        this.procMan.initializeAllProcessors(aContext);
        if (this.find_dates.booleanValue()) {
            Logger.printDetail("Getting Dates...");
        }
        if (this.find_times.booleanValue()) {
            Logger.printDetail("Getting Times...");
        }
        if (this.find_durations.booleanValue()) {
            Logger.printDetail("Getting Durations...");
        }
        if (this.find_sets.booleanValue()) {
            Logger.printDetail("Getting Sets...");
        }
        if (this.find_temponyms.booleanValue()) {
            Logger.printDetail("Getting Temponyms...");
        }
    }

    public void process(JCas jcas) {
        if (!this.isValidDCT(jcas).booleanValue()) {
            Logger.printError(this.component, "The reader component of this workflow has set an incorrect DCT. HeidelTime expects either \"YYYYMMDD\" or \"YYYY-MM-DD...\". This document was skipped.");
            return;
        }
        this.procMan.executeProcessors(jcas, ProcessorManager.Priority.PREPROCESSING);
        RuleManager rulem = RuleManager.getInstance(this.language, this.find_temponyms);
        this.timexID = 1;
        this.timex_counter = 0;
        this.flagHistoricDates = false;
        FSIterator sentIter = jcas.getAnnotationIndex(Sentence.type).iterator();
        if (!sentIter.hasNext()) {
            Logger.printError(this.component, "HeidelTime has not found any sentence tokens in this document. HeidelTime needs sentence tokens tagged by a preprocessing UIMA analysis engine to do its work. Please check your UIMA workflow and add an analysis engine that creates these sentence tokens.");
        }
        while (sentIter.hasNext()) {
            Sentence s = (Sentence)((Object)sentIter.next());
            Boolean debugIteration = false;
            Boolean oldDebugState = Logger.getPrintDetails();
            do {
                try {
                    if (this.find_dates.booleanValue()) {
                        this.findTimexes("DATE", rulem.getHmDatePattern(), rulem.getHmDateOffset(), rulem.getHmDateNormalization(), s, jcas);
                    }
                    if (this.find_times.booleanValue()) {
                        this.findTimexes("TIME", rulem.getHmTimePattern(), rulem.getHmTimeOffset(), rulem.getHmTimeNormalization(), s, jcas);
                    }
                    if (this.typeToProcess.equals("narrative") || this.typeToProcess.equals("narratives")) {
                        for (Timex3 t : jcas.getAnnotationIndex(Timex3.type)) {
                            if (!t.getTimexValue().startsWith("BC")) continue;
                            this.flagHistoricDates = true;
                            break;
                        }
                    }
                    if (this.find_sets.booleanValue()) {
                        this.findTimexes("SET", rulem.getHmSetPattern(), rulem.getHmSetOffset(), rulem.getHmSetNormalization(), s, jcas);
                    }
                    if (this.find_durations.booleanValue()) {
                        this.findTimexes("DURATION", rulem.getHmDurationPattern(), rulem.getHmDurationOffset(), rulem.getHmDurationNormalization(), s, jcas);
                    }
                    if (!this.find_temponyms.booleanValue()) continue;
                    this.findTimexes("TEMPONYM", rulem.getHmTemponymPattern(), rulem.getHmTemponymOffset(), rulem.getHmTemponymNormalization(), s, jcas);
                }
                catch (NullPointerException npe) {
                    if (!debugIteration.booleanValue()) {
                        debugIteration = true;
                        Logger.setPrintDetails(true);
                        Logger.printError(this.component, "HeidelTime's execution has been interrupted by an exception that is likely rooted in faulty normalization resource files. Please consider opening an issue report containing the following information at our GitHub project issue tracker: https://github.com/HeidelTime/heideltime/issues - Thanks!");
                        npe.printStackTrace();
                        Logger.printError(this.component, "Sentence [" + s.getBegin() + "-" + s.getEnd() + "]: " + s.getCoveredText());
                        Logger.printError(this.component, "Language: " + (Object)((Object)this.language));
                        Logger.printError(this.component, "Re-running this sentence with DEBUGGING enabled...");
                        continue;
                    }
                    debugIteration = false;
                    Logger.setPrintDetails(oldDebugState);
                    Logger.printError(this.component, "Execution will now resume.");
                }
            } while (debugIteration.booleanValue());
        }
        if (this.deleteOverlapped.booleanValue()) {
            this.deleteOverlappedTimexesPreprocessing(jcas);
        }
        this.specifyAmbiguousValues(jcas);
        if (this.flagHistoricDates.booleanValue()) {
            try {
                this.disambiguateHistoricDates(jcas);
            }
            catch (Exception e) {
                Logger.printError("Something went wrong disambiguating historic dates.");
                e.printStackTrace();
            }
        }
        if (this.find_temponyms.booleanValue()) {
            TemponymPostprocessing.handleIntervals(jcas);
        }
        if (this.deleteOverlapped.booleanValue()) {
            this.deleteOverlappedTimexesPostprocessing(jcas);
        }
        this.procMan.executeProcessors(jcas, ProcessorManager.Priority.ARBITRARY);
        this.removeInvalids(jcas);
        this.procMan.executeProcessors(jcas, ProcessorManager.Priority.POSTPROCESSING);
        this.timex_counter_global += this.timex_counter;
        Logger.printDetail(this.component, "Number of Timexes added to CAS: " + this.timex_counter + "(global: " + this.timex_counter_global + ")");
    }

    public void addTimexAnnotation(String timexType, int begin, int end, Sentence sentence, String timexValue, String timexQuant, String timexFreq, String timexMod, String emptyValue, String timexId, String foundByRule, JCas jcas) {
        Timex3 annotation = new Timex3(jcas);
        annotation.setBegin(begin);
        annotation.setEnd(end);
        annotation.setFilename(sentence.getFilename());
        annotation.setSentId(sentence.getSentenceId());
        annotation.setEmptyValue(emptyValue);
        FSIterator iterToken = jcas.getAnnotationIndex(Token.type).subiterator((AnnotationFS)sentence);
        String allTokIds = "";
        while (iterToken.hasNext()) {
            Token tok = (Token)((Object)iterToken.next());
            if (tok.getBegin() <= begin && tok.getEnd() > begin) {
                annotation.setFirstTokId(tok.getTokenId());
                allTokIds = "BEGIN<-->" + tok.getTokenId();
            }
            if (tok.getBegin() <= begin || tok.getEnd() > end) continue;
            allTokIds = allTokIds + "<-->" + tok.getTokenId();
        }
        annotation.setAllTokIds(allTokIds);
        annotation.setTimexType(timexType);
        annotation.setTimexValue(timexValue);
        annotation.setTimexId(timexId);
        annotation.setFoundByRule(foundByRule);
        if (timexType.equals("DATE") || timexType.equals("TIME")) {
            if (timexValue.startsWith("X") || timexValue.startsWith("UNDEF")) {
                annotation.setFoundByRule(foundByRule + "-relative");
            } else {
                annotation.setFoundByRule(foundByRule + "-explicit");
            }
        }
        if (timexQuant != null) {
            annotation.setTimexQuant(timexQuant);
        }
        if (timexFreq != null) {
            annotation.setTimexFreq(timexFreq);
        }
        if (timexMod != null) {
            annotation.setTimexMod(timexMod);
        }
        annotation.addToIndexes();
        ++this.timex_counter;
        Logger.printDetail(annotation.getTimexId() + "EXTRACTION PHASE:    found by:" + annotation.getFoundByRule() + " text:" + annotation.getCoveredText());
        Logger.printDetail(annotation.getTimexId() + "NORMALIZATION PHASE: found by:" + annotation.getFoundByRule() + " text:" + annotation.getCoveredText() + " value:" + annotation.getTimexValue());
    }

    public void disambiguateHistoricDates(JCas jcas) {
        ArrayList<Timex3> linearDates = new ArrayList<Timex3>();
        for (Timex3 timex : jcas.getAnnotationIndex(Timex3.type)) {
            if (!timex.getTimexType().equals("DATE") && !timex.getTimexType().equals("TIME")) continue;
            linearDates.add(timex);
        }
        for (int i = 1; i < linearDates.size(); ++i) {
            String value_i;
            Timex3 t_i = (Timex3)((Object)linearDates.get(i));
            String newValue = value_i = t_i.getTimexValue();
            Boolean change = false;
            if (!t_i.getFoundByRule().contains("-BCADhint") && value_i.startsWith("0")) {
                Integer offset = 1;
                Integer counter = 1;
                do {
                    if ((i == 1 || i > 1 && !change.booleanValue()) && ((Timex3)((Object)linearDates.get(i - offset))).getTimexValue().startsWith("BC") && value_i.length() > 1 && (((Timex3)((Object)linearDates.get(i - offset))).getTimexValue().startsWith("BC" + value_i.substring(0, 2)) || ((Timex3)((Object)linearDates.get(i - offset))).getTimexValue().startsWith("BC" + String.format("%02d", Integer.parseInt(value_i.substring(0, 2)) + 1)))) {
                        if (value_i.startsWith("00") && ((Timex3)((Object)linearDates.get(i - offset))).getTimexValue().startsWith("BC00") || value_i.startsWith("01") && ((Timex3)((Object)linearDates.get(i - offset))).getTimexValue().startsWith("BC01")) {
                            if (value_i.length() > 2 && ((Timex3)((Object)linearDates.get(i - offset))).getTimexValue().length() > 4 && Integer.parseInt(value_i.substring(0, 3)) <= Integer.parseInt(((Timex3)((Object)linearDates.get(i - offset))).getTimexValue().substring(2, 5))) {
                                newValue = "BC" + value_i;
                                change = true;
                                Logger.printDetail("DisambiguateHistoricDates: " + value_i + " to " + newValue + ". Expression " + t_i.getCoveredText() + " due to " + ((Timex3)((Object)linearDates.get(i - offset))).getCoveredText());
                            }
                        } else {
                            newValue = "BC" + value_i;
                            change = true;
                            Logger.printDetail("DisambiguateHistoricDates: " + value_i + " to " + newValue + ". Expression " + t_i.getCoveredText() + " due to " + ((Timex3)((Object)linearDates.get(i - offset))).getCoveredText());
                        }
                    }
                    if (!((Timex3)((Object)linearDates.get(i - offset))).getTimexType().equals("TIME") && !((Timex3)((Object)linearDates.get(i - offset))).getTimexType().equals("DATE") || !((Timex3)((Object)linearDates.get(i - offset))).getTimexValue().matches("^\\d.*")) continue;
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                } while (counter < 5 && (offset = Integer.valueOf(offset + 1)) < i);
            }
            if (newValue.equals(value_i)) continue;
            t_i.removeFromIndexes();
            Logger.printDetail("DisambiguateHistoricDates: value changed to BC");
            t_i.setTimexValue(newValue);
            t_i.addToIndexes();
            linearDates.set(i, t_i);
        }
    }

    public void removeInvalids(JCas jcas) {
        FSIterator iterTimex = jcas.getAnnotationIndex(Timex3.type).iterator();
        HashSet<Timex3> hsTimexToRemove = new HashSet<Timex3>();
        while (iterTimex.hasNext()) {
            Timex3 timex = (Timex3)((Object)iterTimex.next());
            if (!timex.getTimexValue().equals("REMOVE")) continue;
            hsTimexToRemove.add(timex);
        }
        for (Timex3 timex3 : hsTimexToRemove) {
            timex3.removeFromIndexes();
            --this.timex_counter;
            Logger.printDetail(timex3.getTimexId() + " REMOVING PHASE: found by:" + timex3.getFoundByRule() + " text:" + timex3.getCoveredText() + " value:" + timex3.getTimexValue());
        }
    }

    public String specifyAmbiguousValuesString(String ambigString, Timex3 t_i, Integer i, List<Timex3> linearDates, JCas jcas) {
        NormalizationManager norm = NormalizationManager.getInstance(this.language, this.find_temponyms);
        boolean dctAvailable = false;
        boolean documentTypeNews = false;
        boolean documentTypeNarrative = false;
        boolean documentTypeColloquial = false;
        boolean documentTypeScientific = false;
        if (this.typeToProcess.equals("news")) {
            documentTypeNews = true;
        }
        if (this.typeToProcess.equals("narrative") || this.typeToProcess.equals("narratives")) {
            documentTypeNarrative = true;
        }
        if (this.typeToProcess.equals("colloquial")) {
            documentTypeColloquial = true;
        }
        if (this.typeToProcess.equals("scientific")) {
            documentTypeScientific = true;
        }
        String dctValue = "";
        int dctCentury = 0;
        int dctYear = 0;
        int dctDecade = 0;
        int dctMonth = 0;
        int dctDay = 0;
        String dctSeason = "";
        String dctQuarter = "";
        String dctHalf = "";
        int dctWeekday = 0;
        int dctWeek = 0;
        FSIterator dctIter = jcas.getAnnotationIndex(Dct.type).iterator();
        if (dctIter.hasNext()) {
            dctAvailable = true;
            Dct dct = (Dct)((Object)dctIter.next());
            dctValue = dct.getValue();
            if (dctValue.matches("\\d\\d\\d\\d\\d\\d\\d\\d")) {
                dctCentury = Integer.parseInt(dctValue.substring(0, 2));
                dctYear = Integer.parseInt(dctValue.substring(0, 4));
                dctDecade = Integer.parseInt(dctValue.substring(2, 3));
                dctMonth = Integer.parseInt(dctValue.substring(4, 6));
                dctDay = Integer.parseInt(dctValue.substring(6, 8));
                Logger.printDetail("dctCentury:" + dctCentury);
                Logger.printDetail("dctYear:" + dctYear);
                Logger.printDetail("dctDecade:" + dctDecade);
                Logger.printDetail("dctMonth:" + dctMonth);
                Logger.printDetail("dctDay:" + dctDay);
            } else {
                dctCentury = Integer.parseInt(dctValue.substring(0, 2));
                dctYear = Integer.parseInt(dctValue.substring(0, 4));
                dctDecade = Integer.parseInt(dctValue.substring(2, 3));
                dctMonth = Integer.parseInt(dctValue.substring(5, 7));
                dctDay = Integer.parseInt(dctValue.substring(8, 10));
                Logger.printDetail("dctCentury:" + dctCentury);
                Logger.printDetail("dctYear:" + dctYear);
                Logger.printDetail("dctDecade:" + dctDecade);
                Logger.printDetail("dctMonth:" + dctMonth);
                Logger.printDetail("dctDay:" + dctDay);
            }
            dctQuarter = "Q" + norm.getFromNormMonthInQuarter(norm.getFromNormNumber(dctMonth + ""));
            dctHalf = "H1";
            if (dctMonth > 6) {
                dctHalf = "H2";
            }
            dctSeason = norm.getFromNormMonthInSeason(norm.getFromNormNumber(dctMonth + "") + "");
            dctWeekday = DateCalculator.getWeekdayOfDate(dctYear + "-" + norm.getFromNormNumber(dctMonth + "") + "-" + norm.getFromNormNumber(dctDay + ""));
            dctWeek = DateCalculator.getWeekOfDate(dctYear + "-" + norm.getFromNormNumber(dctMonth + "") + "-" + norm.getFromNormNumber(dctDay + ""));
            Logger.printDetail("dctQuarter:" + dctQuarter);
            Logger.printDetail("dctSeason:" + dctSeason);
            Logger.printDetail("dctWeekday:" + dctWeekday);
            Logger.printDetail("dctWeek:" + dctWeek);
        } else {
            Logger.printDetail("No DCT available...");
        }
        Boolean viHasMonth = false;
        Boolean viHasDay = false;
        Boolean viHasSeason = false;
        Boolean viHasWeek = false;
        Boolean viHasQuarter = false;
        Boolean viHasHalf = false;
        int viThisMonth = 0;
        int viThisDay = 0;
        String viThisSeason = "";
        String viThisQuarter = "";
        String viThisHalf = "";
        String[] valueParts = ambigString.split("-");
        if (ambigString.startsWith("UNDEF-year") || ambigString.startsWith("UNDEF-century")) {
            if (valueParts.length > 2) {
                if (valueParts[2].matches("\\d\\d")) {
                    viHasMonth = true;
                    viThisMonth = Integer.parseInt(valueParts[2]);
                } else if (valueParts[2].equals("SP") || valueParts[2].equals("SU") || valueParts[2].equals("FA") || valueParts[2].equals("WI")) {
                    viHasSeason = true;
                    viThisSeason = valueParts[2];
                } else if (valueParts[2].equals("Q1") || valueParts[2].equals("Q2") || valueParts[2].equals("Q3") || valueParts[2].equals("Q4")) {
                    viHasQuarter = true;
                    viThisQuarter = valueParts[2];
                } else if (valueParts[2].equals("H1") || valueParts[2].equals("H2")) {
                    viHasHalf = true;
                    viThisHalf = valueParts[2];
                }
                if (valueParts.length > 3 && valueParts[3].matches("\\d\\d")) {
                    viHasDay = true;
                    viThisDay = Integer.parseInt(valueParts[3]);
                }
            }
        } else if (valueParts.length > 1) {
            if (valueParts[1].matches("\\d\\d")) {
                viHasMonth = true;
                viThisMonth = Integer.parseInt(valueParts[1]);
            } else if (valueParts[1].equals("SP") || valueParts[1].equals("SU") || valueParts[1].equals("FA") || valueParts[1].equals("WI")) {
                viHasSeason = true;
                viThisSeason = valueParts[1];
            } else if (valueParts[1].equals("Q1") || valueParts[1].equals("Q2") || valueParts[1].equals("Q3") || valueParts[1].equals("Q4")) {
                viHasQuarter = true;
                viThisQuarter = valueParts[1];
            } else if (valueParts[1].equals("H1") || valueParts[1].equals("H2")) {
                viHasHalf = true;
                viThisHalf = valueParts[1];
            }
            if (valueParts.length > 2 && valueParts[2].matches("\\d\\d")) {
                viHasDay = true;
                viThisDay = Integer.parseInt(valueParts[2]);
            }
        }
        String last_used_tense = ContextAnalyzer.getLastTense(t_i, jcas, this.language);
        String valueNew = ambigString;
        if (ambigString.startsWith("UNDEF-year")) {
            int intNewYear;
            String newYearValue = dctYear + "";
            if (viHasMonth.booleanValue() && !viHasSeason.booleanValue()) {
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    if ((last_used_tense.equals("FUTURE") || last_used_tense.equals("PRESENTFUTURE")) && dctMonth > viThisMonth) {
                        intNewYear = dctYear + 1;
                        newYearValue = intNewYear + "";
                    }
                    if (last_used_tense.equals("PAST") && dctMonth < viThisMonth) {
                        intNewYear = dctYear - 1;
                        newYearValue = intNewYear + "";
                    }
                } else {
                    newYearValue = ContextAnalyzer.getLastMentionedX(linearDates, i, "year", this.language);
                }
            }
            if (viHasQuarter.booleanValue()) {
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    if ((last_used_tense.equals("FUTURE") || last_used_tense.equals("PRESENTFUTURE")) && Integer.parseInt(dctQuarter.substring(1)) < Integer.parseInt(viThisQuarter.substring(1))) {
                        intNewYear = dctYear + 1;
                        newYearValue = intNewYear + "";
                    }
                    if (last_used_tense.equals("PAST") && Integer.parseInt(dctQuarter.substring(1)) < Integer.parseInt(viThisQuarter.substring(1))) {
                        intNewYear = dctYear - 1;
                        newYearValue = intNewYear + "";
                    }
                    if (last_used_tense.equals("")) {
                        if (documentTypeColloquial) {
                            if (Integer.parseInt(dctQuarter.substring(1)) < Integer.parseInt(viThisQuarter.substring(1))) {
                                intNewYear = dctYear + 1;
                                newYearValue = intNewYear + "";
                            }
                        } else if (Integer.parseInt(dctQuarter.substring(1)) < Integer.parseInt(viThisQuarter.substring(1))) {
                            intNewYear = dctYear - 1;
                            newYearValue = intNewYear + "";
                        }
                    }
                } else {
                    newYearValue = ContextAnalyzer.getLastMentionedX(linearDates, i, "year", this.language);
                }
            }
            if (viHasHalf.booleanValue()) {
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    if ((last_used_tense.equals("FUTURE") || last_used_tense.equals("PRESENTFUTURE")) && Integer.parseInt(dctHalf.substring(1)) < Integer.parseInt(viThisHalf.substring(1))) {
                        intNewYear = dctYear + 1;
                        newYearValue = intNewYear + "";
                    }
                    if (last_used_tense.equals("PAST") && Integer.parseInt(dctHalf.substring(1)) < Integer.parseInt(viThisHalf.substring(1))) {
                        intNewYear = dctYear - 1;
                        newYearValue = intNewYear + "";
                    }
                    if (last_used_tense.equals("")) {
                        if (documentTypeColloquial) {
                            if (Integer.parseInt(dctHalf.substring(1)) < Integer.parseInt(viThisHalf.substring(1))) {
                                intNewYear = dctYear + 1;
                                newYearValue = intNewYear + "";
                            }
                        } else if (Integer.parseInt(dctHalf.substring(1)) < Integer.parseInt(viThisHalf.substring(1))) {
                            intNewYear = dctYear - 1;
                            newYearValue = intNewYear + "";
                        }
                    }
                } else {
                    newYearValue = ContextAnalyzer.getLastMentionedX(linearDates, i, "year", this.language);
                }
            }
            if (!viHasMonth.booleanValue() && !viHasDay.booleanValue() && viHasSeason.booleanValue()) {
                newYearValue = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? dctYear + "" : ContextAnalyzer.getLastMentionedX(linearDates, i, "year", this.language);
            }
            if (viHasWeek.booleanValue()) {
                newYearValue = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? dctYear + "" : ContextAnalyzer.getLastMentionedX(linearDates, i, "year", this.language);
            }
            valueNew = newYearValue.equals("") ? ambigString.replaceFirst("UNDEF-year", "XXXX") : ambigString.replaceFirst("UNDEF-year", newYearValue);
        } else if (ambigString.startsWith("UNDEF-century")) {
            String newCenturyValue = dctCentury + "";
            if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable && !ambigString.equals("UNDEF-century")) {
                int viThisDecade = Integer.parseInt(ambigString.substring(13, 14));
                Logger.printDetail("dctCentury" + dctCentury);
                newCenturyValue = dctCentury + "";
                Logger.printDetail("dctCentury" + dctCentury);
                if (last_used_tense.equals("FUTURE") || last_used_tense.equals("PRESENTFUTURE")) {
                    newCenturyValue = viThisDecade < dctDecade ? dctCentury + 1 + "" : dctCentury + "";
                }
                if (last_used_tense.equals("PAST")) {
                    newCenturyValue = dctDecade < viThisDecade ? dctCentury - 1 + "" : dctCentury + "";
                }
            } else {
                newCenturyValue = ContextAnalyzer.getLastMentionedX(linearDates, i, "century", this.language);
                if (!newCenturyValue.startsWith("BC")) {
                    if (newCenturyValue.matches("^\\d\\d.*") && Integer.parseInt(newCenturyValue.substring(0, 2)) < 10) {
                        newCenturyValue = "00";
                    }
                } else {
                    newCenturyValue = "00";
                }
            }
            valueNew = newCenturyValue.equals("") ? (!documentTypeNarrative ? ambigString.replaceFirst("UNDEF-century", "19") : ambigString.replaceFirst("UNDEF-century", "00")) : ambigString.replaceFirst("UNDEF-century", newCenturyValue);
            if (valueNew.matches("\\d\\d\\d") && !documentTypeNarrative) {
                valueNew = "19" + valueNew.substring(2);
            }
        } else if (ambigString.startsWith("UNDEF")) {
            valueNew = ambigString;
            if (ambigString.matches("^UNDEF-REFDATE$")) {
                if (i > 0) {
                    String lmDate;
                    Timex3 anyDate = linearDates.get(i - 1);
                    valueNew = lmDate = anyDate.getTimexValue();
                } else {
                    valueNew = "XXXX-XX-XX";
                }
            } else if (ambigString.matches("^UNDEF-(this|REFUNIT|REF)-(.*?)-(MINUS|PLUS)-([0-9]+).*")) {
                for (MatchResult mr : Toolbox.findMatches(Pattern.compile("^(UNDEF-(this|REFUNIT|REF)-(.*?)-(MINUS|PLUS)-([0-9]+)).*"), ambigString)) {
                    String checkUndef = mr.group(1);
                    String ltn = mr.group(2);
                    String unit = mr.group(3);
                    String op = mr.group(4);
                    String sDiff = mr.group(5);
                    int diff = 0;
                    try {
                        diff = Integer.parseInt(sDiff);
                    }
                    catch (Exception e) {
                        Logger.printError(this.component, "Expression difficult to normalize: ");
                        Logger.printError(this.component, ambigString);
                        Logger.printError(this.component, sDiff + " probably too long for parsing as integer.");
                        Logger.printError(this.component, "set normalized value as PAST_REF / FUTURE_REF:");
                        valueNew = op.equals("PLUS") ? "FUTURE_REF" : "PAST_REF";
                        break;
                    }
                    if (documentTypeScientific) {
                        String opSymbol = "-";
                        if (op.equals("PLUS")) {
                            opSymbol = "+";
                        }
                        if (unit.equals("year")) {
                            String diffString = diff + "";
                            if (diff < 10) {
                                diffString = "000" + diff;
                            } else if (diff < 100) {
                                diffString = "00" + diff;
                            } else if (diff < 1000) {
                                diffString = "0" + diff;
                            }
                            valueNew = "TPZ" + opSymbol + diffString;
                            continue;
                        }
                        if (unit.equals("month")) {
                            String diffString = diff + "";
                            diffString = diff < 10 ? "0000-0" + diff : "0000-" + diff;
                            valueNew = "TPZ" + opSymbol + diffString;
                            continue;
                        }
                        if (unit.equals("week")) {
                            String diffString = diff + "";
                            diffString = diff < 10 ? "0000-W0" + diff : "0000-W" + diff;
                            valueNew = "TPZ" + opSymbol + diffString;
                            continue;
                        }
                        if (unit.equals("day")) {
                            String diffString = diff + "";
                            diffString = diff < 10 ? "0000-00-0" + diff : "0000-00-" + diff;
                            valueNew = "TPZ" + opSymbol + diffString;
                            continue;
                        }
                        if (unit.equals("hour")) {
                            String diffString = diff + "";
                            diffString = diff < 10 ? "0000-00-00T0" + diff : "0000-00-00T" + diff;
                            valueNew = "TPZ" + opSymbol + diffString;
                            continue;
                        }
                        if (unit.equals("minute")) {
                            String diffString = diff + "";
                            diffString = diff < 10 ? "0000-00-00T00:0" + diff : "0000-00-00T00:" + diff;
                            valueNew = "TPZ" + opSymbol + diffString;
                            continue;
                        }
                        if (!unit.equals("second")) continue;
                        String diffString = diff + "";
                        diffString = diff < 10 ? "0000-00-00T00:00:0" + diff : "0000-00-00T00:00:" + diff;
                        valueNew = "TPZ" + opSymbol + diffString;
                        continue;
                    }
                    if (ltn.equals("REFUNIT") && unit.equals("year")) {
                        String dateWithYear;
                        String year = dateWithYear = ContextAnalyzer.getLastMentionedX(linearDates, i, "dateYear", this.language);
                        if (dateWithYear.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX");
                        } else {
                            year = dateWithYear.startsWith("BC") ? dateWithYear.substring(0, 6) : dateWithYear.substring(0, 4);
                            if (op.equals("MINUS")) {
                                diff *= -1;
                            }
                            String yearNew = DateCalculator.getXNextYear(dateWithYear, diff);
                            String rest = dateWithYear.substring(4);
                            valueNew = valueNew.replace(checkUndef, yearNew + rest);
                        }
                    }
                    if (unit.equals("century")) {
                        if ((documentTypeNews | documentTypeColloquial || documentTypeScientific) && dctAvailable && ltn.equals("this")) {
                            int century = dctCentury;
                            if (op.equals("MINUS")) {
                                century = dctCentury - diff;
                            } else if (op.equals("PLUS")) {
                                century = dctCentury + diff;
                            }
                            valueNew = valueNew.replace(checkUndef, century + "");
                            continue;
                        }
                        String lmCentury = ContextAnalyzer.getLastMentionedX(linearDates, i, "century", this.language);
                        if (lmCentury.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XX");
                            continue;
                        }
                        if (op.equals("MINUS")) {
                            diff = -1 * diff;
                        }
                        lmCentury = DateCalculator.getXNextCentury(lmCentury, diff);
                        valueNew = valueNew.replace(checkUndef, lmCentury);
                        continue;
                    }
                    if (unit.equals("decade")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable && ltn.equals("this")) {
                            int dctDecadeLong;
                            int decade = dctDecadeLong = Integer.parseInt(dctCentury + "" + dctDecade);
                            if (op.equals("MINUS")) {
                                decade = dctDecadeLong - diff;
                            } else if (op.equals("PLUS")) {
                                decade = dctDecadeLong + diff;
                            }
                            valueNew = valueNew.replace(checkUndef, decade + "X");
                            continue;
                        }
                        String lmDecade = ContextAnalyzer.getLastMentionedX(linearDates, i, "decade", this.language);
                        if (lmDecade.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXX");
                            continue;
                        }
                        if (op.equals("MINUS")) {
                            diff = -1 * diff;
                        }
                        lmDecade = DateCalculator.getXNextDecade(lmDecade, diff);
                        valueNew = valueNew.replace(checkUndef, lmDecade);
                        continue;
                    }
                    if (unit.equals("year")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable && ltn.equals("this")) {
                            int intValue = dctYear;
                            if (op.equals("MINUS")) {
                                intValue = dctYear - diff;
                            } else if (op.equals("PLUS")) {
                                intValue = dctYear + diff;
                            }
                            valueNew = valueNew.replace(checkUndef, intValue + "");
                            continue;
                        }
                        String lmYear = ContextAnalyzer.getLastMentionedX(linearDates, i, "year", this.language);
                        if (lmYear.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX");
                            continue;
                        }
                        if (op.equals("MINUS")) {
                            diff = -1 * diff;
                        }
                        lmYear = DateCalculator.getXNextYear(lmYear, diff);
                        valueNew = valueNew.replace(checkUndef, lmYear);
                        continue;
                    }
                    if (unit.equals("quarter")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable && ltn.equals("this")) {
                            int intYear = dctYear;
                            int intQuarter = Integer.parseInt(dctQuarter.substring(1));
                            int diffQuarters = diff % 4;
                            int diffYears = (diff -= diffQuarters) / 4;
                            if (op.equals("MINUS")) {
                                diffQuarters *= -1;
                                diffYears *= -1;
                            }
                            valueNew = valueNew.replace(checkUndef, (intYear += diffYears) + "-Q" + (intQuarter += diffQuarters));
                            continue;
                        }
                        String lmQuarter = ContextAnalyzer.getLastMentionedX(linearDates, i, "quarter", this.language);
                        if (lmQuarter.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX-XX");
                            continue;
                        }
                        int intYear = Integer.parseInt(lmQuarter.substring(0, 4));
                        int intQuarter = Integer.parseInt(lmQuarter.substring(6));
                        int diffQuarters = diff % 4;
                        int diffYears = (diff -= diffQuarters) / 4;
                        if (op.equals("MINUS")) {
                            diffQuarters *= -1;
                            diffYears *= -1;
                        }
                        valueNew = valueNew.replace(checkUndef, (intYear += diffYears) + "-Q" + (intQuarter += diffQuarters));
                        continue;
                    }
                    if (unit.equals("month")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable && ltn.equals("this")) {
                            if (op.equals("MINUS")) {
                                diff *= -1;
                            }
                            valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextMonth(dctYear + "-" + norm.getFromNormNumber(dctMonth + ""), diff));
                            continue;
                        }
                        String lmMonth = ContextAnalyzer.getLastMentionedX(linearDates, i, "month", this.language);
                        if (lmMonth.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX-XX");
                            continue;
                        }
                        if (op.equals("MINUS")) {
                            diff *= -1;
                        }
                        valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextMonth(lmMonth, diff));
                        continue;
                    }
                    if (unit.equals("week")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable && ltn.equals("this")) {
                            if (op.equals("MINUS")) {
                                diff *= -1;
                            } else if (op.equals("PLUS")) {
                                // empty if block
                            }
                            valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextWeek(dctYear + "-W" + norm.getFromNormNumber(dctWeek + ""), diff, this.language));
                            continue;
                        }
                        String lmDay = ContextAnalyzer.getLastMentionedX(linearDates, i, "day", this.language);
                        if (lmDay.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX-XX-XX");
                            continue;
                        }
                        if (op.equals("MINUS")) {
                            diff = diff * 7 * -1;
                        } else if (op.equals("PLUS")) {
                            diff *= 7;
                        }
                        valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(lmDay, diff));
                        continue;
                    }
                    if (!unit.equals("day")) continue;
                    if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable && ltn.equals("this")) {
                        if (op.equals("MINUS")) {
                            diff *= -1;
                        }
                        valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(dctYear + "-" + norm.getFromNormNumber(dctMonth + "") + "-" + dctDay, diff));
                        continue;
                    }
                    String lmDay = ContextAnalyzer.getLastMentionedX(linearDates, i, "day", this.language);
                    if (lmDay.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XXXX-XX-XX");
                        continue;
                    }
                    if (op.equals("MINUS")) {
                        diff *= -1;
                    }
                    valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(lmDay, diff));
                }
            } else if (ambigString.startsWith("UNDEF-last-century")) {
                String checkUndef = "UNDEF-last-century";
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    valueNew = valueNew.replace(checkUndef, norm.getFromNormNumber(dctCentury - 1 + ""));
                } else {
                    String lmCentury = ContextAnalyzer.getLastMentionedX(linearDates, i, "century", this.language);
                    if (lmCentury.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XX");
                    } else {
                        lmCentury = DateCalculator.getXNextCentury(lmCentury, -1);
                        valueNew = valueNew.replace(checkUndef, lmCentury);
                    }
                }
            } else if (ambigString.startsWith("UNDEF-this-century")) {
                String lmCentury;
                String checkUndef = "UNDEF-this-century";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, norm.getFromNormNumber(dctCentury + "")) : ((lmCentury = ContextAnalyzer.getLastMentionedX(linearDates, i, "century", this.language)).equals("") ? valueNew.replace(checkUndef, "XX") : valueNew.replace(checkUndef, lmCentury));
            } else if (ambigString.startsWith("UNDEF-next-century")) {
                String checkUndef = "UNDEF-next-century";
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    valueNew = valueNew.replace(checkUndef, norm.getFromNormNumber(dctCentury + 1 + ""));
                } else {
                    String lmCentury = ContextAnalyzer.getLastMentionedX(linearDates, i, "century", this.language);
                    if (lmCentury.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XX");
                    } else {
                        lmCentury = DateCalculator.getXNextCentury(lmCentury, 1);
                        valueNew = valueNew.replace(checkUndef, lmCentury);
                    }
                }
            } else if (ambigString.startsWith("UNDEF-last-decade")) {
                String checkUndef = "UNDEF-last-decade";
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    valueNew = valueNew.replace(checkUndef, (dctYear - 10 + "").substring(0, 3));
                } else {
                    String lmDecade = ContextAnalyzer.getLastMentionedX(linearDates, i, "decade", this.language);
                    if (lmDecade.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XXXX");
                    } else {
                        lmDecade = DateCalculator.getXNextDecade(lmDecade, -1);
                        valueNew = valueNew.replace(checkUndef, lmDecade);
                    }
                }
            } else if (ambigString.startsWith("UNDEF-this-decade")) {
                String lmDecade;
                String checkUndef = "UNDEF-this-decade";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, (dctYear + "").substring(0, 3)) : ((lmDecade = ContextAnalyzer.getLastMentionedX(linearDates, i, "decade", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX") : valueNew.replace(checkUndef, lmDecade));
            } else if (ambigString.startsWith("UNDEF-next-decade")) {
                String checkUndef = "UNDEF-next-decade";
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    valueNew = valueNew.replace(checkUndef, (dctYear + 10 + "").substring(0, 3));
                } else {
                    String lmDecade = ContextAnalyzer.getLastMentionedX(linearDates, i, "decade", this.language);
                    if (lmDecade.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XXXX");
                    } else {
                        lmDecade = DateCalculator.getXNextDecade(lmDecade, 1);
                        valueNew = valueNew.replace(checkUndef, lmDecade);
                    }
                }
            } else if (ambigString.startsWith("UNDEF-last-year")) {
                String checkUndef = "UNDEF-last-year";
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    valueNew = valueNew.replace(checkUndef, dctYear - 1 + "");
                } else {
                    String lmYear = ContextAnalyzer.getLastMentionedX(linearDates, i, "year", this.language);
                    if (lmYear.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XXXX");
                    } else {
                        lmYear = DateCalculator.getXNextYear(lmYear, -1);
                        valueNew = valueNew.replace(checkUndef, lmYear);
                    }
                }
                if (valueNew.endsWith("-FY")) {
                    valueNew = "FY" + valueNew.substring(0, Math.min(valueNew.length(), 4));
                }
            } else if (ambigString.startsWith("UNDEF-this-year")) {
                String lmYear;
                String checkUndef = "UNDEF-this-year";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, dctYear + "") : ((lmYear = ContextAnalyzer.getLastMentionedX(linearDates, i, "year", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX") : valueNew.replace(checkUndef, lmYear));
                if (valueNew.endsWith("-FY")) {
                    valueNew = "FY" + valueNew.substring(0, Math.min(valueNew.length(), 4));
                }
            } else if (ambigString.startsWith("UNDEF-next-year")) {
                String checkUndef = "UNDEF-next-year";
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    valueNew = valueNew.replace(checkUndef, dctYear + 1 + "");
                } else {
                    String lmYear = ContextAnalyzer.getLastMentionedX(linearDates, i, "year", this.language);
                    if (lmYear.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XXXX");
                    } else {
                        lmYear = DateCalculator.getXNextYear(lmYear, 1);
                        valueNew = valueNew.replace(checkUndef, lmYear);
                    }
                }
                if (valueNew.endsWith("-FY")) {
                    valueNew = "FY" + valueNew.substring(0, Math.min(valueNew.length(), 4));
                }
            } else if (ambigString.startsWith("UNDEF-last-month")) {
                String lmMonth;
                String checkUndef = "UNDEF-last-month";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, DateCalculator.getXNextMonth(dctYear + "-" + norm.getFromNormNumber(dctMonth + ""), -1)) : ((lmMonth = ContextAnalyzer.getLastMentionedX(linearDates, i, "month", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX-XX") : valueNew.replace(checkUndef, DateCalculator.getXNextMonth(lmMonth, -1)));
            } else if (ambigString.startsWith("UNDEF-this-month")) {
                String lmMonth;
                String checkUndef = "UNDEF-this-month";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, dctYear + "-" + norm.getFromNormNumber(dctMonth + "")) : ((lmMonth = ContextAnalyzer.getLastMentionedX(linearDates, i, "month", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX-XX") : valueNew.replace(checkUndef, lmMonth));
            } else if (ambigString.startsWith("UNDEF-next-month")) {
                String lmMonth;
                String checkUndef = "UNDEF-next-month";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, DateCalculator.getXNextMonth(dctYear + "-" + norm.getFromNormNumber(dctMonth + ""), 1)) : ((lmMonth = ContextAnalyzer.getLastMentionedX(linearDates, i, "month", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX-XX") : valueNew.replace(checkUndef, DateCalculator.getXNextMonth(lmMonth, 1)));
            } else if (ambigString.startsWith("UNDEF-last-day")) {
                String lmDay;
                String checkUndef = "UNDEF-last-day";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, DateCalculator.getXNextDay(dctYear + "-" + norm.getFromNormNumber(dctMonth + "") + "-" + dctDay, -1)) : ((lmDay = ContextAnalyzer.getLastMentionedX(linearDates, i, "day", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX-XX-XX") : valueNew.replace(checkUndef, DateCalculator.getXNextDay(lmDay, -1)));
            } else if (ambigString.startsWith("UNDEF-this-day")) {
                String checkUndef = "UNDEF-this-day";
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    valueNew = valueNew.replace(checkUndef, dctYear + "-" + norm.getFromNormNumber(dctMonth + "") + "-" + norm.getFromNormNumber(dctDay + ""));
                } else {
                    String lmDay = ContextAnalyzer.getLastMentionedX(linearDates, i, "day", this.language);
                    valueNew = lmDay.equals("") ? valueNew.replace(checkUndef, "XXXX-XX-XX") : valueNew.replace(checkUndef, lmDay);
                    if (ambigString.equals("UNDEF-this-day")) {
                        valueNew = "PRESENT_REF";
                    }
                }
            } else if (ambigString.startsWith("UNDEF-next-day")) {
                String lmDay;
                String checkUndef = "UNDEF-next-day";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, DateCalculator.getXNextDay(dctYear + "-" + norm.getFromNormNumber(dctMonth + "") + "-" + dctDay, 1)) : ((lmDay = ContextAnalyzer.getLastMentionedX(linearDates, i, "day", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX-XX-XX") : valueNew.replace(checkUndef, DateCalculator.getXNextDay(lmDay, 1)));
            } else if (ambigString.startsWith("UNDEF-last-week")) {
                String lmWeek;
                String checkUndef = "UNDEF-last-week";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, DateCalculator.getXNextWeek(dctYear + "-W" + norm.getFromNormNumber(dctWeek + ""), -1, this.language)) : ((lmWeek = ContextAnalyzer.getLastMentionedX(linearDates, i, "week", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX-WXX") : valueNew.replace(checkUndef, DateCalculator.getXNextWeek(lmWeek, -1, this.language)));
            } else if (ambigString.startsWith("UNDEF-this-week")) {
                String lmWeek;
                String checkUndef = "UNDEF-this-week";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, dctYear + "-W" + norm.getFromNormNumber(dctWeek + "")) : ((lmWeek = ContextAnalyzer.getLastMentionedX(linearDates, i, "week", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX-WXX") : valueNew.replace(checkUndef, lmWeek));
            } else if (ambigString.startsWith("UNDEF-next-week")) {
                String lmWeek;
                String checkUndef = "UNDEF-next-week";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, DateCalculator.getXNextWeek(dctYear + "-W" + norm.getFromNormNumber(dctWeek + ""), 1, this.language)) : ((lmWeek = ContextAnalyzer.getLastMentionedX(linearDates, i, "week", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX-WXX") : valueNew.replace(checkUndef, DateCalculator.getXNextWeek(lmWeek, 1, this.language)));
            } else if (ambigString.startsWith("UNDEF-last-quarter")) {
                String checkUndef = "UNDEF-last-quarter";
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    if (dctQuarter.equals("Q1")) {
                        valueNew = valueNew.replace(checkUndef, dctYear - 1 + "-Q4");
                    } else {
                        int newQuarter = Integer.parseInt(dctQuarter.substring(1, 2)) - 1;
                        valueNew = valueNew.replace(checkUndef, dctYear + "-Q" + newQuarter);
                    }
                } else {
                    String lmQuarter = ContextAnalyzer.getLastMentionedX(linearDates, i, "quarter", this.language);
                    if (lmQuarter.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XXXX-QX");
                    } else {
                        int lmQuarterOnly = Integer.parseInt(lmQuarter.substring(6, 7));
                        int lmYearOnly = Integer.parseInt(lmQuarter.substring(0, 4));
                        if (lmQuarterOnly == 1) {
                            valueNew = valueNew.replace(checkUndef, lmYearOnly - 1 + "-Q4");
                        } else {
                            int newQuarter = lmQuarterOnly - 1;
                            valueNew = valueNew.replace(checkUndef, lmYearOnly + "-Q" + newQuarter);
                        }
                    }
                }
            } else if (ambigString.startsWith("UNDEF-this-quarter")) {
                String lmQuarter;
                String checkUndef = "UNDEF-this-quarter";
                valueNew = (documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable ? valueNew.replace(checkUndef, dctYear + "-" + dctQuarter) : ((lmQuarter = ContextAnalyzer.getLastMentionedX(linearDates, i, "quarter", this.language)).equals("") ? valueNew.replace(checkUndef, "XXXX-QX") : valueNew.replace(checkUndef, lmQuarter));
            } else if (ambigString.startsWith("UNDEF-next-quarter")) {
                String checkUndef = "UNDEF-next-quarter";
                if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                    if (dctQuarter.equals("Q4")) {
                        valueNew = valueNew.replace(checkUndef, dctYear + 1 + "-Q1");
                    } else {
                        int newQuarter = Integer.parseInt(dctQuarter.substring(1, 2)) + 1;
                        valueNew = valueNew.replace(checkUndef, dctYear + "-Q" + newQuarter);
                    }
                } else {
                    String lmQuarter = ContextAnalyzer.getLastMentionedX(linearDates, i, "quarter", this.language);
                    if (lmQuarter.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XXXX-QX");
                    } else {
                        int lmQuarterOnly = Integer.parseInt(lmQuarter.substring(6, 7));
                        int lmYearOnly = Integer.parseInt(lmQuarter.substring(0, 4));
                        if (lmQuarterOnly == 4) {
                            valueNew = valueNew.replace(checkUndef, lmYearOnly + 1 + "-Q1");
                        } else {
                            int newQuarter = lmQuarterOnly + 1;
                            valueNew = valueNew.replace(checkUndef, lmYearOnly + "-Q" + newQuarter);
                        }
                    }
                }
            } else if (ambigString.matches("UNDEF-(last|this|next)-(january|february|march|april|may|june|july|august|september|october|november|december).*")) {
                for (MatchResult mr : Toolbox.findMatches(Pattern.compile("(UNDEF-(last|this|next)-(january|february|march|april|may|june|july|august|september|october|november|december))(.*)"), ambigString)) {
                    int lmMonthInt;
                    String lmMonth;
                    String rest = mr.group(4);
                    int day = 0;
                    for (MatchResult mr_rest : Toolbox.findMatches(Pattern.compile("-([0-9][0-9])"), rest)) {
                        day = Integer.parseInt(mr_rest.group(1));
                    }
                    String checkUndef = mr.group(1);
                    String ltn = mr.group(2);
                    String newMonth = norm.getFromNormMonthName(mr.group(3));
                    int newMonthInt = Integer.parseInt(newMonth);
                    if (ltn.equals("last")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                            if (dctMonth == newMonthInt && day != 0) {
                                if (dctDay > day) {
                                    valueNew = valueNew.replace(checkUndef, dctYear + "-" + newMonth);
                                    continue;
                                }
                                valueNew = valueNew.replace(checkUndef, dctYear - 1 + "-" + newMonth);
                                continue;
                            }
                            if (dctMonth <= newMonthInt) {
                                valueNew = valueNew.replace(checkUndef, dctYear - 1 + "-" + newMonth);
                                continue;
                            }
                            valueNew = valueNew.replace(checkUndef, dctYear + "-" + newMonth);
                            continue;
                        }
                        lmMonth = ContextAnalyzer.getLastMentionedX(linearDates, i, "month-with-details", this.language);
                        if (lmMonth.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX-XX");
                            continue;
                        }
                        lmMonthInt = Integer.parseInt(lmMonth.substring(5, 7));
                        int lmDayInt = 0;
                        if (lmMonth.length() > 9 && lmMonth.subSequence(8, 10).toString().matches("\\d\\d")) {
                            lmDayInt = Integer.parseInt(lmMonth.subSequence(8, 10) + "");
                        }
                        if (lmMonthInt == newMonthInt && lmDayInt != 0 && day != 0) {
                            valueNew = lmDayInt > day ? valueNew.replace(checkUndef, lmMonth.substring(0, 4) + "-" + newMonth) : valueNew.replace(checkUndef, Integer.parseInt(lmMonth.substring(0, 4)) - 1 + "-" + newMonth);
                        }
                        if (lmMonthInt <= newMonthInt) {
                            valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmMonth.substring(0, 4)) - 1 + "-" + newMonth);
                            continue;
                        }
                        valueNew = valueNew.replace(checkUndef, lmMonth.substring(0, 4) + "-" + newMonth);
                        continue;
                    }
                    if (ltn.equals("this")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                            valueNew = valueNew.replace(checkUndef, dctYear + "-" + newMonth);
                            continue;
                        }
                        lmMonth = ContextAnalyzer.getLastMentionedX(linearDates, i, "month-with-details", this.language);
                        if (lmMonth.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX-XX");
                            continue;
                        }
                        valueNew = valueNew.replace(checkUndef, lmMonth.substring(0, 4) + "-" + newMonth);
                        continue;
                    }
                    if (!ltn.equals("next")) continue;
                    if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                        if (dctMonth == newMonthInt && day != 0) {
                            if (dctDay < day) {
                                valueNew = valueNew.replace(checkUndef, dctYear + "-" + newMonth);
                                continue;
                            }
                            valueNew = valueNew.replace(checkUndef, dctYear + 1 + "-" + newMonth);
                            continue;
                        }
                        if (dctMonth >= newMonthInt) {
                            valueNew = valueNew.replace(checkUndef, dctYear + 1 + "-" + newMonth);
                            continue;
                        }
                        valueNew = valueNew.replace(checkUndef, dctYear + "-" + newMonth);
                        continue;
                    }
                    lmMonth = ContextAnalyzer.getLastMentionedX(linearDates, i, "month-with-details", this.language);
                    if (lmMonth.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XXXX-XX");
                        continue;
                    }
                    lmMonthInt = Integer.parseInt(lmMonth.substring(5, 7));
                    if (lmMonthInt >= newMonthInt) {
                        valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmMonth.substring(0, 4)) + 1 + "-" + newMonth);
                        continue;
                    }
                    valueNew = valueNew.replace(checkUndef, lmMonth.substring(0, 4) + "-" + newMonth);
                }
            } else if (ambigString.matches("^UNDEF-(last|this|next)-(SP|SU|FA|WI).*")) {
                for (MatchResult mr : Toolbox.findMatches(Pattern.compile("(UNDEF-(last|this|next)-(SP|SU|FA|WI)).*"), ambigString)) {
                    String lmSeason;
                    String checkUndef = mr.group(1);
                    String ltn = mr.group(2);
                    String newSeason = mr.group(3);
                    if (ltn.equals("last")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                            if (dctSeason.equals("SP")) {
                                valueNew = valueNew.replace(checkUndef, dctYear - 1 + "-" + newSeason);
                                continue;
                            }
                            if (dctSeason.equals("SU")) {
                                if (newSeason.equals("SP")) {
                                    valueNew = valueNew.replace(checkUndef, dctYear + "-" + newSeason);
                                    continue;
                                }
                                valueNew = valueNew.replace(checkUndef, dctYear - 1 + "-" + newSeason);
                                continue;
                            }
                            if (dctSeason.equals("FA")) {
                                if (newSeason.equals("SP") || newSeason.equals("SU")) {
                                    valueNew = valueNew.replace(checkUndef, dctYear + "-" + newSeason);
                                    continue;
                                }
                                valueNew = valueNew.replace(checkUndef, dctYear - 1 + "-" + newSeason);
                                continue;
                            }
                            if (!dctSeason.equals("WI")) continue;
                            if (newSeason.equals("WI")) {
                                valueNew = valueNew.replace(checkUndef, dctYear - 1 + "-" + newSeason);
                                continue;
                            }
                            if (dctMonth < 12) {
                                valueNew = valueNew.replace(checkUndef, dctYear - 1 + "-" + newSeason);
                                continue;
                            }
                            valueNew = valueNew.replace(checkUndef, dctYear + "-" + newSeason);
                            continue;
                        }
                        lmSeason = ContextAnalyzer.getLastMentionedX(linearDates, i, "season", this.language);
                        if (lmSeason.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX-XX");
                            continue;
                        }
                        if (lmSeason.substring(5, 7).equals("SP")) {
                            valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) - 1 + "-" + newSeason);
                            continue;
                        }
                        if (lmSeason.substring(5, 7).equals("SU")) {
                            if (lmSeason.substring(5, 7).equals("SP")) {
                                valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) + "-" + newSeason);
                                continue;
                            }
                            valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) - 1 + "-" + newSeason);
                            continue;
                        }
                        if (lmSeason.substring(5, 7).equals("FA")) {
                            if (newSeason.equals("SP") || newSeason.equals("SU")) {
                                valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) + "-" + newSeason);
                                continue;
                            }
                            valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) - 1 + "-" + newSeason);
                            continue;
                        }
                        if (!lmSeason.substring(5, 7).equals("WI")) continue;
                        if (newSeason.equals("WI")) {
                            valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) - 1 + "-" + newSeason);
                            continue;
                        }
                        valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) + "-" + newSeason);
                        continue;
                    }
                    if (ltn.equals("this")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                            valueNew = valueNew.replace(checkUndef, dctYear + "-" + newSeason);
                            continue;
                        }
                        lmSeason = ContextAnalyzer.getLastMentionedX(linearDates, i, "season", this.language);
                        if (lmSeason.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX-XX");
                            continue;
                        }
                        valueNew = valueNew.replace(checkUndef, lmSeason.substring(0, 4) + "-" + newSeason);
                        continue;
                    }
                    if (!ltn.equals("next")) continue;
                    if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                        if (dctSeason.equals("SP")) {
                            if (newSeason.equals("SP")) {
                                valueNew = valueNew.replace(checkUndef, dctYear + 1 + "-" + newSeason);
                                continue;
                            }
                            valueNew = valueNew.replace(checkUndef, dctYear + "-" + newSeason);
                            continue;
                        }
                        if (dctSeason.equals("SU")) {
                            if (newSeason.equals("SP") || newSeason.equals("SU")) {
                                valueNew = valueNew.replace(checkUndef, dctYear + 1 + "-" + newSeason);
                                continue;
                            }
                            valueNew = valueNew.replace(checkUndef, dctYear + "-" + newSeason);
                            continue;
                        }
                        if (dctSeason.equals("FA")) {
                            if (newSeason.equals("WI")) {
                                valueNew = valueNew.replace(checkUndef, dctYear + "-" + newSeason);
                                continue;
                            }
                            valueNew = valueNew.replace(checkUndef, dctYear + 1 + "-" + newSeason);
                            continue;
                        }
                        if (!dctSeason.equals("WI")) continue;
                        valueNew = valueNew.replace(checkUndef, dctYear + 1 + "-" + newSeason);
                        continue;
                    }
                    lmSeason = ContextAnalyzer.getLastMentionedX(linearDates, i, "season", this.language);
                    if (lmSeason.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XXXX-XX");
                        continue;
                    }
                    if (lmSeason.substring(5, 7).equals("SP")) {
                        if (newSeason.equals("SP")) {
                            valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) + 1 + "-" + newSeason);
                            continue;
                        }
                        valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) + "-" + newSeason);
                        continue;
                    }
                    if (lmSeason.substring(5, 7).equals("SU")) {
                        if (newSeason.equals("SP") || newSeason.equals("SU")) {
                            valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) + 1 + "-" + newSeason);
                            continue;
                        }
                        valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) + "-" + newSeason);
                        continue;
                    }
                    if (lmSeason.substring(5, 7).equals("FA")) {
                        if (newSeason.equals("WI")) {
                            valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) + "-" + newSeason);
                            continue;
                        }
                        valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) + 1 + "-" + newSeason);
                        continue;
                    }
                    if (!lmSeason.substring(5, 7).equals("WI")) continue;
                    valueNew = valueNew.replace(checkUndef, Integer.parseInt(lmSeason.substring(0, 4)) + 1 + "-" + newSeason);
                }
            } else if (ambigString.matches("^UNDEF-(last|this|next|day)-(monday|tuesday|wednesday|thursday|friday|saturday|sunday).*")) {
                for (MatchResult mr : Toolbox.findMatches(Pattern.compile("(UNDEF-(last|this|next|day)-(monday|tuesday|wednesday|thursday|friday|saturday|sunday)).*"), ambigString)) {
                    int diff;
                    int lmWeekdayInt;
                    String checkUndef = mr.group(1);
                    String ltnd = mr.group(2);
                    String newWeekday = mr.group(3);
                    int newWeekdayInt = Integer.parseInt(norm.getFromNormDayInWeek(newWeekday));
                    if (ltnd.equals("last")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                            int diff2 = -1 * (dctWeekday - newWeekdayInt);
                            if (diff2 >= 0) {
                                diff2 -= 7;
                            }
                            valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(dctYear + "-" + dctMonth + "-" + dctDay, diff2));
                            continue;
                        }
                        String lmDay = ContextAnalyzer.getLastMentionedX(linearDates, i, "day", this.language);
                        if (lmDay.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX-XX-XX");
                            continue;
                        }
                        lmWeekdayInt = DateCalculator.getWeekdayOfDate(lmDay);
                        diff = -1 * (lmWeekdayInt - newWeekdayInt);
                        if (diff >= 0) {
                            diff -= 7;
                        }
                        valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(lmDay, diff));
                        continue;
                    }
                    if (ltnd.equals("this")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                            int diff3 = -1 * (dctWeekday - newWeekdayInt);
                            if (diff3 >= 0) {
                                diff3 -= 7;
                            }
                            if (diff3 == -7) {
                                diff3 = 0;
                            }
                            valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(dctYear + "-" + dctMonth + "-" + dctDay, diff3));
                            continue;
                        }
                        String lmDay = ContextAnalyzer.getLastMentionedX(linearDates, i, "day", this.language);
                        if (lmDay.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX-XX-XX");
                            continue;
                        }
                        lmWeekdayInt = DateCalculator.getWeekdayOfDate(lmDay);
                        diff = -1 * (lmWeekdayInt - newWeekdayInt);
                        if (diff >= 0) {
                            diff -= 7;
                        }
                        if (diff == -7) {
                            diff = 0;
                        }
                        valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(lmDay, diff));
                        continue;
                    }
                    if (ltnd.equals("next")) {
                        if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                            int diff4 = newWeekdayInt - dctWeekday;
                            if (diff4 <= 0) {
                                diff4 += 7;
                            }
                            valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(dctYear + "-" + dctMonth + "-" + dctDay, diff4));
                            continue;
                        }
                        String lmDay = ContextAnalyzer.getLastMentionedX(linearDates, i, "day", this.language);
                        if (lmDay.equals("")) {
                            valueNew = valueNew.replace(checkUndef, "XXXX-XX-XX");
                            continue;
                        }
                        lmWeekdayInt = DateCalculator.getWeekdayOfDate(lmDay);
                        diff = newWeekdayInt - lmWeekdayInt;
                        if (diff <= 0) {
                            diff += 7;
                        }
                        valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(lmDay, diff));
                        continue;
                    }
                    if (!ltnd.equals("day")) continue;
                    if ((documentTypeNews || documentTypeColloquial || documentTypeScientific) && dctAvailable) {
                        int diff5 = -1 * (dctWeekday - newWeekdayInt);
                        if (diff5 >= 0) {
                            diff5 -= 7;
                        }
                        if (diff5 == -7) {
                            diff5 = 0;
                        }
                        if (last_used_tense.equals("FUTURE") && diff5 != 0) {
                            diff5 += 7;
                        }
                        if (last_used_tense.equals("PAST")) {
                            // empty if block
                        }
                        valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(dctYear + "-" + dctMonth + "-" + dctDay, diff5));
                        continue;
                    }
                    String lmDay = ContextAnalyzer.getLastMentionedX(linearDates, i, "day", this.language);
                    if (lmDay.equals("")) {
                        valueNew = valueNew.replace(checkUndef, "XXXX-XX-XX");
                        continue;
                    }
                    lmWeekdayInt = DateCalculator.getWeekdayOfDate(lmDay);
                    diff = -1 * (lmWeekdayInt - newWeekdayInt);
                    if (diff >= 0) {
                        diff -= 7;
                    }
                    if (diff == -7) {
                        diff = 0;
                    }
                    valueNew = valueNew.replace(checkUndef, DateCalculator.getXNextDay(lmDay, diff));
                }
            } else {
                Logger.printDetail(this.component, "ATTENTION: UNDEF value for: " + valueNew + " is not handled in disambiguation phase!");
            }
        }
        return valueNew;
    }

    public void specifyAmbiguousValues(JCas jcas) {
        ArrayList<Timex3> linearDates = new ArrayList<Timex3>();
        for (Timex3 timex : jcas.getAnnotationIndex(Timex3.type)) {
            if (timex.getTimexType().equals("DATE") || timex.getTimexType().equals("TIME")) {
                linearDates.add(timex);
            }
            if (!timex.getTimexType().equals("DURATION") || timex.getEmptyValue().equals("")) continue;
            linearDates.add(timex);
        }
        for (int i = 0; i < linearDates.size(); ++i) {
            String value_i;
            Timex3 t_i = (Timex3)((Object)linearDates.get(i));
            String valueNew = value_i = t_i.getTimexValue();
            if (t_i.getTimexType().equals("TIME") || t_i.getTimexType().equals("DATE")) {
                valueNew = this.specifyAmbiguousValuesString(value_i, t_i, i, linearDates, jcas);
            }
            if (t_i.getEmptyValue() != null && t_i.getEmptyValue().length() > 0) {
                String emptyValueNew = this.specifyAmbiguousValuesString(t_i.getEmptyValue(), t_i, i, linearDates, jcas);
                t_i.setEmptyValue(emptyValueNew);
            }
            t_i.removeFromIndexes();
            Logger.printDetail(t_i.getTimexId() + " DISAMBIGUATION PHASE: foundBy:" + t_i.getFoundByRule() + " text:" + t_i.getCoveredText() + " value:" + t_i.getTimexValue() + " NEW value:" + valueNew);
            t_i.setTimexValue(valueNew);
            t_i.addToIndexes();
            linearDates.set(i, t_i);
        }
    }

    private void deleteOverlappedTimexesPreprocessing(JCas jcas) {
        FSIterator timexIter1 = jcas.getAnnotationIndex(Timex3.type).iterator();
        HashSet<Timex3> hsTimexesToRemove = new HashSet<Timex3>();
        while (timexIter1.hasNext()) {
            Timex3 t1 = (Timex3)((Object)timexIter1.next());
            for (Timex3 t2 : jcas.getAnnotationIndex(Timex3.type)) {
                if (t1.getBegin() >= t2.getBegin() && t1.getEnd() < t2.getEnd() || t1.getBegin() > t2.getBegin() && t1.getEnd() <= t2.getEnd()) {
                    hsTimexesToRemove.add(t1);
                } else if (t2.getBegin() >= t1.getBegin() && t2.getEnd() < t1.getEnd() || t2.getBegin() > t1.getBegin() && t2.getEnd() <= t1.getEnd()) {
                    hsTimexesToRemove.add(t2);
                }
                if (t1.equals((Object)t2) || t1.getBegin() != t2.getBegin() || t1.getEnd() != t2.getEnd()) continue;
                if (t1.getTimexValue().startsWith("UNDEF") && !t2.getTimexValue().startsWith("UNDEF")) {
                    hsTimexesToRemove.add(t1);
                    continue;
                }
                if (!t1.getTimexValue().startsWith("UNDEF") && t2.getTimexValue().startsWith("UNDEF")) {
                    hsTimexesToRemove.add(t2);
                    continue;
                }
                if (t1.getFoundByRule().endsWith("explicit") && !t2.getFoundByRule().endsWith("explicit")) {
                    hsTimexesToRemove.add(t2);
                    continue;
                }
                if (t2.getEmptyValue().equals("") && !t1.getEmptyValue().equals("")) {
                    hsTimexesToRemove.add(t2);
                    continue;
                }
                if (Integer.parseInt(t1.getTimexId().substring(1)) >= Integer.parseInt(t2.getTimexId().substring(1))) continue;
                hsTimexesToRemove.add(t1);
            }
        }
        for (Timex3 t : hsTimexesToRemove) {
            Logger.printDetail("REMOVE DUPLICATE: " + t.getCoveredText() + "(id:" + t.getTimexId() + " value:" + t.getTimexValue() + " found by:" + t.getFoundByRule() + ")");
            t.removeFromIndexes();
            --this.timex_counter;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deleteOverlappedTimexesPostprocessing(JCas jcas) {
        FSIterator timexIter = jcas.getAnnotationIndex(Timex3.type).iterator();
        FSIterator innerTimexIter = timexIter.copy();
        HashSet effectivelyToInspect = new HashSet();
        ArrayList<Timex3> allTimexesToInspect = new ArrayList<Timex3>();
        while (timexIter.hasNext()) {
            Timex3 myTimex = (Timex3)((Object)timexIter.next());
            ArrayList<Timex3> timexSet = new ArrayList<Timex3>();
            if (!myTimex.getTimexType().equals("TEMPONYM")) {
                timexSet.add(myTimex);
            }
            while (innerTimexIter.hasNext()) {
                Timex3 timex3 = (Timex3)((Object)innerTimexIter.next());
                if (myTimex.getTimexType().equals("TEMPONYM") || !(myTimex.getBegin() <= timex3.getBegin() && myTimex.getEnd() > timex3.getBegin() || timex3.getBegin() <= myTimex.getBegin() && timex3.getEnd() > myTimex.getBegin() || timex3.getBegin() <= myTimex.getBegin() && myTimex.getEnd() <= timex3.getEnd()) && (myTimex.getBegin() > timex3.getBegin() || timex3.getEnd() > myTimex.getEnd())) continue;
                timexSet.add(timex3);
                allTimexesToInspect.add(myTimex);
                allTimexesToInspect.add(timex3);
            }
            if (timexSet.size() > 1) {
                effectivelyToInspect.add(timexSet);
            }
            innerTimexIter.moveToFirst();
        }
        HashSet<ArrayList> newEffectivelyToInspect = new HashSet<ArrayList>();
        for (Timex3 timex3 : allTimexesToInspect) {
            ArrayList setToKeep = new ArrayList();
            for (ArrayList arrayList : effectivelyToInspect) {
                if (!arrayList.contains((Object)timex3) || arrayList.size() <= setToKeep.size()) continue;
                setToKeep = arrayList;
            }
            newEffectivelyToInspect.add(setToKeep);
        }
        effectivelyToInspect = newEffectivelyToInspect;
        for (ArrayList arrayList : effectivelyToInspect) {
            void var11_20;
            Timex3 newTimex = new Timex3(jcas);
            ArrayList newTSet = (ArrayList)arrayList.clone();
            for (Timex3 t : arrayList) {
                if (!t.getTimexValue().equals("REMOVE")) continue;
                newTSet.remove((Object)t);
            }
            ArrayList arrayList2 = newTSet;
            if (arrayList2.size() == 0) continue;
            Boolean bl = true;
            String timexType = null;
            Object longestTimex = null;
            Integer combinedBegin = Integer.MAX_VALUE;
            Integer combinedEnd = Integer.MIN_VALUE;
            ArrayList<Integer> tokenIds = new ArrayList<Integer>();
            for (Object t : arrayList2) {
                if (timexType == null) {
                    timexType = ((Timex3)((Object)t)).getTimexType();
                } else if (var11_20.booleanValue() && !timexType.equals(((Timex3)((Object)t)).getTimexType()) || !timexType.equals("DATE") && !timexType.equals("TIME")) {
                    Boolean bl2 = false;
                }
                Logger.printDetail("Are these overlapping timexes of same type? => " + var11_20);
                if (longestTimex == null) {
                    longestTimex = t;
                } else if (var11_20.booleanValue() && ((Timex3)((Object)t)).getFoundByRule().indexOf("-BCADhint") != -1) {
                    longestTimex = t;
                } else if (var11_20.booleanValue() && ((Timex3)((Object)t)).getFoundByRule().indexOf("relative") == -1 && ((Timex3)((Object)longestTimex)).getFoundByRule().indexOf("relative") != -1) {
                    longestTimex = t;
                } else if (((Timex3)((Object)longestTimex)).getTimexValue().length() == ((Timex3)((Object)t)).getTimexValue().length()) {
                    if (t.getBegin() < longestTimex.getBegin()) {
                        longestTimex = t;
                    }
                } else if (((Timex3)((Object)longestTimex)).getTimexValue().length() < ((Timex3)((Object)t)).getTimexValue().length()) {
                    longestTimex = t;
                }
                Logger.printDetail("Selected " + ((Timex3)((Object)longestTimex)).getTimexId() + ": " + longestTimex.getCoveredText() + "[" + ((Timex3)((Object)longestTimex)).getTimexValue() + "] as the longest-valued timex.");
                if (combinedBegin > t.getBegin()) {
                    combinedBegin = t.getBegin();
                }
                if (combinedEnd < t.getEnd()) {
                    combinedEnd = t.getEnd();
                }
                Logger.printDetail("Selected combined constraints: " + combinedBegin + ":" + combinedEnd);
                String[] tokenizedTokenIds = ((Timex3)((Object)t)).getAllTokIds().split("<-->");
                Integer i = 1;
                while (i < tokenizedTokenIds.length) {
                    if (!tokenIds.contains(Integer.parseInt(tokenizedTokenIds[i]))) {
                        tokenIds.add(Integer.parseInt(tokenizedTokenIds[i]));
                    }
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }
            Collections.sort(tokenIds);
            newTimex = longestTimex;
            if (var11_20.booleanValue()) {
                Object t;
                newTimex.setBegin(combinedBegin);
                newTimex.setEnd(combinedEnd);
                if (tokenIds.size() > 0) {
                    newTimex.setFirstTokId((Integer)tokenIds.get(0));
                }
                String tokenIdText = "BEGIN";
                t = tokenIds.iterator();
                while (t.hasNext()) {
                    Integer tokenId = (Integer)t.next();
                    tokenIdText = tokenIdText + "<-->" + tokenId;
                }
                newTimex.setAllTokIds(tokenIdText);
            }
            for (Object t : arrayList2) {
                t.removeFromIndexes();
            }
            newTimex.addToIndexes();
        }
    }

    public String getPosFromMatchResult(int tokBegin, int tokEnd, Sentence s, JCas jcas) {
        HashMap<Integer, Token> hmTokens = new HashMap<Integer, Token>();
        FSIterator iterTok = jcas.getAnnotationIndex(Token.type).subiterator((AnnotationFS)s);
        while (iterTok.hasNext()) {
            Token token = (Token)((Object)iterTok.next());
            hmTokens.put(token.getBegin(), token);
        }
        String pos = "";
        if (hmTokens.containsKey(tokBegin)) {
            Token tokenToCheck = (Token)((Object)hmTokens.get(tokBegin));
            pos = tokenToCheck.getPos();
        }
        return pos;
    }

    public void findTimexes(String timexType, HashMap<Pattern, String> hmPattern, HashMap<String, String> hmOffset, HashMap<String, String> hmNormalization, Sentence s, JCas jcas) {
        RuleManager rm = RuleManager.getInstance(this.language, this.find_temponyms);
        HashMap<String, String> hmDatePosConstraint = rm.getHmDatePosConstraint();
        HashMap<String, String> hmDurationPosConstraint = rm.getHmDurationPosConstraint();
        HashMap<String, String> hmTimePosConstraint = rm.getHmTimePosConstraint();
        HashMap<String, String> hmSetPosConstraint = rm.getHmSetPosConstraint();
        HashMap<String, String> hmTemponymPosConstraint = rm.getHmTemponymPosConstraint();
        HashMap<String, Pattern> hmDateFastCheck = rm.getHmDateFastCheck();
        HashMap<String, Pattern> hmDurationFastCheck = rm.getHmDurationFastCheck();
        HashMap<String, Pattern> hmTimeFastCheck = rm.getHmTimeFastCheck();
        HashMap<String, Pattern> hmSetFastCheck = rm.getHmSetFastCheck();
        HashMap<String, Pattern> hmTemponymFastCheck = rm.getHmTemponymFastCheck();
        Pattern f = null;
        Boolean fastCheckOK = true;
        for (Pattern p : Toolbox.sortByValue(hmPattern)) {
            if (timexType.equals("DATE")) {
                f = hmDateFastCheck.get(hmPattern.get(p));
            } else if (timexType.equals("Time")) {
                f = hmTimeFastCheck.get(hmPattern.get(p));
            } else if (timexType.equals("DURATION")) {
                f = hmDurationFastCheck.get(hmPattern.get(p));
            } else if (timexType.equals("SET")) {
                f = hmSetFastCheck.get(hmPattern.get(p));
            } else if (timexType.equals("TEMPONYM")) {
                f = hmTemponymFastCheck.get(hmPattern.get(p));
            }
            if (f != null) {
                fastCheckOK = false;
                if (f.matcher(s.getCoveredText()).find()) {
                    fastCheckOK = true;
                }
            }
            if (fastCheckOK.booleanValue()) {
                for (MatchResult r : Toolbox.findMatches(p, s.getCoveredText())) {
                    boolean infrontBehindOK = ContextAnalyzer.checkTokenBoundaries(r, s, jcas) != false && ContextAnalyzer.checkInfrontBehind(r, s) != false;
                    boolean posConstraintOK = true;
                    if (timexType.equals("DATE")) {
                        if (hmDatePosConstraint.containsKey(hmPattern.get(p))) {
                            posConstraintOK = this.checkPosConstraint(s, hmDatePosConstraint.get(hmPattern.get(p)), r, jcas);
                        }
                    } else if (timexType.equals("DURATION")) {
                        if (hmDurationPosConstraint.containsKey(hmPattern.get(p))) {
                            posConstraintOK = this.checkPosConstraint(s, hmDurationPosConstraint.get(hmPattern.get(p)), r, jcas);
                        }
                    } else if (timexType.equals("TIME")) {
                        if (hmTimePosConstraint.containsKey(hmPattern.get(p))) {
                            posConstraintOK = this.checkPosConstraint(s, hmTimePosConstraint.get(hmPattern.get(p)), r, jcas);
                        }
                    } else if (timexType.equals("SET")) {
                        if (hmSetPosConstraint.containsKey(hmPattern.get(p))) {
                            posConstraintOK = this.checkPosConstraint(s, hmSetPosConstraint.get(hmPattern.get(p)), r, jcas);
                        }
                    } else if (timexType.equals("TEMPONYM") && hmTemponymPosConstraint.containsKey(hmPattern.get(p))) {
                        posConstraintOK = this.checkPosConstraint(s, hmSetPosConstraint.get(hmPattern.get(p)), r, jcas);
                    }
                    if (!infrontBehindOK || !posConstraintOK) continue;
                    int timexStart = r.start();
                    int timexEnd = r.end();
                    if (hmOffset.containsKey(hmPattern.get(p))) {
                        String offset = hmOffset.get(hmPattern.get(p));
                        Pattern paOffset = Pattern.compile("group\\(([0-9]+)\\)-group\\(([0-9]+)\\)");
                        for (MatchResult mr : Toolbox.findMatches(paOffset, offset)) {
                            int startOffset = Integer.parseInt(mr.group(1));
                            int endOffset = Integer.parseInt(mr.group(2));
                            timexStart = r.start(startOffset);
                            timexEnd = r.end(endOffset);
                        }
                    }
                    if (hmNormalization.containsKey(hmPattern.get(p))) {
                        String[] attributes = new String[5];
                        if (timexType.equals("DATE")) {
                            attributes = this.getAttributesForTimexFromFile(hmPattern.get(p), rm.getHmDateNormalization(), rm.getHmDateQuant(), rm.getHmDateFreq(), rm.getHmDateMod(), rm.getHmDateEmptyValue(), r, jcas);
                        } else if (timexType.equals("DURATION")) {
                            attributes = this.getAttributesForTimexFromFile(hmPattern.get(p), rm.getHmDurationNormalization(), rm.getHmDurationQuant(), rm.getHmDurationFreq(), rm.getHmDurationMod(), rm.getHmDurationEmptyValue(), r, jcas);
                        } else if (timexType.equals("TIME")) {
                            attributes = this.getAttributesForTimexFromFile(hmPattern.get(p), rm.getHmTimeNormalization(), rm.getHmTimeQuant(), rm.getHmTimeFreq(), rm.getHmTimeMod(), rm.getHmTimeEmptyValue(), r, jcas);
                        } else if (timexType.equals("SET")) {
                            attributes = this.getAttributesForTimexFromFile(hmPattern.get(p), rm.getHmSetNormalization(), rm.getHmSetQuant(), rm.getHmSetFreq(), rm.getHmSetMod(), rm.getHmSetEmptyValue(), r, jcas);
                        } else if (timexType.equals("TEMPONYM")) {
                            attributes = this.getAttributesForTimexFromFile(hmPattern.get(p), rm.getHmTemponymNormalization(), rm.getHmTemponymQuant(), rm.getHmTemponymFreq(), rm.getHmTemponymMod(), rm.getHmTemponymEmptyValue(), r, jcas);
                        }
                        if (attributes == null) continue;
                        this.addTimexAnnotation(timexType, timexStart + s.getBegin(), timexEnd + s.getBegin(), s, attributes[0], attributes[1], attributes[2], attributes[3], attributes[4], "t" + this.timexID++, hmPattern.get(p), jcas);
                        continue;
                    }
                    Logger.printError("SOMETHING REALLY WRONG HERE: " + hmPattern.get(p));
                }
            }
            fastCheckOK = true;
        }
    }

    public boolean checkPosConstraint(Sentence s, String posConstraint, MatchResult m, JCas jcas) {
        Pattern paConstraint = Pattern.compile("group\\(([0-9]+)\\):(.*?):");
        for (MatchResult mr : Toolbox.findMatches(paConstraint, posConstraint)) {
            int groupNumber = Integer.parseInt(mr.group(1));
            int tokenBegin = s.getBegin() + m.start(groupNumber);
            int tokenEnd = s.getBegin() + m.end(groupNumber);
            String pos = mr.group(2);
            String pos_as_is = this.getPosFromMatchResult(tokenBegin, tokenEnd, s, jcas);
            if (pos_as_is.matches(pos)) {
                Logger.printDetail("POS CONSTRAINT IS VALID: pos should be " + pos + " and is " + pos_as_is);
                continue;
            }
            return false;
        }
        return true;
    }

    public String applyRuleFunctions(String tonormalize, MatchResult m) {
        NormalizationManager norm = NormalizationManager.getInstance(this.language, this.find_temponyms);
        String normalized = "";
        Pattern paNorm = Pattern.compile("%([A-Za-z0-9]+?)\\(group\\(([0-9]+)\\)\\)");
        Pattern paGroup = Pattern.compile("group\\(([0-9]+)\\)");
        while (tonormalize.contains("%") || tonormalize.contains("group")) {
            for (MatchResult matchResult : Toolbox.findMatches(paNorm, tonormalize)) {
                Logger.printDetail("-----------------------------------");
                Logger.printDetail("DEBUGGING: tonormalize:" + tonormalize);
                Logger.printDetail("DEBUGGING: mr.group():" + matchResult.group());
                Logger.printDetail("DEBUGGING: mr.group(1):" + matchResult.group(1));
                Logger.printDetail("DEBUGGING: mr.group(2):" + matchResult.group(2));
                Logger.printDetail("DEBUGGING: m.group():" + m.group());
                Logger.printDetail("DEBUGGING: m.group(" + Integer.parseInt(matchResult.group(2)) + "):" + m.group(Integer.parseInt(matchResult.group(2))));
                Logger.printDetail("DEBUGGING: hmR...:" + norm.getFromHmAllNormalization(matchResult.group(1)).get(m.group(Integer.parseInt(matchResult.group(2)))));
                Logger.printDetail("-----------------------------------");
                if (m.group(Integer.parseInt(matchResult.group(2))) != null) {
                    String partToReplace = m.group(Integer.parseInt(matchResult.group(2))).replaceAll("[\n\\s]+", " ");
                    if (!norm.getFromHmAllNormalization(matchResult.group(1)).containsKey(partToReplace)) {
                        Logger.printDetail("Maybe problem with normalization of the resource: " + matchResult.group(1));
                        Logger.printDetail("Maybe problem with part to replace? " + partToReplace);
                        if (!matchResult.group(1).contains("Temponym")) continue;
                        Logger.printDetail("Should be ok, as it's a temponym.");
                        return null;
                    }
                    tonormalize = tonormalize.replace(matchResult.group(), norm.getFromHmAllNormalization(matchResult.group(1)).get(partToReplace));
                    continue;
                }
                Logger.printDetail("Empty part to normalize in " + matchResult.group(1));
                tonormalize = tonormalize.replace(matchResult.group(), "");
            }
            for (MatchResult matchResult : Toolbox.findMatches(paGroup, tonormalize)) {
                Logger.printDetail("-----------------------------------");
                Logger.printDetail("DEBUGGING: tonormalize:" + tonormalize);
                Logger.printDetail("DEBUGGING: mr.group():" + matchResult.group());
                Logger.printDetail("DEBUGGING: mr.group(1):" + matchResult.group(1));
                Logger.printDetail("DEBUGGING: m.group():" + m.group());
                Logger.printDetail("DEBUGGING: m.group(" + Integer.parseInt(matchResult.group(1)) + "):" + m.group(Integer.parseInt(matchResult.group(1))));
                Logger.printDetail("-----------------------------------");
                tonormalize = tonormalize.replace(matchResult.group(), m.group(Integer.parseInt(matchResult.group(1))));
            }
            Pattern paSubstring = Pattern.compile("%SUBSTRING%\\((.*?),([0-9]+),([0-9]+)\\)");
            for (Object mr3 : Toolbox.findMatches(paSubstring, tonormalize)) {
                String string = mr3.group(1).substring(Integer.parseInt(mr3.group(2)), Integer.parseInt(mr3.group(3)));
                tonormalize = tonormalize.replace(mr3.group(), string);
            }
            if (this.language.getName().compareTo("arabic") != 0) {
                Object mr3;
                Pattern pattern = Pattern.compile("%LOWERCASE%\\((.*?)\\)");
                mr3 = Toolbox.findMatches(pattern, tonormalize).iterator();
                while (mr3.hasNext()) {
                    MatchResult matchResult = (MatchResult)mr3.next();
                    String substring = matchResult.group(1).toLowerCase();
                    tonormalize = tonormalize.replace(matchResult.group(), substring);
                }
                Pattern paUppercase = Pattern.compile("%UPPERCASE%\\((.*?)\\)");
                for (MatchResult mr5 : Toolbox.findMatches(paUppercase, tonormalize)) {
                    String substring = mr5.group(1).toUpperCase();
                    tonormalize = tonormalize.replace(mr5.group(), substring);
                }
            }
            Pattern pattern = Pattern.compile("%SUM%\\((.*?),(.*?)\\)");
            for (MatchResult matchResult : Toolbox.findMatches(pattern, tonormalize)) {
                int newValue = Integer.parseInt(matchResult.group(1)) + Integer.parseInt(matchResult.group(2));
                tonormalize = tonormalize.replace(matchResult.group(), newValue + "");
            }
            Pattern paNormNoGroup = Pattern.compile("%([A-Za-z0-9]+?)\\((.*?)\\)");
            for (MatchResult mr6 : Toolbox.findMatches(paNormNoGroup, tonormalize)) {
                tonormalize = tonormalize.replace(mr6.group(), norm.getFromHmAllNormalization(mr6.group(1)).get(mr6.group(2)));
            }
            Pattern pattern2 = Pattern.compile("%CHINESENUMBERS%\\((.*?)\\)");
            for (MatchResult mr7 : Toolbox.findMatches(pattern2, tonormalize)) {
                RegexHashMap<String> chineseNumerals = new RegexHashMap<String>();
                chineseNumerals.put("[\u96f6\uff100]", "0");
                chineseNumerals.put("[\u4e00\uff111]", "1");
                chineseNumerals.put("[\u4e8c\uff122]", "2");
                chineseNumerals.put("[\u4e09\uff133]", "3");
                chineseNumerals.put("[\u56db\uff144]", "4");
                chineseNumerals.put("[\u4e94\uff155]", "5");
                chineseNumerals.put("[\u516d\uff166]", "6");
                chineseNumerals.put("[\u4e03\uff177]", "7");
                chineseNumerals.put("[\u516b\uff188]", "8");
                chineseNumerals.put("[\u4e5d\uff199]", "9");
                String outString = "";
                Integer i = 0;
                while (i < mr7.group(1).length()) {
                    String thisChar = mr7.group(1).substring(i, i + 1);
                    if (chineseNumerals.containsKey(thisChar)) {
                        outString = outString + (String)chineseNumerals.get(thisChar);
                    } else {
                        System.out.println(chineseNumerals.entrySet());
                        Logger.printError(this.component, "Found an error in the resources: " + mr7.group(1) + " contains a character that is not defined in the Chinese numerals map. Normalization may be mangled.");
                        outString = outString + thisChar;
                    }
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                tonormalize = tonormalize.replace(mr7.group(), outString);
            }
        }
        normalized = tonormalize;
        return normalized;
    }

    public String[] getAttributesForTimexFromFile(String rule, HashMap<String, String> hmNormalization, HashMap<String, String> hmQuant, HashMap<String, String> hmFreq, HashMap<String, String> hmMod, HashMap<String, String> hmEmptyValue, MatchResult m, JCas jcas) {
        String[] attributes = new String[5];
        String value = "";
        String quant = "";
        String freq = "";
        String mod = "";
        String emptyValue = "";
        String value_normalization_pattern = hmNormalization.get(rule);
        value = this.applyRuleFunctions(value_normalization_pattern, m);
        if (value == null) {
            return null;
        }
        if (hmQuant.containsKey(rule)) {
            String quant_normalization_pattern = hmQuant.get(rule);
            quant = this.applyRuleFunctions(quant_normalization_pattern, m);
        }
        if (hmFreq.containsKey(rule)) {
            String freq_normalization_pattern = hmFreq.get(rule);
            freq = this.applyRuleFunctions(freq_normalization_pattern, m);
        }
        if (hmMod.containsKey(rule)) {
            String mod_normalization_pattern = hmMod.get(rule);
            mod = this.applyRuleFunctions(mod_normalization_pattern, m);
        }
        if (hmEmptyValue.containsKey(rule)) {
            String emptyValue_normalization_pattern = hmEmptyValue.get(rule);
            emptyValue = this.applyRuleFunctions(emptyValue_normalization_pattern, m);
            emptyValue = this.correctDurationValue(emptyValue);
        }
        if (this.group_gran.booleanValue()) {
            value = this.correctDurationValue(value);
        }
        attributes[0] = value;
        attributes[1] = quant;
        attributes[2] = freq;
        attributes[3] = mod;
        attributes[4] = emptyValue;
        return attributes;
    }

    public String correctDurationValue(String value) {
        block10: {
            block11: {
                block9: {
                    if (!value.matches("PT[0-9]+H")) break block9;
                    for (MatchResult mr : Toolbox.findMatches(Pattern.compile("PT([0-9]+)H"), value)) {
                        try {
                            int hours = Integer.parseInt(mr.group(1));
                            if (hours % 24 != 0) continue;
                            int days = hours / 24;
                            value = "P" + days + "D";
                        }
                        catch (NumberFormatException e) {
                            Logger.printDetail(this.component, "Couldn't do granularity conversion for " + value);
                        }
                    }
                    break block10;
                }
                if (!value.matches("PT[0-9]+M")) break block11;
                for (MatchResult mr : Toolbox.findMatches(Pattern.compile("PT([0-9]+)M"), value)) {
                    try {
                        int minutes = Integer.parseInt(mr.group(1));
                        if (minutes % 60 != 0) continue;
                        int hours = minutes / 60;
                        value = "PT" + hours + "H";
                    }
                    catch (NumberFormatException e) {
                        Logger.printDetail(this.component, "Couldn't do granularity conversion for " + value);
                    }
                }
                break block10;
            }
            if (!value.matches("P[0-9]+M")) break block10;
            for (MatchResult mr : Toolbox.findMatches(Pattern.compile("P([0-9]+)M"), value)) {
                try {
                    int months = Integer.parseInt(mr.group(1));
                    if (months % 12 != 0) continue;
                    int years = months / 12;
                    value = "P" + years + "Y";
                }
                catch (NumberFormatException e) {
                    Logger.printDetail(this.component, "Couldn't do granularity conversion for " + value);
                }
            }
        }
        return value;
    }

    private Boolean isValidDCT(JCas jcas) {
        FSIterator dctIter = jcas.getAnnotationIndex(Dct.type).iterator();
        if (!dctIter.hasNext()) {
            return true;
        }
        Dct dct = (Dct)((Object)dctIter.next());
        String dctVal = dct.getValue();
        if (dctVal == null) {
            return false;
        }
        if (dctVal.matches("\\d{8}") || dctVal.matches("\\d{4}.\\d{2}.\\d{2}.*")) {
            return true;
        }
        return false;
    }
}

