/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.heideltime.standalone;

import de.unihd.dbs.heideltime.standalone.DocumentType;
import de.unihd.dbs.heideltime.standalone.OutputType;
import de.unihd.dbs.heideltime.standalone.POSTagger;
import de.unihd.dbs.uima.annotator.heideltime.resources.Language;
import java.util.Date;

public enum CLISwitch {
    VERBOSITY("Verbosity level set to INFO and above", "-v"),
    VERBOSITY2("Verbosity level set to ALL", "-vv"),
    ENCODING("Encoding to use", "-e", "UTF-8"),
    OUTPUTTYPE("Output Type output type to use", "-o", (Object)((Object)OutputType.TIMEML)),
    LANGUAGE("Language to use", "-l", Language.ENGLISH.toString()),
    DOCTYPE("Document Type/Domain to use", "-t", (Object)((Object)DocumentType.NARRATIVES)),
    DCT("Document Creation Time. Format: YYYY-mm-dd.", "-dct", new Date()),
    CONFIGFILE("Configuration file path", "-c", "config.props"),
    LOCALE("Locale", "-locale", null),
    POSTAGGER("Part of Speech tagger", "-pos", (Object)((Object)POSTagger.TREETAGGER)),
    INTERVALS("Interval Tagger", "-it"),
    HELP("This screen", "-h");

    private boolean hasFollowingValue = false;
    private boolean isActive = false;
    private String name;
    private String switchString;
    private Object value = null;
    private Object defaultValue;

    private CLISwitch(String name, String switchString, Object defaultValue) {
        this.hasFollowingValue = true;
        this.name = name;
        this.switchString = switchString;
        this.defaultValue = defaultValue;
    }

    private CLISwitch(String name, String switchString) {
        this.hasFollowingValue = false;
        this.name = name;
        this.switchString = switchString;
    }

    public static CLISwitch getEnumFromSwitch(String cliSwitch) {
        for (CLISwitch s : CLISwitch.values()) {
            if (!s.getSwitchString().equals(cliSwitch)) continue;
            return s;
        }
        return null;
    }

    public void setValue(String val) {
        this.value = val;
        this.isActive = true;
    }

    public Object getValue() {
        if (this.hasFollowingValue) {
            if (this.value != null) {
                return this.value;
            }
            return this.defaultValue;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getSwitchString() {
        return this.switchString;
    }

    public boolean getHasFollowingValue() {
        return this.hasFollowingValue;
    }

    public boolean getIsActive() {
        return this.isActive;
    }
}

