/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    static Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static DecimalFormat tf = new DecimalFormat("000,000,000.#");
    private static DecimalFormat df = new DecimalFormat("###,###,###,###");

    public static String read(String name) throws IOException {
        return FileUtils.read(new File(name));
    }

    public static String read(File f, int size) throws IOException {
        StringBuilder sb = new StringBuilder();
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
        String line = null;
        int count = 0;
        while ((line = lnr.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
            if (count > size) break;
            ++count;
        }
        lnr.close();
        return sb.toString();
    }

    public static String read(File f) throws IOException {
        StringBuilder sb = new StringBuilder();
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
        String line = null;
        while ((line = lnr.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        lnr.close();
        return sb.toString();
    }

    public static Set<String> readSet(File f) throws IOException {
        return FileUtils.readSet(f, false);
    }

    public static Set<String> readSet(File f, boolean lowercase) throws IOException {
        logger.info("reading from " + f + "...");
        long begin = System.nanoTime();
        HashSet<String> set = new HashSet<String>();
        LineNumberReader lr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
        String line = null;
        while ((line = lr.readLine()) != null) {
            if (lowercase) {
                set.add(line.trim().toLowerCase());
                continue;
            }
            set.add(line.trim());
        }
        lr.close();
        long end = System.nanoTime();
        logger.info(set.size() + " items read  in " + tf.format(end - begin) + " ns");
        return set;
    }
}

