/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class MultiSet<E>
implements Iterable<E>,
Collection<E>,
Set<E> {
    protected Map<E, Counter> map;
    protected int count = 0;

    protected MultiSet() {
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        boolean b = true;
        while (it.hasNext()) {
            b &= this.remove(it.next());
        }
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<E> it = this.iterator();
        boolean b = true;
        while (it.hasNext()) {
            E e = it.next();
            if (c.contains(e)) continue;
            b &= this.remove(e);
        }
        return b;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> it = c.iterator();
        boolean b = true;
        while (it.hasNext()) {
            b &= this.add(it.next());
        }
        return b;
    }

    public void addAll(Set<E> set) {
        Iterator<E> it = set.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public boolean add(E o, int freq) {
        ++this.count;
        Counter c = this.map.get(o);
        if (c == null) {
            this.map.put(o, new Counter(freq));
            return true;
        }
        c.inc(freq);
        return false;
    }

    @Override
    public boolean add(E o) {
        ++this.count;
        Counter c = this.map.get(o);
        if (c == null) {
            this.map.put(o, new Counter(1));
            return true;
        }
        c.inc();
        return false;
    }

    @Override
    public boolean contains(Object o) {
        Counter c = this.map.get(o);
        return c != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<E> it = this.iterator();
        boolean b = true;
        while (it.hasNext()) {
            b &= c.contains(it.next());
        }
        return b;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    public int getFrequency(E o) {
        Counter c = this.map.get(o);
        if (c == null) {
            return 0;
        }
        return c.get();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public SortedMap<Integer, List<E>> toSortedMap() {
        TreeMap<Integer, List<E>> smap = new TreeMap<Integer, List<E>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer e1, Integer e2) {
                return e2.compareTo(e1);
            }
        });
        for (E o : this.map.keySet()) {
            Counter c = this.map.get(o);
            ArrayList<E> list = (ArrayList<E>)smap.get(c.get());
            if (list == null) {
                list = new ArrayList<E>();
                list.add(o);
                smap.put(c.get(), list);
                continue;
            }
            list.add(o);
        }
        return smap;
    }

    public String toString(int t) {
        SortedMap<Integer, List<E>> smap = this.toSortedMap();
        StringBuilder sb = new StringBuilder();
        double fc = 0.0;
        double fi = 0.0;
        Iterator<Integer> it = smap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Integer f = it.next();
            List list = (List)smap.get(f);
            fi = (double)f.intValue() / (double)this.count;
            if (f < t) break;
            fc += fi;
            sb.append(i);
            sb.append("\t");
            sb.append(f);
            sb.append("\t");
            sb.append(fi);
            sb.append("\t");
            sb.append(fc);
            sb.append("\t");
            sb.append(list);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        SortedMap<Integer, List<E>> smap = this.toSortedMap();
        StringBuilder sb = new StringBuilder();
        double fc = 0.0;
        double fi = 0.0;
        Iterator<Integer> it = smap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Integer f = it.next();
            List list = (List)smap.get(f);
            fi = (double)f.intValue() / (double)this.count * (double)list.size();
            fc += fi;
            sb.append(i);
            sb.append("\t");
            sb.append(f);
            sb.append("\t");
            sb.append(fi);
            sb.append("\t");
            sb.append(fc);
            sb.append("\t");
            sb.append(list.size());
            sb.append("\t");
            sb.append(list);
            sb.append("\n");
            ++i;
        }
        sb.append(this.map.size() + " unique elements (" + this.count + ")");
        sb.append("\n");
        return sb.toString();
    }

    class Counter {
        int count;

        public Counter(int count) {
            this.count = count;
        }

        public void inc() {
            ++this.count;
        }

        public void inc(int l) {
            this.count += l;
        }

        public int get() {
            return this.count;
        }

        public String toString() {
            return Integer.toString(this.count);
        }
    }
}

