/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class Range
implements Comparable<Range> {
    private final int begin;
    private final int end;

    @Nullable
    public static Range valueOf(String string) {
        String trimmedSpan = string.trim();
        int delimiter = trimmedSpan.indexOf(44);
        int begin = Integer.parseInt(trimmedSpan.substring(0, delimiter));
        int end = Integer.parseInt(trimmedSpan.substring(delimiter + 1));
        return Range.create(begin, end);
    }

    @Nullable
    public static Range create(int singletonValue) {
        return singletonValue < 0 ? null : new Range(singletonValue, singletonValue + 1);
    }

    @Nullable
    public static Range create(int begin, int end) {
        if (begin < 0 || begin >= end) {
            return null;
        }
        return new Range(begin, end);
    }

    @Nullable
    public static Range intersection(Iterable<Range> ranges) {
        int begin = Integer.MIN_VALUE;
        int end = Integer.MAX_VALUE;
        for (Range range : ranges) {
            if ((begin = Math.max(begin, range.begin)) < (end = Math.min(end, range.end))) continue;
            return null;
        }
        return begin > Integer.MIN_VALUE ? new Range(begin, end) : null;
    }

    @Nullable
    public static Range enclose(int ... values) {
        int begin = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (int value : values) {
            if (value < 0) {
                return null;
            }
            begin = Math.min(begin, value);
            end = Math.max(end, value + 1);
        }
        return begin >= end ? null : new Range(begin, end);
    }

    @Nullable
    public static Range enclose(Iterable<Range> ranges) {
        int begin = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (Range range : ranges) {
            begin = Math.min(range.begin, begin);
            end = Math.max(range.end, end);
        }
        return begin >= end ? null : new Range(begin, end);
    }

    public static List<Range> merge(Iterable<Range> ranges) {
        List sortedRanges = Ordering.natural().sortedCopy(ranges);
        int i = 0;
        while (i < sortedRanges.size() - 1) {
            Range range1 = (Range)sortedRanges.get(i);
            Range range2 = (Range)sortedRanges.get(i + 1);
            if (range1.end >= range2.begin) {
                Range merged = new Range(Math.min(range1.begin, range2.begin), Math.max(range1.end, range2.end));
                sortedRanges.set(i, merged);
                sortedRanges.remove(i + 1);
                continue;
            }
            ++i;
        }
        return sortedRanges;
    }

    public static List<Range> separate(Iterable<Range> ranges) {
        ArrayList sortedRanges = Lists.newArrayList(ranges);
        boolean overlaps = true;
        block0: while (overlaps) {
            overlaps = false;
            Collections.sort(sortedRanges);
            for (int i = 0; i < sortedRanges.size() - 1; ++i) {
                Range range1 = (Range)sortedRanges.get(i);
                Range range2 = (Range)sortedRanges.get(i + 1);
                if (range1.end <= range2.begin) continue;
                sortedRanges.remove(i);
                if (range1.begin < range2.begin) {
                    sortedRanges.add(new Range(range1.begin, range2.begin));
                }
                if (range1.end < range2.end) {
                    sortedRanges.remove(i);
                    sortedRanges.add(new Range(range2.begin, range1.end));
                    sortedRanges.add(new Range(range1.end, range2.end));
                } else if (range1.end > range2.end) {
                    sortedRanges.add(new Range(range2.end, range1.end));
                }
                overlaps = true;
                continue block0;
            }
        }
        return sortedRanges;
    }

    private Range(int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    public int begin() {
        return this.begin;
    }

    public int end() {
        return this.end;
    }

    public int length() {
        return this.end - this.begin;
    }

    public boolean contains(int value) {
        return value >= this.begin && value < this.end;
    }

    public boolean contains(Range range) {
        return this.begin <= range.begin && this.end >= range.end;
    }

    public boolean containedIn(Iterable<Range> ranges) {
        for (Range range : ranges) {
            if (!range.contains(this)) continue;
            return true;
        }
        return false;
    }

    public boolean overlaps(Range range) {
        return this.end > range.begin && this.begin < range.end;
    }

    public boolean overlaps(Iterable<Range> ranges) {
        for (Range range : ranges) {
            if (!this.overlaps(range)) continue;
            return true;
        }
        return false;
    }

    public boolean connectedWith(Range range) {
        return this.end >= range.begin && this.begin <= range.end;
    }

    public boolean connectedWith(Iterable<Range> ranges) {
        for (Range range : ranges) {
            if (!this.connectedWith(range)) continue;
            return true;
        }
        return false;
    }

    public int distance(Range range) {
        if (range.begin > this.end) {
            return range.begin - this.end;
        }
        if (range.end < this.begin) {
            return this.begin - range.end;
        }
        return 0;
    }

    public List<Range> split(Iterable<Range> ranges) {
        List<Range> sortedRanges = Range.separate(ranges);
        ArrayList result = Lists.newArrayList();
        int index = this.begin;
        for (Range range : sortedRanges) {
            if (range.begin >= this.end) break;
            if (range.begin > index) {
                result.add(new Range(index, range.begin));
                index = range.begin;
            }
            if (range.end <= index) continue;
            int end = Math.min(range.end, this.end);
            result.add(index == range.begin && end == range.end ? range : new Range(index, end));
            index = end;
        }
        if (index < this.end) {
            result.add(new Range(index, this.end));
        }
        return result;
    }

    @Override
    public int compareTo(Range range) {
        int result = this.begin - range.begin;
        if (result == 0) {
            result = range.end - this.end;
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Range)) {
            return false;
        }
        Range other = (Range)object;
        return this.begin == other.begin && this.end == other.end;
    }

    public int hashCode() {
        return this.begin * 37 + this.end;
    }

    public String toString() {
        return this.begin + "," + this.end;
    }
}

