/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import eu.fbk.utils.core.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IO {
    private static final Logger LOGGER = LoggerFactory.getLogger(IO.class);
    public static final Set<String> compressedExtensions = new HashSet<String>();
    private static final int BUFFER_SIZE;
    private static final int BUFFER_NUM_READ;
    private static final int BUFFER_NUM_WRITE;
    private static final Map<Path, Object[]> LOCK_DATA;

    @Nullable
    public static <T> T closeQuietly(@Nullable T object) {
        if (object instanceof AutoCloseable) {
            try {
                ((AutoCloseable)object).close();
            }
            catch (Throwable ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOGGER.error("Error closing " + object.getClass().getSimpleName(), ex);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public static FileLock tryLock(final Path path, boolean shared, boolean lenient) throws IOException {
        Objects.requireNonNull(path);
        var3_3 = IO.LOCK_DATA;
        synchronized (var3_3) {
            entry = IO.LOCK_DATA.get(path);
            if (entry == null) {
                channel = FileChannel.open(path, new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE});
                try {
                    lock = channel.tryLock(0L, 0x7FFFFFFFFFFFFFFFL, shared);
                    refCount = new AtomicInteger(1);
                    if (lock == null) ** GOTO lbl33
                    processName = ManagementFactory.getRuntimeMXBean().getName();
                    channel.write(ByteBuffer.wrap(processName.getBytes(Charsets.UTF_8)));
                    IO.LOCK_DATA.put(path, new Object[]{lock, refCount});
                }
                catch (Throwable ex) {
                    IO.LOCK_DATA.remove(path);
                    Throwables.throwIfInstanceOf((Throwable)ex, IOException.class);
                    Throwables.throwIfUnchecked((Throwable)ex);
                    throw new RuntimeException(ex);
                }
            } else {
                oldLock = (FileLock)entry[0];
                refCount = (AtomicInteger)entry[1];
                if (oldLock.isShared()) {
                    lock = oldLock;
                    refCount.incrementAndGet();
                } else {
                    lock = null;
                }
            }
lbl33:
            // 4 sources

            if (lock == null) {
                if (lenient) {
                    return null;
                }
                throw new IllegalStateException(path + " already locked elsewhere");
            }
            return new FileLock(lock.channel(), lock.position(), lock.size(), lock.isShared()){
                private boolean valid;
                {
                    super(x0, x1, x2, x3);
                    this.valid = true;
                }

                @Override
                public synchronized boolean isValid() {
                    return this.valid;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized void release() throws IOException {
                    if (!this.valid) {
                        return;
                    }
                    try {
                        Map map = LOCK_DATA;
                        synchronized (map) {
                            if (refCount.decrementAndGet() == 0) {
                                try {
                                    lock.release();
                                }
                                finally {
                                    LOCK_DATA.remove(path);
                                    IO.closeQuietly(lock.channel());
                                    if (!lock.isShared()) {
                                        Files.deleteIfExists(path);
                                    }
                                }
                            }
                        }
                    }
                    finally {
                        this.valid = false;
                    }
                }
            };
        }
    }

    public static URL extractURL(String location) {
        Objects.requireNonNull(location);
        try {
            String s;
            int index = location.indexOf(58);
            if (index < 0) {
                return new File(location).toURI().toURL();
            }
            String string = s = location.charAt(0) != '.' ? location : location.substring(index + 1);
            if (s.startsWith("classpath:")) {
                s = s.substring("classpath:".length());
                return Objects.requireNonNull(IO.class.getResource(s));
            }
            try {
                return new URL(s);
            }
            catch (MalformedURLException ex) {
                return new File(s).toURI().toURL();
            }
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Cannot extract URL from '" + location + "'", ex);
        }
    }

    public static File extractFile(String location) {
        URL url = IO.extractURL(location);
        if (!"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Not a file " + location);
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid file:// URL: " + location);
        }
    }

    public static String extractExtension(String location) {
        int nameStart;
        int extStart;
        Objects.requireNonNull(location);
        int index = location.indexOf(58);
        int extEnd = location.length();
        if (index >= 0) {
            if (location.charAt(0) == '.') {
                return location.substring(0, index);
            }
            int index2 = location.lastIndexOf(35);
            index2 = index2 >= 0 ? index2 : location.length();
            extEnd = location.lastIndexOf(63, index2);
            extEnd = extEnd >= 0 ? extEnd : index2;
        }
        return (extStart = location.indexOf(46, nameStart = Math.max(-1, location.lastIndexOf(47, extEnd)) + 1)) < 0 ? "" : location.substring(extStart, extEnd);
    }

    public static String extractType(String location) {
        String ext = IO.extractExtension(location);
        String[] parts = ext.split("\\.+");
        String last = null;
        for (int i = parts.length - 1; i >= 0; --i) {
            String part = parts[i];
            if (compressedExtensions.contains("." + part) || part.length() == 0) continue;
            last = part;
            break;
        }
        return last;
    }

    public static InputStream read(String location) throws IOException {
        String ext = IO.extractExtension(location);
        final URL url = IO.extractURL(location);
        ProcessBuilder builder = null;
        if (ext.endsWith(".bz2")) {
            builder = Environment.getProcessBuilder("bzip2", "-dck");
        } else if (ext.endsWith(".gz")) {
            builder = Environment.getProcessBuilder("gzip", "-dc");
        } else if (ext.endsWith(".xz")) {
            builder = Environment.getProcessBuilder("xz", "-dc");
        } else if (ext.endsWith(".7z")) {
            builder = Environment.getProcessBuilder("7za", "-so", "e");
        } else if (ext.endsWith(".lz4")) {
            builder = Environment.getProcessBuilder("lz4", "-dc");
        }
        if ("file".equals(url.getProtocol())) {
            File file;
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Invalid file:// URL: " + location);
            }
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            if (builder == null) {
                LOGGER.debug("Reading file {}", (Object)file);
                return new FileInputStream(file);
            }
            LOGGER.debug("Reading file {} using {}", (Object)file, (Object)Joiner.on((char)' ').join(builder.command()));
            builder.command().add(file.getAbsolutePath());
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            Process process = builder.start();
            return process.getInputStream();
        }
        final InputStream stream = url.openStream();
        if (builder == null) {
            LOGGER.debug("Downloading file {}", (Object)url);
            return stream;
        }
        LOGGER.debug("Downloading file {} using {}", (Object)url, (Object)Joiner.on((char)' ').join(builder.command()));
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        final Process process = builder.start();
        Environment.getPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    int count;
                    byte[] buffer = new byte[8192];
                    while ((count = stream.read(buffer)) >= 0) {
                        process.getOutputStream().write(buffer, 0, count);
                    }
                    process.getOutputStream().close();
                }
                catch (Throwable ex) {
                    LOGGER.error("Error reading from " + url, ex);
                    process.destroy();
                }
                finally {
                    IO.closeQuietly(stream);
                }
            }
        });
        return process.getInputStream();
    }

    public static OutputStream write(String location) throws IOException {
        return IO.writeOrAppend(location, false);
    }

    public static OutputStream append(String location) throws IOException {
        return IO.writeOrAppend(location, true);
    }

    private static OutputStream writeOrAppend(String location, boolean append) throws IOException {
        File file;
        String ext = IO.extractExtension(location);
        URL url = IO.extractURL(location);
        if (!"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Cannot write to non-file URL " + location);
        }
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid file:// URL: " + location);
        }
        ProcessBuilder builder = null;
        if (ext.endsWith(".bz2")) {
            builder = Environment.getProcessBuilder("bzip2", "-c", "-9");
        } else if (ext.endsWith(".gz")) {
            builder = Environment.getProcessBuilder("gzip", "-c", "-9");
        } else if (ext.endsWith(".xz")) {
            builder = Environment.getProcessBuilder("xz", "-c", "-9");
        } else if (ext.endsWith(".lz4")) {
            builder = Environment.getProcessBuilder("lz4", "-c", "-9");
        }
        if (builder == null) {
            LOGGER.debug("Writing file {}", (Object)file);
            return new FileOutputStream(file, append);
        }
        final String cmd = Joiner.on((char)' ').join(builder.command());
        LOGGER.debug("Writing file {} using {}", (Object)file, (Object)cmd);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        builder.redirectOutput(append ? ProcessBuilder.Redirect.appendTo(file) : ProcessBuilder.Redirect.to(file));
        final Process process = builder.start();
        return new FilterOutputStream(process.getOutputStream()){
            private final AtomicBoolean closed;
            {
                super(x0);
                this.closed = new AtomicBoolean(false);
            }

            @Override
            public void write(int b) throws IOException {
                this.out.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.out.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                if (this.closed.compareAndSet(false, true)) {
                    LOGGER.debug("Completing '{}'", (Object)cmd);
                    this.out.flush();
                    this.out.close();
                    try {
                        int code = process.waitFor();
                        LOGGER.debug("Process completed with exit code {}", (Object)code);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new IOException("Didn't wait till IO completion", ex);
                    }
                    finally {
                        process.destroy();
                    }
                }
            }
        };
    }

    public static InputStream buffer(InputStream stream) {
        return new SimpleBufferedInputStream(stream);
    }

    public static OutputStream buffer(OutputStream stream) {
        return new SimpleBufferedOutputStream(stream);
    }

    public static Reader buffer(Reader reader) {
        return new SimpleBufferedReader(reader);
    }

    public static Writer buffer(Writer writer) {
        return new SimpleBufferedWriter(writer);
    }

    public static InputStream parallelBuffer(InputStream stream, byte delimiter) {
        return new ParallelBufferedInputStream(stream, delimiter);
    }

    public static OutputStream parallelBuffer(OutputStream stream, byte delimiter) {
        return new ParallelBufferedOutputStream(stream, delimiter);
    }

    public static Reader parallelBuffer(Reader reader, char delimiter) {
        return new ParallelBufferedReader(reader, delimiter);
    }

    public static Writer parallelBuffer(Writer writer, char delimiter) {
        return new ParallelBufferedWriter(writer, delimiter);
    }

    public static Reader utf8Reader(InputStream stream) {
        return new UTF8Reader(stream);
    }

    public static Writer utf8Writer(OutputStream stream) {
        return new UTF8Writer(stream);
    }

    private static void propagate(Throwable ex) throws IOException {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex);
    }

    private IO() {
    }

    static {
        compressedExtensions.add(".bz2");
        compressedExtensions.add(".gz");
        compressedExtensions.add(".xz");
        compressedExtensions.add(".7z");
        compressedExtensions.add(".lz4");
        BUFFER_SIZE = Integer.parseInt(Environment.getProperty("utils.io.buffer.size", "65536"));
        BUFFER_NUM_READ = Integer.parseInt(Environment.getProperty("utils.io.buffer.numr", "256"));
        BUFFER_NUM_WRITE = Integer.parseInt(Environment.getProperty("utils.io.buffer.numw", "16"));
        LOCK_DATA = new HashMap<Path, Object[]>();
    }

    private static final class UTF8Writer
    extends Writer {
        private final OutputStream stream;
        private boolean closed;

        UTF8Writer(OutputStream stream) {
            this.stream = stream;
            this.closed = false;
        }

        @Override
        public void write(int c) throws IOException {
            if (c <= 127) {
                this.stream.write(c);
            } else {
                this.writeHelper(c);
            }
        }

        private void writeHelper(int c) throws IOException {
            if (c <= 2047) {
                this.stream.write(0xC0 | c >>> 6);
                this.stream.write(0x80 | c & 0x3F);
            } else if (c <= 65535) {
                this.stream.write(0xE0 | c >>> 12);
                this.stream.write(0x80 | c >>> 6 & 0x3F);
                this.stream.write(0x80 | c & 0x3F);
            } else if (c <= 0x1FFFFF) {
                this.stream.write(0xF0 | c >>> 18);
                this.stream.write(0x80 | c >>> 12 & 0x3F);
                this.stream.write(0x80 | c >>> 6 & 0x3F);
                this.stream.write(0x80 | c & 0x3F);
            } else {
                throw new IOException("Invalid code point " + c);
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int end = off + len;
            for (int index = off; index < end; ++index) {
                this.write(cbuf[index]);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            int end = off + len;
            for (int index = off; index < end; ++index) {
                this.write(str.charAt(index));
            }
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            UTF8Writer uTF8Writer = this;
            synchronized (uTF8Writer) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.stream.close();
        }
    }

    private static final class UTF8Reader
    extends Reader {
        private final InputStream stream;
        private boolean closed;

        public UTF8Reader(InputStream stream) {
            this.stream = stream;
            this.closed = false;
        }

        @Override
        public int read() throws IOException {
            int b0 = this.stream.read();
            return (b0 & 0xFFFFFF80) == 0 ? b0 : this.readHelper(b0);
        }

        private int readHelper(int b0) throws IOException {
            if (b0 < 0) {
                return -1;
            }
            if (b0 <= 223) {
                int b1 = this.stream.read();
                if ((b1 & 0xC0) == 128) {
                    return (b0 & 0x1F) << 6 | b1 & 0x3F;
                }
            } else if (b0 <= 239) {
                int b1 = this.stream.read();
                int b2 = this.stream.read();
                if ((b1 & 0xC0) == 128 && (b2 & 0xC0) == 128) {
                    return (b0 & 0xF) << 12 | (b1 & 0x3F) << 6 | b2 & 0x3F;
                }
            } else if (b0 <= 247) {
                int b1 = this.stream.read();
                int b2 = this.stream.read();
                int b3 = this.stream.read();
                if ((b1 & 0xC0) == 128 && (b2 & 0xC0) == 128 && (b3 & 0xC0) == 128) {
                    return (b0 & 7) << 18 | (b1 & 0x3F) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F;
                }
            }
            throw new IOException("Invalid/truncated UTF8 code");
        }

        @Override
        public int read(char[] buf, int off, int len) throws IOException {
            if ((off | len | off + len | buf.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                this.checkNotClosed();
                return 0;
            }
            int index = off;
            int c = this.read();
            if (c < 0) {
                return -1;
            }
            buf[index++] = (char)c;
            int end = off + Math.min(len, this.stream.available() / 2);
            while (index < end && (c = this.read()) >= 0) {
                buf[index++] = (char)c;
            }
            return index - off;
        }

        @Override
        public long skip(long n) throws IOException {
            int c;
            int skippable;
            if (n == 0L) {
                this.checkNotClosed();
                return 0L;
            }
            int toSkip = skippable = this.stream.available() / 2;
            while ((c = this.read()) >= 0 && --toSkip > 0) {
            }
            return skippable - toSkip;
        }

        @Override
        public boolean ready() throws IOException {
            return this.stream.available() >= 4;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("Mark not supported");
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            UTF8Reader uTF8Reader = this;
            synchronized (uTF8Reader) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.stream.close();
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Reader has been closed");
            }
        }
    }

    private static final class ParallelBufferedOutputStream
    extends OutputStream {
        private Emitter emitter;
        private final byte delimiter;
        private final List<ByteBuffer> buffers;
        private byte[] buffer;
        private int count;
        private int threshold;
        private boolean closed;

        ParallelBufferedOutputStream(OutputStream stream, byte delimiter) {
            this.emitter = Emitter.forStream(stream);
            this.delimiter = delimiter;
            this.buffers = new ArrayList<ByteBuffer>();
            this.buffer = new byte[2 * BUFFER_SIZE];
            this.count = 0;
            this.threshold = BUFFER_SIZE;
            this.closed = false;
            this.emitter.open();
        }

        @Override
        public void write(int c) throws IOException {
            if (this.count < this.threshold) {
                this.buffer[this.count++] = (byte)c;
            } else {
                this.writeAndTryFlush((byte)c);
            }
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            int available = this.threshold - this.count;
            if (available >= len) {
                System.arraycopy(buf, off, this.buffer, this.count, len);
                this.count += len;
                return;
            }
            if (available > 0) {
                System.arraycopy(buf, off, this.buffer, this.count, available);
                this.count += available;
                off += available;
                len -= available;
            }
            int end = off + len;
            while (off < end) {
                this.writeAndTryFlush(buf[off++]);
            }
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            List<ByteBuffer> list = this.buffers;
            synchronized (list) {
                if (this.closed) {
                    return;
                }
                this.flushBuffers();
                this.closed = true;
            }
            this.buffers.clear();
            this.buffer = null;
            this.emitter.close();
            this.emitter = null;
        }

        private void writeAndTryFlush(byte c) throws IOException {
            this.buffer[this.count++] = c;
            if (c == this.delimiter) {
                this.flushBuffers();
            } else if (this.count == this.buffer.length) {
                this.checkNotClosed();
                this.buffers.add(ByteBuffer.wrap(this.buffer));
                this.buffer = new byte[BUFFER_SIZE];
                this.count = 0;
                this.threshold = 0;
            }
        }

        private void flushBuffers() throws IOException {
            this.checkNotClosed();
            if (this.count > 0) {
                ByteBuffer buffer = ByteBuffer.wrap(this.buffer);
                buffer.limit(this.count);
                this.buffers.add(buffer);
            }
            this.emitter.emit(this.buffers);
            if (!this.buffers.isEmpty()) {
                this.buffer = this.buffers.get(0).array();
                this.buffers.clear();
            }
            this.count = 0;
            this.threshold = BUFFER_SIZE;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Writer has been closed");
            }
        }

        private static class Emitter
        implements Runnable {
            private static final Map<OutputStream, Emitter> EMITTERS = new WeakHashMap<OutputStream, Emitter>();
            private static final Object EOF = new Object();
            private final BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(IO.access$500(), false);
            private final List<ByteBuffer> buffers;
            private OutputStream stream;
            private int references;
            private Throwable exception;
            private final CountDownLatch latch;

            private Emitter(OutputStream stream) {
                this.stream = stream;
                this.buffers = new ArrayList<ByteBuffer>();
                this.references = 0;
                this.exception = null;
                this.latch = new CountDownLatch(1);
                Environment.getPool().submit(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void release(ByteBuffer buffer) {
                List<ByteBuffer> list = this.buffers;
                synchronized (list) {
                    if (this.buffers.size() < BUFFER_NUM_WRITE + Environment.getCores() + 1) {
                        buffer.clear();
                        this.buffers.add(buffer);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ByteBuffer allocate() {
                List<ByteBuffer> list = this.buffers;
                synchronized (list) {
                    if (!this.buffers.isEmpty()) {
                        return this.buffers.remove(this.buffers.size() - 1);
                    }
                }
                return ByteBuffer.allocate(2 * BUFFER_SIZE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void open() {
                Emitter emitter = this;
                synchronized (emitter) {
                    if (this.references < 0) {
                        throw new IllegalStateException("Stream has been closed");
                    }
                    ++this.references;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                Object object = this;
                synchronized (object) {
                    --this.references;
                    if (this.references != 0) {
                        return;
                    }
                    this.references = -1;
                }
                while (true) {
                    try {
                        this.queue.put(EOF);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                while (true) {
                    try {
                        this.latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                object = EMITTERS;
                synchronized (object) {
                    EMITTERS.remove(this.stream);
                }
                this.queue.clear();
                this.buffers.clear();
                this.stream = null;
                object = this;
                synchronized (object) {
                    if (this.exception != null) {
                        IO.propagate(this.exception);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void emit(List<ByteBuffer> buffers) throws IOException {
                try {
                    Emitter emitter = this;
                    synchronized (emitter) {
                        if (this.exception != null) {
                            throw this.exception;
                        }
                    }
                    this.queue.put(new ArrayList<ByteBuffer>(buffers));
                    buffers.clear();
                    buffers.add(this.allocate());
                }
                catch (Throwable ex) {
                    IO.propagate(ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object;
                    while ((object = this.queue.take()) != EOF) {
                        List buffers = (List)object;
                        for (ByteBuffer buffer : buffers) {
                            this.stream.write(buffer.array(), buffer.position(), buffer.limit());
                        }
                        if (buffers.isEmpty()) continue;
                        this.release((ByteBuffer)buffers.get(0));
                    }
                }
                catch (Throwable ex) {
                    Emitter emitter = this;
                    synchronized (emitter) {
                        this.exception = ex;
                    }
                    this.queue.clear();
                }
                finally {
                    IO.closeQuietly(this.stream);
                    this.latch.countDown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Emitter forStream(OutputStream stream) {
                Map<OutputStream, Emitter> map = EMITTERS;
                synchronized (map) {
                    Emitter emitter = EMITTERS.get(stream);
                    if (emitter == null) {
                        emitter = new Emitter(stream);
                        EMITTERS.put(stream, emitter);
                    }
                    return emitter;
                }
            }
        }
    }

    private static final class ParallelBufferedInputStream
    extends InputStream {
        private Fetcher fetcher;
        private final List<ByteBuffer> buffers;
        private int index;
        private byte[] buffer;
        private int count;
        private int pos;
        private boolean closed;

        ParallelBufferedInputStream(InputStream stream, byte delimiter) {
            this.fetcher = Fetcher.forStream(stream, delimiter);
            this.buffers = new ArrayList<ByteBuffer>();
            this.index = 0;
            this.buffer = null;
            this.count = 0;
            this.pos = 0;
            this.closed = false;
            this.fetcher.open();
        }

        @Override
        public int read() throws IOException {
            if (this.pos >= this.count) {
                this.fill();
                if (this.count == 0) {
                    return -1;
                }
            }
            return this.buffer[this.pos++] & 0xFF;
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if ((off | len | off + len | buf.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                this.checkNotClosed();
                return 0;
            }
            int available = this.count - this.pos;
            if (available == 0) {
                this.fill();
                if (this.count == 0) {
                    return -1;
                }
            }
            int n = available > len ? len : available;
            System.arraycopy(this.buffer, this.pos, buf, off, n);
            this.pos += n;
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                this.checkNotClosed();
                return 0L;
            }
            int available = this.count - this.pos;
            if (available == 0) {
                this.fill();
                available = this.count;
            }
            long skipped = (long)available < n ? (long)available : n;
            this.pos = (int)((long)this.pos + skipped);
            return skipped;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("Mark not supported");
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            List<ByteBuffer> list = this.buffers;
            synchronized (list) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.count = this.pos;
            this.buffers.clear();
            this.fetcher.close();
            this.fetcher = null;
        }

        private void fill() throws IOException {
            this.checkNotClosed();
            if (this.buffer != null) {
                this.buffer = null;
                this.pos = 0;
                this.count = 0;
            }
            if (this.index == this.buffers.size()) {
                this.fetcher.fetch(this.buffers);
                this.index = 0;
            }
            if (this.index < this.buffers.size()) {
                ByteBuffer buffer = this.buffers.get(this.index++);
                this.buffer = buffer.array();
                this.count = buffer.limit();
            }
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Stream has been closed");
            }
        }

        private static final class Fetcher
        implements Runnable {
            private static final Map<InputStream, Fetcher> FETCHERS = new WeakHashMap<InputStream, Fetcher>();
            private static final Object EOF = new Object();
            private final BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(IO.access$300(), false);
            private InputStream stream;
            private final byte delimiter;
            private final List<ByteBuffer> buffers;
            private int references;
            private Throwable exception;
            private final CountDownLatch latch;

            private Fetcher(InputStream stream, byte delimiter) {
                this.stream = stream;
                this.delimiter = delimiter;
                this.buffers = new ArrayList<ByteBuffer>();
                this.references = 0;
                this.exception = null;
                this.latch = new CountDownLatch(1);
                Environment.getPool().submit(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void release(ByteBuffer buffer) {
                List<ByteBuffer> list = this.buffers;
                synchronized (list) {
                    if (this.buffers.size() < BUFFER_NUM_READ + Environment.getCores() + 1) {
                        buffer.clear();
                        this.buffers.add(buffer);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ByteBuffer allocate() {
                List<ByteBuffer> list = this.buffers;
                synchronized (list) {
                    if (!this.buffers.isEmpty()) {
                        return this.buffers.remove(this.buffers.size() - 1);
                    }
                }
                return ByteBuffer.allocate(2 * BUFFER_SIZE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void open() {
                Fetcher fetcher = this;
                synchronized (fetcher) {
                    if (this.references < 0) {
                        throw new IllegalStateException("Reader has been closed");
                    }
                    ++this.references;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                Object object = this;
                synchronized (object) {
                    --this.references;
                    if (this.references != 0) {
                        return;
                    }
                    this.references = -1;
                }
                this.queue.clear();
                while (true) {
                    try {
                        this.latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                object = FETCHERS;
                synchronized (object) {
                    FETCHERS.remove(this.stream);
                }
                this.queue.clear();
                this.buffers.clear();
                this.stream = null;
                object = this;
                synchronized (object) {
                    if (this.exception != null) {
                        IO.propagate(this.exception);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fetch(List<ByteBuffer> buffers) throws IOException {
                try {
                    Fetcher fetcher = this;
                    synchronized (fetcher) {
                        if (this.exception != null) {
                            throw this.exception;
                        }
                    }
                    for (ByteBuffer buffer : buffers) {
                        this.release(buffer);
                    }
                    buffers.clear();
                    Object object = this.queue.take();
                    if (object == EOF) {
                        this.queue.add(EOF);
                        return;
                    }
                    buffers.addAll((List)object);
                }
                catch (IOException | Error | RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new IOException(ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ByteBuffer restBuffer = this.allocate();
                    ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
                    boolean eof = false;
                    block13: while (!eof) {
                        int curLastIndex;
                        Fetcher fetcher = this;
                        synchronized (fetcher) {
                            if (this.references < 0) {
                                break;
                            }
                        }
                        ByteBuffer curBuffer = restBuffer;
                        byte[] array = curBuffer.array();
                        while (!eof && curBuffer.hasRemaining()) {
                            int len;
                            int offset = curBuffer.position();
                            int n = this.stream.read(array, offset, len = curBuffer.remaining());
                            eof = n < 0;
                            if (eof) continue;
                            curBuffer.position(offset + n);
                        }
                        curBuffer.flip();
                        buffers.add(curBuffer);
                        restBuffer = this.allocate();
                        if (eof) continue;
                        for (int i = curLastIndex = curBuffer.limit() - 1; i >= 0; --i) {
                            if (array[i] != this.delimiter) continue;
                            restBuffer.position(curLastIndex - i);
                            System.arraycopy(array, i + 1, restBuffer.array(), 0, restBuffer.position());
                            curBuffer.limit(i + 1);
                            this.queue.put(buffers);
                            buffers = new ArrayList();
                            continue block13;
                        }
                    }
                    this.queue.put(buffers);
                }
                catch (Throwable ex) {
                    Fetcher fetcher = this;
                    synchronized (fetcher) {
                        this.exception = ex;
                    }
                }
                try {
                    IO.closeQuietly(this.stream);
                    while (true) {
                        try {
                            this.queue.put(EOF);
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.latch.countDown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Fetcher forStream(InputStream stream, byte delimiter) {
                Map<InputStream, Fetcher> map = FETCHERS;
                synchronized (map) {
                    Fetcher fetcher = FETCHERS.get(stream);
                    if (fetcher == null) {
                        fetcher = new Fetcher(stream, delimiter);
                        FETCHERS.put(stream, fetcher);
                    } else if (fetcher.delimiter != delimiter) {
                        throw new IllegalStateException("Already reading from stream " + stream + " using delimiter " + delimiter);
                    }
                    return fetcher;
                }
            }
        }
    }

    private static final class ParallelBufferedWriter
    extends Writer {
        private Emitter emitter;
        private final char delimiter;
        private final List<CharBuffer> buffers;
        private char[] buffer;
        private int count;
        private int threshold;
        private boolean closed;

        ParallelBufferedWriter(Writer writer, char delimiter) {
            this.emitter = Emitter.forWriter(writer);
            this.delimiter = delimiter;
            this.buffers = new ArrayList<CharBuffer>();
            this.buffer = new char[2 * BUFFER_SIZE];
            this.count = 0;
            this.threshold = BUFFER_SIZE;
            this.closed = false;
            this.emitter.open();
        }

        @Override
        public void write(int c) throws IOException {
            if (this.count < this.threshold) {
                this.buffer[this.count++] = (char)c;
            } else {
                this.writeAndTryFlush((char)c);
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int available = this.threshold - this.count;
            if (available >= len) {
                System.arraycopy(cbuf, off, this.buffer, this.count, len);
                this.count += len;
                return;
            }
            if (available > 0) {
                System.arraycopy(cbuf, off, this.buffer, this.count, available);
                this.count += available;
                off += available;
                len -= available;
            }
            int end = off + len;
            while (off < end) {
                this.writeAndTryFlush(cbuf[off++]);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            int available = this.threshold - this.count;
            int end = off + len;
            if (available >= len) {
                str.getChars(off, end, this.buffer, this.count);
                this.count += len;
                return;
            }
            if (available > 0) {
                str.getChars(off, off + available, this.buffer, this.count);
                this.count += available;
                off += available;
                len -= available;
            }
            while (off < end) {
                this.writeAndTryFlush(str.charAt(off++));
            }
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            List<CharBuffer> list = this.buffers;
            synchronized (list) {
                if (this.closed) {
                    return;
                }
                this.flushBuffers();
                this.closed = true;
            }
            this.buffers.clear();
            this.buffer = null;
            this.emitter.close();
            this.emitter = null;
        }

        private void writeAndTryFlush(char c) throws IOException {
            this.buffer[this.count++] = c;
            if (c == this.delimiter) {
                this.flushBuffers();
            } else if (this.count == this.buffer.length) {
                this.checkNotClosed();
                this.buffers.add(CharBuffer.wrap(this.buffer));
                this.buffer = new char[BUFFER_SIZE];
                this.count = 0;
                this.threshold = 0;
            }
        }

        private void flushBuffers() throws IOException {
            this.checkNotClosed();
            if (this.count > 0) {
                CharBuffer cb = CharBuffer.wrap(this.buffer);
                cb.limit(this.count);
                this.buffers.add(cb);
            }
            this.emitter.emit(this.buffers);
            if (!this.buffers.isEmpty()) {
                this.buffer = this.buffers.get(0).array();
                this.buffers.clear();
            }
            this.count = 0;
            this.threshold = BUFFER_SIZE;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Writer has been closed");
            }
        }

        private static class Emitter
        implements Runnable {
            private static final Map<Writer, Emitter> EMITTERS = new WeakHashMap<Writer, Emitter>();
            private static final Object EOF = new Object();
            private final BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(IO.access$500(), false);
            private final List<CharBuffer> buffers;
            private Writer writer;
            private int references;
            private Throwable exception;
            private final CountDownLatch latch;

            private Emitter(Writer writer) {
                this.writer = writer;
                this.buffers = new ArrayList<CharBuffer>();
                this.references = 0;
                this.exception = null;
                this.latch = new CountDownLatch(1);
                Environment.getPool().submit(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void release(CharBuffer buffer) {
                List<CharBuffer> list = this.buffers;
                synchronized (list) {
                    if (this.buffers.size() < BUFFER_NUM_WRITE + Environment.getCores() + 1) {
                        buffer.clear();
                        this.buffers.add(buffer);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private CharBuffer allocate() {
                List<CharBuffer> list = this.buffers;
                synchronized (list) {
                    if (!this.buffers.isEmpty()) {
                        return this.buffers.remove(this.buffers.size() - 1);
                    }
                }
                return CharBuffer.allocate(2 * BUFFER_SIZE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void open() {
                Emitter emitter = this;
                synchronized (emitter) {
                    if (this.references < 0) {
                        throw new IllegalStateException("Stream has been closed");
                    }
                    ++this.references;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                Object object = this;
                synchronized (object) {
                    --this.references;
                    if (this.references != 0) {
                        return;
                    }
                    this.references = -1;
                }
                while (true) {
                    try {
                        this.queue.put(EOF);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                while (true) {
                    try {
                        this.latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                object = EMITTERS;
                synchronized (object) {
                    EMITTERS.remove(this.writer);
                }
                this.queue.clear();
                this.buffers.clear();
                this.writer = null;
                object = this;
                synchronized (object) {
                    if (this.exception != null) {
                        IO.propagate(this.exception);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void emit(List<CharBuffer> buffers) throws IOException {
                try {
                    Emitter emitter = this;
                    synchronized (emitter) {
                        if (this.exception != null) {
                            throw this.exception;
                        }
                    }
                    this.queue.put(new ArrayList<CharBuffer>(buffers));
                    buffers.clear();
                    buffers.add(this.allocate());
                }
                catch (IOException | Error | RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new IOException(ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object;
                    while ((object = this.queue.take()) != EOF) {
                        List buffers = (List)object;
                        for (CharBuffer buffer : buffers) {
                            this.writer.write(buffer.array(), buffer.position(), buffer.limit());
                        }
                        if (buffers.isEmpty()) continue;
                        this.release((CharBuffer)buffers.get(0));
                    }
                }
                catch (Throwable ex) {
                    Emitter emitter = this;
                    synchronized (emitter) {
                        this.exception = ex;
                    }
                    this.queue.clear();
                }
                finally {
                    IO.closeQuietly(this.writer);
                    this.latch.countDown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Emitter forWriter(Writer writer) {
                Map<Writer, Emitter> map = EMITTERS;
                synchronized (map) {
                    Emitter manager = EMITTERS.get(writer);
                    if (manager == null) {
                        manager = new Emitter(writer);
                        EMITTERS.put(writer, manager);
                    }
                    return manager;
                }
            }
        }
    }

    private static final class ParallelBufferedReader
    extends Reader {
        private Fetcher fetcher;
        private final List<CharBuffer> buffers;
        private int index;
        private char[] buffer;
        private int count;
        private int pos;
        private boolean closed;

        ParallelBufferedReader(Reader reader, char delimiter) {
            this.fetcher = Fetcher.forReader(reader, delimiter);
            this.buffers = new ArrayList<CharBuffer>();
            this.index = 0;
            this.buffer = null;
            this.count = 0;
            this.pos = 0;
            this.closed = false;
            this.fetcher.open();
        }

        @Override
        public int read() throws IOException {
            if (this.pos >= this.count) {
                this.fill();
                if (this.count == 0) {
                    return -1;
                }
            }
            return this.buffer[this.pos++] & 0xFFFF;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if ((off | len | off + len | cbuf.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                this.checkNotClosed();
                return 0;
            }
            int available = this.count - this.pos;
            if (available == 0) {
                this.fill();
                if (this.count == 0) {
                    return -1;
                }
            }
            int n = available > len ? len : available;
            System.arraycopy(this.buffer, this.pos, cbuf, off, n);
            this.pos += n;
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                this.checkNotClosed();
                return 0L;
            }
            int available = this.count - this.pos;
            if (available == 0) {
                this.fill();
                available = this.count;
            }
            long skipped = (long)available < n ? (long)available : n;
            this.pos = (int)((long)this.pos + skipped);
            return skipped;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("Mark not supported");
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            List<CharBuffer> list = this.buffers;
            synchronized (list) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.count = this.pos;
            this.buffers.clear();
            this.fetcher.close();
            this.fetcher = null;
        }

        private void fill() throws IOException {
            this.checkNotClosed();
            if (this.buffer != null) {
                this.buffer = null;
                this.pos = 0;
                this.count = 0;
            }
            if (this.index == this.buffers.size()) {
                this.fetcher.fetch(this.buffers);
                this.index = 0;
            }
            if (this.index < this.buffers.size()) {
                CharBuffer cb = this.buffers.get(this.index++);
                this.buffer = cb.array();
                this.count = cb.limit();
            }
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Reader has been closed");
            }
        }

        private static final class Fetcher
        implements Runnable {
            private static final Map<Reader, Fetcher> FETCHERS = new WeakHashMap<Reader, Fetcher>();
            private static final Object EOF = new Object();
            private final BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(IO.access$300(), false);
            private Reader reader;
            private final char delimiter;
            private final List<CharBuffer> buffers;
            private int references;
            private Throwable exception;
            private final CountDownLatch latch;

            private Fetcher(Reader reader, char delimiter) {
                this.reader = reader;
                this.delimiter = delimiter;
                this.buffers = new ArrayList<CharBuffer>();
                this.references = 0;
                this.exception = null;
                this.latch = new CountDownLatch(1);
                Environment.getPool().submit(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void release(CharBuffer buffer) {
                List<CharBuffer> list = this.buffers;
                synchronized (list) {
                    if (this.buffers.size() < BUFFER_NUM_READ + Environment.getCores() + 1) {
                        buffer.clear();
                        this.buffers.add(buffer);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private CharBuffer allocate() {
                List<CharBuffer> list = this.buffers;
                synchronized (list) {
                    if (!this.buffers.isEmpty()) {
                        return this.buffers.remove(this.buffers.size() - 1);
                    }
                }
                return CharBuffer.allocate(BUFFER_SIZE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void open() {
                Fetcher fetcher = this;
                synchronized (fetcher) {
                    if (this.references < 0) {
                        throw new IllegalStateException("Reader has been closed");
                    }
                    ++this.references;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                Object object = this;
                synchronized (object) {
                    --this.references;
                    if (this.references != 0) {
                        return;
                    }
                    this.references = -1;
                }
                this.queue.clear();
                while (true) {
                    try {
                        this.latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                object = FETCHERS;
                synchronized (object) {
                    FETCHERS.remove(this.reader);
                }
                this.queue.clear();
                this.buffers.clear();
                this.reader = null;
                object = this;
                synchronized (object) {
                    if (this.exception != null) {
                        IO.propagate(this.exception);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fetch(List<CharBuffer> buffers) throws IOException {
                try {
                    Fetcher fetcher = this;
                    synchronized (fetcher) {
                        if (this.exception != null) {
                            throw this.exception;
                        }
                    }
                    for (CharBuffer buffer : buffers) {
                        this.release(buffer);
                    }
                    buffers.clear();
                    Object object = this.queue.take();
                    if (object == EOF) {
                        this.queue.add(EOF);
                        return;
                    }
                    buffers.addAll((List)object);
                }
                catch (IOException | Error | RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new IOException(ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CharBuffer restBuffer = this.allocate();
                    ArrayList<CharBuffer> buffers = new ArrayList<CharBuffer>();
                    boolean eof = false;
                    block13: while (!eof) {
                        int curLastIndex;
                        Fetcher fetcher = this;
                        synchronized (fetcher) {
                            if (this.references < 0) {
                                break;
                            }
                        }
                        CharBuffer curBuffer = restBuffer;
                        while (!eof && curBuffer.hasRemaining()) {
                            int n = this.reader.read(curBuffer);
                            eof = n < 0;
                        }
                        curBuffer.flip();
                        buffers.add(curBuffer);
                        restBuffer = this.allocate();
                        if (eof) continue;
                        char[] curChars = curBuffer.array();
                        for (int i = curLastIndex = curBuffer.limit() - 1; i >= 0; --i) {
                            if (curChars[i] != this.delimiter) continue;
                            restBuffer.position(curLastIndex - i);
                            System.arraycopy(curChars, i + 1, restBuffer.array(), 0, restBuffer.position());
                            curBuffer.limit(i + 1);
                            this.queue.put(buffers);
                            buffers = new ArrayList();
                            continue block13;
                        }
                    }
                    this.queue.put(buffers);
                }
                catch (Throwable ex) {
                    Fetcher fetcher = this;
                    synchronized (fetcher) {
                        this.exception = ex;
                    }
                }
                try {
                    IO.closeQuietly(this.reader);
                    while (true) {
                        try {
                            this.queue.put(EOF);
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.latch.countDown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Fetcher forReader(Reader reader, char delimiter) {
                Map<Reader, Fetcher> map = FETCHERS;
                synchronized (map) {
                    Fetcher fetcher = FETCHERS.get(reader);
                    if (fetcher == null) {
                        fetcher = new Fetcher(reader, delimiter);
                        FETCHERS.put(reader, fetcher);
                    } else if (fetcher.delimiter != delimiter) {
                        throw new IllegalStateException("Already reading from reader " + reader + " using delimiter " + delimiter);
                    }
                    return fetcher;
                }
            }
        }
    }

    private static final class SimpleBufferedWriter
    extends Writer {
        private final Writer writer;
        private final char[] buffer;
        private int count;
        private boolean closed;

        SimpleBufferedWriter(Writer writer) {
            this.writer = Objects.requireNonNull(writer);
            this.buffer = new char[BUFFER_SIZE];
            this.count = 0;
            this.closed = false;
        }

        @Override
        public void write(int c) throws IOException {
            if (this.count >= BUFFER_SIZE) {
                this.flushBuffer();
            }
            this.buffer[this.count++] = (char)c;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (len >= BUFFER_SIZE) {
                this.flushBuffer();
                this.writer.write(cbuf, off, len);
                return;
            }
            int available = BUFFER_SIZE - this.count;
            if (available < len) {
                System.arraycopy(cbuf, off, this.buffer, this.count, available);
                this.count += available;
                off += available;
                len -= available;
                this.flushBuffer();
            }
            System.arraycopy(cbuf, off, this.buffer, this.count, len);
            this.count += len;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            if (len >= BUFFER_SIZE) {
                this.flushBuffer();
                this.writer.write(str, off, len);
                return;
            }
            int available = BUFFER_SIZE - this.count;
            if (available < len) {
                str.getChars(off, off + available, this.buffer, this.count);
                this.count += available;
                off += available;
                len -= available;
                this.flushBuffer();
            }
            str.getChars(off, off + len, this.buffer, this.count);
            this.count += len;
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffer();
            this.writer.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            char[] cArray = this.buffer;
            synchronized (this.buffer) {
                if (this.closed) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.closed = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.flushBuffer();
                this.writer.close();
                return;
            }
        }

        private void flushBuffer() throws IOException {
            if (this.count > 0) {
                this.writer.write(this.buffer, 0, this.count);
                this.count = 0;
            }
        }
    }

    private static final class SimpleBufferedReader
    extends Reader {
        private final Reader reader;
        private final char[] buffer;
        private int count;
        private int pos;
        private boolean closed;

        public SimpleBufferedReader(Reader reader) {
            this.reader = reader;
            this.buffer = new char[BUFFER_SIZE];
            this.count = 0;
            this.pos = 0;
            this.closed = false;
        }

        @Override
        public int read() throws IOException {
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            return this.buffer[this.pos++] & 0xFFFF;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if ((off | len | off + len | cbuf.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                this.checkNotClosed();
                return 0;
            }
            int available = this.count - this.pos;
            if (available == 0) {
                if (len >= BUFFER_SIZE) {
                    return this.reader.read(cbuf, off, len);
                }
                this.fill();
                available = this.count - this.pos;
                if (available == 0) {
                    return -1;
                }
            }
            int n = available > len ? len : available;
            System.arraycopy(this.buffer, this.pos, cbuf, off, n);
            this.pos += n;
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                this.checkNotClosed();
                return 0L;
            }
            int available = this.count - this.pos;
            if (available == 0) {
                return this.reader.skip(n);
            }
            long skipped = (long)available < n ? (long)available : n;
            this.pos = (int)((long)this.pos + skipped);
            return skipped;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("Mark not supported");
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            char[] cArray = this.buffer;
            synchronized (this.buffer) {
                if (this.closed) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.closed = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.closed = true;
                this.count = this.pos;
                this.reader.close();
                return;
            }
        }

        private void fill() throws IOException {
            this.checkNotClosed();
            int n = this.reader.read(this.buffer);
            this.count = n < 0 ? 0 : n;
            this.pos = 0;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Reader has been closed");
            }
        }
    }

    private static final class SimpleBufferedOutputStream
    extends OutputStream {
        private final OutputStream stream;
        private final byte[] buffer;
        private int count;
        private boolean closed;

        SimpleBufferedOutputStream(OutputStream stream) {
            this.stream = Objects.requireNonNull(stream);
            this.buffer = new byte[BUFFER_SIZE];
            this.count = 0;
            this.closed = false;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.count >= BUFFER_SIZE) {
                this.flushBuffer();
            }
            this.buffer[this.count++] = (byte)b;
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            if (len >= BUFFER_SIZE) {
                this.flushBuffer();
                this.stream.write(buf, off, len);
                return;
            }
            int available = BUFFER_SIZE - this.count;
            if (available < len) {
                System.arraycopy(buf, off, this.buffer, this.count, available);
                this.count += available;
                off += available;
                len -= available;
                this.flushBuffer();
            }
            System.arraycopy(buf, off, this.buffer, this.count, len);
            this.count += len;
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffer();
            this.stream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            byte[] byArray = this.buffer;
            synchronized (this.buffer) {
                if (this.closed) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.closed = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.flushBuffer();
                this.stream.close();
                return;
            }
        }

        private void flushBuffer() throws IOException {
            if (this.count > 0) {
                this.stream.write(this.buffer, 0, this.count);
                this.count = 0;
            }
        }
    }

    private static final class SimpleBufferedInputStream
    extends InputStream {
        private final InputStream stream;
        private final byte[] buffer;
        private int count;
        private int pos;
        private boolean closed;

        public SimpleBufferedInputStream(InputStream stream) {
            this.stream = Objects.requireNonNull(stream);
            this.buffer = new byte[BUFFER_SIZE];
            this.count = 0;
            this.pos = 0;
            this.closed = false;
        }

        @Override
        public int read() throws IOException {
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            return this.buffer[this.pos++] & 0xFF;
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if ((off | len | off + len | buf.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                this.checkNotClosed();
                return 0;
            }
            int result = 0;
            while (true) {
                int n;
                int available;
                if ((available = this.count - this.pos) > 0) {
                    n = available > len ? len : available;
                    System.arraycopy(this.buffer, this.pos, buf, off, n);
                    this.pos += n;
                    off += n;
                    result += n;
                    if ((len -= n) == 0 || this.stream.available() == 0) {
                        return result;
                    }
                }
                if (len >= BUFFER_SIZE) {
                    n = this.stream.read(buf, off, len);
                    return (result += n < 0 ? 0 : n) == 0 ? -1 : result;
                }
                if (len <= 0) continue;
                this.fill();
                if (this.count == 0) break;
            }
            return result == 0 ? -1 : result;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                this.checkNotClosed();
                return 0L;
            }
            int available = this.count - this.pos;
            if (available <= 0) {
                return this.stream.skip(n);
            }
            long skipped = (long)available < n ? (long)available : n;
            this.pos = (int)((long)this.pos + skipped);
            return skipped;
        }

        @Override
        public int available() throws IOException {
            int n = this.count - this.pos;
            int available = this.stream.available();
            return n > Integer.MAX_VALUE - available ? Integer.MAX_VALUE : n + available;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("Mark not supported");
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            byte[] byArray = this.buffer;
            synchronized (this.buffer) {
                if (this.closed) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.closed = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.count = this.pos;
                this.stream.close();
                return;
            }
        }

        private void fill() throws IOException {
            this.checkNotClosed();
            int n = this.stream.read(this.buffer);
            this.count = n < 0 ? 0 : n;
            this.pos = 0;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("Stream has been closed");
            }
        }
    }
}

