/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class Graph<V, E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private transient Set<E> labels;
    @Nullable
    private transient Set<V> neighbours;
    @Nullable
    private transient Set<V> sources;
    @Nullable
    private transient Set<V> targets;
    @Nullable
    private transient Set<V> roots;
    @Nullable
    private transient Set<V> leaves;

    abstract Set<V> doGetVertices();

    abstract Set<Edge<V, E>> doGetEdges();

    abstract Set<Edge<V, E>> doGetEdges(V var1);

    abstract Graph<V, E> doFilter(@Nullable Predicate<V> var1, @Nullable Predicate<Edge<V, E>> var2);

    public final Set<E> getLabels() {
        if (this.labels == null) {
            HashSet labels = Sets.newHashSet();
            for (Edge<V, E> edge : this.doGetEdges()) {
                labels.add(edge.getLabel());
            }
            this.labels = Collections.unmodifiableSet(labels);
        }
        return this.labels;
    }

    public final Set<E> getLabels(@Nullable V vertex) {
        HashSet labels = Sets.newHashSet();
        for (Edge<V, E> edge : this.doGetEdges(vertex)) {
            labels.add(edge.getLabel());
        }
        return Collections.unmodifiableSet(labels);
    }

    public final Set<E> getLabels(@Nullable V source, @Nullable V target) {
        Set<Edge<V, E>> edgesToFilter;
        if (source != null) {
            edgesToFilter = this.doGetEdges(source);
        } else if (target != null) {
            edgesToFilter = this.doGetEdges(target);
        } else {
            return this.getLabels();
        }
        HashSet labels = Sets.newHashSet();
        for (Edge<V, E> edge : edgesToFilter) {
            if (source != null && !edge.getSource().equals(source) && target != null && !edge.getTarget().equals(target)) continue;
            labels.add(edge.getLabel());
        }
        return Collections.unmodifiableSet(labels);
    }

    public final Set<Edge<V, E>> getEdges() {
        return this.doGetEdges();
    }

    public final Set<Edge<V, E>> getEdges(@Nullable V vertex) {
        return vertex == null ? this.doGetEdges() : this.doGetEdges(vertex);
    }

    public final Set<Edge<V, E>> getEdges(@Nullable V source, @Nullable V target) {
        Set<Edge<V, E>> edgesToFilter;
        if (source != null) {
            edgesToFilter = this.doGetEdges(source);
        } else if (target != null) {
            edgesToFilter = this.doGetEdges(target);
        } else {
            return this.doGetEdges();
        }
        ArrayList edges = Lists.newArrayList();
        for (Edge<V, E> edge : edgesToFilter) {
            if (source != null && !edge.getSource().equals(source) && target != null && !edge.getTarget().equals(target)) continue;
            edges.add(edge);
        }
        return ImmutableSet.copyOf((Collection)edges);
    }

    public final Set<V> getVertices() {
        return this.doGetVertices();
    }

    public final Set<V> getNeighbours() {
        if (this.neighbours == null) {
            HashSet neighbours = Sets.newHashSet();
            for (Edge<V, E> edge : this.doGetEdges()) {
                neighbours.add(edge.getSource());
                neighbours.add(edge.getTarget());
            }
            this.neighbours = ImmutableSet.copyOf((Collection)neighbours);
        }
        return this.neighbours;
    }

    public final Set<V> getNeighbours(V vertex) {
        ArrayList neighbours = Lists.newArrayList();
        for (Edge<V, E> edge : this.doGetEdges(vertex)) {
            if (edge.getSource().equals(vertex)) {
                neighbours.add(edge.getTarget());
                continue;
            }
            neighbours.add(edge.getSource());
        }
        return ImmutableSet.copyOf((Collection)neighbours);
    }

    public final Set<V> getSources() {
        if (this.sources == null) {
            HashSet sources = Sets.newHashSet();
            for (Edge<V, E> edge : this.doGetEdges()) {
                sources.add(edge.getSource());
            }
            this.sources = ImmutableSet.copyOf((Collection)sources);
        }
        return this.sources;
    }

    public final Set<V> getSources(V vertex) {
        ArrayList sources = Lists.newArrayList();
        for (Edge<V, E> edge : this.doGetEdges(vertex)) {
            if (!edge.getTarget().equals(vertex)) continue;
            sources.add(edge.getSource());
        }
        return ImmutableSet.copyOf((Collection)sources);
    }

    public final Set<V> getTargets() {
        if (this.targets == null) {
            HashSet targets = Sets.newHashSet();
            for (Edge<V, E> edge : this.doGetEdges()) {
                targets.add(edge.getTarget());
            }
            this.targets = ImmutableSet.copyOf((Collection)targets);
        }
        return this.targets;
    }

    public final Set<V> getTargets(V vertex) {
        ArrayList targets = Lists.newArrayList();
        for (Edge<V, E> edge : this.doGetEdges(vertex)) {
            if (!edge.getSource().equals(vertex)) continue;
            targets.add(edge.getTarget());
        }
        return ImmutableSet.copyOf((Collection)targets);
    }

    public final Set<V> getRoots() {
        if (this.roots == null) {
            HashSet roots = Sets.newHashSet(this.doGetVertices());
            for (Edge<V, E> edge : this.doGetEdges()) {
                roots.remove(edge.getTarget());
            }
            this.roots = ImmutableSet.copyOf((Collection)roots);
        }
        return this.roots;
    }

    public final Set<V> getLeaves() {
        if (this.leaves == null) {
            HashSet leaves = Sets.newHashSet(this.doGetVertices());
            for (Edge<V, E> edge : this.doGetEdges()) {
                leaves.remove(edge.getSource());
            }
            this.leaves = ImmutableSet.copyOf((Collection)leaves);
        }
        return this.leaves;
    }

    public final Set<Path<V, E>> getPaths(V source, V target, boolean directed, int maxLength) {
        HashMultimap map = HashMultimap.create();
        map.put(source, Collections.emptyList());
        int length = 0;
        ImmutableSet frontier = ImmutableSet.of(source);
        while (!frontier.isEmpty() && map.get(target).isEmpty() && length < maxLength) {
            ++length;
            ImmutableSet seen = ImmutableSet.copyOf((Collection)map.keySet());
            for (Object vertex : frontier) {
                Collection paths = map.get(vertex);
                Set<Edge<Object, E>> edges = directed ? this.getEdges(vertex, null) : this.getEdges(vertex);
                for (Edge<Object, E> edge : edges) {
                    Object otherVertex = edge.getOpposite(vertex);
                    if (seen.contains(otherVertex)) continue;
                    for (List path : paths) {
                        ArrayList newPath = Lists.newArrayList((Iterable)path);
                        newPath.add(edge);
                        map.put(otherVertex, (Object)newPath);
                    }
                }
            }
            frontier = ImmutableSet.copyOf((Collection)Sets.difference((Set)map.keySet(), (Set)frontier));
        }
        ArrayList paths = Lists.newArrayList();
        for (List path : map.get(target)) {
            paths.add(Path.create(source, target, path));
        }
        return ImmutableSet.copyOf((Collection)paths);
    }

    public final Graph<V, E> filterLabels(Iterable<E> labels) {
        final Set labelSet = labels instanceof Set ? (Set)labels : Sets.newHashSet(labels);
        return this.doFilter(null, new Predicate<Edge<V, E>>(){

            public boolean apply(Edge<V, E> edge) {
                return labelSet.contains(edge.getLabel());
            }
        });
    }

    public final Graph<V, E> filterEdges(Iterable<Edge<V, E>> edges) {
        Set edgeSet = edges instanceof Set ? (Set)edges : Sets.newHashSet(edges);
        return this.doFilter(null, Predicates.in((Collection)edgeSet));
    }

    public final Graph<V, E> filterVertices(Iterable<V> vertices) {
        final Set vertexSet = vertices instanceof Set ? (Set)vertices : Sets.newHashSet(vertices);
        return this.doFilter(Predicates.in((Collection)vertexSet), new Predicate<Edge<V, E>>(){

            public boolean apply(Edge<V, E> edge) {
                return vertexSet.contains(edge.getSource()) && vertexSet.contains(edge.getTarget());
            }
        });
    }

    public final Graph<V, E> filter(final @Nullable Predicate<V> vertexFilter, final @Nullable Predicate<Edge<V, E>> edgeFilter) {
        if (vertexFilter == null) {
            return edgeFilter == null ? this : this.doFilter(null, edgeFilter);
        }
        if (edgeFilter == null) {
            return this.doFilter(vertexFilter, new Predicate<Edge<V, E>>(){

                public boolean apply(Edge<V, E> edge) {
                    return vertexFilter.apply(edge.getSource()) && vertexFilter.apply(edge.getTarget());
                }
            });
        }
        return this.doFilter(vertexFilter, new Predicate<Edge<V, E>>(){

            public boolean apply(Edge<V, E> edge) {
                return edgeFilter.apply(edge) && vertexFilter.apply(edge.getSource()) && vertexFilter.apply(edge.getTarget());
            }
        });
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Graph)) {
            return false;
        }
        Graph other = (Graph)object;
        return this.doGetVertices().equals(other.doGetVertices()) && this.doGetEdges().equals(other.doGetEdges());
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.doGetVertices(), this.doGetEdges()});
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("V(").append(this.doGetVertices().size()).append(") = {");
        Joiner.on((String)", ").appendTo(builder, this.doGetVertices());
        builder.append("}, E(").append(this.doGetEdges().size()).append(") = {");
        Joiner.on((String)", ").appendTo(builder, this.doGetEdges());
        builder.append("}");
        return builder.toString();
    }

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    private static final class FilteredGraph<V, E>
    extends Graph<V, E> {
        private static final long serialVersionUID = 1L;
        private final Graph<V, E> graph;
        @Nullable
        private final Predicate<V> vertexFilter;
        @Nullable
        private final Predicate<Edge<V, E>> edgeFilter;

        FilteredGraph(Graph<V, E> graph, @Nullable Predicate<V> vertexFilter, @Nullable Predicate<Edge<V, E>> edgeFilter) {
            this.graph = graph;
            this.vertexFilter = vertexFilter;
            this.edgeFilter = edgeFilter;
        }

        @Override
        Set<Edge<V, E>> doGetEdges() {
            return this.edgeFilter == null ? this.graph.doGetEdges() : Sets.filter(this.graph.doGetEdges(), this.edgeFilter);
        }

        @Override
        Set<Edge<V, E>> doGetEdges(V vertex) {
            return this.edgeFilter == null ? this.graph.doGetEdges(vertex) : Sets.filter(this.graph.doGetEdges(vertex), this.edgeFilter);
        }

        @Override
        Set<V> doGetVertices() {
            return this.vertexFilter == null ? this.graph.doGetVertices() : Sets.filter(this.graph.doGetVertices(), this.vertexFilter);
        }

        @Override
        Graph<V, E> doFilter(@Nullable Predicate<V> vertexFilter, @Nullable Predicate<Edge<V, E>> edgeFilter) {
            Predicate newVertexFilter;
            Object object = this.vertexFilter == null ? vertexFilter : (newVertexFilter = vertexFilter == null ? this.vertexFilter : Predicates.and(this.vertexFilter, vertexFilter));
            Predicate newEdgeFilter = this.edgeFilter == null ? edgeFilter : (edgeFilter == null ? this.edgeFilter : Predicates.and(this.edgeFilter, edgeFilter));
            return new FilteredGraph<V, E>(this.graph, newVertexFilter, newEdgeFilter);
        }
    }

    private static final class ConcreteGraph<V, E>
    extends Graph<V, E> {
        private static final long serialVersionUID = 1L;
        private final Set<V> vertices;
        private final Set<Edge<V, E>> edges;
        @Nullable
        private transient Map<V, Set<Edge<V, E>>> map;

        ConcreteGraph(Set<V> vertices, Set<Edge<V, E>> edges) {
            this.vertices = vertices;
            this.edges = edges;
        }

        @Override
        Set<V> doGetVertices() {
            return this.vertices;
        }

        @Override
        Set<Edge<V, E>> doGetEdges() {
            return this.edges;
        }

        @Override
        Set<Edge<V, E>> doGetEdges(V vertex) {
            Set<Edge<V, E>> edges;
            if (this.map == null) {
                HashMap map = Maps.newHashMap();
                for (Edge<V, E> edge : this.edges) {
                    List sourceEdges = (List)map.get(edge.getSource());
                    List targetEdges = (List)map.get(edge.getTarget());
                    if (sourceEdges == null) {
                        sourceEdges = Lists.newArrayList();
                        map.put(edge.getSource(), sourceEdges);
                    }
                    if (targetEdges == null) {
                        targetEdges = Lists.newArrayList();
                        map.put(edge.getTarget(), targetEdges);
                    }
                    sourceEdges.add(edge);
                    targetEdges.add(edge);
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry entry : map.entrySet()) {
                    builder.put(entry.getKey(), (Object)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
                }
                this.map = builder.build();
            }
            return (edges = this.map.get(vertex)) == null ? ImmutableSet.of() : edges;
        }

        @Override
        Graph<V, E> doFilter(Predicate<V> vertexFilter, Predicate<Edge<V, E>> edgeFilter) {
            return new FilteredGraph<V, E>(this, vertexFilter, edgeFilter);
        }
    }

    public static final class Path<V, E>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Edge<V, E>> edges;
        private final List<V> vertices;
        @Nullable
        private transient List<E> labels;
        @Nullable
        private transient Boolean directed;

        private Path(Iterable<Edge<V, E>> edges, Iterable<V> vertices) {
            this.edges = ImmutableList.copyOf(edges);
            this.vertices = ImmutableList.copyOf(vertices);
        }

        public static <V, E> Path<V, E> create(V source, V target, Iterable<Edge<V, E>> edges) {
            ImmutableList edgeList = ImmutableList.copyOf(edges);
            ArrayList verticesList = Lists.newArrayListWithCapacity((int)(edgeList.size() + 1));
            V vertex = source;
            for (Edge edge : edgeList) {
                verticesList.add(vertex);
                if (edge.getSource().equals(vertex)) {
                    vertex = edge.getTarget();
                    continue;
                }
                if (edge.getTarget().equals(vertex)) {
                    vertex = edge.getSource();
                    continue;
                }
                throw new IllegalArgumentException("Invalid path");
            }
            verticesList.add(vertex);
            if (!vertex.equals(target)) {
                throw new IllegalArgumentException("Invalid path");
            }
            return new Path<V, E>(edgeList, verticesList);
        }

        public int length() {
            return this.edges.size();
        }

        public V getSource() {
            return this.vertices.get(0);
        }

        public V getTarget() {
            return this.vertices.get(this.vertices.size() - 1);
        }

        public List<V> getVertices() {
            return this.vertices;
        }

        public List<Edge<V, E>> getEdges() {
            return this.edges;
        }

        public List<E> getLabels() {
            if (this.labels == null) {
                ArrayList labels = Lists.newArrayListWithCapacity((int)this.edges.size());
                for (Edge<V, E> edge : this.edges) {
                    labels.add(edge.getLabel());
                }
                this.labels = ImmutableList.copyOf((Collection)labels);
            }
            return this.labels;
        }

        public boolean isDirected() {
            if (this.directed == null) {
                boolean directed = true;
                for (int i = 0; i < this.edges.size(); ++i) {
                    if (this.edges.get(i).getSource().equals(this.vertices.get(i))) continue;
                    directed = false;
                    break;
                }
                this.directed = directed;
            }
            return this.directed;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Path)) {
                return false;
            }
            Path path = (Path)object;
            return this.edges.equals(path.edges);
        }

        public int hashCode() {
            return this.edges.hashCode();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.edges.size(); ++i) {
                V vertex = this.vertices.get(i);
                Edge<V, E> edge = this.edges.get(i);
                builder.append(vertex);
                if (edge.getSource().equals(vertex)) {
                    builder.append(" -").append(edge.getLabel()).append("-> ");
                    continue;
                }
                builder.append(" <-").append(edge.getLabel()).append("- ");
            }
            builder.append(this.vertices.get(this.vertices.size() - 1));
            return builder.toString();
        }
    }

    public static final class Edge<V, E>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final V source;
        private final V target;
        @Nullable
        private final E label;

        private Edge(V source, V target, @Nullable E label) {
            this.source = source;
            this.target = target;
            this.label = label;
        }

        public static <V, E> Edge<V, E> create(V source, V target, @Nullable E label) {
            return new Edge<Object, E>(Preconditions.checkNotNull(source), Preconditions.checkNotNull(target), label);
        }

        public V getSource() {
            return this.source;
        }

        public V getTarget() {
            return this.target;
        }

        public V getOpposite(V vertex) {
            if (this.source.equals(vertex)) {
                return this.target;
            }
            if (this.target.equals(vertex)) {
                return this.source;
            }
            throw new IllegalArgumentException("Vertex " + vertex + " not contained in " + this);
        }

        @Nullable
        public E getLabel() {
            return this.label;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Edge)) {
                return false;
            }
            Edge other = (Edge)object;
            return this.source.equals(other.source) && this.target.equals(other.target) && Objects.equal(this.label, other.label);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.source, this.target, this.label});
        }

        public String toString() {
            return this.source + " -" + this.label + "-> " + this.target;
        }
    }

    public static final class Builder<V, E> {
        private final Set<V> vertices = Sets.newHashSet();
        private final Set<Edge<V, E>> edges = Sets.newHashSet();

        private Builder() {
        }

        public Builder<V, E> addVertices(V ... vertices) {
            return this.addVertices((Iterable<? extends V>)Arrays.asList(vertices));
        }

        public Builder<V, E> addVertices(Iterable<? extends V> vertices) {
            Iterables.addAll(this.vertices, vertices);
            return this;
        }

        public Builder<V, E> addEdges(Edge<V, E> ... edges) {
            return this.addEdges(Arrays.asList(edges));
        }

        public Builder<V, E> addEdges(Iterable<Edge<V, E>> edges) {
            for (Edge<V, E> edge : edges) {
                this.edges.add(edge);
                this.vertices.add(edge.getSource());
                this.vertices.add(edge.getTarget());
            }
            return this;
        }

        public Builder<V, E> addEdges(V source, V target, E ... labels) {
            this.vertices.add(source);
            this.vertices.add(target);
            for (E label : labels) {
                this.edges.add(Edge.create(source, target, label));
            }
            return this;
        }

        public Graph<V, E> build() {
            return new ConcreteGraph(ImmutableSet.copyOf(this.vertices), ImmutableSet.copyOf(this.edges));
        }
    }
}

