/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Environment {
    private static final Logger LOGGER = LoggerFactory.getLogger(Environment.class);
    @Nullable
    private static List<String> propertyNames;
    private static Map<String, String> configuredProperties;
    private static Map<String, String> loadedProperties;
    private static Map<String, Optional<String>> frozenProperties;
    private static ExecutorService configuredPool;
    private static ExecutorService frozenPool;
    private static List<Plugin> frozenPlugins;
    @Nullable
    private static String frozenName;
    private static int frozenCores;
    private static Map<String, ProcessBuilder> commands;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configurePool(@Nullable ExecutorService pool) {
        Class<Environment> clazz = Environment.class;
        synchronized (Environment.class) {
            if (frozenPool != null) {
                throw new IllegalStateException("Thread pool already in use");
            }
            configuredPool = pool;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureProperty(String name, @Nullable String value) {
        Objects.requireNonNull(name);
        Class<Environment> clazz = Environment.class;
        synchronized (Environment.class) {
            if (frozenPlugins != null && name.startsWith("plugin,")) {
                throw new IllegalStateException("Plugin configuration already loaded");
            }
            if (frozenProperties.containsKey(name)) {
                throw new IllegalStateException("Property " + name + " already in use (value " + frozenProperties.get(name) + ")");
            }
            propertyNames = null;
            if (value == null) {
                configuredProperties.remove(name);
            } else {
                configuredProperties.put(name, value);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static String getName() {
        if (frozenName == null) {
            frozenName = Environment.getProperty("utils.environment.name", "application");
        }
        return frozenName;
    }

    public static int getCores() {
        if (frozenCores <= 0) {
            frozenCores = Integer.parseInt(Environment.getProperty("utils.environment.cores"));
        }
        return frozenCores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getPool() {
        if (frozenPool != null) return frozenPool;
        Class<Environment> clazz = Environment.class;
        synchronized (Environment.class) {
            if (frozenPool != null) return frozenPool;
            frozenPool = configuredPool;
            if (frozenPool == null) {
                frozenPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setPriority(5).setNameFormat(Environment.getName() + "-%03d").build());
            }
            LOGGER.debug("Using pool {}", (Object)frozenPool);
            // ** MonitorExit[var0] (shouldn't be in output)
            return frozenPool;
        }
    }

    public static void run(Iterable<? extends Runnable> runnables) {
        int i;
        ImmutableList runnableList = ImmutableList.copyOf(runnables);
        int parallelism = Math.min(Environment.getCores(), runnableList.size());
        CountDownLatch latch = new CountDownLatch(parallelism);
        AtomicReference exception = new AtomicReference();
        final AtomicInteger index = new AtomicInteger(0);
        ArrayList<1> threadRunnables = new ArrayList<1>();
        for (i = 0; i < parallelism; ++i) {
            threadRunnables.add(new Runnable((List)runnableList, exception, latch){
                final /* synthetic */ List val$runnableList;
                final /* synthetic */ AtomicReference val$exception;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$runnableList = list;
                    this.val$exception = atomicReference;
                    this.val$latch = countDownLatch;
                }

                @Override
                public void run() {
                    try {
                        int i;
                        while ((i = index.getAndIncrement()) < this.val$runnableList.size()) {
                            if (this.val$exception.get() != null) {
                                break;
                            }
                            ((Runnable)this.val$runnableList.get(i)).run();
                        }
                    }
                    catch (Throwable ex) {
                        this.val$exception.set(ex);
                    }
                    finally {
                        this.val$latch.countDown();
                    }
                }
            });
        }
        try {
            for (i = 1; i < parallelism; ++i) {
                Environment.getPool().submit((Runnable)threadRunnables.get(i));
            }
            if (!threadRunnables.isEmpty()) {
                ((Runnable)threadRunnables.get(0)).run();
            }
            latch.await();
            if (exception.get() != null) {
                throw (Throwable)exception.get();
            }
        }
        catch (Throwable ex) {
            Throwables.throwIfUnchecked((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String getProperty(String name) {
        Objects.requireNonNull(name);
        Optional<String> holder = frozenProperties.get(name);
        if (holder != null) return holder.orElse(null);
        Class<Environment> clazz = Environment.class;
        synchronized (Environment.class) {
            holder = frozenProperties.get(name);
            if (holder != null) return holder.orElse(null);
            String value = configuredProperties.containsKey(name) ? configuredProperties.get(name) : loadedProperties.get(name);
            holder = Optional.ofNullable(value);
            frozenProperties.put(name, holder);
            if (value == null) return holder.orElse(null);
            LOGGER.debug("Using {} = {}", (Object)name, (Object)value);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return holder.orElse(null);
        }
    }

    @Nullable
    public static String getProperty(String name, @Nullable String valueIfNull) {
        String value = Environment.getProperty(name);
        return value != null ? value : valueIfNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPropertyNames() {
        Class<Environment> clazz = Environment.class;
        synchronized (Environment.class) {
            if (propertyNames == null) {
                propertyNames = new ArrayList<String>();
                propertyNames.addAll(loadedProperties.keySet());
                for (String property : configuredProperties.keySet()) {
                    if (loadedProperties.containsKey(property)) continue;
                    propertyNames.add(property);
                }
                Collections.sort(propertyNames);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return propertyNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessBuilder getProcessBuilder(String command, String ... args) {
        Map<String, ProcessBuilder> map = commands;
        synchronized (map) {
            ProcessBuilder template = commands.get(command);
            if (template == null) {
                String property = "utils.environment.cmd." + command;
                String cmd = Environment.getProperty(property);
                if (cmd != null) {
                    try {
                        template = new ProcessBuilder(new String[0]);
                        cmd = cmd.trim();
                        String[] tokens = Environment.tokenize(cmd, Pattern.compile("[\\s]+|(=)"));
                        int i = 0;
                        while (i + 3 <= tokens.length) {
                            if (tokens[i + 1].equals("=")) {
                                template.environment().put(tokens[i], tokens[i + 2]);
                            }
                            i += 3;
                        }
                        template.command().addAll(Arrays.asList(tokens).subList(i, tokens.length));
                        LOGGER.debug("Using {} for command {}", (Object)cmd, (Object)command);
                    }
                    catch (Throwable ex) {
                        LOGGER.warn("Ignoring invalid property " + property + " = " + cmd, ex);
                        template = null;
                    }
                }
                template = template != null ? template : new ProcessBuilder(command);
                commands.put(command, template);
            }
            ProcessBuilder result = new ProcessBuilder(new ArrayList<String>(template.command()));
            result.environment().putAll(template.environment());
            result.command().addAll(Arrays.asList(args));
            return result;
        }
    }

    public static Map<String, String> getPlugins(Class<?> baseClass) {
        Objects.requireNonNull(baseClass);
        if (frozenPlugins == null) {
            Environment.loadPlugins();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Plugin plugin : frozenPlugins) {
            if (!baseClass.isAssignableFrom(plugin.factory.getReturnType())) continue;
            map.put(plugin.names.get(0), plugin.description);
        }
        return map;
    }

    public static <T> T newPlugin(Class<T> baseClass, String name, String ... args) {
        Objects.requireNonNull(baseClass);
        Objects.requireNonNull(name);
        if (Arrays.asList(args).contains(null)) {
            throw new NullPointerException();
        }
        if (frozenPlugins == null) {
            Environment.loadPlugins();
        }
        for (Plugin plugin : frozenPlugins) {
            if (!baseClass.isAssignableFrom(plugin.factory.getReturnType()) || !plugin.names.contains(name)) continue;
            try {
                return baseClass.cast(plugin.factory.invoke(null, name, args));
            }
            catch (IllegalAccessException ex) {
                throw new Error("Unexpected error (!)", ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(ex);
            }
        }
        throw new IllegalArgumentException("Unknown " + baseClass.getSimpleName() + " plugin '" + name + "'");
    }

    static String[] tokenize(String string, Pattern delimiter) {
        char startCh;
        char endCh;
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher matcher = delimiter.matcher(string);
        int start = 0;
        int index = 0;
        while (matcher.find(index)) {
            char startCh2 = string.charAt(start);
            int end = matcher.start();
            if (startCh2 == '\'' || startCh2 == '\"') {
                if (end - start < 2) {
                    index = matcher.start() + 1;
                    continue;
                }
                endCh = string.charAt(end - 1);
                int numEscapes = 0;
                for (int i = end - 2; i >= start && string.charAt(i) == '\\'; --i) {
                    ++numEscapes;
                }
                if (endCh != startCh2 || numEscapes % 2 == 1) {
                    index = matcher.start() + 1;
                    continue;
                }
                ++start;
                --end;
            }
            tokens.add(string.substring(start, end));
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String group = matcher.group(i);
                if (group == null) continue;
                tokens.add(group);
            }
            index = matcher.end();
            start = matcher.end();
        }
        int end = string.length();
        if (end - start >= 2 && ((startCh = string.charAt(start)) == (endCh = string.charAt(end - 1)) && startCh == '\'' || startCh == '\"')) {
            ++start;
            --end;
        }
        tokens.add(start < end ? string.substring(start, end) : "");
        return tokens.toArray(new String[tokens.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPlugins() {
        Class<Environment> clazz = Environment.class;
        synchronized (Environment.class) {
            if (frozenPlugins != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            HashSet<String> disabledNames = new HashSet<String>();
            ArrayList<Plugin> plugins = new ArrayList<Plugin>();
            for (Map map : new Map[]{loadedProperties, configuredProperties}) {
                for (Map.Entry entry : map.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (name.startsWith("plugin.enable.") || name.startsWith("plugin,enable,")) {
                        List<String> names = Arrays.asList(name.substring("plugin.enable.".length()).split("[.,]"));
                        if (value.equalsIgnoreCase("true")) {
                            disabledNames.removeAll(names);
                            continue;
                        }
                        disabledNames.addAll(names);
                        continue;
                    }
                    if (!name.startsWith("plugin,") && !name.startsWith("plugin.")) continue;
                    try {
                        String s = name.substring("plugin.".length());
                        String[] tokens = s.split(",");
                        if (tokens.length == 1) {
                            String[] allTokens = s.split("\\.");
                            for (int i = 0; i < allTokens.length; ++i) {
                                if (!Character.isUpperCase(allTokens[i].charAt(0))) continue;
                                tokens = new String[allTokens.length - i];
                                tokens[0] = String.join((CharSequence)".", Arrays.copyOfRange(allTokens, 0, i + 1));
                                System.arraycopy(allTokens, i + 1, tokens, 1, allTokens.length - i - 1);
                            }
                        }
                        String className = tokens[0];
                        String methodName = tokens[1];
                        List<String> pluginNames = Arrays.asList(Arrays.copyOfRange(tokens, 2, tokens.length));
                        Class<?> clazz2 = Class.forName(className);
                        Method method = clazz2.getDeclaredMethod(methodName, String.class, String[].class);
                        method.setAccessible(true);
                        plugins.add(new Plugin(pluginNames, value, method));
                    }
                    catch (Throwable ex) {
                        LOGGER.warn("Invalid plugin definition " + name + " - ignoring", ex);
                    }
                }
            }
            Iterator i = plugins.iterator();
            block8: while (i.hasNext()) {
                List<String> names = ((Plugin)i.next()).names;
                for (String name : names) {
                    if (!disabledNames.contains(name)) continue;
                    i.remove();
                    continue block8;
                }
            }
            frozenPlugins = plugins;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        configuredProperties = new HashMap<String, String>();
        loadedProperties = new HashMap<String, String>();
        frozenProperties = new ConcurrentHashMap<String, Optional<String>>();
        configuredPool = null;
        frozenPool = null;
        frozenPlugins = null;
        frozenCores = 0;
        commands = new HashMap<String, ProcessBuilder>();
        Properties properties = new Properties();
        properties.setProperty("utils.environment.cores", "" + Runtime.getRuntime().availableProcessors());
        HashSet sources = Sets.newHashSet((Object[])new String[]{"environment.properties"});
        sources.addAll(Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)System.getProperty("utils.environment.sources", "")));
        LinkedList<String> queue = new LinkedList<String>(sources);
        try {
            while (!queue.isEmpty()) {
                Object e;
                String source = (String)queue.remove(0);
                ArrayList<URL> arrayList = new ArrayList<URL>();
                for (String path : new String[]{"META-INF/" + source, source}) {
                    e = Environment.class.getClassLoader().getResources(path);
                    while (e.hasMoreElements()) {
                        arrayList.add(e.nextElement());
                    }
                }
                for (URL url : arrayList) {
                    Properties urlProperties = new Properties();
                    try {
                        InputStreamReader in = new InputStreamReader(url.openStream(), Charsets.UTF_8);
                        e = null;
                        try {
                            urlProperties.load(in);
                            properties.putAll((Map<?, ?>)urlProperties);
                            LOGGER.debug("Loaded {} properties from '{}'", (Object)urlProperties.size(), (Object)url);
                        }
                        catch (Throwable throwable) {
                            e = throwable;
                            throw throwable;
                        }
                        finally {
                            if (in != null) {
                                if (e != null) {
                                    try {
                                        ((Reader)in).close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)e).addSuppressed(throwable);
                                    }
                                } else {
                                    ((Reader)in).close();
                                }
                            }
                        }
                    }
                    catch (Throwable ex) {
                        LOGGER.warn("Could not load properties from '" + url + "' - ignore", ex);
                    }
                    for (String urlSource : Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)urlProperties.getProperty("utils.environment.sources", ""))) {
                        if (!sources.add(urlSource)) continue;
                        queue.add(urlSource);
                    }
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Could not complete loading of properties from classpath resources", (Throwable)ex);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            loadedProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            loadedProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
            String key = ((String)entry.getKey()).toString().toLowerCase().replace('_', '.');
            loadedProperties.put(key, (String)entry.getValue());
        }
    }

    private static final class Plugin {
        public final List<String> names;
        public final String description;
        public final Method factory;

        Plugin(List<String> names, String description, Method factory) {
            this.names = names;
            this.description = description;
            this.factory = factory;
        }
    }
}

