/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.runner.outputters;

import com.google.common.reflect.ClassPath;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSerializer;
import eu.fbk.utils.gson.JSONLabel;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerCollector.class);
    private GsonBuilder gsonBuilder = new GsonBuilder();

    public GsonBuilder getGsonBuilder() {
        return this.gsonBuilder;
    }

    public SerializerCollector() {
        LOGGER.info("Loading serializers");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            ClassPath classpath = ClassPath.from((ClassLoader)loader);
            for (ClassPath.ClassInfo classInfo : classpath.getAllClasses()) {
                if (classInfo.getSimpleName().endsWith("_")) continue;
                try {
                    Class[] serializerClasses;
                    Class myClass = classInfo.load();
                    if (!myClass.isAnnotationPresent(JSONLabel.class)) continue;
                    JSONLabel JsonAnnotation = myClass.getAnnotation(JSONLabel.class);
                    for (Class serializerClass : serializerClasses = JsonAnnotation.serializer()) {
                        if (!JsonSerializer.class.isAssignableFrom(serializerClass)) continue;
                        for (Type type : serializerClass.getGenericInterfaces()) {
                            if (!(type instanceof ParameterizedType) || !((ParameterizedType)type).getRawType().equals(JsonSerializer.class)) continue;
                            try {
                                Type thisType = ((ParameterizedType)type).getActualTypeArguments()[0];
                                LOGGER.info("Loading serializer for {}", (Object)thisType);
                                this.gsonBuilder.registerTypeAdapter(thisType, serializerClass.newInstance());
                            }
                            catch (InstantiationException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

