/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.runner;

import eu.fbk.dh.tint.runner.TintHandler;
import eu.fbk.dh.tint.runner.TintPipeline;
import eu.fbk.utils.core.CommandLine;
import java.io.File;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TintServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TintServer.class);
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final Integer DEFAULT_PORT = 8012;

    public TintServer(String host, Integer port) {
        this(host, port, null, null);
    }

    public TintServer(String host, Integer port, @Nullable File configFile) {
        this(host, port, configFile, null);
    }

    public TintServer(String host, Integer port, @Nullable File configFile, @Nullable Properties additionalProperties) {
        LOGGER.info("starting " + host + "\t" + port + " (" + new Date() + ")...");
        int timeoutInSeconds = -1;
        try {
            TintPipeline pipeline = new TintPipeline();
            pipeline.loadDefaultProperties();
            pipeline.loadPropertiesFromFile(configFile);
            pipeline.addProperties(additionalProperties);
            pipeline.loadSerializers();
            pipeline.load();
            LOGGER.info("Pipeline loaded");
            HttpServer httpServer = new HttpServer();
            NetworkListener nl = new NetworkListener("tint-server", host, port.intValue());
            httpServer.addListener(nl);
            TintHandler tintHandler = new TintHandler(pipeline);
            tintHandler.setRequestURIEncoding(Charset.forName("UTF-8"));
            httpServer.getServerConfiguration().setSessionTimeoutSeconds(timeoutInSeconds);
            httpServer.getServerConfiguration().setMaxPostSize(0x400000L);
            httpServer.getServerConfiguration().addHttpHandler((HttpHandler)tintHandler, new String[]{"/tint"});
            httpServer.start();
            Thread.currentThread().join();
        }
        catch (Exception e) {
            LOGGER.error("error running " + host + ":" + port);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            CommandLine cmd = CommandLine.parser().withName("./tintop-server").withHeader("Run the Tintop Server").withOption("c", "config", "Configuration file", "FILE", CommandLine.Type.FILE_EXISTING, true, false, false).withOption("p", "port", String.format("Host port (default %d)", DEFAULT_PORT), "NUM", CommandLine.Type.INTEGER, true, false, false).withOption("h", "host", String.format("Host address (default %s)", DEFAULT_HOST), "NUM", CommandLine.Type.STRING, true, false, false).withOption(null, "properties", "Additional properties", "PROPS", CommandLine.Type.STRING, true, true, false).withLogger(LoggerFactory.getLogger((String)"eu.fbk")).parse(args);
            String host = (String)cmd.getOptionValue("host", String.class, (Object)DEFAULT_HOST);
            Integer port = (Integer)cmd.getOptionValue("port", Integer.class, (Object)DEFAULT_PORT);
            File configFile = (File)cmd.getOptionValue("config", File.class);
            List addProperties = cmd.getOptionValues("properties", String.class);
            Properties additionalProps = new Properties();
            for (String property : addProperties) {
                try {
                    additionalProps.load(new StringReader(property));
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
            }
            TintServer tintServer = new TintServer(host, port, configFile, additionalProps);
        }
        catch (Exception e) {
            CommandLine.fail((Throwable)e);
        }
    }
}

