/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.runner;

import com.google.common.base.Throwables;
import eu.fbk.dh.tint.runner.TintPipeline;
import eu.fbk.utils.core.CommandLine;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TintRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TintRunner.class);

    public static void main(String[] args) {
        try {
            CommandLine cmd = CommandLine.parser().withName("tint").withHeader("Run the Tint pipeline.").withOption("c", "config-file", "Configuration file", "FILE", CommandLine.Type.FILE_EXISTING, true, false, false).withOption("i", "input-file", "Input text file (default stdin)", "FILE", CommandLine.Type.FILE_EXISTING, true, false, false).withOption("o", "output-file", "Output processed file (default stdout)", "FILE", CommandLine.Type.FILE_EXISTING, true, false, false).withOption("f", "output-format", "Output format: textpro, json, xml, conll, naf, readable (default conll)", "FORMAT", CommandLine.Type.STRING, true, false, false).withOption(null, "properties", "Additional properties for Stanford CoreNLP", "PROPS", CommandLine.Type.STRING, true, false, false).withLogger(LoggerFactory.getLogger((String)"eu.fbk")).parse(args);
            File inputPath = (File)cmd.getOptionValue("i", File.class);
            File outputPath = (File)cmd.getOptionValue("o", File.class);
            File configPath = (File)cmd.getOptionValue("c", File.class);
            List addProperties = cmd.getOptionValues("properties", String.class);
            Properties additionalProps = new Properties();
            for (String property : addProperties) {
                try {
                    additionalProps.load(new StringReader(property));
                }
                catch (Exception exception) {}
            }
            Console console = System.console();
            if (console == null) {
                Object level;
                Class<?> levelClass;
                String loggerClassName = LOGGER.getClass().getName();
                if (loggerClassName.equals("ch.qos.logback.classic.Logger")) {
                    levelClass = Class.forName("ch.qos.logback.classic.Level");
                    level = TintRunner.call(levelClass, "valueOf", "OFF");
                    TintRunner.call(LOGGER, "setLevel", level);
                } else if (loggerClassName.equals("org.apache.log4j.Logger")) {
                    levelClass = Class.forName("org.apache.log4j.Level");
                    level = TintRunner.call(levelClass, "valueOf", "OFF");
                    TintRunner.call(LOGGER, "setLevel", level);
                } else if (loggerClassName.equals("org.apache.logging.slf4j.Log4jLogger")) {
                    Class<?> managerClass = Class.forName("org.apache.logging.log4j.LogManager");
                    Object ctx = TintRunner.call(managerClass, "getContext", false);
                    Object config = TintRunner.call(ctx, "getConfiguration", new Object[0]);
                    Object logConfig = TintRunner.call(config, "getLoggerConfig", LOGGER.getName());
                    Class<?> levelClass2 = Class.forName("org.apache.logging.log4j.Level");
                    Object level2 = TintRunner.call(levelClass2, "valueOf", "OFF");
                    TintRunner.call(logConfig, "setLevel", level2);
                    TintRunner.call(ctx, "updateLoggers", new Object[0]);
                }
            }
            String formatString = (String)cmd.getOptionValue("f", String.class);
            OutputFormat format = TintRunner.getOutputFormat(formatString, OutputFormat.JSON);
            InputStream inputStream = inputPath != null ? new FileInputStream(inputPath) : System.in;
            TintPipeline pipeline = new TintPipeline();
            pipeline.loadDefaultProperties();
            pipeline.loadPropertiesFromFile(configPath);
            pipeline.addProperties(additionalProps);
            pipeline.load();
            System.err.println("Tint is ready");
            OutputStream outputStream = System.out;
            if (outputPath != null) {
                outputStream = new FileOutputStream(outputPath);
            }
            pipeline.run(inputStream, outputStream, format);
        }
        catch (Exception e) {
            CommandLine.fail((Throwable)e);
        }
    }

    public static OutputFormat getOutputFormat(String formatString, OutputFormat outputFormat) {
        OutputFormat format = outputFormat;
        try {
            format = OutputFormat.valueOf(formatString.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return format;
    }

    private static Object call(Object object, String methodName, Object ... args) {
        boolean isStatic = object instanceof Class;
        Class<?> clazz = isStatic ? (Class<?>)object : object.getClass();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || isStatic != Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != args.length) continue;
            try {
                return method.invoke(isStatic ? null : object, args);
            }
            catch (InvocationTargetException ex) {
                Throwables.propagate((Throwable)ex.getCause());
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Cannot invoke " + method, ex);
            }
        }
        throw new IllegalArgumentException("Cannot invoke " + methodName);
    }

    public static enum OutputFormat {
        READABLE,
        JSON,
        XML,
        CONLL,
        NAF,
        TEXTPRO;

    }
}

