/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.runner;

import com.google.gson.GsonBuilder;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CoNLLUOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.TextOutputter;
import edu.stanford.nlp.pipeline.XMLOutputter;
import eu.fbk.dh.tint.runner.TimingAnnotations;
import eu.fbk.dh.tint.runner.TintRunner;
import eu.fbk.dh.tint.runner.outputters.JSONOutputter;
import eu.fbk.dh.tint.runner.outputters.SerializerCollector;
import eu.fbk.dh.tint.runner.outputters.TextProOutputter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TintPipeline {
    private static final Logger LOGGER = LoggerFactory.getLogger(TintPipeline.class);
    private String documentDate = null;
    private Properties props = new Properties();
    private boolean DEFAULT_LOAD_SERIALIZER = false;
    SerializerCollector serializerCollector = null;

    public void loadSerializers() {
        this.serializerCollector = new SerializerCollector();
    }

    public void load() {
        StanfordCoreNLP pipeline = new StanfordCoreNLP(this.props);
        if (this.DEFAULT_LOAD_SERIALIZER) {
            this.loadSerializers();
        }
    }

    public void loadDefaultProperties() throws IOException {
        InputStream configStream = TintRunner.class.getResourceAsStream("/default-config.properties");
        if (configStream != null) {
            this.props.load(configStream);
        }
    }

    public void loadPropertiesFromStream(InputStream stream) throws IOException {
        this.props.load(stream);
    }

    public void loadPropertiesFromFile(File propsFile) throws IOException {
        if (propsFile != null) {
            FileInputStream configStream = new FileInputStream(propsFile);
            this.loadPropertiesFromStream(configStream);
        }
    }

    public void addProperties(Properties properties) {
        if (properties != null) {
            this.props.putAll((Map<?, ?>)properties);
        }
    }

    public void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(String documentDate) {
        this.documentDate = documentDate;
    }

    public Annotation runRaw(String text) {
        return this.runRaw(text, null);
    }

    public Annotation runRaw(String text, @Nullable StanfordCoreNLP pipeline) {
        this.load();
        Annotation annotation = new Annotation(text);
        LOGGER.debug("Text: {}", (Object)text);
        if (this.documentDate == null) {
            this.documentDate = Instant.now().toString().substring(0, 10);
        }
        annotation.set(CoreAnnotations.DocDateAnnotation.class, (Object)this.documentDate);
        if (pipeline == null) {
            pipeline = new StanfordCoreNLP(this.props);
        }
        pipeline.annotate(annotation);
        annotation.set(TimingAnnotations.TimingAnnotation.class, (Object)pipeline.timingInformation());
        return annotation;
    }

    public Annotation run(InputStream inputStream, OutputStream outputStream, TintRunner.OutputFormat format) throws IOException {
        int i;
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuilder inputText = new StringBuilder();
        while ((i = ((Reader)reader).read()) != -1) {
            inputText.append((char)i);
        }
        ((Reader)reader).close();
        String text = inputText.toString();
        StanfordCoreNLP pipeline = new StanfordCoreNLP(this.props);
        Annotation annotation = this.runRaw(text, pipeline);
        switch (format) {
            case CONLL: {
                CoNLLUOutputter.conllUPrint((Annotation)annotation, (OutputStream)outputStream, (StanfordCoreNLP)pipeline);
                break;
            }
            case READABLE: {
                TextOutputter.prettyPrint((Annotation)annotation, (OutputStream)outputStream, (StanfordCoreNLP)pipeline);
                break;
            }
            case XML: {
                XMLOutputter.xmlPrint((Annotation)annotation, (OutputStream)outputStream, (StanfordCoreNLP)pipeline);
                break;
            }
            case JSON: {
                GsonBuilder gsonBuilder = this.serializerCollector != null ? this.serializerCollector.getGsonBuilder() : new GsonBuilder();
                JSONOutputter.jsonPrint(gsonBuilder, annotation, outputStream, pipeline);
                break;
            }
            case TEXTPRO: {
                TextProOutputter.tpPrint(annotation, outputStream, pipeline);
                break;
            }
        }
        return annotation;
    }
}

