/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.tense;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.digimorph.annotator.DigiMorphAnnotations;
import eu.fbk.dh.tint.tense.TenseAnnotations;
import eu.fbk.utils.core.PropertiesUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenseAnnotator
implements Annotator {
    static Set<String> noWords = new HashSet<String>();
    static Map<String, String> multiTenses = new HashMap<String, String>();
    private static final boolean DEFAULT_USE_PREFIX = true;
    private static final String DEFAULT_SKIP_TAGS = "B";
    private static final String DEFAULT_VERB_TAGS = "V";
    private static final Logger LOGGER;
    private boolean usePrefix;
    private List<String> skipTags;
    private List<String> verbTags;
    private Set<String> transitiveVerbs;

    public TenseAnnotator(String annotatorName, Properties prop) {
        String[] vParts;
        String[] sParts;
        String tvFile = prop.getProperty(annotatorName + ".transitive_verbs", null);
        this.usePrefix = PropertiesUtils.getBoolean((String)prop.getProperty(annotatorName + ".use_prefix"), (boolean)true);
        String skipTagsText = prop.getProperty(annotatorName + ".skip_tags", DEFAULT_SKIP_TAGS);
        String verbTagsText = prop.getProperty(annotatorName + ".verb_tags", DEFAULT_VERB_TAGS);
        this.skipTags = new ArrayList<String>();
        this.verbTags = new ArrayList<String>();
        for (String sPart : sParts = skipTagsText.split("\\s*,\\s*")) {
            this.skipTags.add(sPart);
        }
        for (String vPart : vParts = verbTagsText.split("\\s*,\\s*")) {
            this.verbTags.add(vPart);
        }
        this.transitiveVerbs = new HashSet<String>();
        InputStream stream = null;
        if (tvFile != null) {
            try {
                stream = new FileInputStream(tvFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (stream == null) {
            stream = this.getClass().getResourceAsStream("/transitiveVerbs.txt");
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                this.transitiveVerbs.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void annotate(Annotation annotation) {
        if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                ArrayList<Object> lastVerb = new ArrayList<CoreLabel>();
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                boolean followedByExMark = ((CoreLabel)tokens.get(tokens.size() - 1)).word().equals("!");
                boolean preceededByNot = false;
                for (int i = 0; i < tokens.size(); ++i) {
                    CoreLabel token = (CoreLabel)tokens.get(i);
                    String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    String form = token.word().toLowerCase();
                    if (noWords.contains(form)) {
                        preceededByNot = true;
                    }
                    if (this.isSatisfied(pos, this.verbTags)) {
                        lastVerb.add(token);
                        continue;
                    }
                    if (this.isSatisfied(pos, this.skipTags) || lastVerb.size() <= 0) continue;
                    String tense = this.analyzeVerb(lastVerb, followedByExMark, preceededByNot);
                    ((CoreLabel)tokens.get(i - 1)).set(TenseAnnotations.TenseAnnotation.class, (Object)tense);
                    preceededByNot = false;
                    lastVerb = new ArrayList();
                }
                if (lastVerb.size() <= 0) continue;
                String tense = this.analyzeVerb(lastVerb, followedByExMark, preceededByNot);
                ((CoreLabel)tokens.get(tokens.size() - 1)).set(TenseAnnotations.TenseAnnotation.class, (Object)tense);
            }
        }
    }

    static Set<String> getFromMap(Set<String> needle, Map<String, String> haystack) {
        HashSet<String> ret = new HashSet<String>();
        for (String s : needle) {
            String v = haystack.get(s);
            if (v == null) continue;
            ret.add(v);
        }
        return ret;
    }

    private String analyzeVerb(List<CoreLabel> verb, boolean followedByExMark, boolean preceededByNot) {
        String lemma = (String)verb.get(verb.size() - 1).get(CoreAnnotations.LemmaAnnotation.class);
        CoreLabel firstToken = verb.get(0);
        String morpho = (String)firstToken.get(DigiMorphAnnotations.MorphoAnnotation.class);
        String firstLemma = firstToken.getString(CoreAnnotations.LemmaAnnotation.class);
        String firstPos = firstToken.getString(CoreAnnotations.PartOfSpeechAnnotation.class);
        List<String> compatibleMorpho = this.getCompatibleMorpho(morpho, firstLemma);
        if (compatibleMorpho.size() == 0) {
            return null;
        }
        String thisMorpho = compatibleMorpho.get(0);
        String[] parts = thisMorpho.split("\\+");
        if (parts.length <= 3) {
            return null;
        }
        String tense = parts[3];
        if (firstPos.equals("VA") && this.isTransitive(lemma) && (firstLemma.equals("essere") || firstLemma.equals("venire"))) {
            tense = "pass";
        }
        return tense;
    }

    private boolean isTransitive(String verb) {
        return this.transitiveVerbs.contains(verb.toLowerCase());
    }

    private List<String> getCompatibleMorpho(String morpho, String lemma) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] parts = morpho.split("\\s+");
        for (int i = 1; i < parts.length; ++i) {
            String[] properties;
            String[] t;
            String part = parts[i];
            String[] words = part.split("/");
            if (words.length > 1 && (t = (part = words[0]).split("~")).length > 1) {
                part = t[1];
            }
            if (!(properties = part.split("\\+"))[0].equalsIgnoreCase(lemma)) continue;
            ret.add(part);
        }
        return ret;
    }

    private boolean isSatisfied(String pos, List<String> tags) {
        boolean ret = false;
        pos = pos.toLowerCase();
        if (this.usePrefix) {
            for (String tag : tags) {
                if (!pos.startsWith(tag = tag.toLowerCase())) continue;
                ret = true;
            }
        } else {
            for (String tag : tags) {
                if (!pos.equals(tag = tag.toLowerCase())) continue;
                ret = true;
            }
        }
        return ret;
    }

    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(TenseAnnotations.DH_TENSE_REQUIREMENT);
    }

    public Set<Annotator.Requirement> requires() {
        return Collections.unmodifiableSet(new ArraySet((Object[])new Annotator.Requirement[]{DigiMorphAnnotations.DH_MORPHOLOGY_REQUIREMENT, POS_REQUIREMENT}));
    }

    static {
        noWords.add("non");
        noWords.add("n\u00e9");
        noWords.add("nemmeno");
        noWords.add("neanche");
        multiTenses.put("indicpres", "indpasspross");
        multiTenses.put("indicimperf", "indtrapasspross");
        multiTenses.put("indicpass", "indtrapassrem");
        multiTenses.put("indicfut", "indfutant");
        LOGGER = LoggerFactory.getLogger(TenseAnnotator.class);
    }

    private class VerbGroup {
        private List<VerbToken> tokens = new ArrayList<VerbToken>();
        private boolean followedByExMark = false;
        private boolean preceededByNot = false;

        private VerbGroup() {
        }

        public void addToken(VerbToken token) {
            this.tokens.add(token);
        }

        public List<VerbToken> getTokens() {
            return this.tokens;
        }

        public void setTokens(List<VerbToken> tokens) {
            this.resetTokens();
            for (VerbToken token : tokens) {
                this.addToken(token);
            }
        }

        private void resetTokens() {
            this.tokens = new ArrayList<VerbToken>();
        }

        public boolean isFollowedByExMark() {
            return this.followedByExMark;
        }

        public void setFollowedByExMark(boolean followedByExMark) {
            this.followedByExMark = followedByExMark;
        }

        public boolean isPreceededByNot() {
            return this.preceededByNot;
        }

        public void setPreceededByNot(boolean preceededByNot) {
            this.preceededByNot = preceededByNot;
        }

        public Set<String> getPatterns() {
            HashSet<String> ret = new HashSet<String>();
            StringBuffer pattern = new StringBuffer();
            for (int i = 0; i < this.tokens.size(); ++i) {
                VerbToken token = this.tokens.get(i);
                if (i < this.tokens.size() - 1) {
                    String lemma = token.getToken().lemma();
                    if (lemma.equals("venire")) {
                        lemma = "essere";
                    }
                    pattern.append(lemma).append("+");
                    continue;
                }
                Set tenses = token.getTense();
                for (String tense : tenses) {
                    ret.add(pattern.toString() + tense);
                }
            }
            return ret;
        }

        public String getLemma() {
            VerbToken lastToken = this.tokens.get(this.tokens.size() - 1);
            return lastToken.getToken().lemma();
        }
    }

    private class VerbToken {
        private CoreLabel token;
        private List<String> compatibleMorpho;

        public VerbToken(CoreLabel token) {
            this.token = token;
            this.compatibleMorpho = (List)token.get(DigiMorphAnnotations.MorphoCompAnnotation.class);
        }

        public CoreLabel getToken() {
            return this.token;
        }

        public void setToken(CoreLabel token) {
            this.token = token;
        }

        public List<String> getCompatibleMorpho() {
            return this.compatibleMorpho;
        }

        public void setCompatibleMorpho(List<String> compatibleMorpho) {
            this.compatibleMorpho = compatibleMorpho;
        }

        private Set<String> getTense() {
            HashSet<String> ret = new HashSet<String>();
            List<String> compatibleMorpho = this.getCompatibleMorpho();
            for (String m : compatibleMorpho) {
                String[] parts = m.split("\\+");
                if (parts.length <= 3) continue;
                ret.add(parts[2] + parts[3]);
            }
            if (ret.size() > 1 && ret.contains("imppres")) {
                ret.remove("imppres");
            }
            return ret;
        }
    }

    static enum Form {
        ACTIVE,
        PASSIVE;

    }
}

