/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.tokenizer.token;

public class Extent {
    private static final long serialVersionUID = 5024396602591514710L;
    protected int start;
    protected int end;

    public Extent() {
        this(0, 0);
    }

    public Extent(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean follows(Extent s) {
        return this.start > s.getEnd();
    }

    public boolean precedes(Extent s) {
        return this.end < s.getStart();
    }

    public boolean contains(Extent s) {
        return this.start <= s.getStart() && s.getEnd() <= this.end;
    }

    public boolean intersects(Extent s) {
        int sstart = s.getStart();
        return this.contains(s) || s.contains(this) || this.start <= sstart && sstart < this.end || sstart <= this.start && this.start < s.getEnd();
    }

    public boolean crosses(Extent s) {
        int sstart = s.getStart();
        return !this.contains(s) && !s.contains(this) && (this.start <= sstart && sstart < this.end || sstart <= this.start && this.start < s.getEnd());
    }

    public int compareTo(Extent o) {
        if (this.end < o.getStart()) {
            return -1;
        }
        if (this.start > o.getEnd()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Extent s = (Extent)o;
        return this.start == s.getStart() && this.end == s.getEnd();
    }

    public String toString() {
        return this.start + "\t" + this.end;
    }
}

